/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.AbstractEXAStatement;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADatabaseMetaData;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.HttpPushTool;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class EXAStatement
extends AbstractEXAStatement {
    List httpPushes = new ArrayList();
    boolean isCloseOnCompletion = false;

    public EXAStatement(EXAConnection c, int resultSetType_, int resultSetConcurrency_) {
        super(c, resultSetType_, resultSetConcurrency_);
    }

    public EXAStatement(EXAConnection c) {
        super(c);
    }

    private HttpPushTool preparePush(String sql) throws SQLException {
        try {
            return HttpPushTool.transformCommand(sql, this.connection.clusterNodes, this.connection.IsEncrypted(), this.debug, ((EXADatabaseMetaData)this.connection.getMetaData()).getDatabaseProductVersionInt());
        }
        catch (IOException e) {
            if (this.debug != null) {
                EXADriver.debugError("Error while perparing import / export. ", e, this.debug);
            }
            throw new SQLException(e.getMessage(), "04508");
        }
    }

    private void finishPush(HttpPushTool httpPushTool) throws SQLException {
        try {
            httpPushTool.checkForErrors();
        }
        catch (IOException e) {
            if (this.connection.debug != null) {
                this.log("Exception caught in import / export process:" + e.getMessage());
            }
            throw new SQLException(e.toString(), "04509");
        }
        finally {
            try {
                httpPushTool.close();
            }
            catch (IOException e) {
                throw new SQLException(e.toString(), "04510");
            }
        }
    }

    private void convertPushSQLException(SQLException ex, HttpPushTool httpPushTool) throws SQLException {
        if (ex.getSQLState().compareTo("42000") >= 0 && ex.getSQLState().compareTo("43000") < 0) {
            String newMessage = Translator.MESSAGE_while_executing_SQL(ex.getMessage(), httpPushTool.getSQL());
            try {
                throw (SQLException)ex.getClass().getConstructor(String.class, String.class).newInstance(newMessage, ex.getSQLState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            throw new SQLException(newMessage, ex.getSQLState());
        }
        throw ex;
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        this.log("EXAStatement.addBatch()");
        HttpPushTool httpPushTool = this.preparePush(sql);
        if (httpPushTool == null) {
            super.addBatch(sql);
            return;
        }
        this.httpPushes.add(httpPushTool);
        super.addBatch(httpPushTool.getSQL());
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            super.clearBatch();
        }
        finally {
            for (int i = 0; i < this.httpPushes.size(); ++i) {
                this.finishPush((HttpPushTool)this.httpPushes.get(i));
            }
            this.httpPushes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.log("EXAStatement.executeBatch()");
        this.connection.setSchemaMayHaveChanged();
        try {
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            for (int i = 0; i < this.httpPushes.size(); ++i) {
                try {
                    this.finishPush((HttpPushTool)this.httpPushes.get(i));
                    continue;
                }
                catch (Exception exception) {}
            }
            this.httpPushes.clear();
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.log("EXAStatement.execute(" + autoGeneratedKeys + ")");
        this.connection.setSchemaMayHaveChanged();
        if (autoGeneratedKeys != 2) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,RETURN_GENERATED_KEYS)");
        }
        return this.execute(sql);
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.log("EXAStatement.execute(columnIndexes[])");
        this.connection.setSchemaMayHaveChanged();
        if (columnIndexes != null && columnIndexes.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,int[] columnIndexes)");
        }
        return this.execute(sql);
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        this.log("EXAStatement.execute(columnNames[])");
        this.connection.setSchemaMayHaveChanged();
        if (columnNames != null && columnNames.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,String[] columnNames)");
        }
        return this.execute(sql);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.log("closeOnCompletion()");
        this.isCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.log("isCloseOnCompletion() - " + this.isCloseOnCompletion);
        return this.isCloseOnCompletion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        this.log("EXAStatement.execute()");
        this.connection.setSchemaMayHaveChanged();
        HttpPushTool httpPushTool = this.preparePush(sql);
        if (httpPushTool == null) {
            return super.execute(sql);
        }
        SQLException sqlpex = null;
        try {
            boolean bl = super.execute(httpPushTool.getSQL());
            return bl;
        }
        catch (SQLException ex) {
            try {
                this.convertPushSQLException(ex, httpPushTool);
                throw ex;
            }
            catch (SQLException pex) {
                httpPushTool.KillHttpPushToolThread();
                sqlpex = pex;
                throw pex;
            }
        }
        finally {
            try {
                this.finishPush(httpPushTool);
                this.log("execution done.");
            }
            catch (SQLException ex) {
                if (null == sqlpex) throw ex;
                throw ExceptionFactory.mergeSQLExceptions(sqlpex, ex);
            }
            finally {
                this.log("execution ended with exception.");
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            this.log("EXAStatement.executeUpdate(autoGeneratedKeys: NO_GENERATED_KEYS (" + autoGeneratedKeys + "))");
        } else if (autoGeneratedKeys == 1) {
            this.log("EXAStatement.executeUpdate(autoGeneratedKeys: RETURN_GENERATED_KEYS (" + autoGeneratedKeys + "))");
        } else {
            this.log("EXAStatement.executeUpdate(autoGeneratedKeys: " + autoGeneratedKeys + ")");
        }
        this.connection.setSchemaMayHaveChanged();
        if (autoGeneratedKeys != 2) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,RETURN_GENERATED_KEYS)");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length > 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < columnIndexes.length - 1; ++i) {
                str.append(columnIndexes[i] + ", ");
            }
            str.append(columnIndexes[columnIndexes.length - 1]);
            this.log("EXAStatement.executeUpdate(columnIndexes: {" + str + "})");
        } else {
            this.log("EXAStatement.executeUpdate(columnIndexes: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (columnIndexes != null && columnIndexes.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,int columnIndexes[])");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < columnNames.length - 1; ++i) {
                str.append(columnNames[i] + ", ");
            }
            str.append(columnNames[columnNames.length - 1]);
            this.log("EXAStatement.executeUpdate(columnNames: {" + str + "})");
        } else {
            this.log("EXAStatement.executeUpdate(columnNames: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (columnNames != null && columnNames.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,String columnNames[])");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        this.log("EXAStatement.executeLargeUpdate()");
        HttpPushTool httpPushTool = this.preparePush(sql);
        this.connection.setSchemaMayHaveChanged();
        if (httpPushTool == null) {
            return super.exaExecuteLargeUpdate(sql);
        }
        SQLException sqlpex = null;
        try {
            long l = super.exaExecuteLargeUpdate(httpPushTool.getSQL());
            return l;
        }
        catch (SQLException ex) {
            try {
                this.convertPushSQLException(ex, httpPushTool);
            }
            catch (SQLException pex) {
                httpPushTool.KillHttpPushToolThread();
                sqlpex = pex;
                throw pex;
            }
            throw ex;
        }
        finally {
            try {
                this.finishPush(httpPushTool);
            }
            catch (SQLException ex) {
                if (null != sqlpex) {
                    throw ExceptionFactory.mergeSQLExceptions(sqlpex, ex);
                }
                throw ex;
            }
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            this.log("EXAStatement.executeLargeUpdate(autoGeneratedKeys: NO_GENERATED_KEYS (" + autoGeneratedKeys + "))");
        } else if (autoGeneratedKeys == 1) {
            this.log("EXAStatement.executeLargeUpdate(autoGeneratedKeys: RETURN_GENERATED_KEYS (" + autoGeneratedKeys + "))");
        } else {
            this.log("EXAStatement.executeLargeUpdate(autoGeneratedKeys: " + autoGeneratedKeys + ")");
        }
        this.connection.setSchemaMayHaveChanged();
        if (autoGeneratedKeys != 2) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql, RETURN_GENERATED_KEYS)");
        }
        return this.executeLargeUpdate(sql);
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length > 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < columnIndexes.length - 1; ++i) {
                str.append(columnIndexes[i] + ", ");
            }
            str.append(columnIndexes[columnIndexes.length - 1]);
            this.log("EXAStatement.executeLargeUpdate(columnIndexes: {" + str + "})");
        } else {
            this.log("EXAStatement.executeLargeUpdate(columnIndexes: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (columnIndexes != null && columnIndexes.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql, int columnIndexes[])");
        }
        return this.executeLargeUpdate(sql);
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length > 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < columnNames.length - 1; ++i) {
                str.append(columnNames[i] + ", ");
            }
            str.append(columnNames[columnNames.length - 1]);
            this.log("EXAStatement.executeLargeUpdate(columnNames: {" + str + "})");
        } else {
            this.log("EXAStatement.executeLargeUpdate(columnNames: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (columnNames != null && columnNames.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql, String columnNames[])");
        }
        return this.executeLargeUpdate(sql);
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        return super.exaExecuteLargeBatch();
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        if (this.debug != null) {
            this.debug.log("getMoreResults(" + current + ")");
        }
        if (current == 1) {
            if (this.current_result >= 0 && this.current_result < this.results.length && this.results[this.current_result] instanceof EXAResultSet) {
                ((EXAResultSet)this.results[this.current_result]).close();
            }
        } else if (current == 3) {
            this.closeResultSets(this.results);
        }
        return this.getMoreResults();
    }

    @Override
    public String getSQLTypeName(int type) {
        switch (type) {
            case 16: {
                return "BOOLEAN";
            }
            case 70: {
                return "DATALINK";
            }
        }
        return super.getSQLTypeName(type);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

