/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.GSSPrivilegedAction;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Set;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GSSAuthentication {
    public static void authenticate(EXAConnection conn, boolean usespnego) throws IOException, SQLException {
        Exception result = null;
        try {
            Subject sub = Subject.getSubject(AccessController.getContext());
            GSSCredential gssCredential = GSSAuthentication.getCredentials(conn, sub);
            GSSPrivilegedAction action = new GSSPrivilegedAction(conn, gssCredential, usespnego);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            conn.logStackTrace(e);
            throw new SQLException(e.getMessage(), e);
        }
        if (result instanceof IOException) {
            conn.logStackTrace(result);
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            conn.logStackTrace(result);
            throw (SQLException)result;
        }
        if (result != null) {
            throw new SQLException("Kerberos authentication failed: " + result.getMessage(), "HY000", result);
        }
    }

    private static GSSCredential getCredentials(EXAConnection conn, Subject subject) throws GSSException {
        if (subject == null) {
            conn.log("No subject found in context");
            return null;
        }
        conn.log("Found subject with " + subject.getPrincipals().size() + " principals(s) in context:");
        for (Principal principal : subject.getPrincipals()) {
            conn.log("  - '" + principal.getName() + "'");
        }
        Set<GSSCredential> gssCreds = subject.getPrivateCredentials(GSSCredential.class);
        if (gssCreds == null || gssCreds.size() <= 0) {
            conn.log("No private credentials found for subject");
            return null;
        }
        GSSCredential gssCredential = gssCreds.iterator().next();
        conn.log("Found " + gssCreds.size() + " private credential(s), using first credentials for '" + gssCredential.getName() + "'");
        return gssCredential;
    }
}

