/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ProtocolException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;

class Header {
    final EXAConnection connection;
    private int size = 0;
    private byte mode = (byte)-1;
    private Vector attributes;
    private int serialNumber = -1;
    private int numberOfResults;
    private int sizeOfAttributes;
    static final int VMU = 64;
    private DebugLog debug;

    Header(EXAConnection connection, DebugLog log, int serialNumber) {
        this.connection = connection;
        this.attributes = new Vector();
        this.debug = log;
        this.serialNumber = serialNumber;
    }

    Header(Header h) {
        this.connection = h.connection;
        this.attributes = new Vector();
        this.debug = h.debug;
        this.serialNumber = h.serialNumber;
    }

    private void log(Object msg) {
        if (this.debug != null) {
            this.debug.log(msg.toString());
        }
    }

    synchronized InputStream read_from(InputStream is, ExecutionStatus executionStatus, int timeout) throws SQLException, IOException {
        EXAInputStream in = new EXAInputStream(is, this.connection, executionStatus);
        long now = System.currentTimeMillis();
        if (this.connection != null && this.connection.csocket != null && this.connection.csocket.getSoTimeout() != timeout) {
            this.connection.SetSocketTimeout(timeout);
        }
        ByteArrayInputStream inDataMem = null;
        try {
            byte[] hbytes = new byte[21];
            in.read(hbytes);
            ByteArrayInputStream inMem = new ByteArrayInputStream(hbytes);
            EXAInputStream inMemIs = new EXAInputStream(inMem, this.connection, executionStatus);
            this.size = inMemIs.readInt();
            if (this.size < 0) {
                throw new ProtocolException("Message size negative: " + this.size);
            }
            this.mode = inMemIs.readByte();
            this.serialNumber = inMemIs.readInt();
            int numberOfAttributes = inMemIs.readInt();
            this.sizeOfAttributes = inMemIs.readInt();
            this.numberOfResults = inMemIs.readInt();
            byte[] mbytes = new byte[this.size];
            in.read(mbytes);
            byte[] abytes = new byte[this.sizeOfAttributes];
            System.arraycopy(mbytes, 0, abytes, 0, this.sizeOfAttributes);
            ByteArrayInputStream inAttrMem = new ByteArrayInputStream(abytes);
            EXAInputStream inAttrMemIs = new EXAInputStream(inAttrMem, this.connection, executionStatus);
            try {
                for (int i = 0; i < numberOfAttributes; ++i) {
                    ProtocolAttribute attrib = inAttrMemIs.readAttribute();
                    this.attributes.add(attrib);
                    this.log("Attribute of message #" + this.serialNumber + ": " + attrib);
                }
            }
            catch (Exception ex) {
                throw new ProtocolException(ex.getMessage());
            }
            byte[] msgbytes = new byte[this.size - this.sizeOfAttributes];
            System.arraycopy(mbytes, this.sizeOfAttributes, msgbytes, 0, this.size - this.sizeOfAttributes);
            inDataMem = new ByteArrayInputStream(msgbytes);
            this.size -= this.sizeOfAttributes;
            this.log("Header.read_from(InputStream, " + timeout + ") serialNumber: " + this.serialNumber + ", attrSize: " + this.sizeOfAttributes + ", numRes: " + this.numberOfResults + ", mode: " + this.mode + ", data_size: " + this.size);
        }
        catch (Exception ex) {
            this.log("read_from - got an exception: " + ex.getClass().getCanonicalName() + ": " + ex.getMessage());
            throw ex;
        }
        return inDataMem;
    }

    private String getStacktrace() {
        String st = "";
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            st = st + ste + "\n";
        }
        return st;
    }

    void write_to(OutputStream os) throws IOException, ConnectionException {
        if (this.mode <= 0) {
            throw new ProtocolException("ProtocolException A0001 in Header.write_to:\n" + this.getStacktrace() + "mode=" + this.mode);
        }
        if (this.serialNumber < 0) {
            throw new ProtocolException("ProtocolException B0001 in Header.write_to:\n" + this.getStacktrace() + "serialNumber=" + this.serialNumber);
        }
        EXAOutputStream out = new EXAOutputStream(os, this.connection);
        ByteArrayOutputStream attribData = new ByteArrayOutputStream();
        EXAOutputStream outAttribs = new EXAOutputStream(attribData, this.connection);
        for (int i = 0; i < this.attributes.size(); ++i) {
            ProtocolAttribute a = (ProtocolAttribute)this.attributes.get(i);
            outAttribs.writeAttribute(a);
        }
        outAttribs.flush();
        int attribsSize = attribData.size();
        if (this.mode <= 0) {
            throw new ProtocolException("ProtocolException A0002 in Header.write_to:\n" + this.getStacktrace() + "mode=" + this.mode);
        }
        if (this.serialNumber < 0) {
            throw new ProtocolException("ProtocolException B0002 in Header.write_to:\n" + this.getStacktrace() + "serialNumber=" + this.serialNumber);
        }
        out.writeInt(attribsSize + this.size);
        out.writeByte(this.mode);
        out.writeInt(this.serialNumber);
        out.writeInt(this.attributes.size());
        out.writeInt(attribsSize);
        out.writeInt(this.numberOfResults);
        out.setHeader();
        out.write(attribData.toByteArray());
        this.log("Header.write_to(OutputStream) serialNumber: " + this.serialNumber + ", numAttr: " + this.attributes.size() + ", attrSize: " + attribsSize + ", numRes: " + this.numberOfResults + ", data_size: " + this.size + ", mode: " + this.mode);
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(int numberOfResults) {
        this.numberOfResults = numberOfResults;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public void incSize(int increment) {
        this.size += increment;
    }

    public void addAttribute(ProtocolAttribute attr) {
        this.attributes.addElement(attr);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("*** Header no. ");
        buf.append(this.serialNumber);
        buf.append(" ***\n");
        buf.append("  message mode   : " + this.mode);
        buf.append('\n');
        buf.append("  result count   : " + this.numberOfResults);
        buf.append('\n');
        buf.append("  data size      : " + this.size);
        buf.append('\n');
        buf.append("  attribute count: " + this.attributes.size());
        buf.append('\n');
        buf.append("  attribute size : " + this.attributes.size());
        buf.append("\n ****************");
        return buf.toString();
    }
}

