/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionParser {
    private String SQL = null;
    private String SQLComment = null;
    private String PublicKey = null;
    private String CertificateParam = null;
    private List<String> Files = null;
    private String Query1 = null;
    private String Query2 = null;

    public String getQuery1() {
        return this.Query1;
    }

    public String getQuery2() {
        return this.Query2;
    }

    public String getSQL() {
        return this.SQL;
    }

    public String getSQLComment() {
        return this.SQLComment;
    }

    public String getPublicKey() {
        return this.PublicKey;
    }

    public String getCertificateParam() {
        return this.CertificateParam;
    }

    public List<String> getFiles() {
        return this.Files;
    }

    public String[] getFilesStringArray() {
        String[] _Files = new String[this.Files.size()];
        for (int i = 0; i < this.Files.size(); ++i) {
            _Files[i] = this.Files.get(i);
        }
        return _Files;
    }

    public ConnectionParser(String sql) {
        this.SQL = sql;
    }

    protected void SplitQueryComments() {
        Matcher matcher = Pattern.compile("(/\\*.[^*][^/]*\\*/)", 42).matcher(this.SQL);
        StringBuilder comment = new StringBuilder();
        StringBuilder sqlWithNoComment = new StringBuilder();
        int sqlCharIndx = 0;
        int groupStartIndx = -1;
        while (matcher.find()) {
            comment.append(matcher.group()).append(" ");
            groupStartIndx = matcher.start();
            sqlWithNoComment.append(this.SQL, sqlCharIndx, groupStartIndx).append(" ");
            sqlCharIndx = matcher.end();
        }
        if (sqlCharIndx < this.SQL.length()) {
            sqlWithNoComment.append(this.SQL.substring(sqlCharIndx)).append(" ");
        }
        comment = new StringBuilder(comment.toString().trim());
        sqlWithNoComment = new StringBuilder(sqlWithNoComment.toString().trim());
        this.SQL = sqlWithNoComment.toString();
        this.SQLComment = comment.toString();
    }

    protected List<String> GetFiles() {
        ArrayList<String> files = new ArrayList<String>();
        Matcher matcher = Pattern.compile("FILE\\s+'(?<SingleQuote>.[^']*)'|\"(?<DoubleQuote>.[^\"]*)\"", 42).matcher(this.Query1);
        int lastCharIndx = -1;
        while (matcher.find()) {
            if (matcher.group("SingleQuote") != null) {
                files.add(matcher.group("SingleQuote"));
                lastCharIndx = matcher.end("SingleQuote");
                continue;
            }
            if (matcher.group("DoubleQuote") == null) continue;
            files.add(matcher.group("DoubleQuote"));
            lastCharIndx = matcher.end("DoubleQuote");
        }
        if (lastCharIndx != -1 && ++lastCharIndx < this.Query1.length()) {
            this.Query2 = this.Query1.substring(lastCharIndx) + " " + this.Query2;
        }
        return files;
    }

    protected static String GetPublicKey(String sql) throws SQLException {
        Matcher matcher = Pattern.compile("(PUBLIC\\s+KEY\\s+(('.[^']*')|(\".[^\"]*\")))", 42).matcher(sql);
        String _publicKey = null;
        int count = 0;
        for (int i = 0; matcher.find() && i < 10; ++i) {
            if (matcher.group() == null) continue;
            _publicKey = matcher.group();
            ++count;
        }
        if (count > 1) {
            throw new SQLException("[ERROR] More than 1 public key is provided.");
        }
        return _publicKey;
    }

    protected static String GetCertificateParameter(String sql) throws SQLException {
        int i;
        Matcher matcher = Pattern.compile("(IGNORE\\s+CERTIFICATE|VERIFY\\s+CERTIFICATE)", 42).matcher(sql);
        String _certificateParam = null;
        for (i = 0; matcher.find() && i < 5; ++i) {
            _certificateParam = matcher.group();
        }
        if (i > 1) {
            throw new SQLException("[ERROR] More than 1 certificate parameters are provided.");
        }
        return _certificateParam;
    }

    protected void SplitQueryError() {
        Matcher matcher = Pattern.compile("(?<ERROR>ERRORS\\s+INTO\\s+(CSV|FBV)\\s+.*$)", 42).matcher(this.SQL);
        if (matcher.find()) {
            if (matcher.group("ERROR") != null) {
                this.Query1 = this.SQL.substring(0, matcher.start("ERROR"));
                this.Query2 = this.SQL.substring(matcher.start("ERROR"));
            } else {
                this.Query1 = this.SQL;
                this.Query2 = "";
            }
        } else {
            this.Query1 = this.SQL;
            this.Query2 = "";
        }
    }

    public void parse() throws SQLException {
        this.SplitQueryComments();
        this.SplitQueryError();
        this.PublicKey = ConnectionParser.GetPublicKey(this.Query1);
        this.CertificateParam = ConnectionParser.GetCertificateParameter(this.Query1);
        this.Files = this.GetFiles();
    }
}

