/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.ImportErrorQuery;
import com.exasol.jdbc.importExport.ImportExportQuery;
import com.exasol.jdbc.importExport.QueryManipulator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexPattern {
    private String sqlQuery;
    private ImportExportQuery queryParser = null;
    private String sqlQueryWithoutComments;
    private boolean IsSecureImportExport = false;
    private boolean IsSecureImportError = false;
    private boolean IsCSV = true;
    private boolean IsImportQuery = true;
    private boolean IsSecure = true;
    private LinkedHashMap<String, String> commentsMap;
    private SQLPatterns sqlPattern = SQLPatterns.NONE;
    private final String SecureImportExportKey = "ImportExportSecure";
    private final String SecureImportErrorKey = "ImportErrorSecure";
    private final String FileTypeKey = "FileType";
    private final String QueryTypeKey = "QueryType";
    private Pattern ImportExportPattern = Pattern.compile("^\\s*(?<QueryType>IMPORT|EXPORT).*((FROM|INTO)\\s+LOCAL\\s+(?<ImportExportSecure>SECURE\\s+)*)(?<FileType>CSV|FBV)\\s+(VERIFY\\s+CERTIFICATE\\s+|IGNORE\\s+CERTIFICATE\\s+)*(PUBLIC\\s+KEY\\s+(('[^']+')|(\"[^\"]+\"))+\\s+)*((\\s*FILE\\s+(('[^']+')|(\"[^\"]+\")))+)(.*$)", 42);
    private Pattern ImpErrCSVPattern = Pattern.compile("^\\s*(IMPORT).*(FROM\\s+LOCAL\\s+(?<ImportExportSecure>SECURE\\s+)*)(CSV)\\s+(VERIFY\\s+CERTIFICATE\\s+|IGNORE\\s+CERTIFICATE\\s+)*(PUBLIC\\s+KEY\\s+(('[^']+')|(\"[^\"]+\"))+\\s+)*((\\s*FILE\\s+(('[^']+')|(\"[^\"]+\")))+)\\s+(REJECT\\s+LIMIT.*ERRORS.*)*ERRORS\\s+INTO\\s+LOCAL\\s+(?<ImportErrorSecure>SECURE\\s+)*(CSV)\\s+(VERIFY\\s+CERTIFICATE\\s+|IGNORE\\s+CERTIFICATE\\s+)*(PUBLIC\\s+KEY\\s+(('[^']+')|(\"[^\"]+\"))+\\s+)*((\\s*FILE\\s+(('[^']+')|(\"[^\"]+\")))+)(.*$)", 42);

    public boolean isSecureImportExport() {
        return this.IsSecureImportExport;
    }

    public boolean isSecureImportError() {
        return this.IsSecureImportError;
    }

    public boolean isCSV() {
        return this.IsCSV;
    }

    public boolean isImportQuery() {
        return this.IsImportQuery;
    }

    public SQLPatterns getSqlPattern() {
        return this.sqlPattern;
    }

    public RegexPattern(String sql) {
        this.sqlQuery = sql;
        this.sqlQueryWithoutComments = QueryManipulator.RemoveComment(this.sqlQuery);
        this.commentsMap = new LinkedHashMap();
    }

    public String getRandomString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String multiLineCommentReplacer(String SQL) {
        Matcher match = Pattern.compile("/\\*(.*?)\\*/", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                String fromSQL = match.group(i);
                String toSQL = "/*" + this.getRandomString() + "*/";
                SQL = SQL.replace(fromSQL, toSQL + " ");
                this.commentsMap.put(toSQL, fromSQL);
            }
        }
        return SQL;
    }

    public String singleLineCommentReplacer(String SQL) {
        Matcher match = Pattern.compile("--.*?(" + System.getProperty("line.separator") + "|\\n|$)", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                String fromSQL = match.group(i);
                String toSQL = "/*" + this.getRandomString() + "*/";
                SQL = SQL.replace(fromSQL, toSQL + " ");
                this.commentsMap.put(toSQL, fromSQL);
            }
        }
        return SQL;
    }

    public String replaceHashWithSingleLineComments(String SQL) {
        return this.replaceHashWithMultiLineComments(SQL);
    }

    public String replaceHashWithMultiLineComments(String SQL) {
        for (Map.Entry<String, String> hash : this.commentsMap.entrySet()) {
            if (!SQL.contains(hash.getKey())) continue;
            SQL = SQL.replace(hash.getKey() + " ", hash.getValue());
        }
        return SQL;
    }

    public String replaceHashWithComments(String SQL) {
        return this.replaceHashWithMultiLineComments(this.replaceHashWithSingleLineComments(SQL));
    }

    public String getCommentForHash(String hash) {
        return this.commentsMap.getOrDefault(hash, null);
    }

    private String replaceCommentsWithHash(String SQL) {
        return this.singleLineCommentReplacer(this.multiLineCommentReplacer(SQL));
    }

    private boolean IsImportErrorQuery(String sql) {
        Matcher match = this.ImpErrCSVPattern.matcher(sql);
        if (match.matches()) {
            if (match.group("ImportExportSecure") != null) {
                this.IsSecureImportExport = true;
            }
            if (match.group("ImportErrorSecure") != null) {
                this.IsSecureImportError = true;
            }
            this.IsCSV = true;
            this.IsImportQuery = true;
            return true;
        }
        return false;
    }

    private boolean IsImportExportQuery(String sql) {
        Matcher match = this.ImportExportPattern.matcher(sql);
        if (match.matches()) {
            String val;
            if (match.group("ImportExportSecure") != null) {
                this.IsSecureImportExport = true;
            }
            if (match.group("FileType") != null) {
                val = match.group("FileType");
                this.IsCSV = val.trim().equalsIgnoreCase("CSV");
            }
            if (match.group("QueryType") != null) {
                val = match.group("QueryType");
                this.IsImportQuery = val.trim().equalsIgnoreCase("IMPORT");
            }
            return true;
        }
        return false;
    }

    public SQLPatterns IdentifyQueryType(String sql) {
        if (this.IsImportErrorQuery(sql)) {
            return SQLPatterns.IMPORT_ERROR;
        }
        if (this.IsImportExportQuery(sql)) {
            return SQLPatterns.IMPORT_EXPORT;
        }
        return SQLPatterns.NONE;
    }

    private boolean isImportExportQuery(String sql) {
        Pattern impexpPattern = Pattern.compile("^.*?(IMPORT|EXPORT).*?((LOCAL).*?(CSV|FBV).*?(FILE)).*", 34);
        return impexpPattern.matcher(sql).matches();
    }

    public boolean Match() throws SQLException {
        if (this.sqlQueryWithoutComments == null) {
            throw new SQLException("SQL Query is not provided.");
        }
        if (!this.isImportExportQuery(this.sqlQueryWithoutComments)) {
            return false;
        }
        this.sqlPattern = this.IdentifyQueryType(this.sqlQueryWithoutComments);
        if (this.sqlPattern != SQLPatterns.NONE) {
            String sql = this.replaceCommentsWithHash(this.sqlQuery);
            if (this.sqlPattern == SQLPatterns.IMPORT_ERROR) {
                this.queryParser = new ImportErrorQuery(sql, this.IsCSV, this.IsSecureImportExport, this.IsSecureImportError);
            } else if (this.sqlPattern == SQLPatterns.IMPORT_EXPORT) {
                this.queryParser = new ImportExportQuery(sql, this.IsCSV, this.IsSecureImportExport);
            } else {
                throw new SQLException("Un-Identified SQL Pattern Type");
            }
            this.queryParser.parse();
            this.setParams();
            return true;
        }
        return false;
    }

    public String[] getFiles() throws SQLException {
        if (this.queryParser == null) {
            throw new SQLException("No Files are provided.");
        }
        return this.queryParser.connectionParser.getFilesStringArray();
    }

    public ImportExportQuery getQueryParser() {
        return this.queryParser;
    }

    public String getErrFiles() throws SQLException {
        if (this.queryParser == null) {
            throw new SQLException("No Files are provided.");
        }
        if (this.sqlPattern == SQLPatterns.IMPORT_ERROR) {
            return ((ImportErrorQuery)this.queryParser).getErrorFile();
        }
        return null;
    }

    private static void DummyFiles(String[] files) {
        for (String file : files) {
            File f = new File(file);
            if (f.exists() || f.isDirectory()) continue;
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setParams() throws SQLException {
        String[] Files = this.getFiles();
        if (this.sqlPattern == SQLPatterns.IMPORT_EXPORT && !this.isImportQuery()) {
            RegexPattern.DummyFiles(Files);
            if (!this.isCSV() && Files.length > 1) {
                if (this.isSecureImportExport()) {
                    throw new SQLException("Only one secure FBV file can be specified in export.", "04505");
                }
                throw new SQLException("Only one FBV file can be specified in export.", "04503");
            }
        }
    }

    public static String CreateFilenameQueryComment(String[] files) {
        if (files.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < files.length - 1; ++i) {
            sb.append(String.format("FILE '%s' ", files[i]));
        }
        sb.append(String.format("FILE '%s'", files[files.length - 1]));
        return "/*" + sb + "*/";
    }

    public static String CreateFilenameQueryComment(String files) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("FILE '%s'", files));
        return "/*" + sb + "*/";
    }

    public void setSecure(boolean value) {
        this.IsSecure = value;
    }

    public boolean IsSecure() {
        return this.IsSecure;
    }

    public static enum SQLPatterns {
        IMPORT_EXPORT,
        IMPORT_ERROR,
        NONE;

    }
}

