/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.List;
import resources.dependencies.org.bouncycastle.asn1.ASN1Set;
import resources.dependencies.org.bouncycastle.asn1.cms.OriginatorInfo;
import resources.dependencies.org.bouncycastle.cert.X509CertificateHolder;
import resources.dependencies.org.bouncycastle.cms.CMSException;
import resources.dependencies.org.bouncycastle.cms.CMSUtils;
import resources.dependencies.org.bouncycastle.cms.OriginatorInformation;
import resources.dependencies.org.bouncycastle.util.Store;

public class OriginatorInfoGenerator {
    private final List origCerts;
    private final List origCRLs;

    public OriginatorInfoGenerator(X509CertificateHolder x509CertificateHolder) {
        this.origCerts = new ArrayList(1);
        this.origCRLs = null;
        this.origCerts.add(x509CertificateHolder.toASN1Structure());
    }

    public OriginatorInfoGenerator(Store store) throws CMSException {
        this(store, null);
    }

    public OriginatorInfoGenerator(Store store, Store store2) throws CMSException {
        this.origCerts = store != null ? CMSUtils.getCertificatesFromStore(store) : null;
        this.origCRLs = store2 != null ? CMSUtils.getCRLsFromStore(store2) : null;
    }

    public OriginatorInformation generate() {
        ASN1Set aSN1Set = this.origCerts == null ? null : CMSUtils.createDerSetFromList(this.origCerts);
        ASN1Set aSN1Set2 = this.origCRLs == null ? null : CMSUtils.createDerSetFromList(this.origCRLs);
        return new OriginatorInformation(new OriginatorInfo(aSN1Set, aSN1Set2));
    }
}

