/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cms.bc;

import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.cms.CMSException;
import resources.dependencies.org.bouncycastle.cms.KeyTransRecipient;
import resources.dependencies.org.bouncycastle.cms.bc.CMSUtils;
import resources.dependencies.org.bouncycastle.crypto.CipherParameters;
import resources.dependencies.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import resources.dependencies.org.bouncycastle.operator.OperatorException;
import resources.dependencies.org.bouncycastle.operator.bc.BcRSAAsymmetricKeyUnwrapper;

public abstract class BcKeyTransRecipient
implements KeyTransRecipient {
    private AsymmetricKeyParameter recipientKey;

    public BcKeyTransRecipient(AsymmetricKeyParameter asymmetricKeyParameter) {
        this.recipientKey = asymmetricKeyParameter;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        BcRSAAsymmetricKeyUnwrapper bcRSAAsymmetricKeyUnwrapper = new BcRSAAsymmetricKeyUnwrapper(algorithmIdentifier, this.recipientKey);
        try {
            return CMSUtils.getBcKey(bcRSAAsymmetricKeyUnwrapper.generateUnwrappedKey(algorithmIdentifier2, byArray));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception unwrapping key: " + operatorException.getMessage(), operatorException);
        }
    }
}

