/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.Column;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;

public class EXADatabaseMetaData
extends ServerCommunication
implements DatabaseMetaData {
    private static final String DB_METADATA = "DB_METADATA";
    private static final String ALL_TABLES = "ALL_TABLES";
    private static final String ALL_PROCEDURES = "ALL_PROCEDURES";
    private static final String TABLE_PRIVILEGES = "TABLE_PRIVILEGES";
    private static final String PROCEDURE_COLUMNS = "PROCEDURE_COLUMNS";
    private static final String FOREIGN_KEYS = "FOREIGN_KEYS";
    private static final String PRIMARY_KEYS = "PRIMARY_KEYS";
    private static final String ALL_COLUMNS = "ALL_COLUMNS";
    private static final String ALL_SCHEMAS = "ALL_SCHEMAS";
    private static final String ALL_CATALOGS = "ALL_CATALOGS";
    private static final String COLUMN_PRIVILEGES = "COLUMN_PRIVILEGES";
    private static final String ALL_INDICES = "ALL_INDICES";
    private String TRANSFERLINKS = "EXA_TRANSFER_LINKS";
    private static final String[] tableTypes = new String[]{"TABLE", "VIEW", "SYSTEM_TABLE"};
    private HashMap staticProps = null;
    private Statement metaStmt;
    private String sysSchema;
    private Vector sqlCommands;
    private Vector plsqlCommands;
    private String databaseName;
    private String databaseProductVersion;
    private int databaseProductVersionInt;
    private int databaseSVNRevision;
    private String databaseProductName;
    private int metadataSQL = 0;

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    EXADatabaseMetaData(EXAConnection eXAConnection, DebugLog debugLog) throws SQLException {
        super(debugLog, "EXADatabaseMetadata", eXAConnection);
        this.log("createStatement to get metadata");
        this.metaStmt = this.connection.createStatement();
        this.sysSchema = this.connection.getSysSchema();
        try {
            this.metadataSQL = Integer.parseInt(this.connection.getParameter("metadataSQL"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.metadataSQL != 0) {
            this.metadataSQL = 1;
        }
        this.databaseProductName = this.connection.GetDatabaseProductName();
        this.databaseName = this.connection.GetDatabaseName();
        this.databaseProductVersion = this.connection.GetDatabaseProductVersion();
    }

    private String getProp(String string) throws SQLException {
        String string2 = null;
        if (this.connection.getActiveProtocolVersion() < 14 || 0 != this.metadataSQL) {
            StringBuffer stringBuffer = new StringBuffer("select \"VALUE\" from ");
            stringBuffer.append(this.sysSchema);
            stringBuffer.append(".");
            stringBuffer.append(DB_METADATA);
            stringBuffer.append(" where \"NAME\"='");
            stringBuffer.append(string);
            stringBuffer.append("'");
            if (this.metaStmt.execute(stringBuffer.toString())) {
                ResultSet resultSet = this.metaStmt.getResultSet();
                resultSet.first();
                if (!resultSet.isAfterLast()) {
                    string2 = resultSet.getString(1);
                    if (null == string2) {
                        string2 = "";
                    }
                } else {
                    this.log("Failed to retrieve DB metainfo \"" + string + "\"");
                }
            }
        } else {
            ExecutionStatus executionStatus = new ExecutionStatus();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
            try {
                if (null == string) {
                    eXAOutputStream.writeInt(-1);
                } else {
                    eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                    eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
                }
                eXAOutputStream.writeInt(-1);
                eXAOutputStream.writeInt(-1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new SQLException(iOException.getMessage());
            }
            EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)122, executionStatus, null);
            this.connection.metadataAcquired();
            if (eXAResultArray != null && eXAResultArray.length > 0) {
                if (eXAResultArray[0] instanceof EXASQLException) {
                    throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
                }
                EXAResultSet eXAResultSet = (EXAResultSet)eXAResultArray[0];
                if (0L >= eXAResultSet.getNumberOfRows()) {
                    throw new SQLException("Property not found: " + string, "HY000", -1);
                }
                eXAResultSet.first();
                if (!eXAResultSet.isAfterLast()) {
                    string2 = eXAResultSet.getString(1);
                    if (null == string2) {
                        string2 = "";
                    }
                } else {
                    this.log("Failed to retrieve DB metainfo \"" + string + "\"");
                }
            } else {
                return null;
            }
        }
        return string2;
    }

    private boolean getPropBoolean(String string, boolean bl) throws SQLException {
        boolean bl2 = false;
        String string2 = null;
        if (this.staticProps == null) {
            this.log("getPropBoolean: Need metadata.");
            this.initializeMetadata();
            this.log("Metadata initialized.");
        }
        if ((string2 = (String)this.staticProps.get(string)) == null) {
            string2 = this.getProp(string);
        } else {
            this.log("Returning cached DB metainfo " + string + "=" + string2);
        }
        if (string2 == null) {
            bl2 = bl;
            this.log("Returning defaultvalue for DB metainfo " + string + "=" + bl2);
        } else {
            bl2 = "1".equals(string2);
        }
        return bl2;
    }

    private String getPropString(String string, String string2) throws SQLException {
        String string3 = null;
        if (this.staticProps == null) {
            this.log("getPropString: Need metadata.");
            this.initializeMetadata();
            this.log("Metadata initialized.");
        }
        if ((string3 = (String)this.staticProps.get(string)) == null) {
            string3 = this.getProp(string);
        } else {
            this.log("Returning cached DB metainfo " + string + "=" + string3);
        }
        if (string3 == null) {
            string3 = string2;
            this.log("Returning defaultvalue for DB metainfo " + string + "=" + string3);
        }
        return string3;
    }

    private int getPropInt(String string, int n) throws SQLException {
        int n2 = n;
        String string2 = null;
        if (null == this.staticProps) {
            this.log("getPropIn: Need metadata.");
            this.initializeMetadata();
            this.log("Metadata initialized.");
        }
        if ((string2 = (String)this.staticProps.get(string)) == null) {
            string2 = this.getProp(string);
        } else {
            this.log("Returning cached DB metainfo " + string + "=" + string2);
        }
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("Returning defaultvalue for DB metainfo after NumberFormatException in parseInt()" + string + "=" + n2);
            }
        } else {
            this.log("Returning defaultvalue for DB metainfo " + string + "=" + n2);
        }
        return n2;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        this.log("allProceduresAreCallable()");
        return this.getPropBoolean("allProceduresAreCallable", true);
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        this.log("allTablesAreSelectable()");
        return this.getPropBoolean("allTablesAreSelectable", true);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.log("dataDefinitionCausesTransactionCommit()");
        return this.getPropBoolean("dataDefinitionCausesTransactionCommit", false);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.log("dataDefinitionIgnoredInTransactions()");
        return this.getPropBoolean("dataDefinitionIgnoredInTransactions", false);
    }

    @Override
    public boolean deletesAreDetected(int n) {
        this.log("deletesAreDetected(" + n + ")");
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.log("doesMaxRowSizeIncludeBlobs()");
        return this.getPropBoolean("doesMaxRowSizeIncludeBlobs", false);
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        if (this.debug != null) {
            this.log("getAttributes(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        EXAResultSet eXAResultSet = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] columnArray = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0), new CharColumn(30), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0)};
        eXAResultSet.addColumn(columnArray[0], "TYPE_CAT");
        eXAResultSet.addColumn(columnArray[1], "TYPE_SCHEM");
        eXAResultSet.addColumn(columnArray[2], "TYPE_NAME");
        eXAResultSet.addColumn(columnArray[3], "ATTR_NAME");
        eXAResultSet.addColumn(columnArray[4], "DATA_TYPE");
        eXAResultSet.addColumn(columnArray[5], "ATTR_TYPE_NAME");
        eXAResultSet.addColumn(columnArray[6], "ATTR_SIZE");
        eXAResultSet.addColumn(columnArray[7], "DECIMAL_DIGITS");
        eXAResultSet.addColumn(columnArray[8], "NUM_PREC_RADIX");
        eXAResultSet.addColumn(columnArray[9], "NULLABLE");
        eXAResultSet.addColumn(columnArray[10], "REMARKS");
        eXAResultSet.addColumn(columnArray[11], "ATTR_DEF");
        eXAResultSet.addColumn(columnArray[12], "SQL_DATA_TYPE");
        eXAResultSet.addColumn(columnArray[13], "SQL_DATETIME_SUB");
        eXAResultSet.addColumn(columnArray[14], "CHAR_OCTET_LENGTH");
        eXAResultSet.addColumn(columnArray[15], "ORDINAL_POSITION");
        eXAResultSet.addColumn(columnArray[16], "IS_NULLABLE");
        eXAResultSet.addColumn(columnArray[17], "SCOPE_CATALOG");
        eXAResultSet.addColumn(columnArray[18], "SCOPE_SCHEMA");
        eXAResultSet.addColumn(columnArray[19], "SCOPE_TABLE");
        eXAResultSet.addColumn(columnArray[20], "SOURCE_DATA_TYPE");
        eXAResultSet.resize(0);
        return eXAResultSet;
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.log("getBestRowIdentifier(" + string2 + "," + string3 + "," + n + "," + bl);
        EXAResultSet eXAResultSet = this.connection.dialectFactory.createResultSet(this.debug);
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "SCOPE");
        eXAResultSet.addColumn(new CharColumn(30), "COLUMN_NAME");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "DATA_TYPE");
        eXAResultSet.addColumn(new CharColumn(30), "TYPE_NAME");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "COLUMN_SIZE");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "BUFFER_LENGTH");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "DECIMAL_DIGITS");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "PSEUDO_COLUMN");
        eXAResultSet.resize(0);
        return eXAResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getCatalogs()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetCatalogs();
            }
            return this.getCatalogsSql();
        }
    }

    private ResultSet jdbcGetCatalogs() throws SQLException {
        this.log("EXAResultSet.jdbcGetCatalogs()");
        ExecutionStatus executionStatus = new ExecutionStatus();
        EXAResult[] eXAResultArray = this.connection.communication_resultset(new byte[0], (byte)61, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getCatalogsSql() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("select \"TABLE_CAT\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(ALL_CATALOGS);
        stringBuffer.append(" order by \"TABLE_CAT\"");
        ResultSet resultSet = this.metaStmt.executeQuery(stringBuffer.toString());
        return resultSet;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        this.log("getCatalogSeparator()");
        return this.getPropString("catalogSeparator", ".");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        this.log("getCatalogTerm()");
        return this.getPropString("catalogTerm", "CATOLOG");
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        return this.getFunctionsSql(string, string2, string3);
    }

    private ResultSet jdbcGetFunctions(String string, String string2, String string3) throws SQLException {
        this.log("EXAResultSet.getFunctions(" + string + ", " + string2 + ", " + string3 + ")");
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)65, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLException();
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getFunctionsSql(String string, String string2, String string3) throws SQLException {
        int n;
        this.log("getFunctions(" + string + "," + string2 + "," + string3 + ")");
        StringBuffer stringBuffer = new StringBuffer("select \"PROCEDURE_CAT\" AS \"FUNCTION_CAT\", \"PROCEDURE_SCHEM\" AS \"FUNCTION_SCHEM\", \"PROCEDURE_NAME\" AS \"FUNCTION_NAME\", cast (\"REMARKS\" as varchar(2000)) as \"REMARKS\", \"PROCEDURE_TYPE\" AS \"FUNCTION_TYPE\", \"PROCEDURE_NAME\" as \"SPECIFIC_NAME\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(ALL_PROCEDURES);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"PROCEDURE_CAT\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"PROCEDURE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"PROCEDURE_NAME\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_NAME\" like '" + string3 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"PROCEDURE_TYPE\",\"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\" ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("EXAResultSet.jdbcGetColumnPrivileges(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetColumnPrivileges(string, string2, string3, string4);
            }
            return this.getColumnPrivilegesSql(string, string2, string3, string4);
        }
    }

    private ResultSet jdbcGetColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
            if (null == string4) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string4.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string4.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)62, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getColumnPrivilegesSql(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",\"GRANTOR\",\"GRANTEE\",\"PRIVILEGE\", case \"IS_GRANTABLE\" when false then 'NO' when true then 'YES' else null end as \"IS_GRANTABLE\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(COLUMN_PRIVILEGES);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"TABLE_CAT\" is null ");
            } else {
                vector.addElement(" \"TABLE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"TABLE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"TABLE_NAME\" is null ");
            } else {
                vector.addElement(" \"TABLE_NAME\" like '" + string3 + "' ");
            }
        }
        if (string4 != null) {
            if ("".equals(string4)) {
                vector.addElement(" \"COLUMN_NAME\" is null ");
            } else {
                vector.addElement(" \"COLUMN_NAME\" like '" + string4 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"COLUMN_NAME\",\"PRIVILEGE\",\"GRANTOR\" nulls first,\"GRANTEE\" nulls first");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("EXAResultSet.jdbcGetColumns(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetColumns(string, string2, string3, string4);
            }
            return this.getColumnsSql(string, string2, string3, string4);
        }
    }

    private ResultSet jdbcGetColumns(String string, String string2, String string3, String string4) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
            if (null == string4) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string4.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string4.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)60, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getColumnsSql(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        this.log("getColumns(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        StringBuffer stringBuffer = this.connection.getActiveProtocolVersion() >= 11 ? new StringBuffer("select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",case when \"DATA_TYPE\"=-7 then 16 else \"DATA_TYPE\" end \"DATA_TYPE\",\"TYPE_NAME\",\"COLUMN_SIZE\",cast(NULL as int) as \"BUFFER_LENGTH\",\"DECIMAL_DIGITS\",\"NUM_PREC_RADIX\",cast (case when \"NULLABLE\"=true then 1 when \"NULLABLE\"=false then 0 else 2 end as INT) \"NULLABLE\",\"COLUMN_COMMENT\" as \"REMARKS\",\"COLUMN_DEF\",cast(NULL as int) as \"SQL_DATA_TYPE\",cast(NULL as int) as \"SQL_DATETIME_SUB\",\"CHAR_OCTET_LENGTH\",cast (\"ORDINAL_POSITION\" as INT) as \"ORDINAL_POSITION\",\"IS_NULLABLE\",\"SCOPE_CATALOG\",\"SCOPE_SCHEMA\",\"SCOPE_TABLE\", cast (\"SOURCE_DATA_TYPE\" as SMALLINT) as \"SOURCE_DATA_TYPE\", cast (case when \"COLUMN_IDENTITY\" is null then 'NO' else 'YES' end as VARCHAR(3)) as \"IS_AUTOINCREMENT\", cast (case when \"COLUMN_IDENTITY\" is null then 'NO' else 'YES' end as VARCHAR(3)) as \"IS_GENERATEDCOLUMN\" from ") : new StringBuffer("select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",case when \"DATA_TYPE\"=-7 then 16 else \"DATA_TYPE\" end \"DATA_TYPE\",\"TYPE_NAME\",\"COLUMN_SIZE\",cast(NULL as int) as \"BUFFER_LENGTH\",\"DECIMAL_DIGITS\",\"NUM_PREC_RADIX\",\"NULLABLE\",\"COLUMN_COMMENT\" as \"REMARKS\",\"COLUMN_DEF\",cast(NULL as int) as \"SQL_DATA_TYPE\",cast(NULL as int) as \"SQL_DATETIME_SUB\",\"CHAR_OCTET_LENGTH\",\"ORDINAL_POSITION\",\"IS_NULLABLE\",\"SCOPE_CATALOG\",\"SCOPE_SCHEMA\",\"SCOPE_TABLE\",\"SOURCE_DATA_TYPE\", 'NO' as \"IS_AUTOINCREMENT\", 'NO' as \"IS_GENERATEDCOLUMN\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(ALL_COLUMNS);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"TABLE_CAT\" is null ");
            } else {
                vector.addElement(" \"TABLE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"TABLE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"TABLE_NAME\" is null ");
            } else {
                vector.addElement(" \"TABLE_NAME\" like '" + string3 + "' ");
            }
        }
        if (string4 != null) {
            if ("".equals(string4)) {
                vector.addElement(" \"COLUMN_NAME\" is null ");
            } else {
                vector.addElement(" \"COLUMN_NAME\" like '" + string4 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"ORDINAL_POSITION\" ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            this.connection.metadataAcquired();
            return resultSet;
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        this.log("getConnection()");
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        int n;
        this.log("getCrossReference(" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + ")");
        StringBuffer stringBuffer = new StringBuffer("select \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"PKCOLUMN_NAME\",\"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"FKCOLUMN_NAME\",\"KEY_SEQ\",\"UPDATE_RULE\",\"DELETE_RULE\",\"FK_NAME\",\"PK_NAME\",\"DEFERRABILITY\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(FOREIGN_KEYS);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"PKTABLE_CAT\" is null ");
            } else {
                vector.addElement(" \"PKTABLE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"PKTABLE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"PKTABLE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"PKTABLE_NAME\" is null ");
            } else {
                vector.addElement(" \"PKTABLE_NAME\" like '" + string3 + "' ");
            }
        }
        if (string4 != null) {
            if ("".equals(string4)) {
                vector.addElement(" \"FKTABLE_CAT\" is null ");
            } else {
                vector.addElement(" \"FKTABLE_CAT\" like '" + string4 + "' ");
            }
        }
        if (string5 != null) {
            if ("".equals(string5)) {
                vector.addElement(" \"FKTABLE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"FKTABLE_SCHEM\" like '" + string5 + "' ");
            }
        }
        if (string6 != null) {
            if ("".equals(string6)) {
                vector.addElement(" \"FKTABLE_NAME\" is null ");
            } else {
                vector.addElement(" \"FKTABLE_NAME\" like '" + string6 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"KEY_SEQ\" ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (this.debug != null) {
            this.log("getDatabaseMajorVersion()");
        }
        return this.getPropInt("databaseMajorVersion", 0);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (this.debug != null) {
            this.log("getDatabaseMinorVersion()");
        }
        return this.getPropInt("databaseMinorVersion", 0);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        this.log("getDatabaseProductName()");
        if (null != this.databaseProductName) {
            return this.databaseProductName;
        }
        return this.getPropString("databaseProductName", "");
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        this.log("getDatabaseProductVersion()");
        if (null != this.databaseProductVersion) {
            return this.databaseProductVersion;
        }
        this.databaseProductVersion = this.getPropString("databaseProductVersion", "");
        return this.databaseProductVersion;
    }

    public int getDatabaseProductVersionInt() throws SQLException {
        this.log("getDatabaseProductVersionInt()");
        if (0 == this.databaseProductVersionInt) {
            if (null == this.databaseProductVersion) {
                this.databaseProductVersion = this.getPropString("databaseProductVersion", "");
            }
            char[] cArray = new char[100];
            for (int i = 0; i < this.databaseProductVersion.length(); ++i) {
                cArray[i] = this.databaseProductVersion.getBytes()[i] == 46 ? 61 : (char)this.databaseProductVersion.getBytes()[i];
            }
            String[] stringArray = TextUtil.split("=", new String(cArray));
            if (0 == stringArray.length) {
                return 0;
            }
            if (1 == stringArray.length) {
                this.databaseProductVersionInt = new Integer(stringArray[0]) * 10000;
            }
            if (2 == stringArray.length) {
                this.databaseProductVersionInt = new Integer(stringArray[0]) * 10000 + new Integer(stringArray[1]) * 100;
            }
            if (3 <= stringArray.length) {
                this.databaseProductVersionInt = new Integer(stringArray[0]) * 10000 + new Integer(stringArray[1]) * 100;
                String string = stringArray[2].trim();
                if (string.length() > 2) {
                    char[] cArray2 = new char[100];
                    string.getChars(0, 2, cArray2, 0);
                    string = "";
                    string = string + cArray2[0];
                    if (cArray2[1] >= '0' && cArray2[1] <= '9') {
                        string = string + cArray2[1];
                    }
                }
                try {
                    this.databaseProductVersionInt += new Integer(string).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.log("getDatabaseProductVersionInt() NumberFormatException: " + numberFormatException.toString());
                }
            }
        }
        return this.databaseProductVersionInt;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        this.log("getDefaultTransactionIsolation()");
        return this.getPropInt("defaultTransactionIsolation", 8);
    }

    @Override
    public int getDriverMajorVersion() {
        this.log("getDriverMajorVersion()");
        return EXADriver.getEXADriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        this.log("getDriverMinorVersion()");
        return EXADriver.getEXADriverMinorVersion();
    }

    @Override
    public String getDriverName() {
        this.log("getDriverName()");
        return EXADriver.getEXADriverName();
    }

    @Override
    public String getDriverVersion() {
        this.log("getDriverVersion()");
        String string = EXADriver.getEXADriverMajorVersion() + "." + EXADriver.getEXADriverMinorVersion() + ".";
        try {
            string = string + new Integer(EXADriver.getEXADriverVersionInc()).toString();
        }
        catch (NumberFormatException numberFormatException) {
            string = string + "0";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            int n;
            this.log("getExportedKeys(" + string + "," + string2 + "," + string3 + ")");
            StringBuffer stringBuffer = new StringBuffer("select \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"PKCOLUMN_NAME\",\"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"FKCOLUMN_NAME\",\"KEY_SEQ\",\"UPDATE_RULE\",\"DELETE_RULE\",\"FK_NAME\",\"PK_NAME\",\"DEFERRABILITY\" from ");
            stringBuffer.append(this.sysSchema);
            stringBuffer.append(".");
            stringBuffer.append(FOREIGN_KEYS);
            Vector<String> vector = new Vector<String>();
            if (string != null) {
                if ("".equals(string)) {
                    vector.addElement(" \"PKTABLE_CAT\" is null ");
                } else {
                    vector.addElement(" \"PKTABLE_CAT\" like '" + string + "' ");
                }
            }
            if (string2 != null) {
                if ("".equals(string2)) {
                    vector.addElement(" \"PKTABLE_SCHEM\" is null ");
                } else {
                    vector.addElement(" \"PKTABLE_SCHEM\" like '" + string2 + "' ");
                }
            }
            if (string3 != null) {
                if ("".equals(string3)) {
                    vector.addElement(" \"PKTABLE_NAME\" is null ");
                } else {
                    vector.addElement(" \"PKTABLE_NAME\" like '" + string3 + "' ");
                }
            }
            if ((n = vector.size()) > 0) {
                stringBuffer.append(" WHERE ");
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append((String)vector.elementAt(i));
                    if (i >= n - 1) continue;
                    stringBuffer.append(" AND ");
                }
            }
            stringBuffer.append(" order by \"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"KEY_SEQ\" ");
            if (this.metaStmt.execute(stringBuffer.toString())) {
                ResultSet resultSet = this.metaStmt.getResultSet();
                return resultSet;
            }
            return null;
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        this.log("getExtraNameCharacters()");
        return this.getPropString("extraNameCharacters", "");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.log("getIdentifierQuoteString()");
        return this.getPropString("identifierQuoteString", "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            int n;
            this.log("getImportedKeys(" + string + "," + string2 + "," + string3 + ")");
            StringBuffer stringBuffer = new StringBuffer("select \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"PKCOLUMN_NAME\",\"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"FKCOLUMN_NAME\",\"KEY_SEQ\",\"UPDATE_RULE\",\"DELETE_RULE\",\"FK_NAME\",\"PK_NAME\",\"DEFERRABILITY\" from ");
            stringBuffer.append(this.sysSchema);
            stringBuffer.append(".");
            stringBuffer.append(FOREIGN_KEYS);
            Vector<String> vector = new Vector<String>();
            if (string != null) {
                if ("".equals(string)) {
                    vector.addElement(" \"FKTABLE_CAT\" is null ");
                } else {
                    vector.addElement(" \"FKTABLE_CAT\" like '" + string + "' ");
                }
            }
            if (string2 != null) {
                if ("".equals(string2)) {
                    vector.addElement(" \"FKTABLE_SCHEM\" is null ");
                } else {
                    vector.addElement(" \"FKTABLE_SCHEM\" like '" + string2 + "' ");
                }
            }
            if (string3 != null) {
                if ("".equals(string3)) {
                    vector.addElement(" \"FKTABLE_NAME\" is null ");
                } else {
                    vector.addElement(" \"FKTABLE_NAME\" like '" + string3 + "' ");
                }
            }
            if ((n = vector.size()) > 0) {
                stringBuffer.append(" WHERE ");
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(vector.elementAt(i).toString());
                    if (i >= n - 1) continue;
                    stringBuffer.append(" AND ");
                }
            }
            stringBuffer.append(" order by \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"KEY_SEQ\" ");
            if (this.metaStmt.execute(stringBuffer.toString())) {
                ResultSet resultSet = this.metaStmt.getResultSet();
                return resultSet;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            int n;
            this.log("getIndexInfo(" + string + "," + string2 + "," + string3 + "," + bl + "," + bl2 + ")");
            StringBuffer stringBuffer = new StringBuffer("select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"NON_UNIQUE\",\"INDEX_QUALIFIER\",\"INDEX_NAME\",\"TYPE\",\"ORDINAL_POSITION\",\"COLUMN_NAME\",\"ASC_OR_DESC\",\"CARDINALITY\",\"PAGES\",\"FILTER_CONDITION\" from ");
            stringBuffer.append(this.sysSchema);
            stringBuffer.append(".");
            stringBuffer.append(ALL_INDICES);
            Vector<String> vector = new Vector<String>();
            if (string != null) {
                if ("".equals(string)) {
                    vector.addElement(" \"TABLE_CAT\" is null ");
                } else {
                    vector.addElement(" \"TABLE_CAT\" like '" + string + "' ");
                }
            }
            if (string2 != null) {
                if ("".equals(string2)) {
                    vector.addElement(" \"TABLE_SCHEM\" is null ");
                } else {
                    vector.addElement(" \"TABLE_SCHEM\" like '" + string2 + "' ");
                }
            }
            if (string3 != null) {
                if ("".equals(string3)) {
                    vector.addElement(" \"TABLE_NAME\" is null ");
                } else {
                    vector.addElement(" \"TABLE_NAME\" like '" + string3 + "' ");
                }
            }
            if (bl) {
                vector.addElement(" \"NON_UNIQUE\"=false ");
            }
            if ((n = vector.size()) > 0) {
                stringBuffer.append(" WHERE ");
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(vector.elementAt(i).toString());
                    if (i >= n - 1) continue;
                    stringBuffer.append(" AND ");
                }
            }
            stringBuffer.append(" order by \"NON_UNIQUE\",\"TYPE\",\"INDEX_NAME\",\"ORDINAL_POSITION\" ");
            if (this.metaStmt.execute(stringBuffer.toString())) {
                ResultSet resultSet = this.metaStmt.getResultSet();
                return resultSet;
            }
            return null;
        }
    }

    @Override
    public int getJDBCMajorVersion() {
        if (this.debug != null) {
            this.log("getDatabaseMajorVersion()");
        }
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        if (this.debug != null) {
            this.log("getDatabaseMinorVersion()");
        }
        return 1;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        this.log("getMaxBinaryLiteralLength()");
        return this.getPropInt("maxBinaryLiteralLength", 0);
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        this.log("getMaxCatalogNameLength()");
        return this.getPropInt("maxCatalogNameLength", 30);
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        this.log("getMaxCharLiteralLength()");
        return this.getPropInt("maxCharLiteralLength", 99);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        this.log("getMaxColumnNameLength()");
        return this.getPropInt("maxColumnNameLength", 30);
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        this.log("getMaxColumnsInGroupBy():1000");
        return this.getPropInt("maxColumnsInGroupBy", 1000);
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        this.log("getMaxColumnsInIndex()");
        return this.getPropInt("maxColumnsInIndex", 0);
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        this.log("getMaxColumnsInOrderBy()");
        return this.getPropInt("maxColumnsInOrderBy", 1000);
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        this.log("getMaxColumnsInSelect()");
        return this.getPropInt("maxColumnsInSelect", 1000);
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        this.log("getMaxColumnsInTable()");
        return this.getPropInt("maxColumnsInTable", 1000);
    }

    @Override
    public int getMaxConnections() throws SQLException {
        this.log("getMaxConnections()");
        return this.getPropInt("maxConnections", 1);
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        this.log("getMaxCursorNameLength()");
        return this.getPropInt("maxCursorNameLength", 0);
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        this.log("getMaxIndexLength()");
        return this.getPropInt("maxIndexLength", 0);
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        this.log("getMaxProcedureNameLength()");
        return this.getPropInt("maxProcedureNameLength", 30);
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        this.log("getMaxRowSize()");
        return this.getPropInt("maxRowSize", 32000);
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        this.log("getMaxSchemaNameLength()");
        return this.getPropInt("maxSchemaNameLength", 30);
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        this.log("getMaxStatementLength()");
        return this.getPropInt("maxStatementLength", 100000);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        this.log("getMaxStatements()");
        return this.getPropInt("maxStatements", 100);
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        this.log("getMaxTableNameLength()");
        return this.getPropInt("maxTableNameLength", 30);
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        this.log("getMaxTablesInSelect()");
        return this.getPropInt("maxTablesInSelect", 0);
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        this.log("getMaxUserNameLength()");
        return this.getPropInt("maxUserNameLength", 30);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        this.log("getNumericFunctions()");
        return this.getPropString("numericFunctions", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getPrimaryKeys(" + string + "," + string2 + "," + string3 + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetPrimaryKeys(string, string2, string3);
            }
            return this.getPrimaryKeysSql(string, string2, string3);
        }
    }

    private ResultSet jdbcGetPrimaryKeys(String string, String string2, String string3) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)63, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getPrimaryKeysSql(String string, String string2, String string3) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",\"KEY_SEQ\",\"PK_NAME\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(PRIMARY_KEYS);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"TABLE_CAT\" is null ");
            } else {
                vector.addElement(" \"TABLE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"TABLE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"TABLE_NAME\" is null ");
            } else {
                vector.addElement(" \"TABLE_NAME\" like '" + string3 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"COLUMN_NAME\" ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getProcedureColumns(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetProcedureColumns(string, string2, string3, string4);
            }
            return this.getProcedureColumnsSql(string, string2, string3, string4);
        }
    }

    private ResultSet jdbcGetProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
            if (null == string4) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string4.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string4.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)64, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getProcedureColumnsSql(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("select \"PROCEDURE_CAT\",\"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\",\"COLUMN_NAME\",cast (\"DATA_TYPE\" as smallint) as \"COLUMN_TYPE\",\"DATA_TYPE\", cast (\"TYPE_NAME\" as varchar(128)) as \"TYPE_NAME\",  cast (\"PRECISION\" as int) as \"PRECISION\", cast (\"LENGTH\" as int) as \"LENGTH\", cast(\"SCALE\" as smallint) as \"SCALE\", cast (\"RADIX\" as smallint) as \"RADIX\", cast (\"NULLABLE\" as smallint) as \"NULLABLE\",\"REMARKS\",  cast (NULL as varchar(2000)) as \"COLUMN_DEF\", cast (NULL as int) as \"SQL_DATA_TYPE\", cast (NULL as int) as \"SQL_DATETIME_SUB\", cast (NULL as int) as \"CHAR_OCTET_LENGTH\", cast (NULL as int) as \"ORDINAL_POSITION\",  cast (NULL as varchar(3)) as \"IS_NULLABLE\", cast (NULL as varchar(128)) as \"SPECIFIC_NAME\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(PROCEDURE_COLUMNS);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"PROCEDURE_CAT\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"PROCEDURE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"PROCEDURE_NAME\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_NAME\" like '" + string3 + "' ");
            }
        }
        if (string4 != null) {
            if ("".equals(string4)) {
                vector.addElement(" \"COLUMN_NAME\" is null ");
            } else {
                vector.addElement(" \"COLUMN_NAME\" like '" + string4 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\" ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getProcedures(" + string + ", " + string2 + ", " + string3 + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetProcedures(string, string2, string3);
            }
            return this.getProceduresSql(string, string2, string3);
        }
    }

    private ResultSet jdbcGetProcedures(String string, String string2, String string3) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)65, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getProceduresSql(String string, String string2, String string3) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("select \"PROCEDURE_CAT\",\"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\", cast(-1 as smallint) as \"NUM_INPUT_PARAMS\", cast(-1 as smallint) as \"NUM_OUTPUT_PARAMS\", cast(-1 as smallint) as \"NUM_RESULT_SETS\", cast (\"REMARKS\" as varchar(2000)) as \"REMARKS\", cast(0 as smallint) as \"PROCEDURE_TYPE\", \"PROCEDURE_NAME\" as \"SPECIFIC_NAME\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(ALL_PROCEDURES);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"PROCEDURE_CAT\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"PROCEDURE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"PROCEDURE_NAME\" is null ");
            } else {
                vector.addElement(" \"PROCEDURE_NAME\" like '" + string3 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\" ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        this.log("getProcedureTerm()");
        return this.getPropString("procedureTerm", "PROCEDURE");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.debug != null) {
            this.log("getResultSetHoldability()");
        }
        return this.getPropInt("resultSetHoldability", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getSchemas()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetSchemas(string, string2);
            }
            return this.getSchemasSql(string, string2);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        if (this.debug != null) {
            this.log("supportsStoredFunctionsUsingCallSyntax()");
        }
        return this.getPropBoolean("supportsStoredFunctionsUsingCallSyntax", false);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        if (this.debug != null) {
            this.log("autoCommitFailureClosesAllResultSets()");
        }
        return this.getPropBoolean("autoCommitFailureClosesAllResultSets", false);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        if (this.debug != null) {
            this.log("getClientInfoProperties()");
        }
        EXAResultSet eXAResultSet = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] columnArray = new Column[]{new CharColumn(128), new DecimalColumn(18, 0), new CharColumn(256), new CharColumn(512)};
        eXAResultSet.addColumn(columnArray[0], "NAME");
        eXAResultSet.addColumn(columnArray[1], "MAX_LEN");
        eXAResultSet.addColumn(columnArray[2], "DEFAULT_VALUE");
        eXAResultSet.addColumn(columnArray[3], "DESCRIPTION");
        eXAResultSet.resize(23);
        int n = 0;
        columnArray[0].setString(n, "autocommit");
        columnArray[1].setInt(n, 1);
        columnArray[2].setString(n, new Integer(1).toString());
        columnArray[3].setString(n, "Right after the connection is established, setAutocommit is called by the driver. Values: 1 for autocommit true, 0 for autocommit false. ");
        columnArray[0].setString(++n, "clientname");
        columnArray[1].setInt(n, this.connection.getMaxIdentifierLen());
        columnArray[2].setString(n, "Generic client");
        columnArray[3].setString(n, "Specifies the name of the client app that uses Exasol JDBC. Is shown in the server log files. ");
        columnArray[0].setString(++n, "clientversion");
        columnArray[1].setInt(n, this.connection.getMaxIdentifierLen());
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "Specifies the version of the client app that uses Exasol JDBC. Is shown in the server log files. ");
        columnArray[0].setString(++n, "connecttimeout");
        columnArray[1].setInt(n, new Integer(Integer.MAX_VALUE).toString().length());
        columnArray[2].setString(n, new Integer(2000).toString());
        columnArray[3].setString(n, "A timeout in seconds that specifies the maximum time interval the driver will try to establish a connection on each node given in the connection string. ");
        columnArray[0].setString(++n, "connectionPoolSize");
        columnArray[1].setInt(n, new Integer(Integer.MAX_VALUE).toString().length());
        columnArray[2].setString(n, new Integer(EXADriver.connectionPoolSize).toString());
        columnArray[3].setString(n, "Specifies the size of the connection pool. This has effect on all connections in this instance of the VM and can be changed only once. ");
        columnArray[0].setString(++n, "debug");
        columnArray[1].setInt(n, 1);
        columnArray[2].setString(n, new Integer(0).toString());
        columnArray[3].setString(n, "The value 1 switches on the driver's log function. The driver then writes a log file named jdbc_timestamp.log for each established connection. ");
        columnArray[0].setString(++n, "encryption");
        columnArray[1].setInt(n, 1);
        columnArray[2].setString(n, new Integer(1).toString());
        columnArray[3].setString(n, "Tells the driver that he has to enable or disable encryption of the socket communications with the server. Default encryption is 1 (enabled).");
        columnArray[0].setString(++n, "feedbackinterval");
        columnArray[1].setInt(n, new Integer(Integer.MAX_VALUE).toString().length());
        columnArray[2].setString(n, new Integer(EXAConnection.defaultFeedbackInterval).toString());
        columnArray[3].setString(n, "Specifies the interval in seconds after that the server gives feedback to the client about a running query. ");
        columnArray[0].setString(++n, "fetchsize");
        columnArray[1].setInt(n, new Integer(Integer.MAX_VALUE).toString().length());
        columnArray[2].setString(n, new Integer(2048).toString());
        columnArray[3].setString(n, "Fetch size in kilobytes for retrieving result sets. ");
        columnArray[0].setString(++n, "kerberosconfig");
        columnArray[1].setInt(n, 4096);
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "Kerberos config file name and path (will set java.security.krb5.conf). ");
        columnArray[0].setString(++n, "kerberosgssconfig");
        columnArray[1].setInt(n, 4096);
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "Kerberos GSS config file name and path (will set java.security.auth.login.config). ");
        columnArray[0].setString(++n, "kerberoshostname");
        columnArray[1].setInt(n, 255);
        columnArray[2].setString(n, this.connection.getEXAServer());
        columnArray[3].setString(n, "Kerberos host name. Default is the host of the EXASOL server where the connection will be made. If in the connection string there are multiple hosts specified, the host chosen to connect to will be used here, too. ");
        columnArray[0].setString(++n, "kerberosrealm");
        columnArray[1].setInt(n, 255);
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "Kerberos realm. ");
        columnArray[0].setString(++n, "kerberosservicename");
        columnArray[1].setInt(n, this.connection.getMaxIdentifierLen());
        columnArray[2].setString(n, "exasol");
        columnArray[3].setString(n, "Kerberos service name. ");
        columnArray[0].setString(++n, "kerberosusername");
        columnArray[1].setInt(n, this.connection.getMaxIdentifierLen());
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "Kerberos user name. ");
        columnArray[0].setString(++n, "debug");
        columnArray[1].setInt(n, 4096);
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "Defines the directory where the JDBC debug log files should be written to (in debug mode). ");
        columnArray[0].setString(++n, "logintimeout");
        columnArray[1].setInt(n, new Integer(Integer.MAX_VALUE).toString().length());
        columnArray[2].setString(n, new Integer(0).toString());
        columnArray[3].setString(n, "A timeout in seconds that specifies how long the driver will wait for the server until the answer package for a connect request arrives. This timeout has effect only after a socket connection to the server was already established. ");
        columnArray[0].setString(++n, "metadataSQL");
        columnArray[1].setInt(n, 1);
        columnArray[2].setString(n, new Integer(0).toString());
        columnArray[3].setString(n, "Used for parallel connections. The identifying token for the worker connection. ");
        columnArray[0].setString(++n, "querytimeout");
        columnArray[1].setInt(n, new Integer(Integer.MAX_VALUE).toString().length());
        columnArray[2].setString(n, new Integer(0).toString());
        columnArray[3].setString(n, "Sets the query timeout for statement execution. Default is 0 (unlimited). ");
        columnArray[0].setString(++n, "schema");
        columnArray[1].setInt(n, this.connection.getMaxIdentifierLen());
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "If specified, the driver opens the schema right after the connection is established. ");
        columnArray[0].setString(++n, "worker");
        columnArray[1].setInt(n, 1);
        columnArray[2].setString(n, new Integer(0).toString());
        columnArray[3].setString(n, "Used for parallel connections. The value 1 tells the driver that a worker connection is to be made. ");
        columnArray[0].setString(++n, "workertoken");
        columnArray[1].setInt(n, new Long(Long.MAX_VALUE).toString().length());
        columnArray[2].setNull(n);
        columnArray[3].setString(n, "Used for parallel connections. The identifying token for the worker connection. ");
        columnArray[0].setString(++n, "superconnection");
        columnArray[1].setInt(n, 1);
        columnArray[2].setString(n, new Integer(0).toString());
        columnArray[3].setString(n, "Enables the super connection mode if set to 1. Only the user sys set this attribute. Default is 0 (no super connection). ");
        ++n;
        return eXAResultSet;
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        this.log("generatedKeyAlwaysReturned() - false");
        return false;
    }

    private ResultSet jdbcGetSchemas(String string, String string2) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)66, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getSchemasSql(String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("select \"TABLE_SCHEM\",\"TABLE_CAT\" as \"TABLE_CATALOG\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".ALL_SCHEMAS ");
        if (null != string || null != string2) {
            stringBuffer.append("where ");
        }
        if (null != string) {
            stringBuffer.append(" \"TABLE_CAT\"='" + string + "' ");
            if (null != string2) {
                stringBuffer.append("and ");
            }
        }
        if (null != string2) {
            stringBuffer.append(" \"TABLE_SCHEM\" like '" + string2 + "' ");
        }
        stringBuffer.append("order by \"TABLE_CATALOG\",\"TABLE_SCHEM\"");
        return this.metaStmt.executeQuery(stringBuffer.toString());
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.log("getSchemas()");
        return this.getSchemas(null, null);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        this.log("getSchemaTerm()");
        return this.getPropString("schemaTerm", "SCHEMA");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        this.log("getSearchStringEscape()");
        return this.getPropString("searchStringEscape", "");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.log("getSQLKeywords()");
        return this.getPropString("SQLKeywords", "");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        if (this.debug != null) {
            this.log("getSQLStateType()");
        }
        return this.getPropInt("SQLStateType", 0);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.log("getStringFunctions()");
        return this.getPropString("stringFunctions", "");
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        if (this.debug != null) {
            this.log("getSuperTables(" + string + "," + string2 + "," + string3 + ")");
        }
        EXAResultSet eXAResultSet = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] columnArray = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30)};
        eXAResultSet.addColumn(columnArray[0], "TABLE_CAT");
        eXAResultSet.addColumn(columnArray[1], "TABLE_SCHEM");
        eXAResultSet.addColumn(columnArray[2], "TABLE_NAME");
        eXAResultSet.addColumn(columnArray[3], "SUPERTABLE_NAME");
        eXAResultSet.resize(0);
        return eXAResultSet;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        if (this.debug != null) {
            this.log("getSuperTypes(" + string + "," + string2 + "," + string3 + ")");
        }
        EXAResultSet eXAResultSet = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] columnArray = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30)};
        eXAResultSet.addColumn(columnArray[0], "TYPE_CAT");
        eXAResultSet.addColumn(columnArray[1], "TYPE_SCHEM");
        eXAResultSet.addColumn(columnArray[2], "TYPE_NAME");
        eXAResultSet.addColumn(columnArray[3], "SUPERTYPE_CAT");
        eXAResultSet.addColumn(columnArray[4], "SUPERTYPE_SCHEM");
        eXAResultSet.addColumn(columnArray[5], "SUPERTYPE_NAME");
        eXAResultSet.resize(0);
        return eXAResultSet;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        this.log("getSystemFunctions()");
        return this.getPropString("systemFunctions", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getTablePrivileges(" + string + "," + string2 + "," + string3 + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTablePrivileges(string, string2, string3);
            }
            return this.getTablePrivilegesSql(string, string2, string3);
        }
    }

    private ResultSet jdbcGetTablePrivileges(String string, String string2, String string3) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)67, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getTablePrivilegesSql(String string, String string2, String string3) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"GRANTOR\",\"GRANTEE\",\"PRIVILEGE\",decode(\"IS_GRANTABLE\",true,'YES',false,'NO') as \"IS_GRANTABLE\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(TABLE_PRIVILEGES);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"TABLE_CAT\" is null ");
            } else {
                vector.addElement(" \"TABLE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"TABLE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"TABLE_NAME\" is null ");
            } else {
                vector.addElement(" \"TABLE_NAME\" like '" + string3 + "' ");
            }
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(vector.elementAt(i).toString());
                if (i >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"TABLE_CAT\", \"TABLE_SCHEM\",\"TABLE_NAME\",\"PRIVILEGE\",\"GRANTOR\" nulls first,\"GRANTEE\" nulls first ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            String string4 = "";
            if (null == stringArray) {
                string4 = "null";
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    string4 = string4 + stringArray[i];
                    if (i >= stringArray.length - 1) continue;
                    string4 = string4 + ",";
                }
            }
            this.log("getTables(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTables(string, string2, string3, stringArray);
            }
            return this.getTablesSql(string, string2, string3, stringArray);
        }
    }

    private ResultSet jdbcGetTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            if (null == string) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string.getBytes(this.connection.getEncoding()));
            }
            if (null == string2) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string2.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string2.getBytes(this.connection.getEncoding()));
            }
            if (null == string3) {
                eXAOutputStream.writeInt(-1);
            } else {
                eXAOutputStream.writeInt(string3.getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(string3.getBytes(this.connection.getEncoding()));
            }
            if (null == stringArray) {
                eXAOutputStream.writeInt(-1);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    eXAOutputStream.writeInt(stringArray[i].getBytes(this.connection.getEncoding()).length);
                    eXAOutputStream.write(stringArray[i].getBytes(this.connection.getEncoding()));
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new SQLException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)68, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    private synchronized ResultSet getTablesSql(String string, String string2, String string3, String[] stringArray) throws SQLException {
        int n;
        int n2;
        StringBuffer stringBuffer;
        if (this.debug != null) {
            stringBuffer = new StringBuffer("getTables(");
            stringBuffer.append(string);
            stringBuffer.append(",");
            stringBuffer.append(string2);
            stringBuffer.append(",");
            stringBuffer.append(string3);
            stringBuffer.append(",[");
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append(",");
                }
            }
            stringBuffer.append("])");
            this.log(stringBuffer.toString());
        }
        stringBuffer = new StringBuffer("select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"TABLE_TYPE\",\"REMARKS\",\"TYPE_CAT\",\"TYPE_SCHEM\",\"TYPE_NAME\",\"SELF_REFERENCING_COL_NAME\",\"REF_GENERATION\" from ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".");
        stringBuffer.append(ALL_TABLES);
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            if ("".equals(string)) {
                vector.addElement(" \"TABLE_CAT\" is null ");
            } else {
                vector.addElement(" \"TABLE_CAT\" like '" + string + "' ");
            }
        }
        if (string2 != null) {
            if ("".equals(string2)) {
                vector.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                vector.addElement(" \"TABLE_SCHEM\" like '" + string2 + "' ");
            }
        }
        if (string3 != null) {
            if ("".equals(string3)) {
                vector.addElement(" \"TABLE_NAME\" is null ");
            } else {
                vector.addElement(" \"TABLE_NAME\" like '" + string3 + "' ");
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(" \"TABLE_TYPE\" in (");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringBuffer2.append("'");
                stringBuffer2.append(stringArray[n2]);
                stringBuffer2.append("'");
                if (n2 >= stringArray.length - 1) continue;
                stringBuffer2.append(',');
            }
            stringBuffer2.append(") ");
            vector.addElement(stringBuffer2.toString());
        }
        if ((n = vector.size()) > 0) {
            stringBuffer.append(" WHERE ");
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(vector.elementAt(n2).toString());
                if (n2 >= n - 1) continue;
                stringBuffer.append(" AND ");
            }
        }
        stringBuffer.append(" order by \"TABLE_TYPE\",\"TABLE_SCHEM\",\"TABLE_NAME\" ");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            ResultSet resultSet = this.metaStmt.getResultSet();
            return resultSet;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getTableTypes()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTableTypes();
            }
            return this.getTableTypesSql();
        }
    }

    private ResultSet jdbcGetTableTypes() throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        EXAResult[] eXAResultArray = this.connection.communication_resultset(new byte[0], (byte)69, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    protected ResultSet getTableTypesSql() throws SQLException {
        ResultSet resultSet = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("select \"TABLE_TYPE\" from ");
            stringBuffer.append(this.sysSchema);
            stringBuffer.append(".TABLE_TYPES order by \"TABLE_TYPE\"");
            if (this.metaStmt.execute(stringBuffer.toString())) {
                resultSet = this.metaStmt.getResultSet();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (resultSet == null) {
            resultSet = this.connection.dialectFactory.createResultSet("TABLE_TYPE", tableTypes, this.debug);
        }
        return resultSet;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        this.log("getTimeDateFunctions()");
        return this.getPropString("timeDateFunctions", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getTypeInfo()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTypeInfo();
            }
            return this.getTypeInfoSql();
        }
    }

    private ResultSet jdbcGetTypeInfo() throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        EXAResult[] eXAResultArray = this.connection.communication_resultset(new byte[0], (byte)70, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    protected ResultSet getTypeInfoSql() throws SQLException {
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        stringBuffer.append("\"TYPE_NAME\",");
        stringBuffer.append("case \"DATA_TYPE\" when -7 then 16 else \"DATA_TYPE\" end as \"DATA_TYPE\",");
        stringBuffer.append("\"PRECISION\",");
        stringBuffer.append("\"LITERAL_PREFIX\",");
        stringBuffer.append("\"LITERAL_SUFFIX\",");
        stringBuffer.append("\"CREATE_PARAMS\",");
        stringBuffer.append("cast (case \"NULLABLE\" when false then 0 when true then 1 end as smallint) as \"NULLABLE\",");
        stringBuffer.append("\"CASE_SENSITIVE\",");
        stringBuffer.append("\"SEARCHABLE\",");
        stringBuffer.append("\"UNSIGNED_ATTRIBUTE\",");
        stringBuffer.append("\"FIXED_PREC_SCALE\",");
        stringBuffer.append("\"AUTO_INCREMENT\",");
        stringBuffer.append("\"LOCAL_TYPE_NAME\",");
        stringBuffer.append("cast (\"MINIMUM_SCALE\" as smallint) as \"MINIMUM_SCALE\",");
        stringBuffer.append("cast (\"MAXIMUM_SCALE\" as smallint) as \"MAXIMUM_SCALE\",");
        stringBuffer.append("\"SQL_DATA_TYPE\",");
        stringBuffer.append("\"SQL_DATETIME_SUB\",");
        stringBuffer.append("\"NUM_PREC_RADIX\" ");
        stringBuffer.append("FROM ");
        stringBuffer.append(this.sysSchema);
        stringBuffer.append(".SQL_TYPES ORDER BY \"DATA_TYPE\"");
        if (this.metaStmt.execute(stringBuffer.toString())) {
            resultSet = this.metaStmt.getResultSet();
        }
        if (null == resultSet) {
            throw new SQLException(Translator.Failed_to_get_types_info_from_server());
        }
        return resultSet;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        this.log("getUDTs(" + string + "," + string2 + "," + string3 + ")");
        EXAResultSet eXAResultSet = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] columnArray = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0), new CharColumn(30), new DecimalColumn(18, 0)};
        eXAResultSet.addColumn(columnArray[0], "TYPE_CAT");
        eXAResultSet.addColumn(columnArray[1], "TYPE_SCHEM");
        eXAResultSet.addColumn(columnArray[2], "TYPE_NAME");
        eXAResultSet.addColumn(columnArray[3], "CLASS_NAME");
        eXAResultSet.addColumn(columnArray[4], "DATA_TYPE");
        eXAResultSet.addColumn(columnArray[5], "REMARKS");
        eXAResultSet.addColumn(columnArray[6], "BASE_TYPE");
        eXAResultSet.resize(0);
        return eXAResultSet;
    }

    @Override
    public String getURL() {
        String string = this.connection.getURL();
        this.log("getURL():" + string);
        return string;
    }

    @Override
    public String getUserName() {
        this.log("getUserName():" + this.connection.getUser());
        return this.connection.getUser();
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this.log("getVersionColumns(" + string + "," + string2 + "," + string3 + ")");
        EXAResultSet eXAResultSet = this.connection.dialectFactory.createResultSet(this.debug);
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "SCOPE");
        eXAResultSet.addColumn(new CharColumn(30), "COLUMN_NAME");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "DATA_TYPE");
        eXAResultSet.addColumn(new CharColumn(30), "TYPE_NAME");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "COLUMN_SIZE");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "BUFFER_LENGTH");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "DECIMAL_DIGITS");
        eXAResultSet.addColumn(new DecimalColumn(18, 0), "PSEUDO_COLUMN");
        eXAResultSet.resize(0);
        return eXAResultSet;
    }

    @Override
    public boolean insertsAreDetected(int n) {
        this.log("insertsAreDetected(" + n + "):false");
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        this.log("isCatalogAtStart()");
        return this.getPropBoolean("isCatalogAtStart", false);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.log("isReadOnly()");
        return this.getPropBoolean("isReadOnly", true);
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        if (this.debug != null) {
            this.log("locatorsUpdateCopy()");
        }
        return this.getPropBoolean("locatorsUpdateCopy", false);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.log("nullPlusNonNullIsNull()");
        return this.getPropBoolean("nullPlusNonNullIsNull", true);
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.log("nullsAreSortedAtEnd()");
        return this.getPropBoolean("nullsAreSortedAtEnd", false);
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        this.log("nullsAreSortedAtStart()");
        return this.getPropBoolean("nullsAreSortedAtStart", false);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        this.log("nullsAreSortedHigh()");
        return this.getPropBoolean("nullsAreSortedHigh", false);
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        this.log("nullsAreSortedLow()");
        return this.getPropBoolean("nullsAreSortedLow", true);
    }

    @Override
    public boolean othersDeletesAreVisible(int n) {
        this.log("othersDeletesAreVisible(" + n + "):false");
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) {
        this.log("othersInsertsAreVisible(" + n + "):false");
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) {
        this.log("othersUpdatesAreVisible(" + n + "):false");
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) {
        this.log("ownDeletesAreVisible(" + n + "):false");
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) {
        this.log("ownInsertsAreVisible(" + n + "):false");
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) {
        this.log("ownUpdatesAreVisible(" + n + "):false");
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.log("storesLowerCaseIdentifiers()");
        return this.getPropBoolean("storesLowerCaseIdentifiers", false);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.log("storesLowerCaseQuotedIdentifiers()");
        return this.getPropBoolean("storesLowerCaseQuotedIdentifiers", false);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.log("storesMixedCaseIdentifiers()");
        return this.getPropBoolean("storesMixedCaseIdentifiers", false);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.log("storesMixedCaseQuotedIdentifiers()");
        return this.getPropBoolean("storesMixedCaseQuotedIdentifiers", false);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.log("storesUpperCaseIdentifiers()");
        return this.getPropBoolean("storesUpperCaseIdentifiers", true);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.log("storesUpperCaseQuotedIdentifiers()");
        return this.getPropBoolean("storesUpperCaseQuotedIdentifiers", false);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.log("supportsAlterTableWithAddColumn()");
        return this.getPropBoolean("supportsAlterTableWithAddColumn", false);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.log("supportsAlterTableWithDropColumn()");
        return this.getPropBoolean("supportsAlterTableWithDropColumn", false);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (this.debug != null) {
            this.log("supportsANSI92EntryLevelSQL()");
        }
        return this.getPropBoolean("supportsANSI92EntryLevelSQL", false);
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (this.debug != null) {
            this.log("supportsANSI92FullSQL()");
        }
        return this.getPropBoolean("supportsANSI92FullSQL", false);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (this.debug != null) {
            this.log("supportsANSI92IntermediateSQL()");
        }
        return this.getPropBoolean("supportsANSI92IntermediateSQL", false);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        if (this.debug != null) {
            this.log("supportsBatchUpdates()");
        }
        return this.getPropBoolean("supportsBatchUpdates", true);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInDataManipulation()");
        }
        return this.getPropBoolean("supportsCatalogsInDataManipulation", false);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInIndexDefinitions()");
        }
        return this.getPropBoolean("supportsCatalogsInIndexDefinitions", false);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInPrivilegeDefinitions()");
        }
        return this.getPropBoolean("supportsCatalogsInPrivilegeDefinitions", false);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInProcedureCalls()");
        }
        return this.getPropBoolean("supportsCatalogsInProcedureCalls", false);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInTableDefinitions()");
        }
        return this.getPropBoolean("supportsCatalogsInTableDefinitions", false);
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        if (this.debug != null) {
            this.log("supportsColumnAliasing()");
        }
        return this.getPropBoolean("supportsColumnAliasing", true);
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        if (this.debug != null) {
            this.log("supportsConvert()");
        }
        return this.getPropBoolean("supportsConvert", false);
    }

    @Override
    public boolean supportsConvert(int n, int n2) {
        if (this.debug != null) {
            this.log("supportsConvert(" + n + "," + n2 + "):false");
        }
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCoreSQLGrammar()");
        }
        return this.getPropBoolean("supportsCoreSQLGrammar", false);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCorrelatedSubqueries()");
        }
        return this.getPropBoolean("supportsCorrelatedSubqueries", false);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsDataDefinitionAndDataManipulationTransactions()");
        }
        return this.getPropBoolean("supportsDataDefinitionAndDataManipulationTransactions", true);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (this.debug != null) {
            this.log("supportsDataManipulationTransactionsOnly()");
        }
        return this.getPropBoolean("supportsDataManipulationTransactionsOnly", false);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (this.debug != null) {
            this.log("supportsDifferentTableCorrelationNames()");
        }
        return this.getPropBoolean("supportsDifferentTableCorrelationNames", false);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (this.debug != null) {
            this.log("supportsExpressionsInOrderBy()");
        }
        return this.getPropBoolean("supportsExpressionsInOrderBy", true);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (this.debug != null) {
            this.log("supportsExtendedSQLGrammar()");
        }
        return this.getPropBoolean("supportsExtendedSQLGrammar", false);
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        if (this.debug != null) {
            this.log("supportsFullOuterJoins()");
        }
        return this.getPropBoolean("supportsFullOuterJoins", false);
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGetGeneratedKeys()");
        }
        return this.getPropBoolean("supportsGetGeneratedKeys", false);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGroupBy()");
        }
        return this.getPropBoolean("supportsGroupBy", true);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGroupByBeyondSelect()");
        }
        return this.getPropBoolean("supportsGroupByBeyondSelect", false);
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGroupByUnrelated()");
        }
        return this.getPropBoolean("supportsGroupByUnrelated", true);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        if (this.debug != null) {
            this.log("supportsIntegrityEnhancementFacility()");
        }
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (this.debug != null) {
            this.log("supportsLikeEscapeClause()");
        }
        return this.getPropBoolean("supportsLikeEscapeClause", false);
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (this.debug != null) {
            this.log("supportsLimitedOuterJoins()");
        }
        return this.getPropBoolean("supportsLimitedOuterJoins", true);
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMinimumSQLGrammar()");
        }
        return this.getPropBoolean("supportsMinimumSQLGrammar", false);
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMixedCaseIdentifiers()");
        }
        return this.getPropBoolean("supportsMixedCaseIdentifiers", true);
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMixedCaseQuotedIdentifiers()");
        }
        return this.getPropBoolean("supportsMixedCaseQuotedIdentifiers", true);
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMultipleResultSets()");
        }
        return this.getPropBoolean("supportsMultipleResultSets", true);
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMultipleOpenResults()");
        }
        return this.getPropBoolean("supportsMultipleOpenResults", true);
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMultipleTransactions()");
        }
        return this.getPropBoolean("supportsMultipleTransactions", false);
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        if (this.debug != null) {
            this.log("supportsNamedParameters()");
        }
        return this.getPropBoolean("supportsNamedParameters", false);
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        if (this.debug != null) {
            this.log("supportsNonNullableColumns()");
        }
        return this.getPropBoolean("supportsNonNullableColumns", false);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenCursorsAcrossCommit()");
        }
        return this.getPropBoolean("supportsOpenCursorsAcrossCommit", false);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenCursorsAcrossRollback()");
        }
        return this.getPropBoolean("supportsOpenCursorsAcrossRollback", false);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenStatementsAcrossCommit()");
        }
        return this.getPropBoolean("supportsOpenStatementsAcrossCommit", true);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenStatementsAcrossRollback()");
        }
        return this.getPropBoolean("supportsOpenStatementsAcrossRollback", true);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOrderByUnrelated()");
        }
        return this.getPropBoolean("supportsOrderByUnrelated", true);
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOuterJoins()");
        }
        return this.getPropBoolean("supportsOuterJoins", true);
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        if (this.debug != null) {
            this.log("supportsPositionedDelete()");
        }
        return this.getPropBoolean("supportsPositionedDelete", false);
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        if (this.debug != null) {
            this.log("supportsPositionedUpdate()");
        }
        return this.getPropBoolean("supportsPositionedUpdate", false);
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) {
        if (this.debug != null) {
            this.log("supportsResultSetConcurrency(" + n + "," + n2 + "):false");
        }
        switch (n) {
            case 1003: {
                switch (n2) {
                    case 1007: {
                        return true;
                    }
                    case 1008: {
                        return false;
                    }
                }
            }
            case 1004: {
                switch (n2) {
                    case 1007: {
                        return true;
                    }
                    case 1008: {
                        return false;
                    }
                }
            }
            case 1005: {
                switch (n2) {
                    case 1007: {
                        return true;
                    }
                    case 1008: {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        int n2;
        if (this.debug != null) {
            this.log("supportsResultSetHoldability(" + n + "): false");
        }
        return (n2 = this.getPropInt("supportedResultSetHoldability", 3)) == n;
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        if (this.debug != null) {
            this.log("supportsResultSetType(" + n + ")");
        }
        return this.getPropInt("supportedResultSetTypes", 1004) == n;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSavepoints(): false");
        }
        return this.getPropBoolean("supportsSavepoints", false);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInDataManipulation()");
        }
        return this.getPropBoolean("supportsSchemasInDataManipulation", true);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInIndexDefinitions()");
        }
        return this.getPropBoolean("supportsSchemasInIndexDefinitions", false);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInPrivilegeDefinitions()");
        }
        return this.getPropBoolean("supportsSchemasInPrivilegeDefinitions", false);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInProcedureCalls()");
        }
        return this.getPropBoolean("supportsSchemasInProcedureCalls", false);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInTableDefinitions()");
        }
        return this.getPropBoolean("supportsSchemasInTableDefinitions", true);
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSelectForUpdate()");
        }
        return this.getPropBoolean("supportsSelectForUpdate", false);
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        if (this.debug != null) {
            this.log("supportsStatementPooling()");
        }
        return this.getPropBoolean("supportsStatementPooling", false);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        if (this.debug != null) {
            this.log("supportsStoredProcedures()");
        }
        return this.getPropBoolean("supportsStoredProcedures", false);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInComparisons()");
        }
        return this.getPropBoolean("supportsSubqueriesInComparisons", false);
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInExists()");
        }
        return this.getPropBoolean("supportsSubqueriesInExists", false);
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInIns()");
        }
        return this.getPropBoolean("supportsSubqueriesInIns", false);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInQuantifieds()");
        }
        return this.getPropBoolean("supportsSubqueriesInQuantifieds", false);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (this.debug != null) {
            this.log("supportsTableCorrelationNames()");
        }
        return this.getPropBoolean("supportsTableCorrelationNames", false);
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) {
        if (this.debug != null) {
            this.log("supportsTransactionIsolationLevel(" + n + "):" + (n == 8));
        }
        return n == 8;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsTransactions()");
        }
        return this.getPropBoolean("supportsTransactions", true);
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        if (this.debug != null) {
            this.log("supportsUnion()");
        }
        return this.getPropBoolean("supportsUnion", false);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        if (this.debug != null) {
            this.log("supportsUnionAll()");
        }
        return this.getPropBoolean("supportsUnionAll", false);
    }

    @Override
    public boolean updatesAreDetected(int n) {
        if (this.debug != null) {
            this.log("updatesAreDetected(" + n + "):false");
        }
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        if (this.debug != null) {
            this.log("usesLocalFilePerTable()");
        }
        return this.getPropBoolean("usesLocalFilePerTable", false);
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        if (this.debug != null) {
            this.log("usesLocalFiles()");
        }
        return this.getPropBoolean("usesLocalFiles", false);
    }

    public String getDatabaseName() throws SQLException {
        this.log("getDatabaseName()");
        if (null != this.databaseName) {
            return this.databaseName;
        }
        return this.getPropString("databaseName", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMetadata() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("initializeMetadata(): start");
            try (EXAStatement eXAStatement = (EXAStatement)this.connection.createStatement();){
                if (eXAStatement.getActiveProtocolVersion() >= 14 && this.metadataSQL == 0) {
                    this.readSQLCommands((EXAResultSet)eXAStatement.GetCommands());
                    this.readStaticProps(eXAStatement.GetDbMetadata(null, "true"));
                } else {
                    StringBuffer stringBuffer = new StringBuffer("select \"COMMAND\",\"IS_PLSQL\" from ");
                    stringBuffer.append(this.sysSchema);
                    stringBuffer.append(".SQL_COMMANDS order by \"COMMAND\"");
                    StringBuffer stringBuffer2 = new StringBuffer("select \"NAME\",\"VALUE\" from ");
                    stringBuffer2.append(this.sysSchema);
                    stringBuffer2.append(".");
                    stringBuffer2.append(DB_METADATA);
                    stringBuffer2.append(" where \"STATIC\"=true");
                    this.log("createStatement to initialize metadata");
                    eXAStatement.addBatch(stringBuffer.toString());
                    eXAStatement.addBatch(stringBuffer2.toString());
                    eXAStatement.executeBatch();
                    EXAResultSet eXAResultSet = (EXAResultSet)eXAStatement.getResultSet();
                    this.readSQLCommands(eXAResultSet);
                    if (!eXAStatement.getMoreResults()) {
                        throw new SQLException(Translator.Expected_2nd_resultset_unavailable());
                    }
                    this.readStaticProps(eXAStatement.getResultSet());
                }
            }
            catch (ConnectionException connectionException) {
                this.log("failed to fetch static metadata from EXA: " + connectionException.toString());
                throw connectionException;
            }
            catch (SQLException sQLException) {
                this.log("failed to fetch static metadata from EXA: " + sQLException.toString());
                throw sQLException;
            }
            this.log("initializeMetadata(): end (success)");
        }
    }

    private void readSQLCommands(EXAResultSet eXAResultSet) throws SQLException {
        this.log("readSQLCommands()");
        if (eXAResultSet != null) {
            this.sqlCommands = new Vector();
            this.plsqlCommands = new Vector();
            eXAResultSet.first();
            int n = 0;
            while ((long)n < eXAResultSet.getNumberOfRows()) {
                String string = eXAResultSet.getString(1);
                boolean bl = eXAResultSet.getBoolean(2);
                if (string != null && string.length() > 0) {
                    if (bl) {
                        this.plsqlCommands.addElement(string);
                    } else {
                        this.sqlCommands.addElement(string);
                    }
                }
                eXAResultSet.next();
                ++n;
            }
        }
    }

    private void readStaticProps(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            resultSet.first();
            this.staticProps = new HashMap();
            if (!resultSet.isAfterLast()) {
                do {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    if (null == string2) {
                        string2 = "";
                    }
                    this.log("Received static DB metainfo: " + string + "=" + string2);
                    this.staticProps.put(string, string2);
                } while (resultSet.next());
            }
        }
    }

    public Vector getSQLCommands() {
        if (null == this.sqlCommands) {
            this.log("getSQLCommands: Need metadata.");
            try {
                this.initializeMetadata();
            }
            catch (Exception exception) {
                this.log("Metadata not initialized: " + exception.toString());
                return null;
            }
            this.log("Metadata initialized.");
        }
        return this.sqlCommands;
    }

    public Vector getPLSQLCommands() {
        if (null == this.plsqlCommands) {
            this.log("getPLSQLCommands: Need metadata.");
            try {
                this.initializeMetadata();
            }
            catch (Exception exception) {
                this.log("Metadata not initialized: " + exception.toString());
                return null;
            }
            this.log("Metadata initialized.");
        }
        return this.plsqlCommands;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

