/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import sun.misc.BASE64Encoder;
import sun.security.x509.X500Name;

public class KeyManager {
    String keyAlgName = "RSA";

    public KeyManagerFactory getKeyManager() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = "JKS";
        String string2 = "ASDF";
        String string3 = "exaloader";
        String string4 = "IMPORT/EXPORT LOCAL SECURE not supported on this platform";
        try {
            Certificate[] certificateArray = new Certificate[]{this.getCertificate()};
            KeyStore keyStore = KeyStore.getInstance(string);
            keyStore.load(null);
            keyStore.setKeyEntry(string3, this.getKey(), string2.toCharArray(), certificateArray);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, string2.toCharArray());
            return keyManagerFactory;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException(string4);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new IOException(invalidKeySpecException.getMessage());
        }
    }

    private String getCertificatePEM() {
        String string = "-----BEGIN CERTIFICATE-----\nMIIDUjCCAjqgAwIBAgIEMRygOzANBgkqhkiG9w0BAQUFADBrMRAwDgYDVQQGEwdHZXJtYW55MRAw\nDgYDVQQIEwdCYXZhcmlhMRIwEAYDVQQHEwlOdXJlbWJlcmcxDzANBgNVBAoTBkVYQVNPTDEMMAoG\nA1UECxMDUitEMRIwEAYDVQQDEwlFWEFMb2FkZXIwHhcNMjEwOTAxMDkxNzIxWhcNMjEwOTAyMDkx\nNzIxWjBrMRAwDgYDVQQGEwdHZXJtYW55MRAwDgYDVQQIEwdCYXZhcmlhMRIwEAYDVQQHEwlOdXJl\nbWJlcmcxDzANBgNVBAoTBkVYQVNPTDEMMAoGA1UECxMDUitEMRIwEAYDVQQDEwlFWEFMb2FkZXIw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCtMVd7NcNpox6J/6qBqfHd+hlmAPCgfFPw\nw9oIO2XUKsFNYNoAI+KKS+eRipeOtCzlGTzseRBJ9Be9irTJw1xOZjF0AYmfQT0XBKQY71ADY6ym\njaKmDKF6IanZOe3clo+3ISbC6YEtCiwKPNT8GRXf6DBj3XFj3LidCGM5Q9RaKX0H3OvIDnDMaN6X\nzjCYGDA2SBrx4CCGv0g8KXlh3dZf5xUWdOf6h6e5lggoDsnRqES75aSj72Ou1zMavRVXw0pWlLTj\ndwoASxiMGnv9xjZeWteeHw+hAlW+OWJoepxmmEE1GITN0PWIIrMnBK84C6IEwLDJEyf6muVu/7+l\nkFYLAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBADy3eY4WQbkJxfJAYmusVrJXUZZUUcQ1ed+MYwkp\nlZkDGMTRossK8ZfB6Zkubf/q1Z3YV00gDFtXzSKQCLZ3yBcMXicOywTaz/Qr7ofb/dlXNva+yQiN\nC6dWvOIz6qsRNmI1LVmUP+umWf/7CofJCsvid3kseWAd17jpICC4anBBi/VP3d36R4FEozqMa7Ud\nJG0uTZ4D9RygZk7KCtMQhmS8U1WG/gehOgf5d2e4Ek+0Z87ej3qXBZUEm8enRx9codUi8qYXPlMZ\nQl3HBH9kNymCiGfkH5UoGApLCOI/PNlOGArFKegsSNCSHnIrdxAto2Up800tH0Ma8tvl01XvD/k=\n-----END CERTIFICATE-----";
        return string;
    }

    private String getPrivateKeyPEM() {
        String string = "-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCtMVd7NcNpox6J/6qBqfHd+hlmAPCgfFPww9oIO2XUKsFNYNoAI+KKS+eRipeOtCzlGTzseRBJ9Be9irTJw1xOZjF0AYmfQT0XBKQY71ADY6ymjaKmDKF6IanZOe3clo+3ISbC6YEtCiwKPNT8GRXf6DBj3XFj3LidCGM5Q9RaKX0H3OvIDnDMaN6XzjCYGDA2SBrx4CCGv0g8KXlh3dZf5xUWdOf6h6e5lggoDsnRqES75aSj72Ou1zMavRVXw0pWlLTjdwoASxiMGnv9xjZeWteeHw+hAlW+OWJoepxmmEE1GITN0PWIIrMnBK84C6IEwLDJEyf6muVu/7+lkFYLAgMBAAECggEAAhRsm4MqxJL74+ZZEtOKnwLI2Uu7mAHGNEb10FF+SIz240n9dDD6IHUG492JMmKBg4LJE4Hkqy6uNk17HE0nR528jEsUbwAmjqc0nUQKbu/8e8eJo3rVWZUb6ArlC1gXg7h3MbICJhtQKhNO73QRqi2snxZirTNSWDhokKB65VZDHC1JX/fgWY2DVHZPf0RpGR9vjStXbIjaGVwF2vVn17YTLtUutZu+gB8jKY0E9nr2M/nEZv4yldHwx4+YhMT9N4uZg488EDPfhGtxuNg4eNePOrZ/SYLewt96F/SdnmDJ0YQKVxObAht+U2ucxAEgv+khsYPwxlL5Sl1Q6QhwiQKBgQDu1xbXWUUhlxZEgc+09BqMLbHiefAu6sAmxK+5w+CgBeEAaUmypNVC8gl+keIVHNwkKpCq+wjMnmEi464XPTC+kLEFtpEGJTfWHi3/Ao92lOyCmK4jgtJl+D8vA9nTx6ZTnu3lYKFW8TFsW58tvlPApgfzEylltidJkIiUd9HjFQKBgQC5otHvl7DPOzjxRUcI87dCmX2a1VRDnyji8WsKcF08fnuLHEw2DalAENsqDdIb/A89NpY8GJqcQ1wrs4Ve65DsiMuYBz9EHsFg6Tg71IYEE5X+aBd3/PT4o76vL7N2pp6XSXHoQKO4DijCbmKEhxbxnyq4S6nokKZ6lG2lX2YcnwKBgQCns81s/lilQlI3XjK661+sp/UsgdRdDSZI0nhU5q3Vjusy/7rovgakkBCMl+B4VKBaoKyd8dB25IpuFhJKbQPJ+wzhZxSjjQSMyvofAew8Jkt/U7eKZbRYNxweZgTQSHKIaqK+GcCPrKG4ZQj69JYYQjx4uC6sJV+mrt7H6O4uFQKBgAEJZb6+zB/8Jq9CQclNAyL+FHN+6X+PLf1Gd+CRDBRAaJQ4TjynCuDutyqe9SNu3u7qlSA0yvhAcA1WbVJAYojPosNwluvceBwAcW30G+N98IKBNlBXO08AKxpzW7834v7ZTCeN5NwsSBH959LxpjEnQGfTFFnWJPfeSFZ6F+nlAoGAYGFRP/MXtfUxBM6q2SzfraX3I6GBlxvyCOHJt9gsyHANW8cTcWGmX3lVOLyK/KZq8srSx90wpBtZEvlYo3iWOaT5zbRt6lxs2NmZ1aKmfMC8xQ+NzANe8nAyP88QolD8Ao8yIZtWmmTLCrS2cEDY0cW3SsEyu8qhckZ4nPST8PQ=\n-----END PRIVATE KEY-----";
        return string;
    }

    private PrivateKey getKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        String string = this.getPrivateKeyPEM();
        String string2 = string.replace("-----BEGIN PRIVATE KEY-----\n", "").replaceAll("\n", "").replace("-----END PRIVATE KEY-----", "");
        byte[] byArray = Base64.getDecoder().decode(string2);
        KeyFactory keyFactory = KeyFactory.getInstance(this.keyAlgName);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        return privateKey;
    }

    private Certificate getCertificate() throws CertificateException {
        String string = this.getCertificatePEM();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return certificateFactory.generateCertificate(byteArrayInputStream);
    }

    private String getPrivKeyPEM(PrivateKey privateKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-----BEGIN PRIVATE KEY-----\n");
        stringBuilder.append(Base64.getEncoder().encodeToString(privateKey.getEncoded()) + "\n");
        stringBuilder.append("-----END PRIVATE KEY-----\n");
        return stringBuilder.toString();
    }

    private Certificate generateCertificate() throws IOException {
        int n = 2048;
        String string = "SHA1WithRSA";
        String string2 = "EXALoader";
        String string3 = "R+D";
        String string4 = "EXASOL";
        String string5 = "Nuremberg";
        String string6 = "Bavaria";
        String string7 = "Germany";
        long l = 86400L;
        String string8 = "IMPORT/EXPORT LOCAL SECURE not supported on this platform";
        try {
            Class<?> clazz;
            X500Name x500Name = new X500Name(string2, string3, string4, string5, string6, string7);
            try {
                clazz = Class.forName("sun.security.x509.CertAndKeyGen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("sun.security.tools.keytool.CertAndKeyGen");
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class);
            Object obj = constructor.newInstance(this.keyAlgName, string);
            Method method = clazz.getDeclaredMethod("generate", Integer.TYPE);
            method.invoke(obj, n);
            method = clazz.getDeclaredMethod("getPrivateKey", new Class[0]);
            PrivateKey privateKey = (PrivateKey)method.invoke(obj, new Object[0]);
            String string9 = this.getPrivKeyPEM(privateKey);
            System.out.println("Private KEY PEM\n" + string9);
            Certificate[] certificateArray = new Certificate[1];
            method = clazz.getDeclaredMethod("getSelfCertificate", X500Name.class, Long.TYPE);
            certificateArray[0] = (Certificate)method.invoke(obj, x500Name, l);
            return certificateArray[0];
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IOException(string8);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(string8);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(string8);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(string8);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException(string8);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(string8);
        }
    }

    private String getEncodedCertificate(Certificate certificate) throws CertificateEncodingException, IOException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-----BEGIN CERTIFICATE-----");
        stringBuilder.append("\n");
        stringBuilder.append(bASE64Encoder.encodeBuffer(certificate.getEncoded()));
        stringBuilder.append("-----END CERTIFICATE-----");
        return stringBuilder.toString();
    }

    private void buildCertificate() throws IOException, CertificateEncodingException {
        Certificate certificate = this.generateCertificate();
        String string = this.getEncodedCertificate(certificate);
        System.out.println(string);
    }
}

