/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ChaCha20_encoder;
import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectFailed;
import com.exasol.jdbc.ConnectRefused;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DialectFactory;
import com.exasol.jdbc.DialectGeneric;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADatabaseMetaData;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAPooledConnection;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXASocketFactory;
import com.exasol.jdbc.EXAStillExecuting;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.EncryptedOutputStream;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.GSSAuthentication;
import com.exasol.jdbc.Header;
import com.exasol.jdbc.InMessage;
import com.exasol.jdbc.LoaderException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.OutMessage;
import com.exasol.jdbc.Protocol;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.RC4_encoder;
import com.exasol.jdbc.RSA_encoder;
import com.exasol.jdbc.RecoverableOperation;
import com.exasol.jdbc.RollbackException;
import com.exasol.jdbc.SchemaEvent;
import com.exasol.jdbc.SchemaListener;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.StreamEncoder;
import com.exasol.jdbc.TimeoutException;
import com.exasol.jdbc.Translator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractEXAConnection
extends ServerCommunication
implements Connection,
Protocol {
    Properties clientInfo = new Properties();
    private boolean isWorkerNode = false;
    private long workerToken = 0L;
    public boolean testReadTimeout = false;
    public static int testReadTimeoutVal = 1;
    protected boolean validateServerCertificate = true;
    protected boolean useLegacyEncryption = false;
    protected boolean enableNumericTypeConversion = true;
    protected String socketFactory = null;
    protected String socketFactoryArg = null;
    public static final String HIBERNATE = "hibernate";
    private static final boolean defaultAutocomitMode = true;
    private static final boolean defaultSuperconnectionMode = false;
    private static final String defaultKerberosServiceName = "exasol";
    private static final String defaultClientName = "Generic JDBC client";
    private int lastSerialNumber = 0;
    private static final int MAX_ATTRIBS = 1000;
    private int connectTimeout = 0;
    private int hostTimeout = 0;
    private int loginTimeout = 0;
    private int feedbackInterval = -1;
    public static int defaultFeedbackInterval = 1;
    private int maxIdentifierLen = 128;
    private static final boolean defaultSnapshotTransactions = false;
    private boolean snapshotTransactions = false;
    private byte[] kerberosToken = null;
    private String encoding = "utf-8";
    private int executionMode = 0;
    private DatabaseMetaData metadata;
    protected InetAddress exaServer;
    protected int exaPort;
    protected String exaFingerprint;
    protected Vector clusterNodes;
    private String user;
    private String password;
    private Header lastHeader;
    private String currentCatalog = null;
    private int transactionIsolation;
    public Socket csocket;
    protected InputStream from_database;
    protected EXAOutputStream to_database;
    private boolean vmuMode = false;
    private Properties connectionParam = null;
    boolean connected = false;
    boolean wasDisconnected = false;
    private int responseTimeout = 0;
    private int queryTimeout = 0;
    private static final boolean defaultEncryptionMode = true;
    private boolean encryptionEnabled = true;
    boolean encryptionRequiredByServer = false;
    private StreamEncoder encryptor = null;
    public static int defaultDriverProtocollVersion = 18;
    private long maxMessageSize = 0x4000000L;
    private String kerberosServiceName = null;
    private String kerberosHostName = null;
    private String kerberosUserName = null;
    private String kerberosConfigFile = null;
    private String kerberosGssConfigFile = null;
    private String kerberosRealm = null;
    private String kerberosTargetName = null;
    private static final int notSpecified = 0;
    private static final int useSSPI = 1;
    private static final int useGSSAPI = 2;
    private static final int defaultKerberosLoginType = 0;
    private int kerberosLoginType = 0;
    private String keystoretype = null;
    private String keystorepath = null;
    private String keystorePassword = null;
    private KeyStore keyStore = null;
    private int loginType = 0;
    private boolean kerberosLogin = false;
    EXAPooledConnection connectionPool = null;
    private boolean certificatePrinted = false;
    private String connectionStatus = null;
    protected static boolean schemaChanged = false;
    private int activeProtocolVersion = defaultDriverProtocollVersion;
    private String dateFormat;
    private String timestampFormat;
    private String dateLanguage;
    private String currentSchema;
    private String databaseName;
    private String databaseProductName;
    private String databaseProductVersion = null;
    private String numericCharacters;
    private long sessionID = -1L;
    private byte[] publicKey;
    private byte[] randomPhrase;
    private byte[] encodedPwd;
    static final int _defaultFetchSize = 2048;
    static final int _maxFetchSize = 65536;
    private int defaultFetchSize = 2048;
    static final int defaultConnectTimeout = 0;
    static final int defaultHostTimeout = 2000;
    static final int defaultLoginTimeout = 0;
    static final int defaultQueryTimeout = 0;
    private Map typeMap = null;
    private SQLWarning warnings;
    private int reconnectCount = 0;
    private static final int maxReconnects = 1;
    static final int exa_so_timeout = 10000;
    private List schemaListeners = null;
    protected int defaultHoldability = 1;
    public boolean hibernate = false;
    DialectFactory dialectFactory = new DialectGeneric();
    private int[] workerPorts = null;
    private String[] workerHosts = null;
    private boolean commandWasEnterParallel = false;

    public boolean isWorkerConnection() {
        return this.isWorkerNode;
    }

    protected long GetMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setPool(EXAPooledConnection eXAPooledConnection) {
        this.connectionPool = eXAPooledConnection;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public boolean getEnableNumericTypeConversion() {
        return this.enableNumericTypeConversion;
    }

    public boolean getSchemaMayHaveChanged() {
        return schemaChanged;
    }

    public void setSchemaMayHaveChanged() {
        schemaChanged = true;
    }

    public int getMaxIdentifierLen() {
        return this.maxIdentifierLen;
    }

    public void metadataAcquired() {
        schemaChanged = false;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.log("prepareStatement(" + string + "," + n + ")", 0);
        if (n != 2) {
            throw new NotImplemented(this.debug, "Auto-generated keys.");
        }
        return this.prepareStatement(string);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.log("prepareStatement(" + string + "," + n + "," + n2 + "," + n3 + ")", 0);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, "Updatable ResultSets");
        }
        return this.prepareStatement(string);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.log("setHoldability(" + n + ")", 0);
        this.defaultHoldability = n;
        throw new NotImplemented(this.debug, "setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.log("getHoldability()", 0);
        return this.defaultHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.log("setSavepoint()", 0);
        throw new NotImplemented(this.debug, "setSavepoint");
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.log("setSavepoint(s)", 0);
        throw new NotImplemented(this.debug, "setSavepoint");
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.log("rollback(Savepoint)", 0);
        throw new NotImplemented(this.debug, "rollback to savepoint");
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.log("releaseSavepoint()", 0);
        throw new NotImplemented(this.debug, "releaseSavepoint");
    }

    protected synchronized byte[] communication(byte[] byArray, int n, byte by, ExecutionStatus executionStatus) throws SQLException {
        if (this.csocket == null || !this.csocket.isConnected() || this.csocket.isClosed()) {
            throw new ConnectionLost("Not connected.", this.getSessionID());
        }
        return this.communication(byArray, n, by, 0, executionStatus, null);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }

    public Vector getNodes() {
        return this.clusterNodes;
    }

    public boolean IsEncrypted() {
        return this.encryptionEnabled;
    }

    public boolean IsEncryptionRequiredByServer() {
        return this.encryptionRequiredByServer;
    }

    @Override
    public synchronized boolean isValid(int n) throws SQLException {
        block11: {
            if (!this.connected) {
                return false;
            }
            int n2 = this.responseTimeout;
            if (0 != n) {
                this.responseTimeout = n;
            }
            try {
                if (this.activeProtocolVersion < 14) {
                    Statement statement = this.createStatement();
                    statement.executeUpdate("/*EXAConnection.isValid(" + n + ")*/");
                    statement.close();
                    break block11;
                }
                EXAResult[] eXAResultArray = this.communication_resultset(new byte[0], (byte)70, new ExecutionStatus(), null);
                if (eXAResultArray != null && eXAResultArray.length > 0) {
                    if (eXAResultArray[0] instanceof EXASQLException) {
                        throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern((EXAConnection)this);
                    }
                    break block11;
                }
                throw new IOException("No vaild response from server, connection is not open");
            }
            catch (Exception exception) {
                this.connected = false;
                SQLException sQLException = exception instanceof SQLException ? (SQLException)exception : new SQLException(exception.getMessage());
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(sQLException);
                }
                throw sQLException;
            }
            finally {
                this.responseTimeout = n2;
            }
        }
        return this.connected;
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog, Properties properties) throws SQLException {
        this(string, n, string2, string3, debugLog, properties, null);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3) throws SQLException {
        this(string, n, string2, string3, null, new Properties(), null);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog) throws SQLException {
        this(string, n, string2, string3, debugLog, new Properties(), null);
    }

    public AbstractEXAConnection(Vector vector, String string, String string2, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        super(debugLog, "EXAConnection", null);
        this.Connect(vector, string, string2, debugLog, properties, hashMap);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        super(debugLog, "EXAConnection", null);
        Vector<ClusterNode> vector = new Vector<ClusterNode>();
        vector.add(new ClusterNode(string, n));
        this.Connect(vector, string2, string3, debugLog, properties, hashMap);
    }

    @Override
    public void clearWarnings() {
        this.log("clearWarnings");
        this.warnings = null;
    }

    public synchronized void closeBase() throws SQLException {
        this.log("closeBase()");
        try {
            if (this.wasDisconnected) {
                this.log(" Info: this connection was allready disconnected, exiting closeBase()");
                return;
            }
            try {
                this.communication(null, 0, (byte)32, this.isWorkerNode ? 0 : this.responseTimeout + this.loginTimeout, new ExecutionStatus(), null);
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            try {
                if (this.csocket != null) {
                    this.csocket.close();
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            this.csocket = null;
            this.log("connection closed", 0);
        }
        finally {
            this.connected = false;
            this.wasDisconnected = true;
            this.reconnectCount = 1;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        this.log("close()", 0);
        if (this.connectionPool != null) {
            this.log(" Closing a connection from the pool: make it available for reuse.");
            this.connectionPool.free();
            return;
        }
        this.closeBase();
    }

    protected void abort() {
        this.log("abort()");
        try {
            this.closeAbort(false);
        }
        catch (Exception exception) {
            this.log("Exception in abort(): " + exception);
        }
        this.wasDisconnected = true;
        if (this.connectionPool != null) {
            try {
                this.connectionPool.close();
            }
            catch (Exception exception) {
                this.log("Exception in abort() in connectionPool.close(): " + exception);
            }
        }
    }

    protected void CheckDisconnected() throws SQLException {
        if (this.wasDisconnected) {
            this.log("ERROR: connection was already disconnected!", 1);
            throw new SQLException(Translator.No_operations_allowed_on_this_connection_because_it_was_already_closed(), "JY000");
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.log("abort(" + executor + ")");
        AbortCommand abortCommand = new AbortCommand();
        if (executor != null) {
            executor.execute(abortCommand);
        } else {
            abortCommand.run();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    public void closeAbort(boolean bl) throws SQLException {
        try {
            this.log("closeAbort(" + bl + ")", 0);
            if (this.wasDisconnected) {
                this.log(" Info: this connection was already disconnected, exiting closeAbort()");
                return;
            }
            try {
                if (this.csocket != null) {
                    this.csocket.close();
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            this.csocket = null;
            this.log("connection closed", 0);
        }
        finally {
            if (!bl) {
                this.connected = false;
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(null);
                }
            }
        }
    }

    protected void closeSocket() throws SQLException {
        this.closeSocket(true);
    }

    protected void closeSocket(boolean bl) throws SQLException {
        this.log("closeSocket()");
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            this.log(stackTraceElement);
        }
        if (this.csocket == null) {
            return;
        }
        try {
            if (this.csocket != null) {
                this.csocket.close();
            }
        }
        catch (Exception exception) {
            this.log(exception.toString(), 0);
        }
        this.csocket = null;
        this.connected = false;
        if (this.connectionPool != null) {
            this.connectionPool.connectionError(null);
        }
        this.wasDisconnected = bl;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.log("commit", 1);
        this.CheckDisconnected();
        this.log("createStatement to execute commit");
        Statement statement = this.createStatement();
        statement.executeUpdate("/*EXAConnection.commit()*/ commit;");
        statement.close();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.log("createStatement()", 1);
        this.CheckDisconnected();
        return this.dialectFactory.createStatement((EXAConnection)this);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.log("createStatement()", 1);
        this.CheckDisconnected();
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, n, n2);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.log("createStatement()", 1);
        this.CheckDisconnected();
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, n, n2);
    }

    @Override
    public boolean getAutoCommit() {
        boolean bl = this.getBooleanParameter("autocommit", true);
        this.log("EXAConnection.getAutoCommit(): " + bl);
        return bl;
    }

    public boolean isSuperConnection() {
        boolean bl = this.getBooleanParameter("superconnection", false);
        this.log("EXAConnection.SUPERCONNECTION_DEFAULT(): " + bl);
        return bl;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.log("getCatalog(): " + this.currentCatalog, 1);
        return this.currentCatalog;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.log("getMetaData() - connection meta data");
        this.CheckDisconnected();
        if (this.metadata == null) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
        }
        return this.metadata;
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public Map getTypeMap() throws SQLException {
        this.log("getTypeMap()", 0);
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        this.log("isClosed:" + (this.csocket == null), 3);
        if (this.connectionPool != null && !this.connectionPool.isOccupied()) {
            return true;
        }
        return this.csocket == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.log("isReadOnly()", 0);
        return false;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.log("prepareCall(" + string + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.log("prepareCall(" + string + "," + n + "," + n2 + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.log("prepareCall(" + string + "," + n + "," + n2 + "," + n3 + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.log("prepareStatement(" + string + ")", 0);
        this.CheckDisconnected();
        return this.dialectFactory.createPreparedStatement(string, (EXAConnection)this);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.log("prepareStatement(" + string + "," + n + "," + n2 + ")", 0);
        this.CheckDisconnected();
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.prepareStatement(string);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.log("prepareStatement(" + string + "," + nArray + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(sql,int[])");
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.log("prepareStatement(" + string + "," + stringArray + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String,String[])");
    }

    public String getHostsList() {
        String string = "";
        for (int i = 0; i < this.clusterNodes.size(); ++i) {
            string = string + ((ClusterNode)this.clusterNodes.get(i)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(i)).GetPort();
            if (i >= this.clusterNodes.size() - 1) continue;
            string = string + ",";
        }
        return string;
    }

    private void Connect(Vector vector, String string, String string2, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        Object object;
        Object object2;
        int n;
        this.log("Connect() start");
        this.warnings = null;
        this.connection = (EXAConnection)this;
        this.clusterNodes = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            ClusterNode clusterNode = new ClusterNode(((ClusterNode)vector.get(n)).GetHost(), ((ClusterNode)vector.get(n)).GetPort());
            clusterNode.UnMark();
            clusterNode.SetFingerprint(((ClusterNode)vector.get(n)).GetFingerprint());
            this.clusterNodes.add(clusterNode);
        }
        n = this.clusterNodes.size();
        this.connectionParam = (Properties)properties.clone();
        Properties properties2 = (Properties)properties.clone();
        if (properties2.getProperty("password") != null && !properties2.getProperty("password").equals("")) {
            properties2.setProperty("password", "*****");
        }
        if (properties2.getProperty("keystorepassword") != null && !properties2.getProperty("keystorepassword").equals("")) {
            object2 = "keystorepassword=" + properties2.getProperty("keystorepassword");
            properties2.setProperty("keystorepassword", "******");
            if (properties2.getProperty("url") != null && !properties2.getProperty("url").equals("")) {
                object = properties2.getProperty("url").replace((CharSequence)object2, "keystorepassword=******");
                properties2.setProperty("url", (String)object);
            }
        }
        this.log("Connect connection param: " + properties2.toString());
        object2 = Locale.getDefault();
        this.log("Locale: " + ((Locale)object2).toString() + ", Display Name: " + ((Locale)object2).getDisplayName());
        object2 = (DecimalFormat)DecimalFormat.getInstance();
        this.log("Decimal Point Separator: " + ((DecimalFormat)object2).getDecimalFormatSymbols().getDecimalSeparator());
        if (this.getParameter("TestConnectionStringOnly") != null && this.getParameter("TestConnectionStringOnly").equals("1")) {
            return;
        }
        if (this.getParameter("worker") != null && this.getParameter("worker").equals("1")) {
            this.isWorkerNode = true;
        }
        if (this.getParameter("workertoken") != null) {
            this.workerToken = new Long(this.getParameter("workertoken"));
        }
        if (this.isWorkerNode && this.workerToken == 0L) {
            throw new ConnectFailed(Translator.Worker_connection_needs_token());
        }
        this.feedbackInterval = this.getIntParameter("feedbackinterval", -1);
        if (-1701 == this.feedbackInterval) {
            this.feedbackInterval = 1;
            this.testReadTimeout = true;
        }
        this.keystoretype = this.getStringParameter("keystoretype", null);
        this.keystorepath = this.getStringParameter("keystore", null);
        this.keystorePassword = this.getStringParameter("keystorepassword", null, true);
        if (this.keystoretype != null) {
            this.log("Keystore Type " + this.keystoretype);
        }
        if (this.keystorepath != null) {
            this.log("Keystore " + this.keystorepath);
        }
        if (this.keystorePassword != null) {
            this.log("Keystore Password ******");
        }
        object2 = new Random(System.nanoTime());
        object = new ConnectRefused(Translator.Connection_refused());
        while (true) {
            block65: {
                int n2;
                try {
                    n2 = ((Random)object2).nextInt(this.clusterNodes.size());
                }
                catch (Exception exception) {
                    throw new SQLException(exception.toString());
                }
                if (((ClusterNode)this.clusterNodes.get(n2)).IsMarked()) continue;
                --n;
                ((ClusterNode)this.clusterNodes.get(n2)).Mark();
                InetAddress[] inetAddressArray = null;
                String string3 = ((ClusterNode)this.clusterNodes.get(n2)).GetHost();
                try {
                    inetAddressArray = InetAddress.getAllByName(string3);
                    ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                    for (int i = inetAddressArray.length - 1; i >= 0; --i) {
                        int n3 = ((Random)threadLocalRandom).nextInt(i + 1);
                        InetAddress inetAddress = inetAddressArray[n3];
                        inetAddressArray[n3] = inetAddressArray[i];
                        inetAddressArray[i] = inetAddress;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    object = new ConnectFailed(Translator.Unknown_host_name() + unknownHostException.getMessage());
                    break block65;
                }
                this.certificatePrinted = false;
                long l = System.currentTimeMillis();
                InetAddress[] inetAddressArray2 = inetAddressArray;
                int n4 = inetAddressArray2.length;
                for (int i = 0; i < n4; ++i) {
                    InetAddress inetAddress;
                    this.exaServer = inetAddress = inetAddressArray2[i];
                    this.log("EXAServer " + this.exaServer.getHostAddress());
                    this.exaPort = ((ClusterNode)this.clusterNodes.get(n2)).GetPort();
                    this.log("EXAPort " + this.exaPort);
                    String string4 = this.getStringParameter("fingerprint", null);
                    String string5 = ((ClusterNode)vector.get(n2)).GetFingerprint();
                    if (string4 == null && string5 != null) {
                        this.exaFingerprint = string5;
                    } else if (string4 != null && string5 == null) {
                        this.exaFingerprint = string4;
                    } else if (string4 != null && string5 != null && string4.equalsIgnoreCase(string5)) {
                        this.exaFingerprint = string4;
                    } else if (string4 == string5 && string5 == null) {
                        this.exaFingerprint = null;
                    } else {
                        throw new SQLException("[ERROR] Fingerprint is provided in the hostname and in the Fingerprint argument. Provide only one Fingerprint.");
                    }
                    this.log("EXAFingerprint " + this.exaFingerprint);
                    this.log("new EXAConnection: " + this.exaServer.getHostAddress() + ":" + this.exaPort + " User: " + string);
                    this.user = string;
                    this.password = string2;
                    if (this.getParameter("TestConnectionStringOnly") != null && this.getParameter("TestConnectionStringOnly").equals("1")) {
                        return;
                    }
                    this.currentSchema = this.getParameter("schema");
                    this.transactionIsolation = 8;
                    this.defaultFetchSize = this.getIntParameter("fetchsize", 2048);
                    if (this.defaultFetchSize <= 0) {
                        this.log("Connect(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size remains: " + 2048);
                        this.defaultFetchSize = 2048;
                    }
                    this.connectTimeout = this.getIntParameter("connecttimeout", 0);
                    if (this.connectTimeout < 0 || this.connectTimeout >= 2147483) {
                        this.connectTimeout = 0;
                    }
                    this.loginTimeout = this.getIntParameter("logintimeout", 0);
                    if (this.loginTimeout < 0 || this.loginTimeout >= 2147483) {
                        this.loginTimeout = 0;
                    }
                    if (!this.isParameterAvailable("logintimeout") && this.isParameterAvailable("connecttimeout")) {
                        this.loginTimeout = this.connectTimeout;
                    }
                    this.hostTimeout = this.getIntParameter("hosttimeout", 2000);
                    if (this.hostTimeout < 0 || this.hostTimeout >= 2147483) {
                        this.hostTimeout = 0;
                    }
                    this.encryptionEnabled = this.getBooleanParameter("encryption", true);
                    this.queryTimeout = this.getIntParameter("querytimeout", 0);
                    this.kerberosServiceName = this.getStringParameter("kerberosservicename", null);
                    this.kerberosHostName = this.getStringParameter("kerberoshostname", null);
                    this.kerberosRealm = this.getStringParameter("kerberosrealm", null);
                    this.kerberosUserName = this.getStringParameter("kerberosusername", null);
                    this.kerberosConfigFile = this.getStringParameter("kerberosconfig", null);
                    this.kerberosGssConfigFile = this.getStringParameter("kerberosgssconfig", null);
                    this.kerberosLoginType = 0;
                    String string6 = this.getStringParameter("logintype", null);
                    if (null == string6) {
                        string6 = this.getStringParameter("loginType", null);
                    }
                    if (null != string6) {
                        switch (string6) {
                            case "1": 
                            case "sspi": {
                                this.kerberosLoginType = 1;
                                break;
                            }
                            case "2": 
                            case "gss": {
                                this.kerberosLoginType = 2;
                            }
                        }
                    }
                    if (this.kerberosServiceName != null && this.kerberosHostName == null) {
                        this.kerberosHostName = string3;
                    }
                    if (this.kerberosServiceName == null && this.kerberosHostName != null) {
                        this.kerberosServiceName = defaultKerberosServiceName;
                    }
                    boolean bl = this.kerberosLogin = this.kerberosServiceName != null || this.kerberosHostName != null;
                    if (this.kerberosLogin && null != this.user && null == this.kerberosUserName) {
                        this.kerberosUserName = this.user;
                    }
                    if (null != this.user && this.user.startsWith("Kerberos:")) {
                        this.kerberosTargetName = this.user.replaceFirst("Kerberos:", "");
                        this.kerberosLogin = true;
                    }
                    if (null == this.kerberosUserName) {
                        this.kerberosUserName = System.getProperty("user.name");
                    }
                    this.log("kerberosUserName = " + this.kerberosUserName);
                    this.log("kerberosServiceName = " + this.kerberosServiceName);
                    this.log("kerberosHostName = " + this.kerberosHostName);
                    this.log("kerberosLogin = " + this.kerberosLogin);
                    this.log("activeProtocolVersion = " + this.getActiveProtocolVersion());
                    this.log("kerberosConfigFile = " + this.kerberosConfigFile);
                    this.log("kerberosGssConfigFile = " + this.kerberosGssConfigFile);
                    this.log("kerberosTargetName = " + this.kerberosTargetName);
                    if (this.getActiveProtocolVersion() < 15) {
                        this.kerberosLogin = false;
                    }
                    long l2 = 0L;
                    try {
                        this.setupConnection(false, hashMap);
                        l2 = System.currentTimeMillis();
                    }
                    catch (ConnectRefused connectRefused) {
                        l2 = System.currentTimeMillis();
                        object = connectRefused;
                        this.log("Connection refused to " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + connectRefused.toString());
                        this.closeSocket();
                    }
                    catch (TimeoutException timeoutException) {
                        l2 = System.currentTimeMillis();
                        object = timeoutException;
                        this.log("Connection attempt timed out on " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + timeoutException.toString());
                        this.closeSocket();
                    }
                    catch (ConnectFailed connectFailed) {
                        l2 = System.currentTimeMillis();
                        object = connectFailed;
                        this.log("Connect - got an ConnectFailed exception: " + connectFailed.getClass().getCanonicalName() + " from " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + connectFailed.toString());
                        if (connectFailed.getMessage().contains("Software caused connection abort: recv failed")) {
                            this.closeSocket(false);
                        } else {
                            this.closeSocket(true);
                        }
                        if (connectFailed.getMessage().contains("Fingerprint did not match.") || connectFailed.getMessage().contains("If you trust the server, you can include the fingerprint in") || connectFailed.getMessage().contains("Certificate was not received from the server.") || connectFailed.getMessage().contains("[ERROR] Keystore Error:")) {
                            throw connectFailed;
                        }
                    }
                    catch (SQLException sQLException) {
                        object = sQLException;
                        this.log("Connect - got an SQLException exception: " + sQLException.getClass().getCanonicalName() + " from " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + sQLException.toString());
                        if (!this.wasDisconnected) {
                            this.closeSocket();
                        }
                        throw sQLException;
                    }
                    catch (Exception exception) {
                        object = new SQLException(exception);
                        this.log("Connect - got an SQLException exception: " + exception.getClass().getCanonicalName() + " from " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + exception.toString());
                        this.closeSocket();
                        throw exception;
                    }
                    if (this.IsConnected()) {
                        try {
                            this.schemaListeners = (List)Class.forName("ArrayList").newInstance();
                        }
                        catch (Exception exception) {
                            this.schemaListeners = new Vector();
                        }
                        break;
                    }
                    long l3 = l2 - l;
                    if (this.loginTimeout <= 0 || l3 < (long)this.loginTimeout) continue;
                    this.log("Connection attempt timed out on " + ((ClusterNode)this.clusterNodes.get(n2)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(n2)).GetPort());
                    throw new ConnectionException("Connection attempt timed out on " + ((ClusterNode)this.clusterNodes.get(n2)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(n2)).GetPort());
                }
            }
            if (0 >= n || this.IsConnected()) break;
        }
        if (0 == n && !this.IsConnected()) {
            this.log("0 nodes left to try");
            throw object;
        }
        this.wasDisconnected = false;
        this.log("Connect() end");
    }

    private boolean IsConnected() {
        return this.connected;
    }

    public void addSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.add(schemaListener);
        }
    }

    public void removeSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.remove(schemaListener);
        }
    }

    public void fireSchemaChanged(String string, String string2) {
        if (null == this.schemaListeners) {
            return;
        }
        if (this.schemaListeners.isEmpty()) {
            return;
        }
        SchemaEvent schemaEvent = new SchemaEvent((EXAConnection)this, string, string2);
        for (int i = 0; i < this.schemaListeners.size(); ++i) {
            ((SchemaListener)this.schemaListeners.get(i)).schemaChanged(schemaEvent);
        }
    }

    private void setupConnection(boolean bl, HashMap hashMap) throws SQLException {
        this.log("setupConnection(" + bl + ")");
        this.connected = false;
        do {
            try {
                this.activeProtocolVersion = defaultDriverProtocollVersion;
                this.connectAndLogin(bl, this.exaServer, this.exaPort, hashMap);
                this.connected = true;
            }
            catch (ConnectionLost connectionLost) {
                this.log(connectionLost.getClass().getCanonicalName() + ": " + connectionLost);
                throw connectionLost;
            }
            catch (ProtocolException protocolException) {
                this.connected = false;
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(protocolException);
                }
                this.log("ProtocolException from " + this.exaServer.getHostAddress() + ":" + this.exaPort + " " + " - " + protocolException.getMessage());
                if (0 == protocolException.getMessage().compareTo(Translator.To_create_an_encrypted_connection_the_server_must_be_at_least_5_0())) {
                    throw protocolException;
                }
                throw new ProtocolException(Translator.Connection_refused());
            }
            catch (SQLException sQLException) {
                this.log("Exception for " + this.exaServer.getHostAddress() + ":" + this.exaPort + " " + sQLException.toString(), 0);
                if (sQLException instanceof ConnectFailed) {
                    throw sQLException;
                }
                if (this.csocket != null && (sQLException instanceof SQLInvalidAuthorizationSpecException || sQLException instanceof ConnectRefused || sQLException instanceof ConnectionLost || sQLException instanceof TimeoutException)) {
                    throw sQLException;
                }
                this.addWarning(sQLException);
                this.connected = true;
            }
            catch (Exception exception) {
                this.log(exception.getClass().getCanonicalName() + " for " + this.exaServer.getHostAddress() + ":" + this.exaPort + " " + exception.toString(), 0);
                if (exception instanceof UnknownHostException) {
                    throw new ConnectFailed(Translator.Unknown_host_name() + exception.getMessage());
                }
                throw new ConnectFailed(exception.getMessage());
            }
        } while (!this.connected);
        if (!bl) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
            if (this.getActiveProtocolVersion() < 14) {
                try {
                    if (this.currentSchema != null && this.currentSchema.length() > 0) {
                        this.setSchema(this.currentSchema);
                    }
                }
                catch (SQLException sQLException) {
                    this.log("Error in EXAConnection - failed to open default schema, aborting. " + sQLException.toString(), 0);
                    this.close();
                    throw sQLException;
                }
            }
        }
    }

    protected boolean isParameterAvailable(String string) {
        if (this.connectionParam != null) {
            return this.connectionParam.containsKey(string);
        }
        return false;
    }

    private void addWarning(SQLException sQLException) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(sQLException.getMessage() + " (SessionID: " + this.getSessionID() + ")", sQLException.getSQLState());
        } else {
            this.warnings.setNextWarning(new SQLWarning(sQLException.getMessage(), sQLException.getSQLState()));
        }
    }

    protected int getDefaultFetchSize() {
        if (this.defaultFetchSize <= 0) {
            if (this.debug != null) {
                this.log("getDefaultFetchSize(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size will be set to connection default: " + 2048);
            }
            this.defaultFetchSize = 2048;
        }
        return this.defaultFetchSize;
    }

    protected String getParameter(String string) {
        return this.getParameter(string, false);
    }

    protected String getParameter(String string, boolean bl) {
        Object object;
        String string2 = null;
        if (this.connectionParam != null && (object = this.connectionParam.get(string)) != null) {
            string2 = object.toString();
        }
        if (string2 != null && string2 != "") {
            if (bl) {
                this.log(" getParameter(" + string + "): ******");
            } else {
                this.log(" getParameter(" + string + "): " + string2);
            }
        }
        return string2;
    }

    protected String getStringParameter(String string, String string2) {
        return this.getStringParameter(string, string2, false);
    }

    protected String getStringParameter(String string, String string2, boolean bl) {
        String string3 = this.getParameter(string, bl);
        if (string3 == null || string3.trim() == "") {
            return string2;
        }
        return string3;
    }

    private boolean getBooleanParameter(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return bl;
        }
        return !"0".equals(string2) && !"false".equalsIgnoreCase(string2);
    }

    private int getIntParameter(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + string + "\"");
            }
        }
        return n;
    }

    private long getLongParameter(String string, long l) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + string + "\"");
            }
        }
        return l;
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute) {
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute);
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute, Object object) {
        ProtocolAttribute protocolAttribute2 = new ProtocolAttribute(protocolAttribute.id);
        protocolAttribute2.value = object;
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute2);
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute, Object object, int n) {
        ProtocolAttribute protocolAttribute2 = new ProtocolAttribute(protocolAttribute.id);
        protocolAttribute2.value = object;
        protocolAttribute2.binaryLength = n;
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute2);
    }

    private HashMap setDefaultAttributes(boolean bl, HashMap hashMap) throws SQLException {
        Object object;
        HashMap<Short, ProtocolAttribute> hashMap2 = new HashMap<Short, ProtocolAttribute>();
        this.useLegacyEncryption = !this.connectionParam.getProperty("legacyencryption", "0").equals("0");
        this.enableNumericTypeConversion = !this.connectionParam.getProperty("enablenumerictypeconversion", "1").equals("0");
        this.socketFactory = this.connectionParam.getProperty("socketfactory", null);
        this.socketFactoryArg = this.connectionParam.getProperty("socketfactoryarg", null);
        String string = this.connectionParam.getProperty("validateservercertificate", null);
        if (string != null && string.equals("0")) {
            this.validateServerCertificate = false;
        } else if (string != null && string.equals("1")) {
            this.validateServerCertificate = true;
        } else if (string != null) {
            throw new ConnectFailed("Invalid value for validateservercertificate: " + string);
        }
        if (this.kerberosLogin) {
            object = new ProtocolAttribute(ProtocolAttribute.ATTR_KERBEROS_TICKET.id);
            ((ProtocolAttribute)object).value = null;
            ((ProtocolAttribute)object).binaryLength = 0;
            this.putAttribute(hashMap2, (ProtocolAttribute)object);
        } else if (this.user != null && this.user.length() > 0) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_USERNAME, this.user);
        }
        if (this.getActiveProtocolVersion() >= 14 && null != this.currentSchema && !bl) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CURRENT_SCHEMA, this.currentSchema);
        }
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_DRIVERNAME, EXADriver.getEXADriverName());
        if (this.workerToken != 0L) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_PARALLEL_TOKEN, this.workerToken);
        }
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_LANGUAGE, Locale.getDefault().getLanguage());
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_RELEASE_VERSION, EXADriver.getVersionInfo());
        object = this.connectionParam.getProperty("clientname", defaultClientName);
        this.setClientInfoBase("clientname", (String)object, false);
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTNAME, this.getClientInfo("clientname"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTNAME, object);
        object = this.connectionParam.getProperty("clientversion", "unknown");
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTVERSION, object);
        object = this.connectionParam.getProperty("authmethod", null);
        if (this.getActiveProtocolVersion() >= 18 && object != null) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_AUTH_METHOD, object);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("os.name", "unknown os"));
        stringBuffer.append(" - ");
        stringBuffer.append(System.getProperty("os.version", "unknown version"));
        stringBuffer.append(" - ");
        stringBuffer.append(System.getProperty("os.arch", "unknown arch"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTOS, stringBuffer.toString());
        object = System.getProperty("user.name");
        if (object != null) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTOS_USERNAME, object);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(System.getProperty("java.vendor"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.version"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.vm.name"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.vm.info"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTRUNTIME, stringBuffer2.toString());
        if (bl) {
            if (-1L == this.sessionID) {
                throw new SQLException(Translator.Connection_was_lost_and_reconnect_could_not_restore_the_session());
            }
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_SESSIONID, new Long(this.sessionID));
        } else {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
            protocolAttribute.value = new Boolean(this.getAutoCommit());
            hashMap2.put(new Short(protocolAttribute.id), protocolAttribute);
        }
        if (this.isSuperConnection()) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_SUPER_CONNECTION, new Boolean(true));
        }
        if (-1 != this.feedbackInterval) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_FEEDBACK_INTERVAL, new Integer(this.feedbackInterval));
        }
        this.queryTimeout = this.getIntParameter("querytimeout", -1);
        if (-1 != this.queryTimeout) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_QUERY_TIMEOUT, new Integer(this.queryTimeout));
        } else {
            this.queryTimeout = 0;
        }
        if (hashMap != null) {
            hashMap2.putAll(hashMap);
        }
        return hashMap2;
    }

    private void setClientInfoBase(String string, String string2, boolean bl) throws SQLClientInfoException {
        switch (string) {
            case "clientname": {
                this.clientInfo.setProperty(string, string2);
                if (!bl) break;
                try {
                    this.setClientName(string2);
                    break;
                }
                catch (SQLException sQLException) {
                    SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
                    sQLClientInfoException.initCause(sQLException);
                    throw sQLClientInfoException;
                }
            }
            case "clientversion": {
                this.clientInfo.setProperty(string, string2);
                if (!bl) break;
                try {
                    this.setClientVersion(string2);
                    break;
                }
                catch (SQLException sQLException) {
                    SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
                    sQLClientInfoException.initCause(sQLException);
                    throw sQLClientInfoException;
                }
            }
            default: {
                this.log("[ERROR] Client info (" + string + " -> \"" + string2 + "\") not known. ");
            }
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.setClientInfoBase(string, string2, true);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setClientInfo(string, properties.getProperty(string));
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return this.clientInfo.getProperty(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    public int[] GetWorkerPorts() {
        String string = "";
        if (this.workerPorts != null) {
            for (int i = 0; i < this.workerPorts.length; ++i) {
                string = string + this.workerPorts[i] + (i == this.workerPorts.length - 1 ? "" : ", ");
            }
        }
        this.log("GetWorkerPorts() - " + string);
        return this.workerPorts;
    }

    public String[] GetWorkerHosts() {
        String string = "";
        if (this.workerHosts != null) {
            for (int i = 0; i < this.workerHosts.length; ++i) {
                string = string + this.workerHosts[i] + (i == this.workerHosts.length - 1 ? "" : ", ");
            }
        }
        this.log("GetWorkerHosts() - " + string);
        return this.workerHosts;
    }

    public long GetWorkerToken() {
        return this.workerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int EnterParallel(int n) throws SQLException {
        this.log("EnterParallel(" + n + ")");
        this.CheckDisconnected();
        try {
            int n2;
            Object object;
            this.commandWasEnterParallel = true;
            int n3 = 0;
            ExecutionStatus executionStatus = new ExecutionStatus();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
            try {
                eXAOutputStream.writeInt(n);
                object = this.exaServer.getHostAddress();
                eXAOutputStream.writeInt(((String)object).getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(((String)object).getBytes(this.connection.getEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new SQLException(iOException.getMessage());
            }
            object = byteArrayOutputStream.toByteArray();
            byte[] byArray = this.communication((byte[])object, object != null ? ((Object)object).length : 0, (byte)30, 0, executionStatus, null);
            EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
            try {
                n3 = eXAInputStream.readInt();
                this.workerToken = eXAInputStream.readLong();
                this.workerPorts = new int[n3];
                this.workerHosts = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.workerPorts[n2] = eXAInputStream.readInt();
                    int n4 = eXAInputStream.readInt();
                    byte[] byArray2 = new byte[n4];
                    eXAInputStream.read(byArray2);
                    this.workerHosts[n2] = new String(byArray2, StandardCharsets.UTF_8);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            n2 = n3;
            return n2;
        }
        finally {
            this.commandWasEnterParallel = false;
        }
    }

    public synchronized ResultSet DescribeResult(int n) throws SQLException {
        this.log("DescribeResult(" + n + ")");
        this.CheckDisconnected();
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            eXAOutputStream.writeInt(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)31, executionStatus, null);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    public String getKerberosUserName() {
        return this.kerberosUserName;
    }

    public String getKerberosHostName() {
        return this.kerberosHostName;
    }

    public String getKerberosTargetNameSSPI() {
        String string = null;
        string = this.kerberosTargetName != null ? this.kerberosTargetName : (this.kerberosHostName != null && this.kerberosRealm != null ? this.kerberosServiceName + "/" + this.kerberosHostName + "@" + this.kerberosRealm : (this.kerberosHostName == null && this.kerberosRealm == null ? this.kerberosServiceName : (this.kerberosHostName != null ? this.kerberosServiceName + "/" + this.kerberosHostName : this.kerberosServiceName + "/@" + this.kerberosRealm)));
        this.log("getKerberosTargetNameSSPI: " + string);
        return string;
    }

    public String getKerberosTargetNameGSS() {
        String string = null;
        string = this.kerberosTargetName != null ? this.kerberosTargetName : this.kerberosServiceName + "@" + this.kerberosHostName;
        this.log("getKerberosTargetNameGSS: " + string);
        return string;
    }

    void UseSSPI() throws IOException, SQLException {
    }

    private void connectAndLogin(boolean bl, InetAddress inetAddress, int n, HashMap hashMap) throws Exception, SQLException {
        EXAResult[] eXAResultArray;
        Object object;
        Object object2;
        byte[] byArray;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        boolean bl2 = true;
        this.log("connectAndLogin(" + bl + ", " + inetAddress.getHostAddress() + ", " + n + ")");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
        eXAOutputStream.writeInt(this.getActiveProtocolVersion());
        SimpleDate simpleDate = new SimpleDate();
        simpleDate.fromCalendar(Calendar.getInstance());
        eXAOutputStream.writeInt(simpleDate.toInt());
        HashMap hashMap2 = this.setDefaultAttributes(bl, hashMap);
        for (Object object62 : hashMap2.values()) {
            eXAOutputStream.writeAttribute((ProtocolAttribute)object62);
        }
        eXAOutputStream.flush();
        if (null == this.password && !this.kerberosLogin) {
            throw new IOException(Translator.Password_is_null_connect_aborted());
        }
        try {
            if (this.csocket != null) {
                throw new SQLException("Socket connection broken.");
            }
            if (null != this.socketFactory) {
                this.log("connectAndLogin - create custom socket from factory: " + this.socketFactory + " (" + inetAddress.getHostAddress() + ", " + n + ", " + this.hostTimeout + " MS)");
                object62 = null;
                object62 = Class.forName(this.socketFactory);
                if (null == object62) {
                    throw new ClassNotFoundException("Not found: " + this.socketFactory);
                }
                if (null == this.socketFactoryArg) {
                    if (EXASocketFactory.class.isAssignableFrom((Class<?>)object62)) {
                        object5 = (EXASocketFactory)((Class)object62).newInstance();
                        this.csocket = ((EXASocketFactory)object5).createCustomSocket(inetAddress, n, this.hostTimeout);
                    } else {
                        this.csocket = ((SocketFactory)((Class)object62).newInstance()).createSocket(inetAddress, n);
                    }
                } else {
                    SocketFactory socketFactory;
                    object5 = new Class[]{String.class};
                    object4 = ((Class)object62).getConstructor((Class<?>)object5);
                    if (null == object4) {
                        throw new ConnectFailed("Cannot find a constructor for the custom socket factory " + ((Class)object62).getName() + " with an argument of type String.");
                    }
                    if (EXASocketFactory.class.isAssignableFrom((Class<?>)object62)) {
                        socketFactory = (EXASocketFactory)object4.newInstance(this.socketFactoryArg);
                        this.csocket = ((EXASocketFactory)socketFactory).createCustomSocket(inetAddress, n, this.hostTimeout);
                    } else {
                        socketFactory = (SocketFactory)object4.newInstance(this.socketFactoryArg);
                        this.csocket = socketFactory.createSocket(inetAddress, n);
                    }
                }
                this.encryptionEnabled = this.csocket instanceof SSLSocket;
                this.useLegacyEncryption = false;
            } else {
                if (this.encryptionEnabled && !this.useLegacyEncryption) {
                    if (this.keystorepath != null) {
                        this.keyStore = this.loadKeystore(this.keystoretype, this.keystorepath, this.keystorePassword);
                    }
                    if (!this.certificatePrinted) {
                        this.listCertificates(this.keyStore);
                        this.certificatePrinted = true;
                    }
                    this.log("connectAndLogin - createTLSSocket(" + inetAddress.getHostAddress() + ", " + n + ", " + this.hostTimeout + " MS)");
                    this.csocket = new EXASocketFactoryInstance().createSSLSocket(this.connectionParam, this.keyStore, inetAddress, n, "TLS", "TLSv1.2", this.exaFingerprint, this.validateServerCertificate, this.hostTimeout);
                }
                if (this.useLegacyEncryption || !this.encryptionEnabled) {
                    this.log("connectAndLogin - createSocket(" + inetAddress.getHostAddress() + ", " + n + ", " + this.hostTimeout + " MS)");
                    this.csocket = new EXASocketFactoryInstance().createSocket(inetAddress, n, this.hostTimeout);
                }
                if (this.csocket == null) {
                    throw new SQLException("Invalid encryption settings requested in the connection string. encryption:" + this.encryptionEnabled + " validateservercertificate: " + this.validateServerCertificate + ", useLegacyEncryption:" + this.useLegacyEncryption);
                }
            }
            this.csocket.setKeepAlive(true);
            this.csocket.setSoTimeout(10000);
        }
        catch (InstantiationException instantiationException) {
            this.log("connectAndLogin - got an exception: InstantiationException: " + instantiationException.getMessage());
            throw new ConnectFailed("Socket factory failure: " + instantiationException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log("connectAndLogin - got an exception: NoSuchMethodException: " + noSuchMethodException.getMessage());
            throw new ConnectFailed("Socket factory constructor not found: " + noSuchMethodException.toString());
        }
        catch (KeyStoreException keyStoreException) {
            this.log("connectAndLogin - got an exception: KeyStoreException: " + keyStoreException.getMessage());
            throw keyStoreException;
        }
        catch (Exception exception) {
            this.log("connectAndLogin - got an exception: " + exception.getClass().getCanonicalName() + ": " + exception.getMessage());
            throw new ConnectFailed(exception.toString());
        }
        this.log("connectAndLogin - creating socket connection");
        this.from_database = new EncryptedInputStream(new BufferedInputStream(this.csocket.getInputStream()));
        this.to_database = new EXAOutputStream(new EncryptedOutputStream(this.csocket.getOutputStream()), (EXAConnection)this);
        this.to_database.writeInt(0x1121201);
        this.to_database.writeInt(byteArrayOutputStream.size());
        this.to_database.write(byteArrayOutputStream.toByteArray());
        try {
            this.to_database.flush();
        }
        catch (Exception exception) {
            this.log("connectAndLogin - to_database.flush() - got an exception: " + exception.getClass().getCanonicalName() + ": " + exception.getMessage());
            throw exception;
        }
        if (this.csocket instanceof SSLSocket) {
            this.log("connectAndLogin - SSLSocket created");
        } else {
            this.log("connectAndLogin - Socket created");
        }
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, null, this.responseTimeout));
        object62 = this.lastHeader.getAttributes();
        this.updateSessionAttributes((Vector)object62);
        if (this.lastHeader.getSize() > 0) {
            object5 = new byte[this.lastHeader.getSize()];
            this.from_database.read((byte[])object5);
            object4 = this.processMessageBody((byte[])object5);
            if (object4 != null) {
                for (int i = 0; i < ((EXAResult[])object4).length; ++i) {
                    if (!(object4[i] instanceof EXASQLException)) continue;
                    throw ExceptionFactory.createSQLException((EXASQLException)object4[i], (EXAConnection)this);
                }
            }
        }
        this.kerberosLoginType = this.kerberosLoginType == 0 && System.getProperty("os.name").startsWith("Windows") ? 1 : 2;
        if (this.kerberosLogin) {
            if (null != this.kerberosConfigFile) {
                System.setProperty("java.security.krb5.conf", this.kerberosConfigFile);
            }
            this.log(" System.setProperty(java.security.krb5.conf): " + System.getProperties().getProperty("java.security.krb5.conf"));
            if (null != this.kerberosGssConfigFile) {
                System.setProperty("java.security.auth.login.config", this.kerberosGssConfigFile);
            }
            this.log(" System.setProperty(java.security.auth.login.config): " + System.getProperties().getProperty("java.security.auth.login.config"));
            if (null != this.kerberosRealm) {
                System.setProperty("java.security.krb5.realm", this.kerberosRealm);
            }
            this.log(" System.setProperty(java.security.krb5.realm): " + System.getProperties().getProperty("java.security.krb5.realm"));
            try {
                switch (this.kerberosLoginType) {
                    case 2: {
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                        if (null != this.kerberosUserName && null != this.kerberosRealm) {
                            System.setProperty("sun.security.krb5.principal", this.kerberosUserName + "@" + this.kerberosRealm);
                        }
                        GSSAuthentication.authenticate((EXAConnection)this, false);
                        break;
                    }
                    case 1: {
                        this.UseSSPI();
                    }
                }
            }
            catch (Exception exception) {
                throw new SQLInvalidAuthorizationSpecException(exception.getMessage(), "28900");
            }
        }
        this.log("connectAndLogin - encrypt password");
        object5 = new RSA_encoder();
        ((RSA_encoder)object5).SetPublicKey(this.publicKey);
        object4 = null;
        if (this.workerToken == 0L && !this.kerberosLogin) {
            int n2 = this.randomPhrase.length - this.password.length() - 2;
            if (n2 > 0) {
                object3 = new ChaCha20_encoder();
                byArray = ((StreamEncoder)object3).getRandomKey("vui4sxz28dpg3da9s1hc7".getBytes(this.getEncoding()), n2);
                object2 = new ByteArrayOutputStream();
                ((OutputStream)object2).write(this.password.getBytes(this.encoding));
                ((ByteArrayOutputStream)object2).write(0);
                ((OutputStream)object2).write(byArray);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                this.encodedPwd = ((RSA_encoder)object5).EncodePwd((byte[])object, this.randomPhrase);
            } else {
                object3 = this.password.getBytes(this.encoding);
                this.encodedPwd = ((RSA_encoder)object5).EncodePwd((byte[])object3, this.randomPhrase);
            }
            object4 = new ProtocolAttribute(ProtocolAttribute.ATTR_ENCODED_PASSWORD.id);
            object4.value = this.encodedPwd;
            object4.binaryLength = this.encodedPwd.length;
        }
        byte[] byArray2 = null;
        object3 = null;
        if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
            byArray = null;
            object2 = null;
            if (this.getActiveProtocolVersion() >= 14) {
                this.encryptor = new ChaCha20_encoder();
                byArray = this.encryptor.getRandomKey("xewd9j439cnr4urdu4ru3".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
                object2 = this.encryptor.getRandomKey("yrke9ek4yy9kd44dk88".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
            } else {
                this.encryptor = new RC4_encoder();
                byArray = this.encryptor.getRandomKey("kmewd9j43239cnre3e324dkurdu4ru3".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
                object2 = this.encryptor.getRandomKey("ke32rke9ek4yy9kdxefwfef234d44dk88".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
            }
            this.encryptor.SetKeys(byArray, (byte[])object2);
            byArray2 = ((RSA_encoder)object5).EncodePwd(byArray, this.randomPhrase);
            object3 = ((RSA_encoder)object5).EncodePwd((byte[])object2, this.randomPhrase);
        }
        int n3 = this.getIntParameter("snapshottransactions", 2);
        switch (n3) {
            case 0: {
                this.snapshotTransactions = false;
                break;
            }
            case 1: {
                this.snapshotTransactions = true;
            }
        }
        object2 = null;
        if ((0 == n3 || 1 == n3) && this.getActiveProtocolVersion() >= 14) {
            object2 = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            ((ProtocolAttribute)object2).value = new Boolean(this.snapshotTransactions);
            ((ProtocolAttribute)object2).binaryLength = 1;
        }
        if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
            object = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_SEND_KEY.id);
            ((ProtocolAttribute)object).value = byArray2;
            ((ProtocolAttribute)object).binaryLength = byArray2.length;
            eXAResultArray = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_RECEIVE_KEY.id);
            eXAResultArray.value = object3;
            eXAResultArray.binaryLength = ((Object)object3).length;
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_KEYS_LEN.id);
            if (this.encryptor instanceof ChaCha20_encoder) {
                protocolAttribute.value = new Integer(ChaCha20_encoder.ENCRYPTION_KEY_LEN);
            } else if (this.encryptor instanceof RC4_encoder) {
                protocolAttribute.value = new Integer(RC4_encoder.ENCRYPTION_KEY_LEN);
            } else {
                throw new IOException("Unknown encryption class");
            }
            protocolAttribute.binaryLength = 4;
            this.to_database.writeInt(6 + (null != object4 ? object4.binaryLength + 6 : 0) + ((ProtocolAttribute)object).binaryLength + 6 + eXAResultArray.binaryLength + 2 + protocolAttribute.binaryLength + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(4 + (null != object2 ? 1 : 0));
            this.to_database.writeInt(6 + (null != object4 ? object4.binaryLength + 6 : 0) + ((ProtocolAttribute)object).binaryLength + 6 + eXAResultArray.binaryLength + 2 + protocolAttribute.binaryLength + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != object2) {
                this.to_database.writeAttribute((ProtocolAttribute)object2);
            }
            if (null != object4) {
                this.to_database.writeAttribute((ProtocolAttribute)object4);
            }
            this.to_database.writeAttribute((ProtocolAttribute)object);
            this.to_database.writeAttribute((ProtocolAttribute)eXAResultArray);
            this.to_database.writeAttribute(protocolAttribute);
        } else {
            this.to_database.writeInt((null != object4 ? object4.binaryLength + 6 : 0) + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(null != object4 ? 1 : 0 + (null != object2 ? 1 : 0));
            this.to_database.writeInt((null != object4 ? object4.binaryLength + 6 : 0) + (null != object2 ? ((ProtocolAttribute)object2).binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != object2) {
                this.to_database.writeAttribute((ProtocolAttribute)object2);
            }
            if (null != object4) {
                this.to_database.writeAttribute((ProtocolAttribute)object4);
            }
        }
        this.to_database.flush();
        this.log("connectAndLogin - read answer");
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, null, 0));
        if (!bl) {
            this.dateFormat = "YYYY-MM-DD";
            this.timestampFormat = "YYYY-MM-DD HH:MI:SS.FF3";
            this.numericCharacters = ".,";
        }
        object62 = this.lastHeader.getAttributes();
        this.updateSessionAttributes((Vector)object62);
        try {
            if (this.lastHeader.getSize() > 0) {
                object = new byte[this.lastHeader.getSize()];
                this.from_database.read((byte[])object);
                eXAResultArray = this.processMessageBody((byte[])object);
                if (eXAResultArray != null) {
                    for (int i = 0; i < eXAResultArray.length; ++i) {
                        if (!(eXAResultArray[i] instanceof EXASQLException)) continue;
                        throw ExceptionFactory.createSQLException((EXASQLException)eXAResultArray[i], (EXAConnection)this);
                    }
                }
            }
        }
        catch (RollbackException rollbackException) {
            this.log("connectAndLogin - got an exception: RollbackException: " + rollbackException.getMessage());
            if (this.getActiveProtocolVersion() >= 12) {
                if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
                    this.to_database.SetEncryptor(this.encryptor);
                    ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
                }
                this.getAttributes();
                this.updateSessionAttributes((Vector)object62);
            }
            throw rollbackException;
        }
        if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
            this.to_database.SetEncryptor(this.encryptor);
            ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
        }
        this.getAttributes();
        this.updateSessionAttributes((Vector)object62);
        if (this.snapshotTransactions && this.getActiveProtocolVersion() < 14) {
            this.SetSnapshotTransactions(this.snapshotTransactions);
        }
        if (!this.useLegacyEncryption && this.MustUseLegacyEncryption()) {
            this.useLegacyEncryption = true;
            this.connectionParam.setProperty("legacyencryption", "1");
            this.close();
            this.wasDisconnected = false;
            this.reconnectCount = 0;
            this.connectAndLogin(bl, inetAddress, n, hashMap);
            return;
        }
    }

    public boolean usingSSLSocket() {
        return this.csocket instanceof SSLSocket;
    }

    private String toHexStr(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i]));
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized void setSchema(String string) throws SQLException {
        this.log("EXAConnection.setSchema(" + string + ") protocolVersion=" + this.getActiveProtocolVersion());
        this.CheckDisconnected();
        if (this.getActiveProtocolVersion() < 14 || string == null) {
            String string2 = null;
            string2 = string == null ? "close schema" : "open schema " + string;
            EXAResult[] eXAResultArray = null;
            ExecutionStatus executionStatus = new ExecutionStatus();
            try {
                eXAResultArray = this.connection.communication_resultset(string2.getBytes(this.connection.getEncoding()), (byte)12, executionStatus, null);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
            if (eXAResultArray != null && eXAResultArray.length > 0 && eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
        } else {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CURRENT_SCHEMA.id);
            protocolAttribute.value = string;
            ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
            try {
                this.setAttributes(protocolAttributeArray);
            }
            catch (IOException iOException) {
                this.log("EXAConnection.setSchema(): caught IOException: " + iOException);
                throw new ConnectionLost(iOException.toString(), this.getSessionID());
            }
            catch (SQLException sQLException) {
                this.log("EXAConnection.setSchema(): caught SQLException: " + sQLException);
                throw sQLException;
            }
        }
        this.getSchema();
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        this.log("EXAConnection.getSchema()");
        this.CheckDisconnected();
        try {
            this.getAttributes();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage(), "HY000");
        }
        this.log("EXAConnection.getSchema() returns " + this.getCurrentSchema());
        return this.getCurrentSchema();
    }

    protected int getNextSerialNumber() {
        return this.lastSerialNumber++;
    }

    public final synchronized byte[] communication(byte[] byArray, byte by, ExecutionStatus executionStatus, ProtocolAttribute[] protocolAttributeArray) throws SQLException {
        this.executionMode = by;
        byte[] byArray2 = this.communication(byArray, byArray == null ? -1 : byArray.length, by, 0, executionStatus, protocolAttributeArray);
        if (executionStatus.cancelInitiated()) {
            byArray2 = this.communication(null, 0, (byte)37, 0, executionStatus, protocolAttributeArray);
        }
        return byArray2;
    }

    private final synchronized InMessage _communication(OutMessage outMessage) throws IOException, SQLException {
        outMessage.write_to_and_no_clean(this.to_database, (EXAConnection)this);
        return new InMessage(this.debug, this.from_database, (EXAConnection)this);
    }

    private final synchronized InMessage communication(OutMessage outMessage) throws IOException, SQLException {
        this.tmpOutMessage = outMessage;
        this.tmpOutMessage.flush();
        this.handle(new RecoverableOperation(){

            @Override
            public void op() throws IOException, SQLException {
                AbstractEXAConnection.this.tmpInMessage = AbstractEXAConnection.this._communication(AbstractEXAConnection.this.tmpOutMessage);
            }
        });
        return this.tmpInMessage;
    }

    protected final synchronized EXAResult[] communication_resultset(byte[] byArray, byte by, ExecutionStatus executionStatus, ProtocolAttribute[] protocolAttributeArray) throws SQLException {
        this.executionMode = by;
        int n = null != byArray ? byArray.length : 0;
        try {
            this.log("start communication_resultset(nBytes: " + n + ", mode: " + by + ")");
            byte[] byArray2 = this.communication(byArray, byArray != null ? byArray.length : 0, by, 0, executionStatus, protocolAttributeArray);
            if (executionStatus.cancelInitiated()) {
                byArray2 = this.communication(null, 0, (byte)37, 0, executionStatus, protocolAttributeArray);
            }
            EXAResult[] eXAResultArray = this.readResults(byArray2, this.lastHeader.getNumberOfResults());
            return eXAResultArray;
        }
        catch (IOException iOException) {
            this.log(iOException);
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
        finally {
            this.log("end communication_resultset(nBytes: " + n + ", mode: " + by + ")");
        }
    }

    private EXAResult[] processMessageBody(byte[] byArray) throws IOException, SQLException {
        if (byArray == null) {
            return null;
        }
        EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
        int n = this.lastHeader.getNumberOfResults();
        EXAResult[] eXAResultArray = new EXAResult[n];
        block5: for (int i = 0; i < n; ++i) {
            byte by = eXAInputStream.readByte();
            switch (by) {
                case 0: {
                    eXAResultArray[i] = new EXARowCount(eXAInputStream, this.debug);
                    continue block5;
                }
                case 1: {
                    eXAResultArray[i] = this.dialectFactory.createResultSet(eXAInputStream, (EXAConnection)this, this.debug);
                    continue block5;
                }
                case -1: {
                    eXAResultArray[i] = new EXASQLException(eXAInputStream, this.debug);
                    continue block5;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return eXAResultArray;
    }

    public final synchronized EXAResult[] communication_vector(Vector vector, byte by, ExecutionStatus executionStatus, ProtocolAttribute[] protocolAttributeArray) throws SQLException {
        this.executionMode = by;
        EXAResult[] eXAResultArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
            eXAOutputStream.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                eXAOutputStream.writeString((String)vector.elementAt(i));
            }
            eXAOutputStream.flush();
            eXAResultArray = vector.size() > 0 ? this.communication_resultset(byteArrayOutputStream.toByteArray(), by, executionStatus, protocolAttributeArray) : this.communication_resultset(null, by, executionStatus, protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log(iOException);
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
        return eXAResultArray;
    }

    private EXAResult readSingleResult(EXAInputStream eXAInputStream) throws IOException, SQLException {
        EXAResult eXAResult = null;
        byte by = eXAInputStream.readByte();
        switch (by) {
            case 0: {
                eXAResult = new EXARowCount(eXAInputStream, this.debug);
                break;
            }
            case 1: {
                eXAResult = this.dialectFactory.createResultSet(eXAInputStream, (EXAConnection)this, this.debug);
                if (-4 != ((EXAResultSet)eXAResult).GetHandle()) break;
                eXAResult = new EXASQLException("HY000", Translator.Query_did_not_return_a_result_set(), this.debug);
                break;
            }
            case -1: {
                eXAResult = new EXASQLException(eXAInputStream, this.debug);
                break;
            }
            case 2: {
                eXAResult = new EXAHandle(eXAInputStream, this.debug);
                break;
            }
            case 5: {
                eXAResult = new EXAStillExecuting(eXAInputStream, this.debug);
                break;
            }
            default: {
                throw new ProtocolException(Translator.Server_returned_unknow_type_of_result() + " (Type: " + by + ", SessionID: " + this.getSessionID() + ")");
            }
        }
        return eXAResult;
    }

    private EXAResult[] readResults(byte[] byArray, int n) throws IOException, SQLException, ProtocolException {
        if (byArray == null) {
            return null;
        }
        return this.readResults(new EXAInputStream(byArray, (EXAConnection)this), n);
    }

    private EXAResult[] readResults(EXAInputStream eXAInputStream, int n) throws IOException, SQLException {
        EXAResult[] eXAResultArray = null;
        int n2 = n;
        this.log(n2 + " results in message");
        if (n2 > 0) {
            eXAResultArray = new EXAResult[n2];
            for (int i = 0; i < n2; ++i) {
                eXAResultArray[i] = this.readSingleResult(eXAInputStream);
            }
        }
        return eXAResultArray;
    }

    private void checkResults(InMessage inMessage) throws ProtocolException, IOException, SQLException {
        EXAResult[] eXAResultArray = this.readResults(inMessage.getStream(), inMessage.getHeader().getNumberOfResults());
        if (eXAResultArray != null) {
            for (int i = 0; i < eXAResultArray.length; ++i) {
                if (!(eXAResultArray[i] instanceof EXASQLException)) continue;
                throw ((EXASQLException)eXAResultArray[i]).getSQLExceptionIntern(this.connection);
            }
        }
    }

    protected synchronized byte[] communication(byte[] byArray, int n, byte by, int n2, ExecutionStatus executionStatus, ProtocolAttribute[] protocolAttributeArray) throws SQLException {
        this.executionMode = by;
        try {
            CommOp commOp = new CommOp();
            commOp.execStatus = executionStatus;
            commOp.execStatus.connection = (EXAConnection)this;
            commOp.responseTimeout = n2;
            if (n >= 0) {
                commOp.header = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
                if (null != protocolAttributeArray) {
                    for (int i = 0; i < protocolAttributeArray.length; ++i) {
                        commOp.header.addAttribute(protocolAttributeArray[i]);
                    }
                }
                commOp.header.setSize(n);
                commOp.header.setMode(by);
                commOp.header.setNumberOfResults(0);
            }
            commOp.outBytes = byArray;
            this.handle(commOp);
            this.lastHeader = commOp.header;
            return commOp.inBytes;
        }
        catch (IOException iOException) {
            this.log(iOException.toString());
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
    }

    private byte[] readMessageBody(Header header) throws ConnectionException, IOException, ConnectionLost {
        int n;
        int n2 = 0;
        byte[] byArray = null;
        if (n > 0) {
            int n3;
            byArray = new byte[header.getSize()];
            for (n = header.getSize(); n > 0; n -= n3) {
                n3 = 0;
                try {
                    n3 = this.from_database.read(byArray, n2, n);
                    if (n3 < 0) {
                        throw new ConnectionLost(Translator.Failed_to_read_from_server(), this.getSessionID());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    n3 = interruptedIOException.bytesTransferred;
                }
                n2 += n3;
            }
        }
        return byArray;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.log("rollback", 1);
        this.CheckDisconnected();
        this.log("createStatement to execute rollback");
        Statement statement = this.createStatement();
        statement.executeUpdate("/*EXAConnection.rollback()*/ rollback;");
        statement.close();
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.log("EXAConnection.setAutoCommit(" + bl + ")");
        this.CheckDisconnected();
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
        protocolAttribute.value = new Boolean(bl);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
            this.connectionParam.put("autocommit", bl ? "1" : "0");
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setAutoCommit(): caught exception: " + iOException);
            throw new ConnectionLost(Translator.Failed_to_set_autocommit_mode_to() + iOException.toString(), this.getSessionID());
        }
    }

    public synchronized void setClientName(String string) throws SQLException {
        this.log("EXAConnection.setClientName(" + string + ")");
        this.CheckDisconnected();
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENTNAME.id);
        protocolAttribute.value = string;
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setClientName(): caught exception: " + iOException);
            throw new ConnectionLost("Failed to set the client name in the server: " + iOException.toString(), this.getSessionID());
        }
    }

    public synchronized void setClientVersion(String string) throws SQLException {
        this.log("EXAConnection.setClientVersion(" + string + ")");
        this.CheckDisconnected();
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENTVERSION.id);
        protocolAttribute.value = string;
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setClientVersion(): caught exception: " + iOException);
            throw new ConnectionLost("Failed to set the client version in the server: " + iOException.toString(), this.getSessionID());
        }
    }

    public synchronized void SetSnapshotTransactions(boolean bl) throws SQLException {
        this.log("EXAConnection.useSnpashotTransaction(" + bl + ")");
        this.CheckDisconnected();
        if (this.getActiveProtocolVersion() >= 12) {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            protocolAttribute.value = new Boolean(bl);
            ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
            try {
                this.setAttributes(protocolAttributeArray);
            }
            catch (IOException iOException) {
                this.log("EXAConnection.useSnpashotTransaction(): caught exception: " + iOException);
                throw new ConnectionLost(Translator.Failed_to_set_use_snapshot_transactions_to() + iOException.toString(), this.getSessionID());
            }
        } else {
            this.log("Attribute ATTR_SNAPSHOT_TRANSACTIONS_ENABLED not implemented for protocol V" + this.getActiveProtocolVersion());
        }
    }

    public synchronized void setFeedbackInterval(int n) throws SQLException {
        this.log("EXAConnection.setFeedbackInterval(" + n + ")");
        this.CheckDisconnected();
        if (this.getActiveProtocolVersion() < 9) {
            throw new SQLException(Translator.Failed_to_set_feedback_interval_to() + n + ". Active protocol version: " + this.getActiveProtocolVersion());
        }
        this.feedbackInterval = n;
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id);
        protocolAttribute.value = new Integer(n);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setFeedbackInterval(): caught exception: " + iOException);
            throw new ConnectionLost(Translator.Failed_to_set_feedback_interval_to() + n + ". " + iOException.toString(), this.getSessionID());
        }
    }

    public int getFeedbackInterval() {
        if (-1 == this.feedbackInterval) {
            return defaultFeedbackInterval;
        }
        return this.feedbackInterval;
    }

    public boolean getSnapshotTransactionsEnabled() {
        return this.snapshotTransactions;
    }

    public int getExecutionMode() {
        return this.executionMode;
    }

    @Override
    public synchronized void setCatalog(String string) throws SQLException {
        this.log("setCatalog(" + string + ")", 1);
        this.CheckDisconnected();
        if (!this.currentCatalog.equalsIgnoreCase(string)) {
            throw new SQLException(Translator.No_such_catalog() + string);
        }
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.log("setReadOnly(" + bl + ")", 0);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.log("setTypeMap(" + map + ")", 0);
        this.typeMap = map;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.log("EXAConnection.setQueryTimeout(" + n + ")");
        this.CheckDisconnected();
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_QUERY_TIMEOUT.id);
        protocolAttribute.value = new Integer(n);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setQueryTimeout(" + n + "): caught IOException: " + iOException.toString());
            throw new SQLException(iOException.toString());
        }
        catch (SQLException sQLException) {
            this.log("EXAConnection.setQueryTimeout(" + n + "): caught SQLException: " + sQLException.toString());
            throw sQLException;
        }
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public synchronized String[] getClusterNodes() throws IOException, SQLException {
        this.log("getClusterNodes()");
        this.CheckDisconnected();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
        String string = this.exaServer.getHostAddress();
        eXAOutputStream.writeString(string);
        eXAOutputStream.flush();
        this.log("    sending IP: " + string);
        byte[] byArray = this.communication(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), (byte)16, 0, new ExecutionStatus(), null);
        EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
        int n = eXAInputStream.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = eXAInputStream.readString();
            this.log("EXA reports ip " + i + " of " + n + ": " + stringArray[i]);
        }
        return stringArray;
    }

    public Vector getClusterNodesVector() {
        return this.clusterNodes;
    }

    @Override
    public DebugLog getDebug() {
        return this.debug;
    }

    protected int uploadJob(String string, byte by, Vector vector, Vector vector2, String string2) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    protected int uploadJob(String string, byte by, Vector vector, Vector vector2) throws SQLException, IOException {
        return this.uploadJob(string, by, vector, vector2, this.user);
    }

    protected void setQueuePolicy(int n) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    public synchronized void killSession(long l) throws SQLException {
        this.log("killSession(" + l + ")", 0);
        this.CheckDisconnected();
        if (l < 0L) {
            throw ExceptionFactory.createSQLException(Translator.Invalid_process_number(), "08003", (EXAConnection)this);
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        EXAResult[] eXAResultArray = null;
        byte[] byArray = null;
        if (this.getActiveProtocolVersion() >= 8) {
            byArray = new byte[8];
            for (int i = 0; i < 8; ++i) {
                byArray[i] = (byte)(l >>> i * 8);
            }
        } else {
            byArray = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)(l >>> i * 8);
            }
        }
        if ((eXAResultArray = this.connection.communication_resultset(byArray, (byte)27, executionStatus, null)) != null && eXAResultArray.length > 0 && eXAResultArray[0] instanceof EXASQLException) {
            throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
        }
    }

    protected boolean isInVMUMode() {
        return this.vmuMode;
    }

    private String[] ColSplitter(String string) throws LoaderException {
        if (null == string || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 1;
        String[] stringArray = null;
        int n4 = 0;
        string = string + ",";
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '(': {
                    if (bl) continue block6;
                    ++n2;
                    continue block6;
                }
                case ')': {
                    if (bl) continue block6;
                    --n2;
                    continue block6;
                }
                case '\"': {
                    if (!bl) {
                        bl = true;
                        continue block6;
                    }
                    bl = false;
                    continue block6;
                }
                case ',': {
                    if (false != n2 || bl) continue block6;
                    if (i - n < 3) {
                        throw new LoaderException(Translator.Sytax_error_missing_column_description_for_col() + n3);
                    }
                    ++n3;
                    if (0 == n4) {
                        stringArray = new String[1];
                    } else {
                        String[] stringArray2 = new String[n4 + 1];
                        for (int j = 0; j < n4; ++j) {
                            stringArray2[j] = stringArray[j];
                        }
                        stringArray = stringArray2;
                    }
                    stringArray[n4] = new String(cArray, n, i - n);
                    n = i + 1;
                    ++n4;
                }
            }
        }
        if (0 == n4) {
            stringArray = new String[]{new String(cArray)};
        }
        return stringArray;
    }

    private void GetCollsAndTypes(String[] stringArray, String[] stringArray2, String[] stringArray3) throws LoaderException {
        for (int i = 0; i < stringArray3.length; ++i) {
            int n;
            char[] cArray = new char[stringArray3[i].length()];
            stringArray3[i].getChars(0, stringArray3[i].length(), cArray, 0);
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            boolean bl2 = false;
            block13: for (n = 0; n < cArray.length && null == stringArray[i]; ++n) {
                switch (cArray[n]) {
                    case '\"': {
                        if (!bl) {
                            bl = true;
                            continue block13;
                        }
                        bl = false;
                        continue block13;
                    }
                    case ' ': {
                        if (!bl && bl2) {
                            stringArray[i] = new String(cArray, n2, n - n2);
                            n2 = n + 1;
                            continue block13;
                        }
                        if (bl2) continue block13;
                        ++n2;
                        continue block13;
                    }
                    default: {
                        bl2 = true;
                    }
                }
            }
            if (null == stringArray[i]) {
                throw new LoaderException(Translator.No_column_name_found_for_column() + (i + 1));
            }
            bl2 = false;
            boolean bl3 = false;
            while (n < cArray.length && null == stringArray2[i]) {
                switch (cArray[n]) {
                    case '(': {
                        ++n3;
                        if (bl3) {
                            throw new LoaderException(Translator.To_many_parantheses_describing_datatype_for_col() + (i + 1));
                        }
                        bl3 = true;
                        break;
                    }
                    case ')': {
                        --n3;
                        break;
                    }
                    case ' ': {
                        if (0 == n3 && bl2) {
                            boolean bl4 = true;
                            if (!bl3) {
                                bl4 = false;
                                int n4 = 0;
                                while (n + n4 < cArray.length && cArray[n + n4] == ' ') {
                                    ++n4;
                                }
                                if (n + n4 == cArray.length) {
                                    bl4 = true;
                                } else if ('(' != cArray[n + n4]) {
                                    bl4 = true;
                                }
                            }
                            if (!bl4) break;
                            stringArray2[i] = new String(cArray, n2, n - n2);
                            break;
                        }
                        if (bl2) break;
                        ++n2;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                ++n;
            }
            if (0 != n3) {
                throw new LoaderException(Translator.Error_found_counting_parantheses_in_datatype_description_for_col() + (i + 1));
            }
            if (n2 + 1 < n && null == stringArray2[i]) {
                stringArray2[i] = new String(cArray, n2, n - n2);
            }
            if (null == stringArray2[i]) {
                throw new LoaderException(Translator.No_datataype_found_for_column() + (i + 1));
            }
            while (n < cArray.length) {
                switch (cArray[n]) {
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new LoaderException(i + 1 + Translator.Too_many_words_found());
                    }
                }
                ++n;
            }
        }
    }

    protected static String sqlQuote(String string, char c) {
        char[] cArray = new char[(string.length() << 1) + 2];
        int n = 0;
        cArray[n++] = c;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                cArray[n++] = c2;
            }
            cArray[n++] = c2;
        }
        cArray[n++] = c;
        return new String(cArray, 0, n);
    }

    protected int compiledDriverVersion() {
        return defaultDriverProtocollVersion;
    }

    public int getEXAPort() {
        return this.exaPort;
    }

    public String getEXAServer() {
        String string = new InetSocketAddress(this.exaServer, this.exaPort).getHostString();
        this.log(Thread.currentThread().getStackTrace()[2].getMethodName() + "() : " + string);
        return string;
    }

    public String getEXAServerSSLParam() {
        if (this.exaFingerprint != null) {
            return this.exaFingerprint;
        }
        if (!this.validateServerCertificate) {
            return "nocertcheck";
        }
        return null;
    }

    public String getEXAServerIP() {
        String string = this.exaServer.getHostAddress();
        this.log(Thread.currentThread().getStackTrace()[2].getMethodName() + "() : " + string);
        return string;
    }

    protected String getUser() {
        if (this.kerberosLogin && this.kerberosUserName != null) {
            return this.kerberosUserName;
        }
        return this.user;
    }

    protected String getURL() {
        return this.connectionParam.getProperty("url");
    }

    protected static DriverPropertyInfo[] getDefaultProperties() {
        ArrayList<DriverPropertyInfo> arrayList = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("autocommit", "1");
        driverPropertyInfo.description = Translator.Auto_commit_0_disabled_1_enabled();
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("fetchsize", Integer.toString(2048));
        driverPropertyInfo.description = Translator.Default_fetch_size();
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("schema", null);
        driverPropertyInfo.description = Translator.Name_of_initially_opened_schema();
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("fingerprint", null);
        driverPropertyInfo.description = "The fingerprint used by the ssl connection.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("debug", "0");
        driverPropertyInfo.description = Translator.Set_to_1_to_activate_logging();
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("logdir", "");
        driverPropertyInfo.description = "Directory name where to save the logfiles to.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("clientname", defaultClientName);
        driverPropertyInfo.description = "Name of the client application.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("clientversion", null);
        driverPropertyInfo.description = "Version of the client application.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("logintimeout", String.valueOf(0));
        driverPropertyInfo.description = "A timeout in milli seconds that specifies the maximum time interval the driver will try to establish a socket connection for the host available in the connection string.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("connecttimeout", String.valueOf(0));
        driverPropertyInfo.description = "[Deprecated] A timeout in milli seconds that specifies the maximum time interval the driver will try to establish a socket connection on each node given in the connection string.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("hosttimeout", String.valueOf(2000));
        driverPropertyInfo.description = "A timeout in milli seconds that specifies the maximum time interval the driver will try to establish a socket connection on each node given in the connection string.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("encryption", "1");
        driverPropertyInfo.description = "Encrypt the client server communication.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("querytimeout", String.valueOf(0));
        driverPropertyInfo.description = "Query timeout in seconds, default is 0 (infinite).";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("superconnection", "0");
        driverPropertyInfo.description = "Enables the SuperConnection mode.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("feedbackinterval", String.valueOf(defaultFeedbackInterval));
        driverPropertyInfo.description = "While a query is running, the server sends status feedback to the client. This is also used by the driver to cancel queries. The interval is seconds.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("kerberosservicename", defaultKerberosServiceName);
        driverPropertyInfo.description = "Kerberos service name. The default (exasol) is used if neither database user nor password are specified in the connection string.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("kerberoshostname", "");
        driverPropertyInfo.description = "Kerberos host name. If not specified, the default kerberos host name will be the same as the one the driver is connecting to the database server.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("kerberosusername", System.getProperty("user.name", ""));
        driverPropertyInfo.description = "Kerberos user name. The default is the name of the OS user running the application.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("kerberosrealm", "");
        driverPropertyInfo.description = "Kerberos REALM name.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("kerberosconfig", "");
        driverPropertyInfo.description = "Kerberos config file (krb5.conf).";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("kerberosgssconfig", "");
        driverPropertyInfo.description = "Kerberos GSS config file (gss-jaas.conf).";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("logintype", String.valueOf(0));
        driverPropertyInfo.description = "Kerberos login type: 0=not specified, 1=use SSPI, 2=use GSSAPI.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("connectionPoolSize", String.valueOf(64));
        driverPropertyInfo.description = "Size of the connection pool if any is used.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("metadataSQL", "0");
        driverPropertyInfo.description = "Data for DatabaseMetaData results will be read using SQL from the server.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.description = "Database user name.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.description = "Database users password.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("authmethod", null);
        driverPropertyInfo.description = "Authentication method (accesstoken or refreshtoken), used for OpenID authentication.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("validateservercertificate", "1");
        driverPropertyInfo.description = "Can be used to disable server certificate validation in ssl connections.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("legacyencryption", "0");
        driverPropertyInfo.description = "Enables usage of deprecated ChaCha encryption instead of ssl in the client-server communication.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("socketfactory", null);
        driverPropertyInfo.description = "A custom socket factory.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("enablenumerictypeconversion", "1");
        driverPropertyInfo.description = "Decimal columns in result sets are shown as int types if this is possible.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("socketfactoryarg", null);
        driverPropertyInfo.description = "Parameter for the constructor of the custom socket factory.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("worker", "0");
        driverPropertyInfo.description = "Used in parallel connections, specifies if this connection is a worker connection.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("workertoken", "0");
        driverPropertyInfo.description = "Used in parallel connections to give a recognition token to the worker connection.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("keystoretype", null);
        driverPropertyInfo.description = "Keystore Type.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("keystore", null);
        driverPropertyInfo.description = "Keystore Path File Location.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        driverPropertyInfo = new DriverPropertyInfo("keystorepassword", null);
        driverPropertyInfo.description = "Keystore Password.";
        driverPropertyInfo.required = false;
        arrayList.add(driverPropertyInfo);
        arrayList.sort(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((DriverPropertyInfo)object).name.compareTo(((DriverPropertyInfo)object2).name);
            }
        });
        DriverPropertyInfo[] driverPropertyInfoArray = arrayList.toArray(new DriverPropertyInfo[arrayList.size()]);
        return driverPropertyInfoArray;
    }

    protected synchronized void setAttributes(ProtocolAttribute[] protocolAttributeArray) throws IOException, SQLException {
        this.log("setAttributes(), setting " + protocolAttributeArray.length + " attributes.");
        this.CheckDisconnected();
        this.tmpOutMessage = new OutMessage(this.debug, (EXAConnection)this);
        this.tmpOutMessage.getHeader().setMode((byte)35);
        for (int i = 0; i < protocolAttributeArray.length; ++i) {
            this.tmpOutMessage.getHeader().addAttribute(protocolAttributeArray[i]);
        }
        this.tmpInMessage = this.communication(this.tmpOutMessage);
        this.checkResults(this.tmpInMessage);
    }

    protected synchronized void getAttributes() throws SQLException, IOException {
        this.log("getAttributes()");
        this.CheckDisconnected();
        byte[] byArray = this.communication(null, 0, (byte)34, 0, new ExecutionStatus(), null);
        this.log("getAttributes() numeric_characters=" + this.numericCharacters);
    }

    public synchronized byte[] exchangeTicket(byte[] byArray) throws SQLException {
        this.log("exchangeTicket(nBytes=" + byArray.length + ")");
        this.CheckDisconnected();
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_KERBEROS_TICKET.id);
        protocolAttribute.value = byArray;
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
            return this.kerberosToken;
        }
        catch (IOException iOException) {
            this.log("exchangeTicket(): caught exception: " + iOException);
            throw new ConnectionLost(iOException.getMessage(), 0L);
        }
    }

    protected void reconnect() throws SQLException {
        this.log("reconnect()");
        this.CheckDisconnected();
        this.closeAbort(false);
        if (this.reconnectCount++ < 1) {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {
                throw new SQLException(interruptedException.toString());
            }
            try {
                this.setupConnection(true, null);
            }
            catch (ConnectionException connectionException) {
                if (connectionException instanceof ConnectionLost) {
                    this.log("ConnectionLost exception: " + connectionException);
                    this.closeSocket();
                    throw connectionException;
                }
                this.log("Exception: " + connectionException);
                this.closeSocket();
                throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
            }
        }
        this.closeSocket();
        throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
        this.reconnectCount = 0;
    }

    protected static int getProtocolVersion() {
        return defaultDriverProtocollVersion;
    }

    void updateSessionAttributes(Vector vector) throws SQLException {
        for (int i = 0; i < vector.size(); ++i) {
            ProtocolAttribute protocolAttribute = (ProtocolAttribute)vector.elementAt(i);
            if (protocolAttribute.id == ProtocolAttribute.ATTR_SESSIONID.id) {
                this.sessionID = (Long)protocolAttribute.value;
                this.log("Session id received: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_CURRENT_SCHEMA.id) {
                if (protocolAttribute.value != null) {
                    this.changeCurrentSchema(protocolAttribute.value.toString());
                    this.log("Current schema: " + protocolAttribute.value.toString());
                    continue;
                }
                this.changeCurrentSchema(null);
                this.log("Current schema: <none>");
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_CURRENT_CATALOG.id) {
                if (protocolAttribute.value != null) {
                    this.currentCatalog = protocolAttribute.value.toString();
                    this.log("Current catalog: " + protocolAttribute.value);
                    continue;
                }
                this.currentCatalog = null;
                this.log("Current catalog: <none>");
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PROTOCOL_VERSION.id) {
                this.activeProtocolVersion = (Integer)protocolAttribute.value;
                this.log("Protocol version: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATA_MESSAGE_SIZE.id) {
                this.maxMessageSize = (Long)protocolAttribute.value;
                this.log("maxDataMessageSize: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATE_FORMAT.id) {
                this.dateFormat = protocolAttribute.value != null ? protocolAttribute.value.toString() : "YYYY-MM-DD";
                this.log("NLS date format: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATETIME_FORMAT.id) {
                this.timestampFormat = protocolAttribute.value != null ? protocolAttribute.value.toString() : "YYYY-MM-DD HH:MI:SS.FF3";
                this.log("NLS timestamp format: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATE_LANGUAGE.id) {
                this.dateLanguage = protocolAttribute.value != null ? protocolAttribute.value.toString() : "german";
                this.log("NLS date language: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_NUMERIC_CHARACTERS.id) {
                this.numericCharacters = protocolAttribute.value != null ? protocolAttribute.value.toString() : ".,";
                this.log("Numeric characters: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PUBLIC_KEY.id) {
                this.publicKey = (byte[])protocolAttribute.value;
                this.log("Public Key: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_RANDOM_PHRASE.id) {
                this.randomPhrase = (byte[])protocolAttribute.value;
                this.log("Random phrase: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DB_NAME.id) {
                this.databaseName = protocolAttribute.value.toString();
                this.log("Database Name: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PRODUCT_NAME.id) {
                this.databaseProductName = protocolAttribute.value.toString();
                this.log("Database Product Name: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_RELEASE_VERSION.id) {
                this.databaseProductVersion = protocolAttribute.value.toString();
                this.log("Database Product Version: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_QUERY_CACHE_ACCESS.id) {
                this.log("Query cache access: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_ENCRYPTION_REQUIRED.id) {
                this.encryptionRequiredByServer = (Boolean)protocolAttribute.value;
                this.log("Encryption required: " + protocolAttribute.value);
                if (!this.encryptionRequiredByServer || this.encryptionEnabled) continue;
                throw new ConnectRefused("Illegal encryption settings: server requires encryption but the user has turned encryption off. ");
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id) {
                this.feedbackInterval = (Integer)protocolAttribute.value;
                this.log("Feedback interval: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id) {
                this.snapshotTransactions = (Boolean)protocolAttribute.value;
                this.log("Snapshot transactions enabled: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_KERBEROS_TOKEN.id) {
                this.kerberosToken = (byte[])protocolAttribute.value;
                this.log("kerberosToken recieved, bytes: " + this.kerberosToken.length);
                continue;
            }
            if (protocolAttribute.id != ProtocolAttribute.ATTR_MAX_IDENTIFIER_LENGTH.id) continue;
            this.maxIdentifierLen = (Integer)protocolAttribute.value;
            this.log("Max identifier len: " + this.maxIdentifierLen);
        }
    }

    public int getActiveProtocolVersion() {
        return this.activeProtocolVersion;
    }

    public String getCurrentSchema() throws SQLException {
        return this.currentSchema;
    }

    protected void changeCurrentSchema(String string) {
        String string2 = this.currentSchema;
        this.currentSchema = string;
        this.fireSchemaChanged(string2, this.currentSchema);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getDateLanguage() {
        return this.dateLanguage;
    }

    public String getNumericCharacters() {
        return this.numericCharacters;
    }

    protected static int getDateFormatWidth(String string) {
        if (string == null) {
            return 10;
        }
        return string.length();
    }

    protected static int getTimestampFormatWidth(String string) {
        if (string == null) {
            return 23;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (n2 < 2) {
                if (cArray[i] == 'f' || cArray[i] == 'F') {
                    ++n2;
                    continue;
                }
                n2 = 0;
                continue;
            }
            if (cArray[i] >= '\u0000' || cArray[i] <= '\t') {
                int n3 = cArray[i] - 48;
                n = n - 3 + n3;
            }
            n2 = 0;
        }
        return n;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected String GetDatabaseName() {
        return this.databaseName;
    }

    protected String GetDatabaseProductName() {
        return this.databaseProductName;
    }

    protected String GetDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    private boolean MustUseLegacyEncryption() {
        String string = this.GetDatabaseProductVersion();
        if (string.startsWith("6.2")) {
            String string2 = string.substring(0, 5);
            if (string.length() > 5) {
                string2 = string.substring(0, 6);
            }
            switch (string2) {
                case "6.2.0": 
                case "6.2.1": 
                case "6.2.2": 
                case "6.2.3": 
                case "6.2.4": 
                case "6.2.5": 
                case "6.2.6": 
                case "6.2.7": 
                case "6.2.8": 
                case "6.2.9": 
                case "6.2.10": 
                case "6.2.11": 
                case "6.2.12": 
                case "6.2.13": 
                case "6.2.14": {
                    return true;
                }
            }
        } else if (string.startsWith("7.0")) {
            String string3 = string.substring(0, 5);
            if (string.length() > 5) {
                string3 = string.substring(0, 6);
            }
            switch (string3) {
                case "7.0.0": 
                case "7.0.1": 
                case "7.0.2": 
                case "7.0.3": 
                case "7.0.4": 
                case "7.0.5": 
                case "7.0.6": 
                case "7.0.7": 
                case "7.0.8": 
                case "7.0.9": {
                    return true;
                }
            }
        }
        return false;
    }

    public void listCertificates(KeyStore keyStore) {
        if (keyStore != null) {
            this.log("Listing available certificates from the Keystore");
        } else {
            this.log("Listing available certificates from the default Keystore");
        }
        TrustManagerFactory trustManagerFactory = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                Map<String, String> map = this.certificateData(x509Certificate);
                String string = "Certificate: ";
                string = map.containsKey("CN") ? string + map.get("CN") : string + map.values().toArray()[1];
                string = string + " | " + map.get("Validity") + " | " + map.get("Valid Until: ");
                this.log(string);
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            this.log("[Error] Certificate Listing Error. " + generalSecurityException.getLocalizedMessage());
        }
    }

    private Map<String, String> certificateData(X509Certificate x509Certificate) {
        String[] stringArray;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("Subject", x509Certificate.getSubjectDN().toString());
        for (String string : stringArray = x509Certificate.getSubjectDN().getName().split(", ")) {
            String[] stringArray2 = string.split("=");
            if (stringArray2.length <= 1) continue;
            linkedHashMap.put(stringArray2[0], stringArray2[1]);
        }
        Date date = new Date();
        linkedHashMap.put("Valid From: ", x509Certificate.getNotBefore().toString());
        linkedHashMap.put("Valid Until: ", x509Certificate.getNotAfter().toString());
        if (x509Certificate.getNotAfter().after(date) && x509Certificate.getNotBefore().before(date)) {
            linkedHashMap.put("Validity", "VALID");
        } else if (x509Certificate.getNotAfter().before(date)) {
            linkedHashMap.put("Validity", "EXPIRED");
        } else if (x509Certificate.getNotBefore().after(date)) {
            linkedHashMap.put("Validity", "VALID FROM " + x509Certificate.getNotBefore().toString());
        } else {
            linkedHashMap.put("Validity", "INVALID");
        }
        return linkedHashMap;
    }

    private KeyStore loadKeystore(String string, String string2, String string3) throws KeyStoreException {
        KeyStore keyStore = null;
        String string4 = KeyStore.getDefaultType();
        String string5 = "[ERROR] Keystore Error: ";
        if (string3 == null) {
            throw new KeyStoreException(string5 + "Keystore password is empty.");
        }
        try {
            if (string != null) {
                keyStore = KeyStore.getInstance(string);
            } else {
                this.log("Using Default Keystore Type: " + string4);
                keyStore = KeyStore.getInstance(string4);
            }
            keyStore.load(new FileInputStream(string2), string3.toCharArray());
            return keyStore;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(string5 + noSuchAlgorithmException.getLocalizedMessage());
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyStoreException(string5 + keyStoreException.getLocalizedMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyStoreException(string5 + fileNotFoundException.getLocalizedMessage());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(string5 + certificateException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new KeyStoreException(string5 + iOException.getLocalizedMessage());
        }
    }

    private class CommOp
    implements RecoverableOperation {
        protected Header header = null;
        protected byte[] outBytes = null;
        protected byte[] inBytes = null;
        protected int responseTimeout = 0;
        ExecutionStatus execStatus = null;

        protected CommOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void op() throws IOException, SQLException {
            if (this.header != null) {
                this.header.write_to(AbstractEXAConnection.this.to_database);
            }
            if (this.outBytes != null) {
                AbstractEXAConnection.this.to_database.write(this.outBytes, 0, this.outBytes.length);
            }
            AbstractEXAConnection.this.to_database.flush();
            boolean bl = false;
            Header header = new Header(this.header);
            try {
                while (!bl) {
                    if (null != this.execStatus && this.execStatus.mustCancel()) {
                        this.inBytes = null;
                        return;
                    }
                    ((EncryptedInputStream)AbstractEXAConnection.this.from_database).SetMemoryStream(header.read_from(AbstractEXAConnection.this.from_database, this.execStatus, this.responseTimeout));
                    AbstractEXAConnection.this.updateSessionAttributes(header.getAttributes());
                    this.inBytes = AbstractEXAConnection.this.readMessageBody(header);
                    if (AbstractEXAConnection.this.getActiveProtocolVersion() <= 8) {
                        bl = true;
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0] && !AbstractEXAConnection.this.commandWasEnterParallel) {
                        byte[] byArray = new byte[this.inBytes.length - 5];
                        System.arraycopy(this.inBytes, 5, byArray, 0, byArray.length);
                        String string = null;
                        try {
                            string = new String(byArray, StandardCharsets.UTF_8);
                            if (string.length() > 0) {
                                this.execStatus.connection.clientLogExternal(string);
                            }
                            if (string.toUpperCase(Locale.ENGLISH).contains("<status>EXECUTING</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "EXECUTING";
                            }
                            if (string.toUpperCase(Locale.ENGLISH).contains("<status>QUEUED</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "QUEUED";
                            }
                            if (!AbstractEXAConnection.this.connectionStatus.equals("QUEUED") || !this.execStatus.isCanceled()) continue;
                            this.inBytes = null;
                            AbstractEXAConnection.this.closeAbort(false);
                            return;
                        }
                        catch (Exception exception) {
                            string = "UNKNOWN";
                        }
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0] && !AbstractEXAConnection.this.commandWasEnterParallel) continue;
                    bl = true;
                }
            }
            finally {
                this.header.setSerialNumber(header.getSerialNumber());
            }
            this.header = header;
        }
    }

    private class EXASocketFactoryInstance
    extends EXASocketFactory {
        private EXASocketFactoryInstance() {
        }

        @Override
        public Socket createCustomSocket(InetAddress inetAddress, int n, int n2) {
            return null;
        }
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            AbstractEXAConnection.this.abort();
        }
    }

    private static final class ConnectionStatus {
        public static final String EXECUTING = "EXECUTING";
        public static final String QUEUED = "QUEUED";
        public static final String UNKNOWN = "UNKNOWN";

        private ConnectionStatus() {
        }
    }
}

