/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateBuilder {
    static final String sigAlgName = "SHA256WithRSA";
    static final String commonName = "EXALoader";
    static final int keysize = 2048;
    static final String keyAlg = "RSA";
    static final String organizationalUnit = "R&D";
    static final String organization = "EXASOL";
    static final String city = "Nuremberg";
    static final String state = "Bavaria";
    static final String country = "Germany";
    private KeyPair keyPair = null;

    private KeyPair getKeypair() throws NoSuchAlgorithmException {
        if (this.keyPair == null) {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyAlg);
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        return this.keyPair;
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    private ContentSigner getSigner(String string, KeyPair keyPair) throws OperatorCreationException {
        return new JcaContentSignerBuilder(string).build(keyPair.getPrivate());
    }

    private static X500NameBuilder getSubject(String string, String string2, String string3, String string4, String string5) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(RFC4519Style.INSTANCE);
        x500NameBuilder.addRDN(RFC4519Style.o, string);
        x500NameBuilder.addRDN(RFC4519Style.ou, string2);
        x500NameBuilder.addRDN(RFC4519Style.l, string3);
        x500NameBuilder.addRDN(RFC4519Style.st, string4);
        x500NameBuilder.addRDN(RFC4519Style.c, string5);
        return x500NameBuilder;
    }

    public X509Certificate generate(int n) throws NoSuchAlgorithmException, CertificateException, IOException {
        X509Certificate x509Certificate;
        ContentSigner contentSigner;
        X509v3CertificateBuilder x509v3CertificateBuilder;
        try {
            this.keyPair = this.getKeypair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("ERROR: KeyPair failed. Exception: " + noSuchAlgorithmException.getLocalizedMessage());
        }
        Instant instant = Instant.now();
        Date date = Date.from(instant);
        Date date2 = Date.from(instant.plus(Duration.ofDays(n)));
        X500Name x500Name = new X500Name("CN=EXALoader");
        try {
            x509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500Name, BigInteger.valueOf(instant.toEpochMilli()), date, date2, CertificateBuilder.getSubject(organization, organizationalUnit, city, state, country).build(), this.keyPair.getPublic()).addExtension(Extension.subjectKeyIdentifier, false, CertificateBuilder.createSubjectKeyId(this.keyPair.getPublic())).addExtension(Extension.authorityKeyIdentifier, false, CertificateBuilder.createAuthorityKeyId(this.keyPair.getPublic())).addExtension(Extension.basicConstraints, true, new BasicConstraints(true));
        }
        catch (CertIOException | OperatorCreationException exception) {
            throw new CertificateException("ERROR: Certificate Builder Error. Exception: " + exception.getLocalizedMessage());
        }
        try {
            contentSigner = this.getSigner(sigAlgName, this.keyPair);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new IOException("ERROR: ContentSigner Failed. Exception: " + operatorCreationException.getLocalizedMessage());
        }
        try {
            x509Certificate = new JcaX509CertificateConverter().setProvider(new BouncyCastleProvider()).getCertificate(x509v3CertificateBuilder.build(contentSigner));
        }
        catch (CertificateException certificateException) {
            throw new CertificateException("ERROR: Certificate Signing Failed. Exception: " + certificateException.getLocalizedMessage());
        }
        return x509Certificate;
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        return new X509ExtensionUtils(digestCalculator).createSubjectKeyIdentifier(subjectPublicKeyInfo);
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws OperatorCreationException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        DigestCalculator digestCalculator = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        return new X509ExtensionUtils(digestCalculator).createAuthorityKeyIdentifier(subjectPublicKeyInfo);
    }

    public static String x509CertificateToPem(X509Certificate x509Certificate) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter jcaPEMWriter = new JcaPEMWriter(stringWriter);
        jcaPEMWriter.writeObject(x509Certificate);
        jcaPEMWriter.flush();
        jcaPEMWriter.close();
        return stringWriter.toString();
    }
}

