/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDML;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.Type;

public class ParserTable
extends ParserDML {
    ParserTable(Session session, Scanner scanner) {
        super(session, scanner);
    }

    StatementSchema compileCreateTable(int n) {
        Table table;
        boolean bl = false;
        if (this.token.tokenType == 412) {
            int n2 = this.getPosition();
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                this.readThis(101);
                bl = true;
            } else {
                this.rewind(n2);
            }
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        switch (n) {
            case 6: 
            case 7: {
                table = new TextTable(this.database, hsqlName, n);
                break;
            }
            default: {
                table = new Table(this.database, hsqlName, n);
            }
        }
        if (this.token.tokenType == 10) {
            return this.compileCreateTableAsSubqueryDefinition(table);
        }
        return this.compileCreateTableBody(table, bl);
    }

    StatementSchema compileCreateTableBody(Table table, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        boolean bl2 = this.readTableContentsSource(table, hsqlArrayList, hsqlArrayList2);
        if (!bl2) {
            return this.compileCreateTableAsSubqueryDefinition(table);
        }
        this.readTableOnCommitClause(table);
        if (this.database.sqlSyntaxMys && this.readIfThis(576)) {
            this.readIfThis(396);
            table.getName().comment = object = this.readQuotedString();
        }
        object = new OrderedHashSet();
        ((HashSet)object).add(this.database.getCatalogName());
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Table table2;
            objectArray2 = (Object[])hsqlArrayList.get(i);
            objectArray = objectArray2.getMainTableName();
            if (objectArray == null || (table2 = this.database.schemaManager.findUserTable(null, objectArray.name, objectArray.schema.name)) == null || table2.isTemp()) continue;
            ((HashSet)object).add(table.getName());
        }
        String string = this.getLastPart();
        objectArray2 = new Object[]{table, hsqlArrayList, hsqlArrayList2, null, bl};
        objectArray = new HsqlNameManager.HsqlName[((BaseHashMap)object).size()];
        ((OrderedHashSet)object).toArray(objectArray);
        return new StatementSchema(string, 77, objectArray2, null, (HsqlNameManager.HsqlName[])objectArray);
    }

    boolean readTableContentsSource(Table table, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) {
        int n = this.getPosition();
        this.readThis(816);
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        block7: while (!bl3) {
            Object object;
            switch (this.token.tokenType) {
                case 154: {
                    object = this.readLikeTable(table);
                    for (int i = 0; i < ((ColumnSchema[])object).length; ++i) {
                        table.addColumn(object[i]);
                    }
                    bl = false;
                    bl2 = false;
                    continue block7;
                }
                case 37: 
                case 48: 
                case 113: 
                case 214: 
                case 299: {
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, hsqlArrayList);
                    bl = false;
                    bl2 = false;
                    continue block7;
                }
                case 804: {
                    if (bl2) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl2 = true;
                    continue block7;
                }
                case 802: {
                    this.read();
                    bl3 = true;
                    continue block7;
                }
                case 427: 
                case 598: {
                    if (!this.database.sqlSyntaxMys) break;
                    this.readIndex(table, hsqlArrayList2);
                    bl = false;
                    bl2 = false;
                    continue block7;
                }
            }
            if (!bl2) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            object = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, (HsqlNameManager.HsqlName)object, hsqlArrayList);
            if (columnSchema == null) {
                if (bl) {
                    this.rewind(n);
                    return false;
                }
                throw Error.error(5000);
            }
            table.addColumn(columnSchema);
            bl = false;
            bl2 = false;
        }
        if (table.getColumnCount() == 0) {
            throw Error.error(5591);
        }
        return true;
    }

    void readTableOnCommitClause(Table table) {
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Table table2 = this.readTableName();
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        while (true) {
            boolean bl4;
            boolean bl5 = bl4 = this.token.tokenType == 416;
            if (!bl4 && this.token.tokenType != 399) break;
            this.read();
            switch (this.token.tokenType) {
                case 407: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl = bl4;
                    break;
                }
                case 128: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl2 = bl4;
                    break;
                }
                case 381: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl3 = bl4;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[table2.getColumnCount()];
        for (int i = 0; i < columnSchemaArray.length; ++i) {
            ColumnSchema columnSchema = table2.getColumn(i).duplicate();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), columnSchema.getName());
            columnSchema.setName(hsqlName);
            columnSchema.setPrimaryKey(false);
            if (bl2) {
                if (columnSchema.isIdentity()) {
                    columnSchema.setIdentity(columnSchema.getIdentitySequence().duplicate());
                }
            } else {
                columnSchema.setIdentity(null);
            }
            if (!bl3) {
                columnSchema.setDefaultExpression(null);
            }
            if (!bl) {
                columnSchema.setGeneratingExpression(null);
            }
            columnSchemaArray[i] = columnSchema;
        }
        return columnSchemaArray;
    }

    StatementSchema compileCreateTableAsSubqueryDefinition(Table table) {
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        boolean bl = true;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = null;
        StatementQuery statementQuery = null;
        if (this.token.tokenType == 816) {
            hsqlNameArray2 = this.readColumnNames(table.getName());
        }
        this.readThis(10);
        this.readThis(816);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(802);
        this.readThis(319);
        if (this.token.tokenType == 180) {
            this.read();
            bl = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(378);
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
        if (hsqlNameArray2 == null) {
            hsqlNameArray2 = queryExpression.getResultColumnNames();
        } else if (hsqlNameArray2.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, hsqlNameArray2, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (table.isTemp() && table.hasLobColumn()) {
            throw Error.error(5534);
        }
        if (bl) {
            statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
            hsqlNameArray = statementQuery.getTableNamesForRead();
        }
        Object[] objectArray = new Object[]{table, new HsqlArrayList(), null, statementQuery, Boolean.FALSE};
        String string = this.getLastPart();
        HsqlNameManager.HsqlName[] hsqlNameArray3 = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string, 77, objectArray, hsqlNameArray, hsqlNameArray3);
        return statementSchema;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2, boolean bl) {
        Constraint constraint = (Constraint)hsqlArrayList.get(0);
        String string = constraint.getName() == null ? null : constraint.getName().name;
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.newAutoName("IDX", string, table.getSchemaName(), table.getName(), 20);
        constraint.setColumnsIndexes(table);
        table.createPrimaryKey(hsqlName, constraint.core.mainCols, true);
        if (constraint.core.mainCols != null) {
            Constraint constraint2 = new Constraint(constraint.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(constraint2);
            if (bl) {
                session.database.schemaManager.addSchemaObject(constraint2);
            }
        }
        block7: for (int i = 1; i < hsqlArrayList.size(); ++i) {
            constraint = (Constraint)hsqlArrayList.get(i);
            switch (constraint.getConstraintType()) {
                case 2: {
                    constraint.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(constraint.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    hsqlName = session.database.nameManager.newAutoName("IDX", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
                    SchemaObject schemaObject = table.createAndAddIndexStructure(session, hsqlName, constraint.core.mainCols, null, null, true, true, false);
                    Constraint constraint3 = new Constraint(constraint.getName(), table, (Index)schemaObject, 2);
                    table.addConstraint(constraint3);
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint3);
                    continue block7;
                }
                case 0: {
                    ParserTable.addForeignKey(session, table, constraint, hsqlArrayList2);
                    continue block7;
                }
                case 3: {
                    SchemaObject schemaObject;
                    try {
                        constraint.prepareCheckConstraint(session, table);
                    }
                    catch (HsqlException hsqlException) {
                        if (session.isProcessingScript()) continue block7;
                        throw hsqlException;
                    }
                    table.addConstraint(constraint);
                    if (constraint.isNotNull()) {
                        schemaObject = table.getColumn(constraint.notNullColumnIndex);
                        schemaObject.setNullable(false);
                        table.setColumnTypeVars(constraint.notNullColumnIndex);
                    }
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint constraint, HsqlArrayList hsqlArrayList) {
        Object object;
        HsqlNameManager.HsqlName hsqlName = constraint.getMainTableName();
        if (hsqlName == table.getName()) {
            constraint.core.mainTable = table;
        } else {
            object = session.database.schemaManager.findUserTable(session, hsqlName.name, hsqlName.schema.name);
            if (object == null) {
                if (hsqlArrayList == null) {
                    throw Error.error(5501, hsqlName.name);
                }
                hsqlArrayList.add(constraint);
                return;
            }
            constraint.core.mainTable = object;
        }
        constraint.setColumnsIndexes(table);
        object = new TableWorks(session, table);
        ((TableWorks)object).checkCreateForeignKey(constraint);
        Constraint constraint2 = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols);
        if (constraint2 == null) {
            throw Error.error(5523);
        }
        Index index = constraint2.getMainIndex();
        boolean bl = constraint.core.mainTable.getSchemaName() != table.getSchemaName();
        int n = session.database.schemaManager.getTableIndex(table);
        if (n != -1 && n < session.database.schemaManager.getTableIndex(constraint.core.mainTable)) {
            bl = true;
        }
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newAutoName("IDX", table.getSchemaName(), table.getName(), 20);
        Index index2 = table.createAndAddIndexStructure(session, hsqlName2, constraint.core.refCols, null, null, false, true, bl);
        HsqlNameManager.HsqlName hsqlName3 = session.database.nameManager.newAutoName("REF", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
        constraint.core.uniqueName = constraint2.getName();
        constraint.core.mainName = hsqlName3;
        constraint.core.mainIndex = index;
        constraint.core.refTable = table;
        constraint.core.refName = constraint.getName();
        constraint.core.refIndex = index2;
        constraint.isForward = bl;
        table.addConstraint(constraint);
        constraint.core.mainTable.addConstraint(new Constraint(hsqlName3, constraint));
        session.database.schemaManager.addSchemaObject(constraint);
    }

    Constraint readFKReferences(Table table, HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        HsqlNameManager.HsqlName hsqlName2;
        OrderedHashSet orderedHashSet2 = null;
        this.readThis(222);
        HsqlNameManager.HsqlName hsqlName3 = this.token.namePrefix == null ? table.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (table.getSchemaName() == hsqlName3 && table.getName().name.equals(this.token.tokenString)) {
            hsqlName2 = table.getName();
            this.read();
        } else {
            hsqlName2 = this.readFKTableName(hsqlName3);
        }
        if (this.token.tokenType == 816) {
            orderedHashSet2 = this.readColumnNames(false);
        }
        int n = 59;
        if (this.token.tokenType == 162) {
            this.read();
            switch (this.token.tokenType) {
                case 511: {
                    this.read();
                    break;
                }
                case 470: {
                    throw super.unsupportedFeature();
                }
                case 116: {
                    this.read();
                    n = 61;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int n2 = 3;
        int n3 = 3;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 194) {
            this.read();
            if (!orderedIntHashSet.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 79) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            n2 = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            n2 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    n2 = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            if (this.token.tokenType == 303) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            n3 = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            n3 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    n3 = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        return new Constraint(hsqlName, table.getName(), orderedHashSet, hsqlName2, orderedHashSet2, 0, n2, n3, n);
    }

    HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName hsqlName) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.session, this.token.tokenString, hsqlName.name);
        HsqlNameManager.HsqlName hsqlName2 = table == null ? this.database.nameManager.newHsqlName(hsqlName, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return hsqlName2;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList hsqlArrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Expression expression = null;
        boolean bl5 = true;
        Expression expression2 = null;
        Type type = null;
        NumberSequence numberSequence = null;
        switch (this.token.tokenType) {
            case 407: {
                this.read();
                this.readThis(337);
                bl = true;
                bl4 = true;
                throw this.unexpectedToken("GENERATED");
            }
            case 128: {
                this.read();
                bl2 = true;
                bl3 = true;
                type = Type.SQL_INTEGER;
                numberSequence = new NumberSequence(null, 0L, 1L, type);
                break;
            }
            case 804: {
                return null;
            }
            case 802: {
                return null;
            }
            default: {
                if (this.token.isUndelimitedIdentifier) {
                    if ("SERIAL".equals(this.token.tokenString)) {
                        if (this.database.sqlSyntaxMys) {
                            this.read();
                            bl2 = true;
                            bl3 = true;
                            type = Type.SQL_BIGINT;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                        if (this.database.sqlSyntaxPgs) {
                            this.read();
                            bl2 = true;
                            type = Type.SQL_INTEGER;
                            numberSequence = new NumberSequence(null, 1L, 1L, type);
                            break;
                        }
                    } else if ("BIGSERIAL".equals(this.token.tokenString) && this.database.sqlSyntaxPgs) {
                        this.read();
                        bl2 = true;
                        bl3 = true;
                        type = Type.SQL_BIGINT;
                        numberSequence = new NumberSequence(null, 1L, 1L, type);
                        break;
                    }
                }
                type = this.readTypeDefinition(true, true);
            }
        }
        if (!bl && !bl2) {
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 186: {
                        this.read();
                        break;
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        bl5 = false;
                        break;
                    }
                }
            }
            switch (this.token.tokenType) {
                case 319: {
                    if (this.database.sqlSyntaxDb2) {
                        this.read();
                    } else {
                        throw this.unexpectedToken();
                    }
                }
                case 78: {
                    this.read();
                    expression2 = this.readDefaultClause(type);
                    if (expression2.opType != 12 || !this.database.sqlSyntaxPgs) break;
                    numberSequence = ((ExpressionColumn)expression2).sequence;
                    expression2 = null;
                    bl2 = true;
                    break;
                }
                case 407: {
                    this.read();
                    if (this.token.tokenType == 24) {
                        this.read();
                        this.readThis(78);
                    } else {
                        this.readThis(337);
                        bl4 = true;
                    }
                    this.readThis(10);
                    if (this.token.tokenType == 128) {
                        this.read();
                        numberSequence = new NumberSequence(null, type);
                        numberSequence.setAlways(bl4);
                        if (this.token.tokenType == 816) {
                            this.read();
                            this.readSequenceOptions(numberSequence, false, false, true);
                            this.readThis(802);
                        }
                        bl2 = true;
                        break;
                    }
                    if (this.token.tokenType == 816) {
                        if (!bl4) {
                            throw super.unexpectedTokenRequire("IDENTITY");
                        }
                        bl = true;
                        break;
                    }
                    if (this.token.tokenType != 505) break;
                    if (bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                        throw super.unexpectedToken(this.token.namePrefix);
                    }
                    numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
                    bl2 = true;
                    this.read();
                    break;
                }
                case 128: {
                    this.read();
                    bl2 = true;
                    bl3 = true;
                    numberSequence = new NumberSequence(null, 0L, 1L, type);
                }
            }
        }
        if (bl) {
            this.readThis(816);
            expression = this.XreadValueExpression();
            this.readThis(802);
        }
        if (!bl && !bl2 && this.database.sqlSyntaxMys && this.token.isUndelimitedIdentifier && "AUTO_INCREMENT".equals(this.token.tokenString)) {
            this.read();
            bl2 = true;
            numberSequence = new NumberSequence(null, 1L, 1L, type);
        }
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, bl5, false, expression2);
        columnSchema.setGeneratingExpression(expression);
        this.readColumnConstraints(table, columnSchema, hsqlArrayList);
        if (this.token.tokenType == 128 && !bl2) {
            this.read();
            bl2 = true;
            bl3 = true;
            numberSequence = new NumberSequence(null, 0L, 1L, type);
        }
        if (this.token.tokenType == 407 && !bl2 && !bl) {
            this.read();
            if (this.token.tokenType == 24) {
                this.read();
                this.readThis(78);
            } else {
                this.readThis(337);
                bl4 = true;
            }
            this.readThis(10);
            this.readThis(128);
            numberSequence = new NumberSequence(null, type);
            numberSequence.setAlways(bl4);
            if (this.token.tokenType == 816) {
                this.read();
                this.readSequenceOptions(numberSequence, false, false, true);
                this.readThis(802);
            }
            bl2 = true;
        }
        if (bl2) {
            columnSchema.setIdentity(numberSequence);
        }
        if (bl3 && !columnSchema.isPrimaryKey()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            orderedHashSet.add(columnSchema.getName().name);
            HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            Constraint constraint = new Constraint(hsqlName2, orderedHashSet, 4);
            hsqlArrayList.set(0, constraint);
            columnSchema.setPrimaryKey(true);
        }
        if (this.database.sqlSyntaxPgs && this.token.tokenType == 78 && columnSchema.getDefaultExpression() == null && columnSchema.getIdentitySequence() == null) {
            this.read();
            expression2 = this.readDefaultClause(type);
            if (expression2.opType == 12) {
                numberSequence = ((ExpressionColumn)expression2).sequence;
                expression2 = null;
            }
            columnSchema.setDefaultExpression(expression2);
            columnSchema.setIdentity(numberSequence);
        }
        return columnSchema;
    }

    void readConstraint(SchemaObject schemaObject, HsqlArrayList hsqlArrayList) {
        HsqlNameManager.HsqlName hsqlName = null;
        if (this.token.tokenType == 48) {
            this.read();
            hsqlName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 214: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                if (constraint.getConstraintType() == 4) {
                    throw Error.error(5532);
                }
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint2 = new Constraint(hsqlName, orderedHashSet, 4);
                hsqlArrayList.set(0, constraint2);
                break;
            }
            case 299: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                if (this.database.sqlSyntaxMys && !this.readIfThis(598)) {
                    this.readIfThis(427);
                }
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, orderedHashSet, 2);
                hsqlArrayList.add(constraint);
                break;
            }
            case 113: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint = this.readFKReferences((Table)schemaObject, hsqlName, orderedHashSet);
                hsqlArrayList.add(constraint);
                break;
            }
            case 37: {
                this.read();
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, null, 3);
                this.readCheckConstraintCondition(constraint);
                hsqlArrayList.add(constraint);
                break;
            }
            default: {
                if (hsqlName == null) break;
                throw this.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema columnSchema, HsqlArrayList hsqlArrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            HsqlNameManager.HsqlName hsqlName = null;
            if (this.token.tokenType == 48) {
                this.read();
                hsqlName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 214: {
                    if (bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(427);
                    Object object = (Constraint)hsqlArrayList.get(0);
                    if (((Constraint)object).getConstraintType() == 4) {
                        throw Error.error(5532);
                    }
                    Object object2 = new OrderedHashSet();
                    ((HashSet)object2).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint constraint = new Constraint(hsqlName, (OrderedHashSet)object2, 4);
                    hsqlArrayList.set(0, constraint);
                    columnSchema.setPrimaryKey(true);
                    bl4 = true;
                    break;
                }
                case 299: {
                    this.read();
                    Object object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object2 = new Constraint(hsqlName, (OrderedHashSet)object, 2);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 113: {
                    this.read();
                    this.readThis(427);
                }
                case 222: {
                    Object object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    Object object2 = this.readFKReferences(table, hsqlName, (OrderedHashSet)object);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 37: {
                    this.read();
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object = new Constraint(hsqlName, null, 3);
                    this.readCheckConstraintCondition((Constraint)object);
                    Object object2 = ((Constraint)object).getCheckColumnExpressions();
                    for (int i = 0; i < ((BaseHashMap)object2).size(); ++i) {
                        ExpressionColumn expressionColumn = (ExpressionColumn)((OrderedHashSet)object2).get(i);
                        if (columnSchema.getName().name.equals(expressionColumn.getColumnName())) {
                            if (expressionColumn.getSchemaName() == null || expressionColumn.getSchemaName().equals(table.getSchemaName().name)) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    hsqlArrayList.add(object);
                    break;
                }
                case 183: {
                    if (bl2 || bl3) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(186);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object = new Constraint(hsqlName, null, 3);
                    ((Constraint)object).check = new ExpressionLogical(columnSchema);
                    hsqlArrayList.add(object);
                    bl2 = true;
                    break;
                }
                case 186: {
                    if (bl2 || bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl3 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
    }

    void readCheckConstraintCondition(Constraint constraint) {
        this.readThis(816);
        this.startRecording();
        this.isCheckOrTriggerCondition = true;
        Expression expression = this.XreadBooleanValueExpression();
        this.isCheckOrTriggerCondition = false;
        Token[] tokenArray = this.getRecordedStatement();
        this.readThis(802);
        constraint.check = expression;
    }

    Expression readDefaultClause(Type type) {
        Expression expression = null;
        boolean bl = false;
        if (this.token.tokenType == 186) {
            this.read();
            return new ExpressionValue(null, type);
        }
        if (type.isDateTimeType() || type.isIntervalType()) {
            switch (this.token.tokenType) {
                case 72: 
                case 140: 
                case 281: 
                case 282: {
                    expression = this.readDateTimeIntervalLiteral(this.session);
                    if (expression.dataType.typeCode != type.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object object = expression.getValue(this.session, type);
                    return new ExpressionValue(object, type);
                }
                case 869: {
                    break;
                }
                default: {
                    expression = this.XreadDateTimeValueFunctionOrNull();
                    if (expression == null) break;
                    expression = this.XreadModifier(expression);
                    break;
                }
            }
        } else if (type.isNumberType()) {
            if (this.token.tokenType == 814) {
                this.read();
                bl = true;
            } else if (this.database.sqlSyntaxPgs && this.token.tokenType == 612) {
                return this.readNextvalFunction();
            }
        } else if (type.isCharacterType()) {
            switch (this.token.tokenType) {
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 69: 
                case 253: 
                case 277: 
                case 305: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    expression = this.readSQLFunction(functionSQL);
                    break;
                }
            }
        } else if (type.isBooleanType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 106: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        } else if (type.isBitType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, type);
                }
                case 106: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, type);
                }
            }
        } else if (type.isArrayType()) {
            expression = this.readCollection(19);
            if (expression.nodes.length > 0) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            expression.dataType = type;
            return expression;
        }
        if (expression != null) {
            expression.resolveTypes(this.session, null);
            if (!type.canBeAssignedFrom(expression.getDataType())) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            return expression;
        }
        boolean bl2 = false;
        if ((this.database.sqlSyntaxMss || this.database.sqlSyntaxPgs) && this.token.tokenType == 816) {
            this.read();
            bl2 = true;
        }
        if (this.token.tokenType == 869) {
            Object object = this.token.tokenValue;
            Type type2 = this.token.dataType;
            Type type3 = type;
            if (type.typeCode == 40) {
                type3 = Type.getType(12, null, this.database.collation, type.precision, 0);
            } else if (type.typeCode == 30) {
                type3 = Type.getType(61, null, null, type.precision, 0);
            }
            object = type3.convertToType(this.session, object, type2);
            this.read();
            if (bl) {
                object = type.negate(object);
            }
            if (bl2) {
                this.readThis(802);
            }
            return new ExpressionValue(object, type3);
        }
        if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxPgs) && (expression = this.XreadValueExpressionOrNull()) != null) {
            QuerySpecification querySpecification;
            TableDerived tableDerived;
            if (expression.getType() == 22) {
                tableDerived = (TableDerived)expression.getTable();
                querySpecification = (QuerySpecification)tableDerived.getQueryExpression();
                querySpecification.setReturningResult();
            }
            expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, 0, RangeGroup.emptyArray, null, true);
            expression.resolveTypes(this.session, null);
            if (expression.getType() == 22) {
                tableDerived = (TableDerived)expression.getTable();
                querySpecification = (QuerySpecification)tableDerived.getQueryExpression();
                Table table = querySpecification.getRangeVariables()[0].getTable();
                if (table != this.session.database.schemaManager.dualTable || querySpecification.exprColumns.length != 1) {
                    throw Error.error(5565);
                }
                expression = querySpecification.exprColumns[0];
            }
            if (bl2) {
                this.readThis(802);
            }
            return expression;
        }
        if (this.database.sqlSyntaxDb2) {
            Object object = null;
            switch (type.typeComparisonGroup) {
                case 12: {
                    object = "";
                    break;
                }
                case 61: {
                    object = BinaryData.zeroLengthBinary;
                    break;
                }
                case 2: {
                    object = 0;
                    break;
                }
                case 16: {
                    object = Boolean.FALSE;
                    break;
                }
                case 40: {
                    object = "";
                    return new ExpressionValue(object, Type.SQL_VARCHAR_DEFAULT);
                }
                case 30: {
                    object = BinaryData.zeroLengthBinary;
                    return new ExpressionValue(object, Type.SQL_VARBINARY_DEFAULT);
                }
                case 92: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_TIME", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
                case 91: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_DATE", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
                case 93: {
                    FunctionSQL functionSQL = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                    functionSQL.resolveTypes(this.session, null);
                    return functionSQL;
                }
            }
            object = type.convertToDefaultType(this.session, object);
            return new ExpressionValue(object, type);
        }
        if (bl2) {
            this.readThis(802);
        }
        throw this.unexpectedToken();
    }

    void readSequenceOptions(NumberSequence numberSequence, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block10: do {
            bl4 = false;
            if (orderedIntHashSet.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 10: {
                    if (bl) {
                        orderedIntHashSet.add(this.token.tokenType);
                        this.read();
                        Type type = this.readTypeDefinition(false, true);
                        numberSequence.setDefaults(numberSequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 267: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(319);
                    long l = this.readBigint();
                    numberSequence.setStartValueNoCheck(l);
                    if (!bl3) continue block10;
                    this.readIfThis(804);
                    break;
                }
                case 484: {
                    if (!bl2) {
                        bl4 = true;
                        break;
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(319)) {
                        long l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.setStartValueDefault();
                    break;
                }
                case 417: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(24);
                    long l = this.readBigint();
                    numberSequence.setIncrement(l);
                    break;
                }
                case 180: {
                    this.read();
                    if (orderedIntHashSet.contains(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    if (this.token.tokenType == 438) {
                        numberSequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 442) {
                        numberSequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 71) {
                        numberSequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 438: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMaxValueNoCheck(l);
                    break;
                }
                case 442: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMinValueNoCheck(l);
                    break;
                }
                case 71: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    numberSequence.setCycle(true);
                    break;
                }
                default: {
                    if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxDb2) && this.isSimpleName()) {
                        if (this.token.tokenString.equals("NOCACHE") || this.token.tokenString.equals("NOCYCLE") || this.token.tokenString.equals("NOMAXVALUE") || this.token.tokenString.equals("NOMINVALUE") || this.token.tokenString.equals("NOORDER") || this.token.tokenString.equals("ORDER")) {
                            this.read();
                            break;
                        }
                        if (this.token.tokenString.equals("CACHE")) {
                            this.read();
                            this.readBigint();
                            break;
                        }
                    }
                    bl4 = true;
                }
            }
        } while (!bl4);
        numberSequence.checkValues();
    }

    private void readIndex(Table table, HsqlArrayList hsqlArrayList) {
        HsqlNameManager.HsqlName hsqlName;
        this.read();
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(20, true);
        hsqlName2.schema = hsqlName = table.getSchemaName();
        hsqlName2.parent = table.getName();
        hsqlName2.schema = table.getSchemaName();
        int[] nArray = this.readColumnList(table, true);
        Constraint constraint = new Constraint(hsqlName2, table, nArray, 20);
        hsqlArrayList.add(constraint);
    }
}

