/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;

public class IntIndex {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = true;
    private boolean hasChanged;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public IntIndex(int n, boolean bl) {
        this.capacity = n;
        this.keys = new int[n];
        this.fixedSize = bl;
        this.hasChanged = true;
    }

    public synchronized int getKey(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n];
    }

    public synchronized void setKey(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[n] = n2;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public long getTotalValues() {
        long l = 0L;
        for (int i = 0; i < this.count; ++i) {
            l += (long)this.keys[i];
        }
        return l;
    }

    public void setSize(int n) {
        this.count = n;
    }

    public synchronized boolean addUnsorted(int n) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0 && n < this.keys[this.count - 1]) {
            this.sorted = false;
        }
        this.hasChanged = true;
        this.keys[this.count] = n;
        ++this.count;
        return true;
    }

    public synchronized boolean addSorted(int n) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0 && n < this.keys[this.count - 1]) {
            return false;
        }
        this.hasChanged = true;
        this.keys[this.count] = n;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int n) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        int n2 = this.binaryEmptySlotSearch();
        if (n2 == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != n2) {
            this.moveRows(n2, n2 + 1, this.count - n2);
        }
        this.keys[n2] = n;
        ++this.count;
        return true;
    }

    public synchronized int add(int n) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return -1;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        int n2 = this.binarySlotSearch();
        if (n2 == -1) {
            return n2;
        }
        this.hasChanged = true;
        if (this.count != n2) {
            this.moveRows(n2, n2 + 1, this.count - n2);
        }
        this.keys[n2] = n;
        ++this.count;
        return n2;
    }

    public void clear() {
        this.removeAll();
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int n) {
        int n2 = this.findFirstGreaterEqualSlotIndex(n);
        return n2 == this.count ? -1 : n2;
    }

    public synchronized int findFirstEqualKeyIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binaryFirstSearch();
    }

    public synchronized int findFirstConsecutiveKeys(int n) {
        int n2 = -1;
        if (this.count == 0) {
            return -1;
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        if (n == 1) {
            return 0;
        }
        for (int i = 1; i < this.count; ++i) {
            if (this.keys[i - 1] == this.keys[i] - 1) {
                if (n2 == -1) {
                    n2 = i - 1;
                }
                if (i - n2 + 1 != this.count) continue;
                return n2;
            }
            n2 = -1;
        }
        return n2;
    }

    public synchronized int removeFirstConsecutiveKeys(int n, int n2) {
        int n3 = this.findFirstConsecutiveKeys(n);
        if (n3 == -1) {
            return n2;
        }
        int n4 = this.keys[n3];
        this.removeRange(n3, n3 + n);
        return n4;
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binarySlotSearch();
    }

    private int binaryFirstSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.count;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
            n5 = n3;
        }
        return n5 == this.count ? -1 : n5;
    }

    private int binarySlotSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 <= 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n;
    }

    private int binaryEmptySlotSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return -1;
        }
        return n;
    }

    public synchronized void sort() {
        this.fastQuickSort();
    }

    private synchronized void fastQuickSort() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(32, false);
        int n = 16;
        doubleIntIndex.push(0, this.count - 1);
        while (doubleIntIndex.size() > 0) {
            int n2 = doubleIntIndex.peekKey();
            int n3 = doubleIntIndex.peekValue();
            doubleIntIndex.pop();
            if (n3 - n2 >= n) {
                int n4 = this.partition(n2, n3, n2 + (n3 - n2 >>> 1));
                doubleIntIndex.push(n2, n4 - 1);
                doubleIntIndex.push(n4 + 1, n3);
                continue;
            }
            this.insertionSort(n2, n3);
        }
        this.sorted = true;
    }

    private int partition(int n, int n2, int n3) {
        int n4 = n;
        this.swap(n3, n2);
        for (int i = n; i <= n2 - 1; ++i) {
            if (!this.lessThan(i, n2)) continue;
            this.swap(i, n4);
            ++n4;
        }
        this.swap(n4, n2);
        return n4;
    }

    private synchronized void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n, int n2) {
        int n3 = 16;
        if (n2 - n > n3) {
            int n4 = n2 + n >>> 1;
            if (this.lessThan(n4, n)) {
                this.swap(n, n4);
            }
            if (this.lessThan(n2, n)) {
                this.swap(n, n2);
            }
            if (this.lessThan(n2, n4)) {
                this.swap(n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(n4, n5);
            n4 = n;
            int n6 = n5;
            while (true) {
                if (this.lessThan(++n4, n6)) {
                    continue;
                }
                while (this.lessThan(n6, --n5)) {
                }
                if (n5 < n4) break;
                this.swap(n4, n5);
            }
            this.swap(n4, n2 - 1);
            this.quickSort(n, n5);
            this.quickSort(n4 + 1, n2);
        }
    }

    private void insertionSort(int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3;
            for (n3 = i; n3 > n && this.lessThan(i, n3 - 1); --n3) {
            }
            if (i == n3) continue;
            this.moveAndInsertRow(i, n3);
        }
    }

    protected void moveAndInsertRow(int n, int n2) {
        int n3 = this.keys[n];
        this.moveRows(n2, n2 + 1, n - n2);
        this.keys[n2] = n3;
    }

    protected void swap(int n, int n2) {
        int n3 = this.keys[n];
        this.keys[n] = this.keys[n2];
        this.keys[n2] = n3;
    }

    protected int compare(int n) {
        if (this.targetSearchValue > this.keys[n]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n]) {
            return -1;
        }
        return 0;
    }

    protected boolean lessThan(int n, int n2) {
        return this.keys[n] < this.keys[n2];
    }

    protected void moveRows(int n, int n2, int n3) {
        System.arraycopy(this.keys, n, this.keys, n2, n3);
    }

    protected void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.capacity *= 2;
    }

    public void removeRange(int n, int n2) {
        ArrayUtil.adjustArray(73, this.keys, this.count, n, n - n2);
        this.count -= n2 - n;
    }

    public void removeAll() {
        this.hasChanged = true;
        ArrayUtil.clearArray(73, this.keys, 0, this.count);
        this.count = 0;
    }

    public void copyTo(IntIndex intIndex) {
        System.arraycopy(this.keys, 0, intIndex.keys, 0, this.count);
        intIndex.setSize(this.count);
    }

    public final synchronized void remove(int n) {
        this.hasChanged = true;
        this.moveRows(n + 1, n, this.count - n - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    private int peek() {
        return this.getKey(this.count - 1);
    }

    private boolean pop() {
        if (this.count > 0) {
            --this.count;
            return true;
        }
        return false;
    }

    private boolean push(int n) {
        return this.addUnsorted(n);
    }
}

