/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.Logs;

public final class LDLogger {
    private final String name;
    final LDLogAdapter adapter;
    private final LDLogAdapter.Channel channel;

    LDLogger(String name, LDLogAdapter adapter, LDLogAdapter.Channel channel) {
        this.name = name;
        this.adapter = adapter;
        this.channel = channel;
    }

    public static LDLogger withAdapter(LDLogAdapter adapter, String name) {
        return new LDLogger(name, adapter, adapter.newChannel(name));
    }

    public static LDLogger none() {
        return LDLogger.withAdapter(Logs.none(), "");
    }

    public LDLogger subLogger(String nameSuffix) {
        if (nameSuffix == null || nameSuffix.equals("")) {
            return this;
        }
        String subName = this.name + "." + nameSuffix;
        return new LDLogger(subName, this.adapter, this.adapter.newChannel(subName));
    }

    public boolean isEnabled(LDLogLevel level) {
        return this.channel.isEnabled(level);
    }

    public void debug(Object message) {
        this.channel.log(LDLogLevel.DEBUG, message);
    }

    public void debug(String format, Object param) {
        this.channel.log(LDLogLevel.DEBUG, format, param);
    }

    public void debug(String format, Object param1, Object param2) {
        this.channel.log(LDLogLevel.DEBUG, format, param1, param2);
    }

    public void debug(String format, Object ... params) {
        this.channel.log(LDLogLevel.DEBUG, format, params);
    }

    public void info(Object message) {
        this.channel.log(LDLogLevel.INFO, message);
    }

    public void info(String format, Object param) {
        this.channel.log(LDLogLevel.INFO, format, param);
    }

    public void info(String format, Object param1, Object param2) {
        this.channel.log(LDLogLevel.INFO, format, param1, param2);
    }

    public void info(String format, Object ... params) {
        this.channel.log(LDLogLevel.INFO, format, params);
    }

    public void warn(Object message) {
        this.channel.log(LDLogLevel.WARN, message);
    }

    public void warn(String format, Object param) {
        this.channel.log(LDLogLevel.WARN, format, param);
    }

    public void warn(String format, Object param1, Object param2) {
        this.channel.log(LDLogLevel.WARN, format, param1, param2);
    }

    public void warn(String format, Object ... params) {
        this.channel.log(LDLogLevel.WARN, format, params);
    }

    public void error(Object message) {
        this.channel.log(LDLogLevel.ERROR, message);
    }

    public void error(String format, Object param) {
        this.channel.log(LDLogLevel.ERROR, format, param);
    }

    public void error(String format, Object param1, Object param2) {
        this.channel.log(LDLogLevel.ERROR, format, param1, param2);
    }

    public void error(String format, Object ... params) {
        this.channel.log(LDLogLevel.ERROR, format, params);
    }
}

