/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.server.DiagnosticAccumulator;
import com.launchdarkly.sdk.server.DiagnosticEvent;
import com.launchdarkly.sdk.server.EventFactory;
import com.launchdarkly.sdk.server.EventOutputFormatter;
import com.launchdarkly.sdk.server.EventSummarizer;
import com.launchdarkly.sdk.server.EventsConfiguration;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.SimpleLRUCache;
import com.launchdarkly.sdk.server.interfaces.Event;
import com.launchdarkly.sdk.server.interfaces.EventProcessor;
import com.launchdarkly.sdk.server.interfaces.EventSender;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class DefaultEventProcessor
implements EventProcessor {
    @VisibleForTesting
    final EventDispatcher dispatcher;
    private final BlockingQueue<EventProcessorMessage> inbox;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final List<ScheduledFuture<?>> scheduledTasks = new ArrayList();
    private volatile boolean inputCapacityExceeded = false;
    private final LDLogger logger;

    DefaultEventProcessor(EventsConfiguration eventsConfig, ScheduledExecutorService sharedExecutor, int threadPriority, DiagnosticAccumulator diagnosticAccumulator, DiagnosticEvent.Init diagnosticInitEvent, LDLogger logger) {
        this.inbox = new ArrayBlockingQueue<EventProcessorMessage>(eventsConfig.capacity);
        this.scheduler = sharedExecutor;
        this.logger = logger;
        this.dispatcher = new EventDispatcher(eventsConfig, sharedExecutor, threadPriority, this.inbox, this.closed, diagnosticAccumulator, diagnosticInitEvent, logger);
        Runnable flusher = () -> this.postMessageAsync(MessageType.FLUSH, null);
        this.scheduledTasks.add(this.scheduler.scheduleAtFixedRate(flusher, eventsConfig.flushInterval.toMillis(), eventsConfig.flushInterval.toMillis(), TimeUnit.MILLISECONDS));
        Runnable userKeysFlusher = () -> this.postMessageAsync(MessageType.FLUSH_USERS, null);
        this.scheduledTasks.add(this.scheduler.scheduleAtFixedRate(userKeysFlusher, eventsConfig.userKeysFlushInterval.toMillis(), eventsConfig.userKeysFlushInterval.toMillis(), TimeUnit.MILLISECONDS));
        if (diagnosticAccumulator != null) {
            Runnable diagnosticsTrigger = () -> this.postMessageAsync(MessageType.DIAGNOSTIC, null);
            this.scheduledTasks.add(this.scheduler.scheduleAtFixedRate(diagnosticsTrigger, eventsConfig.diagnosticRecordingInterval.toMillis(), eventsConfig.diagnosticRecordingInterval.toMillis(), TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void sendEvent(Event e) {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.EVENT, e);
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.FLUSH, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduledTasks.forEach(task -> task.cancel(false));
            this.postMessageAsync(MessageType.FLUSH, null);
            this.postMessageAndWait(MessageType.SHUTDOWN, null);
        }
    }

    @VisibleForTesting
    void waitUntilInactive() throws IOException {
        this.postMessageAndWait(MessageType.SYNC, null);
    }

    @VisibleForTesting
    void postDiagnostic() {
        this.postMessageAsync(MessageType.DIAGNOSTIC, null);
    }

    private void postMessageAsync(MessageType type, Event event) {
        this.postToChannel(new EventProcessorMessage(type, event, false));
    }

    private void postMessageAndWait(MessageType type, Event event) {
        EventProcessorMessage message = new EventProcessorMessage(type, event, true);
        if (this.postToChannel(message)) {
            message.waitForCompletion();
        }
    }

    private boolean postToChannel(EventProcessorMessage message) {
        if (this.inbox.offer(message)) {
            return true;
        }
        boolean alreadyLogged = this.inputCapacityExceeded;
        this.inputCapacityExceeded = true;
        if (!alreadyLogged) {
            this.logger.warn("Events are being produced faster than they can be processed; some events will be dropped");
        }
        return false;
    }

    private static final class SendDiagnosticTaskFactory {
        private final EventsConfiguration eventsConfig;
        private final EventResponseListener eventResponseListener;

        SendDiagnosticTaskFactory(EventsConfiguration eventsConfig, EventResponseListener eventResponseListener) {
            this.eventsConfig = eventsConfig;
            this.eventResponseListener = eventResponseListener;
        }

        Runnable createSendDiagnosticTask(final DiagnosticEvent diagnosticEvent) {
            return new Runnable(){

                @Override
                public void run() {
                    String json = JsonHelpers.serialize(diagnosticEvent);
                    EventSender.Result result = ((SendDiagnosticTaskFactory)this).eventsConfig.eventSender.sendEventData(EventSender.EventDataKind.DIAGNOSTICS, json, 1, ((SendDiagnosticTaskFactory)this).eventsConfig.eventsUri);
                    if (eventResponseListener != null) {
                        eventResponseListener.handleResponse(result);
                    }
                }
            };
        }
    }

    private static final class SendEventsTask
    implements Runnable {
        private final EventsConfiguration eventsConfig;
        private final EventResponseListener responseListener;
        private final BlockingQueue<FlushPayload> payloadQueue;
        private final AtomicInteger activeFlushWorkersCount;
        private final AtomicBoolean stopping;
        private final EventOutputFormatter formatter;
        private final Thread thread;
        private final LDLogger logger;

        SendEventsTask(EventsConfiguration eventsConfig, EventResponseListener responseListener, BlockingQueue<FlushPayload> payloadQueue, AtomicInteger activeFlushWorkersCount, ThreadFactory threadFactory2, LDLogger logger) {
            this.eventsConfig = eventsConfig;
            this.formatter = new EventOutputFormatter(eventsConfig);
            this.responseListener = responseListener;
            this.payloadQueue = payloadQueue;
            this.activeFlushWorkersCount = activeFlushWorkersCount;
            this.stopping = new AtomicBoolean(false);
            this.logger = logger;
            this.thread = threadFactory2.newThread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopping.get()) {
                FlushPayload payload = null;
                try {
                    payload = this.payloadQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    StringWriter stringWriter = new StringWriter();
                    int outputEventCount = this.formatter.writeOutputEvents(payload.events, payload.summary, stringWriter);
                    EventSender.Result result = this.eventsConfig.eventSender.sendEventData(EventSender.EventDataKind.ANALYTICS, stringWriter.toString(), outputEventCount, this.eventsConfig.eventsUri);
                    this.responseListener.handleResponse(result);
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error in event processor: {}", LogValues.exceptionSummary(e));
                    this.logger.debug(LogValues.exceptionTrace(e));
                }
                AtomicInteger atomicInteger = this.activeFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.activeFlushWorkersCount.decrementAndGet();
                    this.activeFlushWorkersCount.notifyAll();
                }
            }
        }

        void stop() {
            this.stopping.set(true);
            this.thread.interrupt();
        }
    }

    private static interface EventResponseListener {
        public void handleResponse(EventSender.Result var1);
    }

    private static final class FlushPayload {
        final Event[] events;
        final EventSummarizer.EventSummary summary;

        FlushPayload(Event[] events, EventSummarizer.EventSummary summary) {
            this.events = events;
            this.summary = summary;
        }
    }

    private static final class EventBuffer {
        final List<Event> events = new ArrayList<Event>();
        final EventSummarizer summarizer = new EventSummarizer();
        private final int capacity;
        private final LDLogger logger;
        private boolean capacityExceeded = false;
        private long droppedEventCount = 0L;

        EventBuffer(int capacity, LDLogger logger) {
            this.capacity = capacity;
            this.logger = logger;
        }

        void add(Event e) {
            if (this.events.size() >= this.capacity) {
                if (!this.capacityExceeded) {
                    this.capacityExceeded = true;
                    this.logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
                }
                ++this.droppedEventCount;
            } else {
                this.capacityExceeded = false;
                this.events.add(e);
            }
        }

        void addToSummary(Event e) {
            this.summarizer.summarizeEvent(e);
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.summarizer.isEmpty();
        }

        long getAndClearDroppedCount() {
            long res = this.droppedEventCount;
            this.droppedEventCount = 0L;
            return res;
        }

        FlushPayload getPayload() {
            Event[] eventsOut = this.events.toArray(new Event[this.events.size()]);
            EventSummarizer.EventSummary summary = this.summarizer.getSummaryAndReset();
            return new FlushPayload(eventsOut, summary);
        }

        void clear() {
            this.events.clear();
            this.summarizer.clear();
        }
    }

    static final class EventDispatcher {
        private static final int MAX_FLUSH_THREADS = 5;
        private static final int MESSAGE_BATCH_SIZE = 50;
        @VisibleForTesting
        final EventsConfiguration eventsConfig;
        private final BlockingQueue<EventProcessorMessage> inbox;
        private final AtomicBoolean closed;
        private final List<SendEventsTask> flushWorkers;
        private final AtomicInteger busyFlushWorkersCount;
        private final AtomicLong lastKnownPastTime = new AtomicLong(0L);
        private final AtomicBoolean disabled = new AtomicBoolean(false);
        @VisibleForTesting
        final DiagnosticAccumulator diagnosticAccumulator;
        private final ExecutorService sharedExecutor;
        private final SendDiagnosticTaskFactory sendDiagnosticTaskFactory;
        private final LDLogger logger;
        private long deduplicatedUsers = 0L;

        private EventDispatcher(EventsConfiguration eventsConfig, ExecutorService sharedExecutor, int threadPriority, BlockingQueue<EventProcessorMessage> inbox, AtomicBoolean closed, DiagnosticAccumulator diagnosticAccumulator, DiagnosticEvent.Init diagnosticInitEvent, LDLogger logger) {
            this.eventsConfig = eventsConfig;
            this.inbox = inbox;
            this.closed = closed;
            this.sharedExecutor = sharedExecutor;
            this.diagnosticAccumulator = diagnosticAccumulator;
            this.busyFlushWorkersCount = new AtomicInteger(0);
            this.logger = logger;
            ThreadFactory threadFactory2 = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-event-delivery-%d").setPriority(threadPriority).build();
            ArrayBlockingQueue<FlushPayload> payloadQueue = new ArrayBlockingQueue<FlushPayload>(1);
            EventBuffer outbox = new EventBuffer(eventsConfig.capacity, logger);
            SimpleLRUCache userKeys = new SimpleLRUCache(eventsConfig.userKeysCapacity);
            Thread mainThread = threadFactory2.newThread(() -> this.runMainLoop(inbox, outbox, userKeys, payloadQueue));
            mainThread.setDaemon(true);
            mainThread.setUncaughtExceptionHandler(this::onUncaughtException);
            mainThread.start();
            this.flushWorkers = new ArrayList<SendEventsTask>();
            EventResponseListener listener = this::handleResponse;
            for (int i = 0; i < 5; ++i) {
                SendEventsTask task = new SendEventsTask(eventsConfig, listener, payloadQueue, this.busyFlushWorkersCount, threadFactory2, logger);
                this.flushWorkers.add(task);
            }
            if (diagnosticAccumulator != null) {
                this.sendDiagnosticTaskFactory = new SendDiagnosticTaskFactory(eventsConfig, this::handleResponse);
                sharedExecutor.submit(this.sendDiagnosticTaskFactory.createSendDiagnosticTask(diagnosticInitEvent));
            } else {
                this.sendDiagnosticTaskFactory = null;
            }
        }

        private void onUncaughtException(Thread thread2, Throwable e) {
            this.logger.error("Event processor thread was terminated by an unrecoverable error. No more analytics events will be sent. {} {}", LogValues.exceptionSummary(e), LogValues.exceptionTrace(e));
            this.closed.set(true);
            ArrayList messages = new ArrayList();
            this.inbox.drainTo(messages);
            for (EventProcessorMessage m3 : messages) {
                m3.completed();
            }
        }

        private void runMainLoop(BlockingQueue<EventProcessorMessage> inbox, EventBuffer outbox, SimpleLRUCache<String, String> userKeys, BlockingQueue<FlushPayload> payloadQueue) {
            ArrayList<EventProcessorMessage> batch = new ArrayList<EventProcessorMessage>(50);
            while (true) {
                try {
                    block12: while (true) {
                        batch.clear();
                        batch.add(inbox.take());
                        inbox.drainTo(batch, 49);
                        Iterator iterator2 = batch.iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block12;
                            EventProcessorMessage message = (EventProcessorMessage)iterator2.next();
                            switch (message.type) {
                                case EVENT: {
                                    this.processEvent(message.event, userKeys, outbox);
                                    break;
                                }
                                case FLUSH: {
                                    this.triggerFlush(outbox, payloadQueue);
                                    break;
                                }
                                case FLUSH_USERS: {
                                    userKeys.clear();
                                    break;
                                }
                                case DIAGNOSTIC: {
                                    this.sendAndResetDiagnostics(outbox);
                                    break;
                                }
                                case SYNC: {
                                    this.waitUntilAllFlushWorkersInactive();
                                    break;
                                }
                                case SHUTDOWN: {
                                    this.doShutdown();
                                    message.completed();
                                    return;
                                }
                            }
                            message.completed();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    this.logger.debug(e.toString(), (Object)e);
                    continue;
                }
                break;
            }
        }

        private void sendAndResetDiagnostics(EventBuffer outbox) {
            if (this.disabled.get()) {
                return;
            }
            long droppedEvents = outbox.getAndClearDroppedCount();
            DiagnosticEvent.Statistics diagnosticEvent = this.diagnosticAccumulator.createEventAndReset(droppedEvents, this.deduplicatedUsers);
            this.deduplicatedUsers = 0L;
            this.sharedExecutor.submit(this.sendDiagnosticTaskFactory.createSendDiagnosticTask(diagnosticEvent));
        }

        private void doShutdown() {
            this.waitUntilAllFlushWorkersInactive();
            this.disabled.set(true);
            for (SendEventsTask task : this.flushWorkers) {
                task.stop();
            }
            try {
                this.eventsConfig.eventSender.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected error when closing event sender: {}", LogValues.exceptionSummary(e));
                this.logger.debug(LogValues.exceptionTrace(e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilAllFlushWorkersInactive() {
            while (true) {
                try {
                    while (true) {
                        AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                        synchronized (atomicInteger) {
                            if (this.busyFlushWorkersCount.get() == 0) {
                                return;
                            }
                            this.busyFlushWorkersCount.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processEvent(Event e, SimpleLRUCache<String, String> userKeys, EventBuffer outbox) {
            LDUser user;
            if (this.disabled.get()) {
                return;
            }
            outbox.addToSummary(e);
            boolean addIndexEvent = false;
            boolean addFullEvent = false;
            Event.FeatureRequest debugEvent = null;
            if (e instanceof Event.FeatureRequest) {
                Event.FeatureRequest fe = (Event.FeatureRequest)e;
                addFullEvent = fe.isTrackEvents();
                if (this.shouldDebugEvent(fe)) {
                    debugEvent = EventFactory.newDebugEvent(fe);
                }
            } else {
                addFullEvent = true;
            }
            if (!(addFullEvent && this.eventsConfig.inlineUsersInEvents || (user = e.getUser()) == null || user.getKey() == null)) {
                if (e instanceof Event.FeatureRequest || e instanceof Event.Custom) {
                    boolean alreadySeen;
                    String key = user.getKey();
                    boolean bl = alreadySeen = userKeys.put(key, key) != null;
                    if (alreadySeen) {
                        ++this.deduplicatedUsers;
                    } else {
                        addIndexEvent = true;
                    }
                } else if (e instanceof Event.Identify) {
                    String key = user.getKey();
                    userKeys.put(key, key);
                }
            }
            if (addIndexEvent) {
                Event.Index ie = new Event.Index(e.getCreationDate(), e.getUser());
                outbox.add(ie);
            }
            if (addFullEvent) {
                outbox.add(e);
            }
            if (debugEvent != null) {
                outbox.add(debugEvent);
            }
        }

        private boolean shouldDebugEvent(Event.FeatureRequest fe) {
            long lastPast;
            long debugEventsUntilDate = fe.getDebugEventsUntilDate();
            return debugEventsUntilDate > 0L && debugEventsUntilDate > (lastPast = this.lastKnownPastTime.get()) && debugEventsUntilDate > System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerFlush(EventBuffer outbox, BlockingQueue<FlushPayload> payloadQueue) {
            if (this.disabled.get() || outbox.isEmpty()) {
                return;
            }
            FlushPayload payload = outbox.getPayload();
            if (this.diagnosticAccumulator != null) {
                this.diagnosticAccumulator.recordEventsInBatch(payload.events.length);
            }
            this.busyFlushWorkersCount.incrementAndGet();
            if (payloadQueue.offer(payload)) {
                outbox.clear();
            } else {
                this.logger.debug("Skipped flushing because all workers are busy");
                outbox.summarizer.restoreTo(payload.summary);
                AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.busyFlushWorkersCount.decrementAndGet();
                    this.busyFlushWorkersCount.notify();
                }
            }
        }

        private void handleResponse(EventSender.Result result) {
            if (result.getTimeFromServer() != null) {
                this.lastKnownPastTime.set(result.getTimeFromServer().getTime());
            }
            if (result.isMustShutDown()) {
                this.disabled.set(true);
            }
        }
    }

    private static final class EventProcessorMessage {
        private final MessageType type;
        private final Event event;
        private final Semaphore reply;

        private EventProcessorMessage(MessageType type, Event event, boolean sync) {
            this.type = type;
            this.event = event;
            this.reply = sync ? new Semaphore(0) : null;
        }

        void completed() {
            if (this.reply != null) {
                this.reply.release();
            }
        }

        void waitForCompletion() {
            if (this.reply == null) {
                return;
            }
            while (true) {
                try {
                    this.reply.acquire();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static enum MessageType {
        EVENT,
        FLUSH,
        FLUSH_USERS,
        DIAGNOSTIC,
        SYNC,
        SHUTDOWN;

    }
}

