/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.Maps;
import com.launchdarkly.shaded.com.google.gson.TypeAdapter;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAdapter(value=JsonSerialization.class)
public final class FeatureFlagsState
implements JsonSerializable {
    private final ImmutableMap<String, FlagMetadata> flagMetadata;
    private final boolean valid;

    private FeatureFlagsState(ImmutableMap<String, FlagMetadata> flagMetadata, boolean valid) {
        this.flagMetadata = flagMetadata;
        this.valid = valid;
    }

    public static Builder builder(FlagsStateOption ... options) {
        return new Builder(options);
    }

    public boolean isValid() {
        return this.valid;
    }

    public LDValue getFlagValue(String key) {
        FlagMetadata data = this.flagMetadata.get(key);
        return data == null ? null : data.value;
    }

    public EvaluationReason getFlagReason(String key) {
        FlagMetadata data = this.flagMetadata.get(key);
        return data == null ? null : data.reason;
    }

    public Map<String, LDValue> toValuesMap() {
        return Maps.transformValues(this.flagMetadata, v -> v.value);
    }

    public boolean equals(Object other) {
        if (other instanceof FeatureFlagsState) {
            FeatureFlagsState o = (FeatureFlagsState)other;
            return this.flagMetadata.equals(o.flagMetadata) && this.valid == o.valid;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.flagMetadata, this.valid);
    }

    static class JsonSerialization
    extends TypeAdapter<FeatureFlagsState> {
        JsonSerialization() {
        }

        @Override
        public void write(JsonWriter out, FeatureFlagsState state) throws IOException {
            out.beginObject();
            for (Map.Entry entry : state.flagMetadata.entrySet()) {
                out.name((String)entry.getKey());
                JsonHelpers.gsonInstanceWithNullsAllowed().toJson((Object)((FlagMetadata)entry.getValue()).value, (Type)((Object)LDValue.class), out);
            }
            out.name("$flagsState");
            out.beginObject();
            for (Map.Entry entry : state.flagMetadata.entrySet()) {
                out.name((String)entry.getKey());
                FlagMetadata meta = (FlagMetadata)entry.getValue();
                out.beginObject();
                if (meta.variation != null) {
                    out.name("variation");
                    out.value(meta.variation.intValue());
                }
                if (meta.reason != null) {
                    out.name("reason");
                    JsonHelpers.gsonInstanceWithNullsAllowed().toJson((Object)meta.reason, (Type)((Object)EvaluationReason.class), out);
                }
                if (meta.version != null) {
                    out.name("version");
                    out.value(meta.version.intValue());
                }
                if (meta.trackEvents) {
                    out.name("trackEvents");
                    out.value(meta.trackEvents);
                }
                if (meta.trackReason) {
                    out.name("trackReason");
                    out.value(meta.trackReason);
                }
                if (meta.debugEventsUntilDate != null) {
                    out.name("debugEventsUntilDate");
                    out.value(meta.debugEventsUntilDate);
                }
                out.endObject();
            }
            out.endObject();
            out.name("$valid");
            out.value(state.valid);
            out.endObject();
        }

        @Override
        public FeatureFlagsState read(JsonReader in) throws IOException {
            HashMap<String, LDValue> flagValues = new HashMap<String, LDValue>();
            HashMap<String, FlagMetadata> flagMetadataWithoutValues = new HashMap<String, FlagMetadata>();
            boolean valid = true;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("$flagsState")) {
                    in.beginObject();
                    while (in.hasNext()) {
                        String metaName = in.nextName();
                        FlagMetadata meta = (FlagMetadata)JsonHelpers.gsonInstanceWithNullsAllowed().fromJson(in, (Type)((Object)FlagMetadata.class));
                        flagMetadataWithoutValues.put(metaName, meta);
                    }
                    in.endObject();
                    continue;
                }
                if (name.equals("$valid")) {
                    valid = in.nextBoolean();
                    continue;
                }
                LDValue value = (LDValue)JsonHelpers.gsonInstanceWithNullsAllowed().fromJson(in, (Type)((Object)LDValue.class));
                flagValues.put(name, value);
            }
            in.endObject();
            ImmutableMap.Builder<String, FlagMetadata> allFlagMetadata = ImmutableMap.builder();
            for (Map.Entry e : flagValues.entrySet()) {
                FlagMetadata m0 = (FlagMetadata)flagMetadataWithoutValues.get(e.getKey());
                if (m0 == null) continue;
                FlagMetadata m1 = new FlagMetadata((LDValue)e.getValue(), m0.variation, m0.reason, m0.version, m0.trackEvents, m0.trackReason, m0.debugEventsUntilDate);
                allFlagMetadata.put((String)e.getKey(), m1);
            }
            return new FeatureFlagsState(allFlagMetadata.build(), valid);
        }
    }

    public static class Builder {
        private ImmutableMap.Builder<String, FlagMetadata> flagMetadata = ImmutableMap.builder();
        private final boolean saveReasons;
        private final boolean detailsOnlyForTrackedFlags;
        private boolean valid = true;

        private Builder(FlagsStateOption ... options) {
            this.saveReasons = FlagsStateOption.hasOption(options, FlagsStateOption.WITH_REASONS);
            this.detailsOnlyForTrackedFlags = FlagsStateOption.hasOption(options, FlagsStateOption.DETAILS_ONLY_FOR_TRACKED_FLAGS);
        }

        public Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public Builder add(String flagKey, LDValue value, Integer variationIndex, EvaluationReason reason, int flagVersion, boolean trackEvents, Long debugEventsUntilDate) {
            return this.add(flagKey, value, variationIndex, reason, flagVersion, trackEvents, false, debugEventsUntilDate);
        }

        public Builder add(String flagKey, LDValue value, Integer variationIndex, EvaluationReason reason, int flagVersion, boolean trackEvents, boolean trackReason, Long debugEventsUntilDate) {
            boolean flagIsTracked = trackEvents || debugEventsUntilDate != null && debugEventsUntilDate > System.currentTimeMillis();
            boolean wantDetails = !this.detailsOnlyForTrackedFlags || flagIsTracked;
            FlagMetadata data = new FlagMetadata(value, variationIndex, this.saveReasons && wantDetails || trackReason ? reason : null, wantDetails ? Integer.valueOf(flagVersion) : null, trackEvents, trackReason, debugEventsUntilDate);
            this.flagMetadata.put(flagKey, data);
            return this;
        }

        Builder addFlag(DataModel.FeatureFlag flag, EvalResult eval) {
            return this.add(flag.getKey(), eval.getValue(), eval.isNoVariation() ? null : Integer.valueOf(eval.getVariationIndex()), eval.getReason(), flag.getVersion(), flag.isTrackEvents() || eval.isForceReasonTracking(), eval.isForceReasonTracking(), flag.getDebugEventsUntilDate());
        }

        public FeatureFlagsState build() {
            return new FeatureFlagsState(this.flagMetadata.build(), this.valid);
        }
    }

    static class FlagMetadata {
        final LDValue value;
        final Integer variation;
        final EvaluationReason reason;
        final Integer version;
        final boolean trackEvents;
        final boolean trackReason;
        final Long debugEventsUntilDate;

        FlagMetadata(LDValue value, Integer variation, EvaluationReason reason, Integer version, boolean trackEvents, boolean trackReason, Long debugEventsUntilDate) {
            this.value = LDValue.normalize(value);
            this.variation = variation;
            this.reason = reason;
            this.version = version;
            this.trackEvents = trackEvents;
            this.trackReason = trackReason;
            this.debugEventsUntilDate = debugEventsUntilDate;
        }

        public boolean equals(Object other) {
            if (other instanceof FlagMetadata) {
                FlagMetadata o = (FlagMetadata)other;
                return this.value.equals(o.value) && Objects.equals(this.variation, o.variation) && Objects.equals(this.reason, o.reason) && Objects.equals(this.version, o.version) && this.trackEvents == o.trackEvents && this.trackReason == o.trackReason && Objects.equals(this.debugEventsUntilDate, o.debugEventsUntilDate);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.variation, this.version, this.trackEvents, this.trackReason, this.debugEventsUntilDate);
        }
    }
}

