/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;

final class MultiLogging
implements LDLogAdapter {
    private final LDLogAdapter[] adapters;

    MultiLogging(LDLogAdapter[] adapters) {
        this.adapters = new LDLogAdapter[adapters.length];
        System.arraycopy(adapters, 0, this.adapters, 0, adapters.length);
    }

    @Override
    public LDLogAdapter.Channel newChannel(String name) {
        LDLogAdapter.Channel[] channels = new LDLogAdapter.Channel[this.adapters.length];
        for (int i = 0; i < this.adapters.length; ++i) {
            channels[i] = this.adapters[i].newChannel(name);
        }
        return new ChannelImpl(channels);
    }

    private static final class ChannelImpl
    implements LDLogAdapter.Channel {
        private final LDLogAdapter.Channel[] channels;

        ChannelImpl(LDLogAdapter.Channel[] channels) {
            this.channels = channels;
        }

        @Override
        public boolean isEnabled(LDLogLevel level) {
            for (LDLogAdapter.Channel c : this.channels) {
                if (!c.isEnabled(level)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void log(LDLogLevel level, Object message) {
            for (LDLogAdapter.Channel c : this.channels) {
                c.log(level, message);
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param) {
            for (LDLogAdapter.Channel c : this.channels) {
                c.log(level, format, param);
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object param1, Object param2) {
            for (LDLogAdapter.Channel c : this.channels) {
                c.log(level, format, param1, param2);
            }
        }

        @Override
        public void log(LDLogLevel level, String format, Object ... params) {
            for (LDLogAdapter.Channel c : this.channels) {
                c.log(level, format, params);
            }
        }
    }
}

