/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.DataModelSerialization;
import com.launchdarkly.sdk.server.FeatureRequestor;
import com.launchdarkly.sdk.server.HttpErrorException;
import com.launchdarkly.sdk.server.StandardEndpoints;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import com.launchdarkly.sdk.server.interfaces.HttpConfiguration;
import com.launchdarkly.sdk.server.interfaces.SerializationException;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.okhttp3.Cache;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class DefaultFeatureRequestor
implements FeatureRequestor {
    private static final long MAX_HTTP_CACHE_SIZE_BYTES = 0xA00000L;
    @VisibleForTesting
    final URI baseUri;
    private final OkHttpClient httpClient;
    private final URI pollingUri;
    private final Headers headers;
    private final Path cacheDir;
    private final LDLogger logger;

    DefaultFeatureRequestor(HttpConfiguration httpConfig, URI baseUri, LDLogger logger) {
        this.baseUri = baseUri;
        this.pollingUri = Util.concatenateUriPath(baseUri, StandardEndpoints.POLLING_REQUEST_PATH);
        this.logger = logger;
        OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
        Util.configureHttpClientBuilder(httpConfig, httpBuilder);
        this.headers = Util.getHeadersBuilderFor(httpConfig).build();
        try {
            this.cacheDir = Files.createTempDirectory("LaunchDarklySDK", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to create cache directory for polling", e);
        }
        Cache cache = new Cache(this.cacheDir.toFile(), 0xA00000L);
        httpBuilder.cache(cache);
        this.httpClient = httpBuilder.build();
    }

    @Override
    public void close() {
        Util.shutdownHttpClient(this.httpClient);
        Util.deleteDirectory(this.cacheDir);
    }

    @Override
    public DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> getAllData(boolean returnDataEvenIfCached) throws IOException, HttpErrorException, SerializationException {
        Request request = new Request.Builder().url(this.pollingUri.toURL()).headers(this.headers).get().build();
        this.logger.debug("Making request: " + request);
        try (Response response = this.httpClient.newCall(request).execute();){
            boolean wasCached;
            boolean bl = wasCached = response.networkResponse() == null || response.networkResponse().code() == 304;
            if (wasCached && !returnDataEvenIfCached) {
                this.logger.debug("Get flag(s) got cached response, will not parse");
                this.logger.debug("Cache hit count: {} Cache network count: {} ", (Object)this.httpClient.cache().hitCount(), (Object)this.httpClient.cache().networkCount());
                DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> fullDataSet = null;
                return fullDataSet;
            }
            this.logger.debug("Get flag(s) response: " + response.toString());
            this.logger.debug("Network response: " + response.networkResponse());
            this.logger.debug("Cache hit count: " + this.httpClient.cache().hitCount() + " Cache network Count: " + this.httpClient.cache().networkCount());
            this.logger.debug("Cache response: " + response.cacheResponse());
            if (!response.isSuccessful()) {
                throw new HttpErrorException(response.code());
            }
            JsonReader jr = new JsonReader(response.body().charStream());
            DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> fullDataSet = DataModelSerialization.parseFullDataSet(jr);
            return fullDataSet;
        }
    }
}

