/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

final class PersistentDataStoreStatusManager
implements Closeable {
    static final int POLL_INTERVAL_MS = 500;
    private final Consumer<DataStoreStatusProvider.Status> statusUpdater;
    private final ScheduledExecutorService scheduler;
    private final Callable<Boolean> statusPollFn;
    private final boolean refreshOnRecovery;
    private final LDLogger logger;
    private volatile boolean lastAvailable;
    private volatile ScheduledFuture<?> pollerFuture;

    PersistentDataStoreStatusManager(boolean refreshOnRecovery, boolean availableNow, Callable<Boolean> statusPollFn, Consumer<DataStoreStatusProvider.Status> statusUpdater, ScheduledExecutorService sharedExecutor, LDLogger logger) {
        this.refreshOnRecovery = refreshOnRecovery;
        this.lastAvailable = availableNow;
        this.statusPollFn = statusPollFn;
        this.statusUpdater = statusUpdater;
        this.scheduler = sharedExecutor;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PersistentDataStoreStatusManager persistentDataStoreStatusManager = this;
        synchronized (persistentDataStoreStatusManager) {
            if (this.pollerFuture != null) {
                this.pollerFuture.cancel(true);
                this.pollerFuture = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAvailability(boolean available) {
        PersistentDataStoreStatusManager persistentDataStoreStatusManager = this;
        synchronized (persistentDataStoreStatusManager) {
            if (this.lastAvailable == available) {
                return;
            }
            this.lastAvailable = available;
        }
        DataStoreStatusProvider.Status status = new DataStoreStatusProvider.Status(available, available && this.refreshOnRecovery);
        if (available) {
            this.logger.warn("Persistent store is available again");
        }
        this.statusUpdater.accept(status);
        if (available) {
            PersistentDataStoreStatusManager persistentDataStoreStatusManager2 = this;
            synchronized (persistentDataStoreStatusManager2) {
                if (this.pollerFuture != null) {
                    this.pollerFuture.cancel(false);
                    this.pollerFuture = null;
                }
            }
        }
        this.logger.warn("Detected persistent store unavailability; updates will be cached until it recovers");
        Runnable pollerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (((Boolean)PersistentDataStoreStatusManager.this.statusPollFn.call()).booleanValue()) {
                        PersistentDataStoreStatusManager.this.updateAvailability(true);
                    }
                }
                catch (Exception e) {
                    PersistentDataStoreStatusManager.this.logger.error("Unexpected error from data store status function: {}", LogValues.exceptionSummary(e));
                    PersistentDataStoreStatusManager.this.logger.debug(LogValues.exceptionTrace(e));
                }
            }
        };
        PersistentDataStoreStatusManager persistentDataStoreStatusManager3 = this;
        synchronized (persistentDataStoreStatusManager3) {
            if (this.pollerFuture == null) {
                this.pollerFuture = this.scheduler.scheduleAtFixedRate(pollerTask, 500L, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

