/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import java.net.URI;

abstract class StandardEndpoints {
    static URI DEFAULT_STREAMING_BASE_URI = URI.create("https://stream.launchdarkly.com");
    static URI DEFAULT_POLLING_BASE_URI = URI.create("https://app.launchdarkly.com");
    static URI DEFAULT_EVENTS_BASE_URI = URI.create("https://events.launchdarkly.com");
    static String STREAMING_REQUEST_PATH = "/all";
    static String POLLING_REQUEST_PATH = "/sdk/latest-all";
    static String ANALYTICS_EVENTS_POST_REQUEST_PATH = "/bulk";
    static String DIAGNOSTIC_EVENTS_POST_REQUEST_PATH = "/diagnostic";

    private StandardEndpoints() {
    }

    static URI selectBaseUri(URI serviceEndpointsValue, URI overrideValue, URI defaultValue, String description, LDLogger logger) {
        if (overrideValue != null) {
            return overrideValue;
        }
        if (serviceEndpointsValue != null) {
            return serviceEndpointsValue;
        }
        logger.warn("You have set custom ServiceEndpoints without specifying the {} base URI; connections may not work properly", (Object)description);
        return defaultValue;
    }

    static boolean isCustomBaseUri(URI serviceEndpointsValue, URI overrideValue, URI defaultValue) {
        return overrideValue != null && !overrideValue.equals(defaultValue) || serviceEndpointsValue != null && !serviceEndpointsValue.equals(defaultValue);
    }
}

