/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.logging;

import com.launchdarkly.logging.LDJavaUtilLogging;
import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.LevelFilter;
import com.launchdarkly.logging.LogCapture;
import com.launchdarkly.logging.MultiLogging;
import com.launchdarkly.logging.NullLogging;
import com.launchdarkly.logging.SimpleLogging;
import java.io.PrintStream;

public abstract class Logs {
    private Logs() {
    }

    public static LDLogAdapter none() {
        return NullLogging.INSTANCE;
    }

    public static LDLogAdapter level(LDLogAdapter adapter, LDLogLevel minimumLevel) {
        if (adapter instanceof LDLogAdapter.IsConfiguredExternally) {
            return adapter;
        }
        return new LevelFilter(adapter, minimumLevel);
    }

    public static LDLogAdapter basic() {
        return Logs.level(Logs.toConsole(), LDLogLevel.INFO);
    }

    public static LogCapture capture() {
        return new LogCapture();
    }

    public static SimpleLogging toConsole() {
        return Logs.toStream(System.err);
    }

    public static SimpleLogging toStream(PrintStream stream) {
        return Logs.toMethod(new StreamLineWriter(stream));
    }

    public static SimpleLogging toMethod(SimpleLogging.LineWriter lineWriter) {
        return new SimpleLogging(lineWriter, null, SimpleLogging.getDefaultTimestampFormat());
    }

    public static LDLogAdapter toJavaUtilLogging() {
        return LDJavaUtilLogging.INSTANCE;
    }

    public static LDLogAdapter toMultiple(LDLogAdapter ... adapters) {
        return adapters == null || adapters.length == 0 ? Logs.none() : new MultiLogging(adapters);
    }

    static final class StreamLineWriter
    implements SimpleLogging.LineWriter {
        final PrintStream stream;

        StreamLineWriter(PrintStream stream) {
            this.stream = stream;
        }

        @Override
        public void writeLine(String line) {
            this.stream.println(line);
        }
    }
}

