/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextBuilder;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.ContextMultiBuilder;
import com.launchdarkly.sdk.LDContextTypeAdapter;
import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonAdapter(value=LDContextTypeAdapter.class)
public final class LDContext
implements JsonSerializable {
    static final String ATTR_KIND = "kind";
    static final String ATTR_KEY = "key";
    static final String ATTR_NAME = "name";
    static final String ATTR_ANONYMOUS = "anonymous";
    final String error;
    final ContextKind kind;
    final LDContext[] multiContexts;
    final String key;
    final String fullyQualifiedKey;
    final String name;
    final Map<String, LDValue> attributes;
    final boolean anonymous;
    final List<AttributeRef> privateAttributes;

    private LDContext(ContextKind kind, LDContext[] multiContexts, String key, String fullyQualifiedKey, String name, Map<String, LDValue> attributes, boolean anonymous, List<AttributeRef> privateAttributes) {
        this.error = null;
        this.kind = kind == null ? ContextKind.DEFAULT : kind;
        this.multiContexts = multiContexts;
        this.key = key;
        this.fullyQualifiedKey = fullyQualifiedKey;
        this.name = name;
        this.attributes = attributes;
        this.anonymous = anonymous;
        this.privateAttributes = privateAttributes;
    }

    private LDContext(String error) {
        this.error = error;
        this.kind = null;
        this.multiContexts = null;
        this.key = "";
        this.fullyQualifiedKey = "";
        this.name = null;
        this.attributes = null;
        this.anonymous = false;
        this.privateAttributes = null;
    }

    static LDContext createSingle(ContextKind kind, String key, String name, Map<String, LDValue> attributes, boolean anonymous, List<AttributeRef> privateAttributes, boolean allowEmptyKey) {
        String error;
        if (kind != null && (error = kind.validateAsSingleKind()) != null) {
            return LDContext.failed(error);
        }
        if (key == null || key.isEmpty() && !allowEmptyKey) {
            return LDContext.failed("context key must not be null or empty");
        }
        String fullyQualifiedKey = kind.isDefault() ? key : kind.toString() + ":" + LDContext.escapeKeyForFullyQualifiedKey(key);
        return new LDContext(kind, null, key, fullyQualifiedKey, name, attributes, anonymous, privateAttributes);
    }

    static LDContext createMultiInternal(LDContext[] multiContexts) {
        ArrayList<String> errors = null;
        boolean duplicates = false;
        block0: for (int i = 0; i < multiContexts.length; ++i) {
            LDContext c = multiContexts[i];
            if (!c.isValid()) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(c.getError());
                continue;
            }
            for (int j = 0; j < i; ++j) {
                if (!multiContexts[j].getKind().equals(c.getKind())) continue;
                duplicates = true;
                continue block0;
            }
        }
        if (duplicates) {
            if (errors == null) {
                errors = new ArrayList<String>();
            }
            errors.add("multi-kind context cannot have same kind more than once");
        }
        if (errors != null) {
            StringBuilder s2 = new StringBuilder();
            for (String e : errors) {
                if (s2.length() != 0) {
                    s2.append(", ");
                }
                s2.append(e);
            }
            return LDContext.failed(s2.toString());
        }
        Arrays.sort(multiContexts, ByKindComparator.INSTANCE);
        StringBuilder fullKey = new StringBuilder();
        for (LDContext c : multiContexts) {
            if (fullKey.length() != 0) {
                fullKey.append(':');
            }
            fullKey.append(c.getKind().toString()).append(':').append(LDContext.escapeKeyForFullyQualifiedKey(c.getKey()));
        }
        return new LDContext(ContextKind.MULTI, multiContexts, "", fullKey.toString(), null, null, false, null);
    }

    static LDContext failed(String error) {
        return new LDContext(error);
    }

    public static LDContext create(String key) {
        return LDContext.create(ContextKind.DEFAULT, key);
    }

    public static LDContext create(ContextKind kind, String key) {
        return LDContext.createSingle(kind, key, null, null, false, null, false);
    }

    public static LDContext createMulti(LDContext ... contexts) {
        if (contexts == null || contexts.length == 0) {
            return LDContext.failed("multi-kind context must contain at least one kind");
        }
        if (contexts.length == 1) {
            return contexts[0];
        }
        for (LDContext c : contexts) {
            if (!c.isMultiple()) continue;
            ContextMultiBuilder b = LDContext.multiBuilder();
            for (LDContext c1 : contexts) {
                b.add(c1);
            }
            return b.build();
        }
        LDContext[] copied = Arrays.copyOf(contexts, contexts.length);
        return LDContext.createMultiInternal(copied);
    }

    public static LDContext fromUser(LDUser user) {
        if (user == null) {
            return LDContext.failed("tried to use a null LDUser reference");
        }
        String key = user.getKey();
        if (key == null) {
            if (user.isAnonymous()) {
                key = "";
            } else {
                return LDContext.failed("context key must not be null or empty");
            }
        }
        HashMap<String, LDValue> attributes = null;
        for (UserAttribute a : UserAttribute.OPTIONAL_STRING_ATTRIBUTES) {
            LDValue value;
            if (a == UserAttribute.NAME || (value = user.getAttribute(a)).isNull()) continue;
            if (attributes == null) {
                attributes = new HashMap();
            }
            attributes.put(a.getName(), value);
        }
        if (user.custom != null && !user.custom.isEmpty()) {
            if (attributes == null) {
                attributes = new HashMap<String, LDValue>();
            }
            for (Map.Entry entry : user.custom.entrySet()) {
                attributes.put(((UserAttribute)entry.getKey()).getName(), (LDValue)entry.getValue());
            }
        }
        ArrayList<AttributeRef> privateAttributes = null;
        if (user.privateAttributeNames != null && !user.privateAttributeNames.isEmpty()) {
            privateAttributes = new ArrayList<AttributeRef>();
            for (UserAttribute pa : user.privateAttributeNames) {
                privateAttributes.add(AttributeRef.fromLiteral(pa.getName()));
            }
        }
        return new LDContext(ContextKind.DEFAULT, null, key, key, user.getName(), attributes, user.isAnonymous(), privateAttributes);
    }

    public static ContextBuilder builder(String key) {
        return LDContext.builder(ContextKind.DEFAULT, key);
    }

    public static ContextBuilder builder(ContextKind kind, String key) {
        return new ContextBuilder(kind, key);
    }

    public static ContextBuilder builderFromContext(LDContext context) {
        return new ContextBuilder().copyFrom(context);
    }

    public static ContextMultiBuilder multiBuilder() {
        return new ContextMultiBuilder();
    }

    public boolean isValid() {
        return this.error == null;
    }

    public String getError() {
        return this.error;
    }

    public ContextKind getKind() {
        return this.kind;
    }

    public boolean isMultiple() {
        return this.multiContexts != null;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public LDValue getValue(String attributeName) {
        return this.getTopLevelAttribute(attributeName);
    }

    public LDValue getValue(AttributeRef attributeRef) {
        String component;
        if (attributeRef == null || !attributeRef.isValid()) {
            return LDValue.ofNull();
        }
        String name = attributeRef.getComponent(0);
        if (this.isMultiple()) {
            if (attributeRef.getDepth() == 1 && name.equals(ATTR_KIND)) {
                return LDValue.of(this.kind.toString());
            }
            return LDValue.ofNull();
        }
        LDValue value = this.getTopLevelAttribute(name);
        if (value.isNull()) {
            return value;
        }
        for (int i = 1; i < attributeRef.getDepth() && !(value = value.get(component = attributeRef.getComponent(i))).isNull(); ++i) {
        }
        return value;
    }

    public Iterable<String> getCustomAttributeNames() {
        return this.attributes == null ? Collections.emptyList() : this.attributes.keySet();
    }

    public int getIndividualContextCount() {
        if (this.error != null) {
            return 0;
        }
        return this.multiContexts == null ? 1 : this.multiContexts.length;
    }

    public LDContext getIndividualContext(int index) {
        if (this.multiContexts == null) {
            return index == 0 ? this : null;
        }
        return index < 0 || index >= this.multiContexts.length ? null : this.multiContexts[index];
    }

    public LDContext getIndividualContext(ContextKind kind) {
        if (kind == null) {
            kind = ContextKind.DEFAULT;
        }
        if (this.multiContexts == null) {
            return this.kind.equals(kind) ? this : null;
        }
        for (LDContext c : this.multiContexts) {
            if (!c.kind.equals(kind)) continue;
            return c;
        }
        return null;
    }

    public LDContext getIndividualContext(String kind) {
        if (kind == null || kind.isEmpty()) {
            return this.getIndividualContext(ContextKind.DEFAULT);
        }
        if (this.multiContexts == null) {
            return this.kind.toString().equals(kind) ? this : null;
        }
        for (LDContext c : this.multiContexts) {
            if (!c.kind.toString().equals(kind)) continue;
            return c;
        }
        return null;
    }

    public int getPrivateAttributeCount() {
        return this.privateAttributes == null ? 0 : this.privateAttributes.size();
    }

    public AttributeRef getPrivateAttribute(int index) {
        if (this.privateAttributes == null) {
            return null;
        }
        return index < 0 || index >= this.privateAttributes.size() ? null : this.privateAttributes.get(index);
    }

    public String getFullyQualifiedKey() {
        return this.fullyQualifiedKey;
    }

    public String toString() {
        if (!this.isValid()) {
            return "(invalid LDContext: " + this.getError() + ")";
        }
        return JsonSerialization.serialize(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LDContext)) {
            return false;
        }
        LDContext o = (LDContext)other;
        if (!Objects.equals(this.error, o.error)) {
            return false;
        }
        if (this.error != null) {
            return true;
        }
        if (!this.kind.equals(o.kind)) {
            return false;
        }
        if (this.isMultiple()) {
            if (this.multiContexts.length != o.multiContexts.length) {
                return false;
            }
            for (int i = 0; i < this.multiContexts.length; ++i) {
                if (this.multiContexts[i].equals(o.multiContexts[i])) continue;
                return false;
            }
            return true;
        }
        if (!this.key.equals(o.key) || !Objects.equals(this.name, o.name) || this.anonymous != o.anonymous) {
            return false;
        }
        if ((this.attributes == null ? 0 : this.attributes.size()) != (o.attributes == null ? 0 : o.attributes.size())) {
            return false;
        }
        if (this.attributes != null) {
            for (Map.Entry<String, LDValue> kv : this.attributes.entrySet()) {
                if (Objects.equals(o.attributes.get(kv.getKey()), kv.getValue())) continue;
                return false;
            }
        }
        if (this.getPrivateAttributeCount() != o.getPrivateAttributeCount()) {
            return false;
        }
        if (this.privateAttributes != null) {
            for (AttributeRef a : this.privateAttributes) {
                boolean found = false;
                for (AttributeRef a1 : o.privateAttributes) {
                    if (!a1.equals(a)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h2 = Objects.hash(this.error, this.kind, this.key, this.name, this.anonymous);
        if (this.multiContexts != null) {
            for (LDContext c : this.multiContexts) {
                h2 = h2 * 17 + c.hashCode();
            }
        }
        if (this.attributes != null) {
            Object[] names = this.attributes.keySet().toArray(new String[this.attributes.size()]);
            Arrays.sort(names);
            for (Object name : names) {
                h2 = (h2 * 17 + ((String)name).hashCode()) * 17 + this.attributes.get(name).hashCode();
            }
        }
        if (this.privateAttributes != null) {
            Object[] refs = this.privateAttributes.toArray(new AttributeRef[this.privateAttributes.size()]);
            Arrays.sort(refs);
            for (Object a : refs) {
                h2 = h2 * 17 + ((AttributeRef)a).hashCode();
            }
        }
        return h2;
    }

    private LDValue getTopLevelAttribute(String attributeName) {
        switch (attributeName) {
            case "kind": {
                return LDValue.of(this.kind.toString());
            }
            case "key": {
                return this.multiContexts == null ? LDValue.of(this.key) : LDValue.ofNull();
            }
            case "name": {
                return LDValue.of(this.name);
            }
            case "anonymous": {
                return LDValue.of(this.anonymous);
            }
        }
        if (this.attributes == null) {
            return LDValue.ofNull();
        }
        LDValue v = this.attributes.get(attributeName);
        return v == null ? LDValue.ofNull() : v;
    }

    private static String escapeKeyForFullyQualifiedKey(String key) {
        return key.replace("%", "%25").replace(":", "%3A");
    }

    private static class ByKindComparator
    implements Comparator<LDContext> {
        static final ByKindComparator INSTANCE = new ByKindComparator();

        private ByKindComparator() {
        }

        @Override
        public int compare(LDContext c1, LDContext c2) {
            return c1.getKind().compareTo(c2.getKind());
        }
    }
}

