/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.json.GsonReaderAdapter;
import com.launchdarkly.sdk.json.GsonWriterAdapter;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public abstract class LDGson {
    private static final JsonElement JSONELEMENT_TRUE = new JsonPrimitive(Boolean.valueOf(true));
    private static final JsonElement JSONELEMENT_FALSE = new JsonPrimitive(Boolean.valueOf(false));

    private LDGson() {
    }

    public static TypeAdapterFactory typeAdapters() {
        return LDTypeAdapterFactory.INSTANCE;
    }

    public static JsonElement valueToJsonElement(LDValue value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        switch (value.getType()) {
            case BOOLEAN: {
                return value.booleanValue() ? JSONELEMENT_TRUE : JSONELEMENT_FALSE;
            }
            case NUMBER: {
                return new JsonPrimitive((Number)value.doubleValue());
            }
            case STRING: {
                return value.stringValue() == null ? JsonNull.INSTANCE : new JsonPrimitive(value.stringValue());
            }
            case ARRAY: {
                JsonArray a = new JsonArray();
                for (LDValue e : value.values()) {
                    a.add(LDGson.valueToJsonElement(e));
                }
                return a;
            }
            case OBJECT: {
                JsonObject o = new JsonObject();
                for (String k : value.keys()) {
                    o.add(k, LDGson.valueToJsonElement(value.get(k)));
                }
                return o;
            }
        }
        return JsonNull.INSTANCE;
    }

    public static <T> Map<T, JsonElement> valueMapToJsonElementMap(Map<T, LDValue> valueMap) {
        HashMap<T, JsonElement> ret = new HashMap<T, JsonElement>(valueMap.size());
        for (Map.Entry<T, LDValue> e : valueMap.entrySet()) {
            ret.put(e.getKey(), LDGson.valueToJsonElement(e.getValue()));
        }
        return ret;
    }

    static class DelegatingJsonWriterAdapter
    extends GsonWriterAdapter {
        private final JsonWriter writer;

        DelegatingJsonWriterAdapter(JsonWriter writer) {
            this.writer = writer;
        }

        @Override
        protected void beginArrayInternal() throws IOException {
            this.writer.beginArray();
        }

        @Override
        protected void beginObjectInternal() throws IOException {
            this.writer.beginObject();
        }

        @Override
        protected void endArrayInternal() throws IOException {
            this.writer.endArray();
        }

        @Override
        protected void endObjectInternal() throws IOException {
            this.writer.endObject();
        }

        @Override
        protected void jsonValueInternal(String value) throws IOException {
            this.writer.jsonValue(value);
        }

        @Override
        protected void nameInternal(String name) throws IOException {
            this.writer.name(name);
        }

        @Override
        protected void valueInternalNull() throws IOException {
            this.writer.nullValue();
        }

        @Override
        protected void valueInternalBool(boolean value) throws IOException {
            this.writer.value(value);
        }

        @Override
        protected void valueInternalDouble(double value) throws IOException {
            this.writer.value(value);
        }

        @Override
        protected void valueInternalLong(long value) throws IOException {
            this.writer.value(value);
        }

        @Override
        protected void valueInternalString(String value) throws IOException {
            this.writer.value(value);
        }
    }

    static class DelegatingJsonReaderAdapter
    extends GsonReaderAdapter {
        private final JsonReader reader;

        DelegatingJsonReaderAdapter(JsonReader reader) {
            this.reader = reader;
        }

        @Override
        public void beginArray() throws IOException {
            this.reader.beginArray();
        }

        @Override
        public void beginObject() throws IOException {
            this.reader.beginObject();
        }

        @Override
        public void endArray() throws IOException {
            this.reader.endArray();
        }

        @Override
        public void endObject() throws IOException {
            this.reader.endObject();
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.reader.hasNext();
        }

        @Override
        public boolean nextBoolean() throws IOException {
            return this.reader.nextBoolean();
        }

        @Override
        public double nextDouble() throws IOException {
            return this.reader.nextDouble();
        }

        @Override
        public int nextInt() throws IOException {
            return this.reader.nextInt();
        }

        @Override
        public long nextLong() throws IOException {
            return this.reader.nextLong();
        }

        @Override
        public String nextName() throws IOException {
            return this.reader.nextName();
        }

        @Override
        public void nextNull() throws IOException {
            this.reader.nextNull();
        }

        @Override
        public String nextString() throws IOException {
            return this.reader.nextString();
        }

        @Override
        public void skipValue() throws IOException {
            this.reader.skipValue();
        }

        @Override
        protected int peekInternal() throws IOException {
            return this.reader.peek().ordinal();
        }
    }

    private static class LDTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Type objectType;

        LDTypeAdapter(Type objectType) {
            this.objectType = objectType;
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                JsonSerialization.serializeToGsonInternal(value, value.getClass(), new DelegatingJsonWriterAdapter(out));
            }
        }

        public T read(JsonReader in) throws IOException {
            return JsonSerialization.deserializeFromGsonInternal(new DelegatingJsonReaderAdapter(in), this.objectType);
        }
    }

    private static class LDTypeAdapterFactory
    implements TypeAdapterFactory {
        private static LDTypeAdapterFactory INSTANCE = new LDTypeAdapterFactory();

        private LDTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (JsonSerializable.class.isAssignableFrom(type.getRawType())) {
                return new LDTypeAdapter(type.getType());
            }
            return null;
        }
    }
}

