/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.shaded.org.apache.commons.codec.digest.DigestUtils;

abstract class EvaluatorBucketing {
    private static final float LONG_SCALE = 1.1529215E18f;

    private EvaluatorBucketing() {
    }

    static float computeBucketValue(boolean isExperiment, Integer seed, LDContext context, ContextKind contextKind, String flagOrSegmentKey, AttributeRef attr, String salt) {
        LDValue contextValue;
        LDContext matchContext = context.getIndividualContext(contextKind);
        if (matchContext == null) {
            return -1.0f;
        }
        if (isExperiment || attr == null) {
            contextValue = LDValue.of(matchContext.getKey());
        } else {
            if (!attr.isValid()) {
                return 0.0f;
            }
            contextValue = matchContext.getValue(attr);
            if (contextValue.isNull()) {
                return 0.0f;
            }
        }
        String idHash = EvaluatorBucketing.getBucketableStringValue(contextValue);
        if (idHash == null) {
            return 0.0f;
        }
        String prefix = seed != null ? seed.toString() : flagOrSegmentKey + "." + salt;
        String hash = DigestUtils.sha1Hex(prefix + "." + idHash).substring(0, 15);
        long longVal = Long.parseLong(hash, 16);
        return (float)longVal / 1.1529215E18f;
    }

    private static String getBucketableStringValue(LDValue userValue) {
        switch (userValue.getType()) {
            case STRING: {
                return userValue.stringValue();
            }
            case NUMBER: {
                return userValue.isInt() ? String.valueOf(userValue.intValue()) : null;
            }
        }
        return null;
    }
}

