/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import java.net.URI;

abstract class StandardEndpoints {
    static final URI DEFAULT_STREAMING_BASE_URI = URI.create("https://stream.launchdarkly.com");
    static final URI DEFAULT_POLLING_BASE_URI = URI.create("https://app.launchdarkly.com");
    static final URI DEFAULT_EVENTS_BASE_URI = URI.create("https://events.launchdarkly.com");
    static final String STREAMING_REQUEST_PATH = "/all";
    static final String POLLING_REQUEST_PATH = "/sdk/latest-all";

    private StandardEndpoints() {
    }

    static URI selectBaseUri(URI serviceEndpointsValue, URI defaultValue, String description, LDLogger logger) {
        if (serviceEndpointsValue != null) {
            return serviceEndpointsValue;
        }
        logger.warn("You have set custom ServiceEndpoints without specifying the {} base URI; connections may not work properly", (Object)description);
        return defaultValue;
    }

    static boolean isCustomBaseUri(URI serviceEndpointsValue, URI defaultValue) {
        return serviceEndpointsValue != null && !serviceEndpointsValue.equals(defaultValue);
    }
}

