/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.persistence.util.COSObjectKey;

public class PDFXrefStreamParser
extends BaseParser {
    private COSStream stream;
    private XrefTrailerResolver xrefTrailerResolver;

    public PDFXrefStreamParser(COSStream strm, COSDocument doc, boolean forceParsing, XrefTrailerResolver resolver) throws IOException {
        super(strm.getUnfilteredStream(), forceParsing);
        this.setDocument(doc);
        this.stream = strm;
        this.xrefTrailerResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            COSArray xrefFormat = (COSArray)this.stream.getDictionaryObject(COSName.W);
            COSArray indexArray = (COSArray)this.stream.getDictionaryObject(COSName.INDEX);
            if (indexArray == null) {
                indexArray = new COSArray();
                indexArray.add(COSInteger.ZERO);
                indexArray.add(this.stream.getDictionaryObject(COSName.SIZE));
            }
            ArrayList<Integer> objNums = new ArrayList<Integer>();
            Iterator<COSBase> indexIter = indexArray.iterator();
            while (indexIter.hasNext()) {
                int objID = ((COSInteger)indexIter.next()).intValue();
                int size = ((COSInteger)indexIter.next()).intValue();
                for (int i = 0; i < size; ++i) {
                    objNums.add(new Integer(objID + i));
                }
            }
            Iterator objIter = objNums.iterator();
            int w0 = xrefFormat.getInt(0);
            int w1 = xrefFormat.getInt(1);
            int w2 = xrefFormat.getInt(2);
            int lineSize = w0 + w1 + w2;
            while (this.pdfSource.available() > 0 && objIter.hasNext()) {
                int type;
                byte[] currLine = new byte[lineSize];
                this.pdfSource.read(currLine);
                if (w0 == 0) {
                    type = 1;
                } else {
                    type = 0;
                    for (int i = 0; i < w0; ++i) {
                        type += (currLine[i] & 0xFF) << (w0 - i - 1) * 8;
                    }
                }
                Integer objID = (Integer)objIter.next();
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int offset = 0;
                        for (int i = 0; i < w1; ++i) {
                            offset += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                        }
                        int genNum = 0;
                        for (int i = 0; i < w2; ++i) {
                            genNum += (currLine[i + w0 + w1] & 0xFF) << (w2 - i - 1) * 8;
                        }
                        COSObjectKey objKey = new COSObjectKey(objID.intValue(), genNum);
                        this.xrefTrailerResolver.setXRef(objKey, offset);
                        break;
                    }
                    case 2: {
                        int objstmObjNr = 0;
                        for (int i = 0; i < w1; ++i) {
                            objstmObjNr += (currLine[i + w0] & 0xFF) << (w1 - i - 1) * 8;
                        }
                        COSObjectKey objKey = new COSObjectKey(objID.intValue(), 0L);
                        this.xrefTrailerResolver.setXRef(objKey, -objstmObjNr);
                        break;
                    }
                }
            }
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.pdfSource.close();
            throw throwable;
        }
        this.pdfSource.close();
    }
}

