/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSParser;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.EndstreamFilterStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFXrefStreamParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;

public class COSParser
extends BaseParser
implements ICOSParser {
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final String FDF_DEFAULT_VERSION = "1.0";
    private static final char[] XREF_TABLE = new char[]{'x', 'r', 'e', 'f'};
    private static final char[] XREF_STREAM = new char[]{'/', 'X', 'R', 'e', 'f'};
    private static final char[] STARTXREF = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    private static final byte[] ENDSTREAM = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    private static final byte[] ENDOBJ = new byte[]{101, 110, 100, 111, 98, 106};
    private static final long MINIMUM_SEARCH_OFFSET = 6L;
    private static final int X = 120;
    private static final int STRMBUFLEN = 2048;
    private final byte[] strmBuf = new byte[2048];
    private AccessPermission accessPermission;
    private InputStream keyStoreInputStream = null;
    private String password = "";
    private String keyAlias = null;
    public static final String SYSPROP_EOFLOOKUPRANGE = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private static final char[] TRAILER_MARKER = new char[]{'t', 'r', 'a', 'i', 'l', 'e', 'r'};
    private static final char[] OBJ_STREAM = new char[]{'/', 'O', 'b', 'j', 'S', 't', 'm'};
    protected long fileLen;
    private boolean isLenient = true;
    protected boolean initialParseDone = false;
    private boolean trailerWasRebuild = false;
    private Map<COSObjectKey, Long> bfSearchCOSObjectKeyOffsets = null;
    boolean bruteForceSearchTriggered = false;
    private PDEncryption encryption = null;
    protected SecurityHandler<? extends ProtectionPolicy> securityHandler = null;
    private int readTrailBytes = 2048;
    private static final Log LOG = LogFactory.getLog(COSParser.class);
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();
    public static final String TMP_FILE_PREFIX = "tmpPDF";

    public COSParser(RandomAccessRead source) throws IOException {
        super(source);
        this.fileLen = source.length();
    }

    public COSParser(RandomAccessRead source, String password, InputStream keyStore, String keyAlias) throws IOException {
        super(source);
        this.password = password;
        this.keyAlias = keyAlias;
        this.fileLen = source.length();
        this.keyStoreInputStream = keyStore;
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected COSDictionary retrieveTrailer() throws IOException {
        COSDictionary trailer = null;
        boolean rebuildTrailer = false;
        try {
            long startXRefOffset = this.getStartxrefOffset();
            if (startXRefOffset > -1L) {
                trailer = this.parseXref(startXRefOffset);
            } else {
                rebuildTrailer = this.isLenient();
            }
        }
        catch (IOException exception) {
            if (this.isLenient()) {
                rebuildTrailer = true;
            }
            throw exception;
        }
        if (trailer != null && trailer.getItem(COSName.ROOT) == null) {
            rebuildTrailer = this.isLenient();
        }
        if (rebuildTrailer) {
            trailer = this.rebuildTrailer();
        } else {
            this.prepareDecryption();
            if (this.bruteForceSearchTriggered && !this.getBFCOSObjectOffsets().isEmpty()) {
                this.bfSearchForObjStreams();
            }
        }
        if (this.resetTrailerResolver()) {
            this.xrefTrailerResolver.reset();
            this.xrefTrailerResolver = null;
        }
        return trailer;
    }

    protected boolean resetTrailerResolver() {
        return true;
    }

    private COSDictionary parseXref(long startXRefOffset) throws IOException {
        COSDictionary trailer;
        this.source.seek(startXRefOffset);
        long startXrefOffset = Math.max(0L, this.parseStartXref());
        long fixedOffset = this.checkXRefOffset(startXrefOffset);
        if (fixedOffset > -1L) {
            startXrefOffset = fixedOffset;
        }
        this.document.setStartXref(startXrefOffset);
        long prev = startXrefOffset;
        HashSet<Long> prevSet = new HashSet<Long>();
        while (prev > 0L) {
            this.source.seek(prev);
            this.skipSpaces();
            if (this.source.peek() == 120) {
                if (!this.parseXrefTable(prev) || !this.parseTrailer()) {
                    throw new IOException("Expected trailer object at offset " + this.source.getPosition());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                if (trailer.containsKey(COSName.XREF_STM)) {
                    int streamOffset = trailer.getInt(COSName.XREF_STM);
                    fixedOffset = this.checkXRefOffset(streamOffset);
                    if (fixedOffset > -1L && fixedOffset != (long)streamOffset) {
                        LOG.warn((Object)("/XRefStm offset " + streamOffset + " is incorrect, corrected to " + fixedOffset));
                        streamOffset = (int)fixedOffset;
                        trailer.setInt(COSName.XREF_STM, streamOffset);
                    }
                    if (streamOffset > 0) {
                        this.source.seek(streamOffset);
                        this.skipSpaces();
                        try {
                            this.parseXrefObjStream(prev, false);
                        }
                        catch (IOException ex) {
                            if (this.isLenient) {
                                LOG.error((Object)("Failed to parse /XRefStm at offset " + streamOffset), (Throwable)ex);
                            }
                            throw ex;
                        }
                    } else if (this.isLenient) {
                        LOG.error((Object)("Skipped XRef stream due to a corrupt offset:" + streamOffset));
                    } else {
                        throw new IOException("Skipped XRef stream due to a corrupt offset:" + streamOffset);
                    }
                }
                if ((prev = trailer.getLong(COSName.PREV)) > 0L && (fixedOffset = this.checkXRefOffset(prev)) > -1L && fixedOffset != prev) {
                    prev = fixedOffset;
                    trailer.setLong(COSName.PREV, prev);
                }
            } else if ((prev = this.parseXrefObjStream(prev, true)) > 0L && (fixedOffset = this.checkXRefOffset(prev)) > -1L && fixedOffset != prev) {
                prev = fixedOffset;
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                trailer.setLong(COSName.PREV, prev);
            }
            if (prevSet.contains(prev)) {
                throw new IOException("/Prev loop at offset " + prev);
            }
            prevSet.add(prev);
        }
        this.xrefTrailerResolver.setStartxref(startXrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        this.document.setIsXRefStream(XrefTrailerResolver.XRefType.STREAM == this.xrefTrailerResolver.getXrefType());
        this.checkXrefOffsets();
        this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
        Optional<Long> maxValue = this.document.getXrefTable().keySet().stream().map(COSObjectKey::getNumber).reduce(Long::max);
        this.document.setHighestXRefObjectNumber(maxValue.isPresent() ? maxValue.get() : 0L);
        return trailer;
    }

    private long parseXrefObjStream(long objByteOffset, boolean isStandalone) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        COSDictionary dict = this.parseCOSDictionary();
        try (COSStream xrefStream = this.parseCOSStream(dict);){
            this.parseXrefStream(xrefStream, objByteOffset, isStandalone);
        }
        return dict.getLong(COSName.PREV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        try {
            int readBytes;
            int trailByteCount = this.fileLen < (long)this.readTrailBytes ? (int)this.fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = this.fileLen - (long)trailByteCount;
            this.source.seek(skipBytes);
            for (int off = 0; off < trailByteCount; off += readBytes) {
                readBytes = this.source.read(buf, off, trailByteCount - off);
                if (readBytes >= 1) continue;
                throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
            }
        }
        finally {
            this.source.seek(0L);
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            if (this.isLenient) {
                bufOff = buf.length;
                LOG.debug((Object)("Missing end of file marker '" + new String(EOF_MARKER) + "'"));
            } else {
                throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
            }
        }
        if ((bufOff = this.lastIndexOf(STARTXREF, buf, bufOff)) < 0) {
            throw new IOException("Missing 'startxref' marker.");
        }
        return skipBytes + (long)bufOff;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    protected void setLenient(boolean lenient) {
        if (this.initialParseDone) {
            throw new IllegalArgumentException("Cannot change leniency after parsing");
        }
        this.isLenient = lenient;
    }

    @Override
    public COSBase dereferenceCOSObject(COSObject obj) throws IOException {
        long currentPos = this.source.getPosition();
        COSBase parsedObj = this.parseObjectDynamically(obj.getObjectNumber(), obj.getGenerationNumber(), false);
        if (currentPos > 0L) {
            this.source.seek(currentPos);
        }
        return parsedObj;
    }

    @Override
    public RandomAccessReadView createRandomAccessReadView(long startPosition, long streamLength) throws IOException {
        return this.source.createView(startPosition, streamLength);
    }

    protected synchronized COSBase parseObjectDynamically(long objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (!pdfObject.isObjectNull()) {
            return pdfObject.getObject();
        }
        Long offsetOrObjstmObNr = this.getObjectOffset(objKey, requireExistingNotCompressedObj);
        COSBase referencedObject = null;
        if (offsetOrObjstmObNr != null) {
            referencedObject = offsetOrObjstmObNr > 0L ? this.parseFileObject(offsetOrObjstmObNr, objKey) : this.parseObjectStreamObject((int)(-offsetOrObjstmObNr.longValue()), objKey);
        }
        if (referencedObject == null || referencedObject instanceof COSNull) {
            pdfObject.setToNull();
        }
        return referencedObject;
    }

    private Long getObjectOffset(COSObjectKey objKey, boolean requireExistingNotCompressedObj) throws IOException {
        Map<COSObjectKey, Long> bfCOSObjectKeyOffsets;
        Long offsetOrObjstmObNr = this.document.getXrefTable().get(objKey);
        if (offsetOrObjstmObNr == null && this.isLenient && (offsetOrObjstmObNr = (bfCOSObjectKeyOffsets = this.getBFCOSObjectOffsets()).get(objKey)) != null) {
            LOG.debug((Object)("Set missing offset " + offsetOrObjstmObNr + " for object " + objKey));
            this.document.getXrefTable().put(objKey, offsetOrObjstmObNr);
        }
        if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
            throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
        }
        return offsetOrObjstmObNr;
    }

    private COSBase parseFileObject(Long offsetOrObjstmObNr, COSObjectKey objKey) throws IOException {
        this.source.seek(offsetOrObjstmObNr);
        long readObjNr = this.readObjectNumber();
        int readObjGen = this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
            throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen + " at offset " + offsetOrObjstmObNr);
        }
        this.skipSpaces();
        COSBase parsedObject = this.parseDirObject();
        String endObjectKey = this.readString();
        if (endObjectKey.equals("stream")) {
            COSStream stream;
            this.source.rewind(endObjectKey.getBytes(StandardCharsets.ISO_8859_1).length);
            if (parsedObject instanceof COSDictionary) {
                stream = this.parseCOSStream((COSDictionary)parsedObject);
                if (this.securityHandler != null) {
                    this.securityHandler.decryptStream(stream, objKey.getNumber(), objKey.getGeneration());
                }
            } else {
                throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
            }
            parsedObject = stream;
            this.skipSpaces();
            endObjectKey = this.readLine();
            if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                endObjectKey = this.readLine();
            }
        } else if (this.securityHandler != null) {
            this.securityHandler.decrypt(parsedObject, objKey.getNumber(), objKey.getGeneration());
        }
        if (!endObjectKey.startsWith("endobj")) {
            if (this.isLenient) {
                LOG.warn((Object)("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'"));
            } else {
                throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
            }
        }
        return parsedObject;
    }

    protected COSBase parseObjectStreamObject(int objstmObjNr, COSObjectKey key) throws IOException {
        COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
        COSBase objectStreamObject = null;
        if (objstmBaseObj instanceof COSStream) {
            PDFObjectStreamParser parser = null;
            try {
                parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document);
                objectStreamObject = parser.parseObject(key.getNumber());
                if (objectStreamObject != null) {
                    objectStreamObject.setKey(key);
                }
            }
            catch (IOException ex) {
                if (this.isLenient) {
                    LOG.error((Object)("object stream " + objstmObjNr + " could not be parsed due to an exception"), (Throwable)ex);
                }
                throw ex;
            }
        }
        return objectStreamObject;
    }

    private COSNumber getLength(COSBase lengthBaseObj) throws IOException {
        if (lengthBaseObj == null) {
            return null;
        }
        if (lengthBaseObj instanceof COSNumber) {
            return (COSNumber)lengthBaseObj;
        }
        if (lengthBaseObj instanceof COSObject) {
            COSObject lengthObj = (COSObject)lengthBaseObj;
            COSBase length = lengthObj.getObject();
            if (length == null) {
                throw new IOException("Length object content was not read.");
            }
            if (COSNull.NULL == length) {
                LOG.warn((Object)("Length object (" + lengthObj.getObjectNumber() + " " + lengthObj.getGenerationNumber() + ") not found"));
                return null;
            }
            if (length instanceof COSNumber) {
                return (COSNumber)length;
            }
            throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + length.getClass().getSimpleName());
        }
        throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
    }

    protected COSStream parseCOSStream(COSDictionary dic) throws IOException {
        long streamLength;
        this.readString();
        this.skipWhiteSpaces();
        COSNumber streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH));
        if (streamLengthObj == null) {
            if (this.isLenient) {
                LOG.warn((Object)("The stream doesn't provide any stream length, using fallback readUntilEnd, at offset " + this.source.getPosition()));
            } else {
                throw new IOException("Missing length for stream.");
            }
        }
        long streamStartPosition = this.source.getPosition();
        if (streamLengthObj != null && this.validateStreamLength(streamLengthObj.longValue())) {
            streamLength = streamLengthObj.longValue();
            this.source.seek(this.source.getPosition() + (long)streamLengthObj.intValue());
        } else {
            streamLength = this.readUntilEndStream(new EndstreamFilterStream());
        }
        String endStream = this.readString();
        if (endStream.equals("endobj") && this.isLenient) {
            LOG.warn((Object)("stream ends with 'endobj' instead of 'endstream' at offset " + this.source.getPosition()));
            this.source.rewind(ENDOBJ.length);
        } else if (endStream.length() > 9 && this.isLenient && endStream.substring(0, 9).equals("endstream")) {
            LOG.warn((Object)("stream ends with '" + endStream + "' instead of 'endstream' at offset " + this.source.getPosition()));
            this.source.rewind(endStream.substring(9).getBytes(StandardCharsets.ISO_8859_1).length);
        } else if (!endStream.equals("endstream")) {
            throw new IOException("Error reading stream, expected='endstream' actual='" + endStream + "' at offset " + this.source.getPosition());
        }
        return this.document.createCOSStream(dic, streamStartPosition, streamLength);
    }

    private long readUntilEndStream(EndstreamFilterStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.source.read(this.strmBuf, charMatchCount, 2048 - charMatchCount)) > 0) {
            int contentBytes;
            int bIdx;
            int maxQuicktestIdx = (bufSize += charMatchCount) - 5;
            for (bIdx = charMatchCount; bIdx < bufSize; ++bIdx) {
                byte ch;
                int quickTestIdx = bIdx + 5;
                if (charMatchCount == 0 && quickTestIdx < maxQuicktestIdx && ((ch = this.strmBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                    continue;
                }
                ch = this.strmBuf[bIdx];
                if (ch == keyw[charMatchCount]) {
                    if (++charMatchCount != keyw.length) continue;
                    ++bIdx;
                    break;
                }
                if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                    keyw = ENDOBJ;
                    ++charMatchCount;
                    continue;
                }
                charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                keyw = ENDSTREAM;
            }
            if ((contentBytes = Math.max(0, bIdx - charMatchCount)) > 0) {
                out.filter(this.strmBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.source.rewind(bufSize - contentBytes);
                break;
            }
            System.arraycopy(keyw, 0, this.strmBuf, 0, charMatchCount);
        }
        return out.calculateLength();
    }

    private boolean validateStreamLength(long streamLength) throws IOException {
        boolean streamLengthIsValid = true;
        long originOffset = this.source.getPosition();
        long expectedEndOfStream = originOffset + streamLength;
        if (expectedEndOfStream > this.fileLen) {
            streamLengthIsValid = false;
            LOG.warn((Object)("The end of the stream is out of range, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream));
        } else {
            this.source.seek(expectedEndOfStream);
            this.skipSpaces();
            if (!this.isString(ENDSTREAM)) {
                streamLengthIsValid = false;
                LOG.warn((Object)("The end of the stream doesn't point to the correct offset, using workaround to read the stream, stream start position: " + originOffset + ", length: " + streamLength + ", expected end position: " + expectedEndOfStream));
            }
            this.source.seek(originOffset);
        }
        return streamLengthIsValid;
    }

    private long checkXRefOffset(long startXRefOffset) throws IOException {
        if (!this.isLenient) {
            return startXRefOffset;
        }
        this.source.seek(startXRefOffset);
        this.skipSpaces();
        if (this.isString(XREF_TABLE)) {
            return startXRefOffset;
        }
        if (startXRefOffset > 0L) {
            if (this.checkXRefStreamOffset(startXRefOffset)) {
                return startXRefOffset;
            }
            return this.calculateXRefFixedOffset(startXRefOffset);
        }
        return -1L;
    }

    private boolean checkXRefStreamOffset(long startXRefOffset) throws IOException {
        if (!this.isLenient || startXRefOffset == 0L) {
            return true;
        }
        this.source.seek(startXRefOffset - 1L);
        int nextValue = this.source.read();
        if (this.isWhitespace(nextValue)) {
            this.skipSpaces();
            if (this.isDigit()) {
                try {
                    this.readObjectNumber();
                    this.readGenerationNumber();
                    this.readExpectedString(OBJ_MARKER, true);
                    COSDictionary dict = this.parseCOSDictionary();
                    this.source.seek(startXRefOffset);
                    if ("XRef".equals(dict.getNameAsString(COSName.TYPE))) {
                        return true;
                    }
                }
                catch (IOException exception) {
                    LOG.debug((Object)("No Xref stream at given location " + startXRefOffset), (Throwable)exception);
                    this.source.seek(startXRefOffset);
                }
            }
        }
        return false;
    }

    private long calculateXRefFixedOffset(long objectOffset) throws IOException {
        if (objectOffset < 0L) {
            LOG.error((Object)("Invalid object offset " + objectOffset + " when searching for a xref table/stream"));
            return 0L;
        }
        long newOffset = this.bfSearchForXRef(objectOffset);
        if (newOffset > -1L) {
            LOG.debug((Object)("Fixed reference for xref table/stream " + objectOffset + " -> " + newOffset));
            return newOffset;
        }
        LOG.error((Object)("Can't find the object xref table/stream at offset " + objectOffset));
        return 0L;
    }

    private boolean validateXrefOffsets(Map<COSObjectKey, Long> xrefOffset) throws IOException {
        if (xrefOffset == null) {
            return true;
        }
        for (Map.Entry<COSObjectKey, Long> objectEntry : xrefOffset.entrySet()) {
            COSObjectKey objectKey = objectEntry.getKey();
            Long objectOffset = objectEntry.getValue();
            if (objectOffset == null || objectOffset < 0L || this.checkObjectKey(objectKey, objectOffset)) continue;
            LOG.debug((Object)("Stop checking xref offsets as at least one (" + objectKey + ") couldn't be dereferenced"));
            return false;
        }
        return true;
    }

    private void checkXrefOffsets() throws IOException {
        Map<COSObjectKey, Long> bfCOSObjectKeyOffsets;
        if (!this.isLenient) {
            return;
        }
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (!this.validateXrefOffsets(xrefOffset) && !(bfCOSObjectKeyOffsets = this.getBFCOSObjectOffsets()).isEmpty()) {
            LOG.debug((Object)"Replaced read xref table with the results of a brute force search");
            xrefOffset.clear();
            xrefOffset.putAll(bfCOSObjectKeyOffsets);
        }
    }

    private boolean checkObjectKey(COSObjectKey objectKey, long offset) throws IOException {
        if (offset < 6L) {
            return false;
        }
        boolean objectKeyFound = false;
        try {
            this.source.seek(offset);
            if (objectKey.getNumber() == this.readObjectNumber()) {
                int genNumber = this.readGenerationNumber();
                if (genNumber == objectKey.getGeneration()) {
                    this.readExpectedString(OBJ_MARKER, true);
                    objectKeyFound = true;
                } else if (this.isLenient && genNumber > objectKey.getGeneration()) {
                    this.readExpectedString(OBJ_MARKER, true);
                    objectKeyFound = true;
                    objectKey.fixGeneration(genNumber);
                }
            }
        }
        catch (IOException exception) {
            LOG.debug((Object)("No valid object at given location " + offset + " - ignoring"), (Throwable)exception);
        }
        return objectKeyFound;
    }

    private Map<COSObjectKey, Long> getBFCOSObjectOffsets() throws IOException {
        if (this.bfSearchCOSObjectKeyOffsets == null) {
            this.bfSearchCOSObjectKeyOffsets = this.bfSearchForObjects();
            this.bruteForceSearchTriggered = true;
        }
        return this.bfSearchCOSObjectKeyOffsets;
    }

    private Map<COSObjectKey, Long> bfSearchForObjects() throws IOException {
        HashMap<COSObjectKey, Long> bfCOSObjectKeyOffsets = new HashMap<COSObjectKey, Long>();
        long lastEOFMarker = this.bfSearchForLastEOFMarker();
        long originOffset = this.source.getPosition();
        long currentOffset = 6L;
        long lastObjectId = Long.MIN_VALUE;
        int lastGenID = Integer.MIN_VALUE;
        long lastObjOffset = Long.MIN_VALUE;
        char[] endobjString = "ndo".toCharArray();
        char[] endobjRemainingString = "bj".toCharArray();
        boolean endOfObjFound = false;
        do {
            this.source.seek(currentOffset);
            int nextChar = this.source.read();
            ++currentOffset;
            if (this.isWhitespace(nextChar) && this.isString(OBJ_MARKER)) {
                long tempOffset = currentOffset - 2L;
                this.source.seek(tempOffset);
                int genID = this.source.peek();
                if (!COSParser.isDigit(genID)) continue;
                genID -= 48;
                this.source.seek(--tempOffset);
                if (!this.isWhitespace()) continue;
                while (tempOffset > 6L && this.isWhitespace()) {
                    this.source.seek(--tempOffset);
                }
                boolean objectIDFound = false;
                while (tempOffset > 6L && this.isDigit()) {
                    this.source.seek(--tempOffset);
                    objectIDFound = true;
                }
                if (!objectIDFound) continue;
                this.source.read();
                long objectId = this.readObjectNumber();
                if (lastObjOffset > 0L) {
                    bfCOSObjectKeyOffsets.put(new COSObjectKey(lastObjectId, lastGenID), lastObjOffset);
                }
                lastObjectId = objectId;
                lastGenID = genID;
                lastObjOffset = tempOffset + 1L;
                currentOffset += (long)(OBJ_MARKER.length - 1);
                endOfObjFound = false;
                continue;
            }
            if (nextChar != 101 || !this.isString(endobjString)) continue;
            this.source.seek(currentOffset += (long)endobjString.length);
            if (this.source.isEOF()) {
                endOfObjFound = true;
                continue;
            }
            if (!this.isString(endobjRemainingString)) continue;
            currentOffset += (long)endobjRemainingString.length;
            endOfObjFound = true;
        } while (currentOffset < lastEOFMarker && !this.source.isEOF());
        if ((lastEOFMarker < Long.MAX_VALUE || endOfObjFound) && lastObjOffset > 0L) {
            bfCOSObjectKeyOffsets.put(new COSObjectKey(lastObjectId, lastGenID), lastObjOffset);
        }
        this.source.seek(originOffset);
        return bfCOSObjectKeyOffsets;
    }

    private long bfSearchForXRef(long xrefOffset) throws IOException {
        long newOffset = -1L;
        List<Long> bfSearchXRefTablesOffsets = this.bfSearchForXRefTables();
        List<Long> bfSearchXRefStreamsOffsets = this.bfSearchForXRefStreams();
        long newOffsetTable = this.searchNearestValue(bfSearchXRefTablesOffsets, xrefOffset);
        long newOffsetStream = this.searchNearestValue(bfSearchXRefStreamsOffsets, xrefOffset);
        if (newOffsetTable > -1L && newOffsetStream > -1L) {
            long differenceTable = xrefOffset - newOffsetTable;
            long differenceStream = xrefOffset - newOffsetStream;
            if (Math.abs(differenceTable) > Math.abs(differenceStream)) {
                newOffset = newOffsetStream;
                bfSearchXRefStreamsOffsets.remove(newOffsetStream);
            } else {
                newOffset = newOffsetTable;
                bfSearchXRefTablesOffsets.remove(newOffsetTable);
            }
        } else if (newOffsetTable > -1L) {
            newOffset = newOffsetTable;
            bfSearchXRefTablesOffsets.remove(newOffsetTable);
        } else if (newOffsetStream > -1L) {
            newOffset = newOffsetStream;
            bfSearchXRefStreamsOffsets.remove(newOffsetStream);
        }
        return newOffset;
    }

    private long searchNearestValue(List<Long> values, long offset) {
        long newValue = -1L;
        Long currentDifference = null;
        int currentOffsetIndex = -1;
        int numberOfOffsets = values.size();
        for (int i = 0; i < numberOfOffsets; ++i) {
            long newDifference = offset - values.get(i);
            if (currentDifference != null && Math.abs(currentDifference) <= Math.abs(newDifference)) continue;
            currentDifference = newDifference;
            currentOffsetIndex = i;
        }
        if (currentOffsetIndex > -1) {
            newValue = values.get(currentOffsetIndex);
        }
        return newValue;
    }

    private boolean bfSearchForTrailer(COSDictionary trailer) throws IOException {
        HashMap<String, COSDictionary> trailerDicts = new HashMap<String, COSDictionary>();
        long originOffset = this.source.getPosition();
        this.source.seek(6L);
        long trailerOffset = this.findString(TRAILER_MARKER);
        while (trailerOffset != -1L) {
            try {
                COSObject infoObj;
                boolean rootFound = false;
                boolean infoFound = false;
                this.skipSpaces();
                COSDictionary trailerDict = this.parseCOSDictionary();
                StringBuilder trailerKeys = new StringBuilder();
                COSObject rootObj = trailerDict.getCOSObject(COSName.ROOT);
                if (rootObj != null) {
                    long objNumber = rootObj.getObjectNumber();
                    int genNumber = rootObj.getGenerationNumber();
                    trailerKeys.append(objNumber).append(" ");
                    trailerKeys.append(genNumber).append(" ");
                    rootFound = true;
                }
                if ((infoObj = trailerDict.getCOSObject(COSName.INFO)) != null) {
                    long objNumber = infoObj.getObjectNumber();
                    int genNumber = infoObj.getGenerationNumber();
                    trailerKeys.append(objNumber).append(" ");
                    trailerKeys.append(genNumber).append(" ");
                    infoFound = true;
                }
                if (rootFound && infoFound) {
                    trailerDicts.put(trailerKeys.toString(), trailerDict);
                }
            }
            catch (IOException exception) {
                LOG.debug((Object)"An exception occurred during brute force search for trailer - ignoring", (Throwable)exception);
            }
            trailerOffset = this.findString(TRAILER_MARKER);
        }
        this.source.seek(originOffset);
        int trailerdictsSize = trailerDicts.size();
        String firstEntry = null;
        if (trailerdictsSize > 0) {
            String[] keys = new String[trailerdictsSize];
            trailerDicts.keySet().toArray(keys);
            firstEntry = keys[0];
            for (int i = 1; i < trailerdictsSize; ++i) {
                if (!firstEntry.equals(keys[i])) continue;
                trailerDicts.remove(keys[i]);
            }
        }
        if (trailerDicts.size() == 1) {
            COSBase infoDict;
            COSBase infoObj;
            COSBase rootDict;
            boolean rootFound = false;
            boolean infoFound = false;
            COSDictionary trailerDict = (COSDictionary)trailerDicts.get(firstEntry);
            COSBase rootObj = trailerDict.getItem(COSName.ROOT);
            if (rootObj instanceof COSObject && (rootDict = ((COSObject)rootObj).getObject()) instanceof COSDictionary && this.isCatalog((COSDictionary)rootDict)) {
                rootFound = true;
            }
            if ((infoObj = trailerDict.getItem(COSName.INFO)) instanceof COSObject && (infoDict = ((COSObject)infoObj).getObject()) instanceof COSDictionary && this.isInfo((COSDictionary)infoDict)) {
                infoFound = true;
            }
            if (rootFound && infoFound) {
                COSBase idObj;
                COSBase encDict;
                COSBase encObj;
                trailer.setItem(COSName.ROOT, rootObj);
                trailer.setItem(COSName.INFO, infoObj);
                if (trailerDict.containsKey(COSName.ENCRYPT) && (encObj = trailerDict.getItem(COSName.ENCRYPT)) instanceof COSObject && (encDict = ((COSObject)encObj).getObject()) instanceof COSDictionary) {
                    trailer.setItem(COSName.ENCRYPT, encObj);
                }
                if (trailerDict.containsKey(COSName.ID) && (idObj = trailerDict.getItem(COSName.ID)) instanceof COSArray) {
                    trailer.setItem(COSName.ID, idObj);
                }
                return true;
            }
        }
        return false;
    }

    private long bfSearchForLastEOFMarker() throws IOException {
        long lastEOFMarker = -1L;
        long originOffset = this.source.getPosition();
        this.source.seek(6L);
        long tempMarker = this.findString(EOF_MARKER);
        while (tempMarker != -1L) {
            try {
                this.skipSpaces();
                if (!this.isString(XREF_TABLE)) {
                    this.readObjectNumber();
                    this.readGenerationNumber();
                }
            }
            catch (IOException exception) {
                LOG.debug((Object)"An exception occurred during brute force for last EOF - ignoring", (Throwable)exception);
                lastEOFMarker = tempMarker;
            }
            tempMarker = this.findString(EOF_MARKER);
        }
        this.source.seek(originOffset);
        if (lastEOFMarker == -1L) {
            lastEOFMarker = Long.MAX_VALUE;
        }
        return lastEOFMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bfSearchForObjStreams() throws IOException {
        long originOffset = this.source.getPosition();
        Map<Long, COSObjectKey> bfSearchForObjStreamOffsets = this.bfSearchForObjStreamOffsets();
        Map<COSObjectKey, Long> bfCOSObjectOffsets = this.getBFCOSObjectOffsets();
        bfSearchForObjStreamOffsets.entrySet().stream().filter(o -> bfCOSObjectOffsets.get(o.getValue()) == null).forEach(o -> LOG.warn((Object)("Skipped incomplete object stream:" + o.getValue() + " at " + o.getKey())));
        List objStreamOffsets = bfSearchForObjStreamOffsets.entrySet().stream().filter(o -> bfCOSObjectOffsets.get(o.getValue()) != null).filter(o -> ((Long)o.getKey()).equals(bfCOSObjectOffsets.get(o.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        for (Long offset : objStreamOffsets) {
            this.source.seek(offset);
            long stmObjNumber = this.readObjectNumber();
            int stmGenNumber = this.readGenerationNumber();
            this.readExpectedString(OBJ_MARKER, true);
            COSStream stream = null;
            try {
                COSDictionary dict = this.parseCOSDictionary();
                stream = this.parseCOSStream(dict);
                if (this.securityHandler != null) {
                    this.securityHandler.decryptStream(stream, stmObjNumber, stmGenNumber);
                }
                PDFObjectStreamParser objStreamParser = new PDFObjectStreamParser(stream, this.document);
                Map<Long, Integer> objectNumbers = objStreamParser.readObjectNumbers();
                Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
                for (Long objNumber : objectNumbers.keySet()) {
                    COSObjectKey objKey = new COSObjectKey(objNumber, 0);
                    Long existingOffset = bfCOSObjectOffsets.get(objKey);
                    if (existingOffset != null && existingOffset < 0L) {
                        COSObjectKey objStmKey = new COSObjectKey(Math.abs(existingOffset), 0);
                        existingOffset = bfCOSObjectOffsets.get(objStmKey);
                    }
                    if (existingOffset != null && offset <= existingOffset) continue;
                    bfCOSObjectOffsets.put(objKey, -stmObjNumber);
                    xrefOffset.put(objKey, -stmObjNumber);
                }
            }
            catch (IOException exception) {
                LOG.debug((Object)("Skipped corrupt stream: (" + stmObjNumber + " 0 at offset " + offset), (Throwable)exception);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        this.source.seek(originOffset);
    }

    private Map<Long, COSObjectKey> bfSearchForObjStreamOffsets() throws IOException {
        HashMap<Long, COSObjectKey> bfSearchObjStreamsOffsets = new HashMap<Long, COSObjectKey>();
        this.source.seek(6L);
        char[] string = " obj".toCharArray();
        long positionObjStream = this.findString(OBJ_STREAM);
        while (positionObjStream != -1L) {
            long newOffset = -1L;
            boolean objFound = false;
            block1: for (int i = 1; i < 40 && !objFound; ++i) {
                long currentOffset = positionObjStream - (long)(i * 10);
                if (currentOffset <= 0L) continue;
                this.source.seek(currentOffset);
                for (int j = 0; j < 10; ++j) {
                    if (this.isString(string)) {
                        long tempOffset = currentOffset - 1L;
                        this.source.seek(tempOffset);
                        int genID = this.source.peek();
                        if (COSParser.isDigit(genID)) {
                            this.source.seek(--tempOffset);
                            if (this.isSpace()) {
                                int length = 0;
                                this.source.seek(--tempOffset);
                                while (tempOffset > 6L && this.isDigit()) {
                                    this.source.seek(--tempOffset);
                                    ++length;
                                }
                                if (length > 0) {
                                    this.source.read();
                                    newOffset = this.source.getPosition();
                                    long objNumber = this.readObjectNumber();
                                    int genNumber = this.readGenerationNumber();
                                    COSObjectKey streamObjectKey = new COSObjectKey(objNumber, genNumber);
                                    bfSearchObjStreamsOffsets.put(newOffset, streamObjectKey);
                                }
                            }
                        }
                        LOG.debug((Object)("Dictionary start for object stream -> " + newOffset));
                        objFound = true;
                        continue block1;
                    }
                    ++currentOffset;
                    this.source.read();
                }
            }
            this.source.seek(positionObjStream + (long)OBJ_STREAM.length);
            positionObjStream = this.findString(OBJ_STREAM);
        }
        return bfSearchObjStreamsOffsets;
    }

    private List<Long> bfSearchForXRefTables() throws IOException {
        ArrayList<Long> bfSearchXRefTablesOffsets = new ArrayList<Long>();
        this.source.seek(6L);
        long newOffset = this.findString(XREF_TABLE);
        while (newOffset != -1L) {
            this.source.seek(newOffset - 1L);
            if (this.isWhitespace()) {
                bfSearchXRefTablesOffsets.add(newOffset);
            }
            this.source.seek(newOffset + 4L);
            newOffset = this.findString(XREF_TABLE);
        }
        return bfSearchXRefTablesOffsets;
    }

    private List<Long> bfSearchForXRefStreams() throws IOException {
        ArrayList<Long> bfSearchXRefStreamsOffsets = new ArrayList<Long>();
        this.source.seek(6L);
        String objString = " obj";
        char[] string = objString.toCharArray();
        long xrefOffset = this.findString(XREF_STREAM);
        while (xrefOffset != -1L) {
            long newOffset = -1L;
            boolean objFound = false;
            block1: for (int i = 1; i < 40 && !objFound; ++i) {
                long currentOffset = xrefOffset - (long)(i * 10);
                if (currentOffset <= 0L) continue;
                this.source.seek(currentOffset);
                for (int j = 0; j < 10; ++j) {
                    if (this.isString(string)) {
                        long tempOffset = currentOffset - 1L;
                        this.source.seek(tempOffset);
                        int genID = this.source.peek();
                        if (COSParser.isDigit(genID)) {
                            this.source.seek(--tempOffset);
                            if (this.isSpace()) {
                                int length = 0;
                                this.source.seek(--tempOffset);
                                while (tempOffset > 6L && this.isDigit()) {
                                    this.source.seek(--tempOffset);
                                    ++length;
                                }
                                if (length > 0) {
                                    this.source.read();
                                    newOffset = this.source.getPosition();
                                }
                            }
                        }
                        LOG.debug((Object)("Fixed reference for xref stream " + xrefOffset + " -> " + newOffset));
                        objFound = true;
                        continue block1;
                    }
                    ++currentOffset;
                    this.source.read();
                }
            }
            if (newOffset > -1L) {
                bfSearchXRefStreamsOffsets.add(newOffset);
            }
            this.source.seek(xrefOffset + 5L);
            xrefOffset = this.findString(XREF_STREAM);
        }
        return bfSearchXRefStreamsOffsets;
    }

    private COSDictionary rebuildTrailer() throws IOException {
        Map<COSObjectKey, Long> bfCOSObjectOffsets = this.getBFCOSObjectOffsets();
        this.xrefTrailerResolver.reset();
        this.xrefTrailerResolver.nextXrefObj(0L, XrefTrailerResolver.XRefType.TABLE);
        bfCOSObjectOffsets.forEach(this.xrefTrailerResolver::setXRef);
        this.xrefTrailerResolver.setStartxref(0L);
        COSDictionary trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        boolean searchForObjStreamsDone = false;
        if (!this.bfSearchForTrailer(trailer) && !this.searchForTrailerItems(trailer)) {
            this.bfSearchForObjStreams();
            searchForObjStreamsDone = true;
            this.searchForTrailerItems(trailer);
        }
        this.prepareDecryption();
        if (!searchForObjStreamsDone) {
            this.bfSearchForObjStreams();
        }
        this.trailerWasRebuild = true;
        return trailer;
    }

    private boolean searchForTrailerItems(COSDictionary trailer) throws IOException {
        boolean rootFound = false;
        for (COSObjectKey key : this.getBFCOSObjectOffsets().keySet()) {
            COSObject cosObject = this.document.getObjectFromPool(key);
            COSBase baseObject = cosObject.getObject();
            if (!(baseObject instanceof COSDictionary)) continue;
            COSDictionary dictionary = (COSDictionary)baseObject;
            if (this.isCatalog(dictionary)) {
                trailer.setItem(COSName.ROOT, (COSBase)cosObject);
                rootFound = true;
                continue;
            }
            if (!this.isInfo(dictionary)) continue;
            trailer.setItem(COSName.INFO, (COSBase)cosObject);
        }
        return rootFound;
    }

    protected void checkPages(COSDictionary root) throws IOException {
        COSDictionary pages;
        if (this.trailerWasRebuild && (pages = root.getCOSDictionary(COSName.PAGES)) != null) {
            this.checkPagesDictionary(pages, new HashSet<COSObject>());
        }
        if (root.getCOSDictionary(COSName.PAGES) == null) {
            throw new IOException("Page tree root must be a dictionary");
        }
    }

    private int checkPagesDictionary(COSDictionary pagesDict, Set<COSObject> set) {
        COSArray kidsArray = pagesDict.getCOSArray(COSName.KIDS);
        int numberOfPages = 0;
        if (kidsArray != null) {
            List<? extends COSBase> kidsList = kidsArray.toList();
            for (COSBase cOSBase : kidsList) {
                if (!(cOSBase instanceof COSObject) || set.contains((COSObject)cOSBase)) {
                    kidsArray.remove(cOSBase);
                    continue;
                }
                COSObject kidObject = (COSObject)cOSBase;
                COSBase kidBaseobject = kidObject.getObject();
                if (kidBaseobject == null || kidBaseobject.equals(COSNull.NULL)) {
                    LOG.warn((Object)("Removed null object " + cOSBase + " from pages dictionary"));
                    kidsArray.remove(cOSBase);
                    continue;
                }
                if (!(kidBaseobject instanceof COSDictionary)) continue;
                COSDictionary kidDictionary = (COSDictionary)kidBaseobject;
                COSName type = kidDictionary.getCOSName(COSName.TYPE);
                if (COSName.PAGES.equals(type)) {
                    set.add(kidObject);
                    numberOfPages += this.checkPagesDictionary(kidDictionary, set);
                    continue;
                }
                if (!COSName.PAGE.equals(type)) continue;
                ++numberOfPages;
            }
        }
        pagesDict.setInt(COSName.COUNT, numberOfPages);
        return numberOfPages;
    }

    protected boolean isCatalog(COSDictionary dictionary) {
        return COSName.CATALOG.equals(dictionary.getCOSName(COSName.TYPE));
    }

    private boolean isInfo(COSDictionary dictionary) {
        if (dictionary.containsKey(COSName.PARENT) || dictionary.containsKey(COSName.A) || dictionary.containsKey(COSName.DEST)) {
            return false;
        }
        return dictionary.containsKey(COSName.MOD_DATE) || dictionary.containsKey(COSName.TITLE) || dictionary.containsKey(COSName.AUTHOR) || dictionary.containsKey(COSName.SUBJECT) || dictionary.containsKey(COSName.KEYWORDS) || dictionary.containsKey(COSName.CREATOR) || dictionary.containsKey(COSName.PRODUCER) || dictionary.containsKey(COSName.CREATION_DATE);
    }

    private long parseStartXref() throws IOException {
        long startXref = -1L;
        if (this.isString(STARTXREF)) {
            this.readString();
            this.skipSpaces();
            startXref = this.readLong();
        }
        return startXref;
    }

    private boolean isString(byte[] string) throws IOException {
        boolean bytesMatching = true;
        long originOffset = this.source.getPosition();
        for (byte c : string) {
            if (this.source.read() == c) continue;
            bytesMatching = false;
            break;
        }
        this.source.seek(originOffset);
        return bytesMatching;
    }

    private boolean isString(char[] string) throws IOException {
        boolean bytesMatching = true;
        long originOffset = this.source.getPosition();
        for (char c : string) {
            if (this.source.read() == c) continue;
            bytesMatching = false;
            break;
        }
        this.source.seek(originOffset);
        return bytesMatching;
    }

    private long findString(char[] string) throws IOException {
        long position = -1L;
        int stringLength = string.length;
        int counter = 0;
        int readChar = this.source.read();
        while (readChar != -1) {
            if (readChar == string[counter]) {
                if (counter == 0) {
                    position = this.source.getPosition();
                }
                if (++counter == stringLength) {
                    return position;
                }
            } else if (counter > 0) {
                counter = 0;
                position = -1L;
                continue;
            }
            readChar = this.source.read();
        }
        return position;
    }

    private boolean parseTrailer() throws IOException {
        long trailerOffset = this.source.getPosition();
        if (this.isLenient) {
            int nextCharacter = this.source.peek();
            while (nextCharacter != 116 && COSParser.isDigit(nextCharacter)) {
                if (this.source.getPosition() == trailerOffset) {
                    LOG.warn((Object)("Expected trailer object at offset " + trailerOffset + ", keep trying"));
                }
                this.readLine();
                nextCharacter = this.source.peek();
            }
        }
        if (this.source.peek() != 116) {
            return false;
        }
        long currentOffset = this.source.getPosition();
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                int len = "trailer".length();
                this.source.seek(currentOffset + (long)len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    protected boolean parsePDFHeader() throws IOException {
        return this.parseHeader(PDF_HEADER, PDF_DEFAULT_VERSION);
    }

    protected boolean parseFDFHeader() throws IOException {
        return this.parseHeader(FDF_HEADER, FDF_DEFAULT_VERSION);
    }

    private boolean parseHeader(String headerMarker, String defaultVersion) throws IOException {
        String header = this.readLine();
        if (!header.contains(headerMarker)) {
            header = this.readLine();
            while (!(header.contains(headerMarker) || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.readLine();
            }
        }
        if (!header.contains(headerMarker)) {
            this.source.seek(0L);
            return false;
        }
        int headerStart = header.indexOf(headerMarker);
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(headerMarker) && !header.matches(headerMarker + "\\d.\\d")) {
            if (header.length() < headerMarker.length() + 3) {
                header = headerMarker + defaultVersion;
                LOG.debug((Object)("No version found, set to " + defaultVersion + " as default."));
            } else {
                String headerGarbage = header.substring(headerMarker.length() + 3, header.length()) + "\n";
                header = header.substring(0, headerMarker.length() + 3);
                this.source.rewind(headerGarbage.getBytes(StandardCharsets.ISO_8859_1).length);
            }
        }
        float headerVersion = -1.0f;
        try {
            String[] headerParts = header.split("-");
            if (headerParts.length == 2) {
                headerVersion = Float.parseFloat(headerParts[1]);
            }
        }
        catch (NumberFormatException exception) {
            LOG.debug((Object)"Can't parse the header version.", (Throwable)exception);
        }
        if (headerVersion < 0.0f) {
            if (this.isLenient) {
                headerVersion = 1.7f;
            } else {
                throw new IOException("Error getting header version: " + header);
            }
        }
        this.document.setVersion(headerVersion);
        this.source.seek(0L);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        if (this.source.peek() != 120) {
            return false;
        }
        xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        str = this.readString();
        b = str.getBytes(StandardCharsets.ISO_8859_1);
        this.source.rewind(b.length);
        this.xrefTrailerResolver.nextXrefObj(startByteOffset, XrefTrailerResolver.XRefType.TABLE);
        if (str.startsWith("trailer")) {
            COSParser.LOG.warn((Object)"skipping empty xref table");
            return false;
        }
        do {
            if ((splitString = (currentLine = this.readLine()).split("\\s")).length != 2) {
                COSParser.LOG.warn((Object)("Unexpected XRefTable Entry: " + currentLine));
                return false;
            }
            try {
                currObjID = Long.parseLong(splitString[0]);
            }
            catch (NumberFormatException exception) {
                COSParser.LOG.warn((Object)("XRefTable: invalid ID for the first object: " + currentLine));
                return false;
            }
            count = 0;
            try {
                count = Integer.parseInt(splitString[1]);
            }
            catch (NumberFormatException exception) {
                COSParser.LOG.warn((Object)("XRefTable: invalid number of objects: " + currentLine));
                return false;
            }
            this.skipSpaces();
            for (i = 0; i < count && !this.source.isEOF() && !this.isEndOfName((char)this.source.peek()) && this.source.peek() != 116; ++i) {
                currentLine = this.readLine();
                splitString = currentLine.split("\\s");
                if (splitString.length < 3) {
                    COSParser.LOG.warn((Object)("invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        currOffset = Long.parseLong(splitString[0]);
                        if (currOffset <= 0L) ** GOTO lbl49
                        currGenID = Integer.parseInt(splitString[1]);
                        objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e);
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
lbl49:
                // 4 sources

                ++currObjID;
                this.skipSpaces();
            }
            this.skipSpaces();
        } while (this.isDigit());
        return true;
    }

    private void parseXrefStream(COSStream stream, long objByteOffset, boolean isStandalone) throws IOException {
        if (isStandalone) {
            this.xrefTrailerResolver.nextXrefObj(objByteOffset, XrefTrailerResolver.XRefType.STREAM);
            this.xrefTrailerResolver.setTrailer(stream);
        }
        PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this.document);
        parser.parse(this.xrefTrailerResolver);
    }

    public PDEncryption getEncryption() throws IOException {
        if (this.document == null) {
            throw new IOException("You must parse the document first before calling getEncryption()");
        }
        return this.encryption;
    }

    public AccessPermission getAccessPermission() throws IOException {
        if (this.document == null) {
            throw new IOException("You must parse the document first before calling getAccessPermission()");
        }
        return this.accessPermission;
    }

    private void prepareDecryption() throws IOException {
        if (this.encryption != null) {
            return;
        }
        COSBase trailerEncryptItem = this.document.getTrailer().getItem(COSName.ENCRYPT);
        if (trailerEncryptItem == null || trailerEncryptItem instanceof COSNull) {
            return;
        }
        try {
            DecryptionMaterial decryptionMaterial;
            this.encryption = new PDEncryption(this.document.getEncryptionDictionary());
            if (this.keyStoreInputStream != null) {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(this.keyStoreInputStream, this.password.toCharArray());
                decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.keyAlias, this.password);
            } else {
                decryptionMaterial = new StandardDecryptionMaterial(this.password);
            }
            this.securityHandler = this.encryption.getSecurityHandler();
            this.securityHandler.prepareForDecryption(this.encryption, this.document.getDocumentID(), decryptionMaterial);
            this.accessPermission = this.securityHandler.getCurrentAccessPermission();
        }
        catch (IOException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption", e);
        }
        finally {
            if (this.keyStoreInputStream != null) {
                IOUtils.closeQuietly(this.keyStoreInputStream);
            }
        }
    }
}

