/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;

public class PDDeviceCMYK
extends PDDeviceColorSpace {
    public static PDDeviceCMYK INSTANCE = new PDDeviceCMYK();
    private final PDColor initialColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f, 1.0f}, (PDColorSpace)this);
    private ICC_ColorSpace awtColorSpace;
    private volatile boolean initDone = false;
    private boolean usePureJavaCMYKConversion = false;

    protected PDDeviceCMYK() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException {
        if (this.initDone) {
            return;
        }
        PDDeviceCMYK pDDeviceCMYK = this;
        synchronized (pDDeviceCMYK) {
            if (this.initDone) {
                return;
            }
            ICC_Profile iccProfile = this.getICCProfile();
            if (iccProfile == null) {
                throw new IOException("Default CMYK color profile could not be loaded");
            }
            this.awtColorSpace = new ICC_ColorSpace(iccProfile);
            this.awtColorSpace.toRGB(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
            this.usePureJavaCMYKConversion = System.getProperty("org.apache.pdfbox.rendering.UsePureJavaCMYKConversion") != null;
            this.initDone = true;
        }
    }

    /*
     * Exception decompiling
     */
    protected ICC_Profile getICCProfile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getName() {
        return COSName.DEVICECMYK.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 4;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) throws IOException {
        this.init();
        return this.awtColorSpace.toRGB(value);
    }

    @Override
    public BufferedImage toRawImage(WritableRaster raster) throws IOException {
        return null;
    }

    @Override
    public BufferedImage toRGBImage(WritableRaster raster) throws IOException {
        this.init();
        return this.toRGBImageAWT(raster, this.awtColorSpace);
    }

    @Override
    protected BufferedImage toRGBImageAWT(WritableRaster raster, ColorSpace colorSpace) {
        if (this.usePureJavaCMYKConversion) {
            BufferedImage dest = new BufferedImage(raster.getWidth(), raster.getHeight(), 1);
            ColorSpace destCS = dest.getColorModel().getColorSpace();
            WritableRaster destRaster = dest.getRaster();
            float[] srcValues = new float[4];
            float[] lastValues = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
            float[] destValues = new float[3];
            int width = raster.getWidth();
            int startX = raster.getMinX();
            int height = raster.getHeight();
            int startY = raster.getMinY();
            for (int x = startX; x < width + startX; ++x) {
                for (int y = startY; y < height + startY; ++y) {
                    raster.getPixel(x, y, srcValues);
                    if (!Arrays.equals(lastValues, srcValues)) {
                        int k;
                        for (k = 0; k < 4; ++k) {
                            lastValues[k] = srcValues[k];
                            srcValues[k] = srcValues[k] / 255.0f;
                        }
                        destValues = destCS.fromCIEXYZ(colorSpace.toCIEXYZ(srcValues));
                        for (k = 0; k < destValues.length; ++k) {
                            destValues[k] = destValues[k] * 255.0f;
                        }
                    }
                    destRaster.setPixel(x, y, destValues);
                }
            }
            return dest;
        }
        return super.toRGBImageAWT(raster, colorSpace);
    }
}

