/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBComment;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBProcInst;
import oracle.xdb.dom.XDBText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDBNodeList
implements NodeList {
    private long m_listcstate;
    private XDBDocument m_ownerdoc;

    XDBNodeList(long l, XDBDocument xDBDocument) {
        this.m_listcstate = l;
        this.m_ownerdoc = xDBDocument;
    }

    private native long getChildTypeNative(long var1, long var3);

    public int getLength() {
        int n = (int)this.getNumListNative(XDBDocument.getGP(this.m_ownerdoc.m_conn), this.m_listcstate);
        return n;
    }

    private native long getListChildNative(long var1, long var3, long var5);

    private native long getNumListNative(long var1, long var3);

    public Node item(int n) {
        XDBNode xDBNode;
        long l = this.getListChildNative(XDBDocument.getGP(this.m_ownerdoc.m_conn), this.m_listcstate, n);
        if (l == 0L) {
            return null;
        }
        long l2 = this.getChildTypeNative(XDBDocument.getGP(this.m_ownerdoc.m_conn), l);
        switch ((int)l2) {
            case 1: {
                xDBNode = new XDBElement(this.m_ownerdoc, l);
                break;
            }
            case 2: {
                xDBNode = new XDBAttribute(this.m_ownerdoc, l);
                break;
            }
            case 3: {
                xDBNode = new XDBText(this.m_ownerdoc, l);
                break;
            }
            case 7: {
                xDBNode = new XDBProcInst(this.m_ownerdoc, l);
                break;
            }
            case 8: {
                xDBNode = new XDBComment(this.m_ownerdoc, l);
                break;
            }
            default: {
                xDBNode = null;
            }
        }
        return xDBNode;
    }
}

