/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContext;
import oracle.xdb.spi.XDBContextFactory;
import oracle.xdb.spi.XDBResource;

public class XDBNamingEnumeration
implements NamingEnumeration {
    public static int NAMING_TYPE_NAMEPAIR = 0;
    public static int NAMING_TYPE_BINDING = 1;
    private long m_enum;
    private Hashtable m_env;
    private int m_type;
    private boolean m_closed;
    private String m_path;

    public XDBNamingEnumeration(Hashtable hashtable, int n, String string, long l) {
        this.m_enum = l;
        this.m_path = string;
        this.m_closed = false;
        this.m_type = n;
        this.m_env = hashtable != null ? (Hashtable)hashtable.clone() : null;
    }

    public void close() {
        if (!this.m_closed) {
            this.closeNative(this.m_enum);
            this.m_closed = true;
        }
    }

    public native void closeNative(long var1);

    public void finalize() throws Throwable {
        this.close();
    }

    public boolean hasMore() throws NamingException {
        boolean bl;
        if (!this.m_closed) {
            bl = this.hasMoreNative(this.m_enum);
            if (!bl) {
                this.close();
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean hasMoreElements() {
        boolean bl = false;
        try {
            bl = this.hasMore();
        }
        catch (NamingException namingException) {
            bl = false;
        }
        return bl;
    }

    public native boolean hasMoreNative(long var1);

    public Object next() throws NamingException {
        NameClassPair nameClassPair;
        boolean bl = false;
        if (this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE) {
            bl = true;
        }
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        long[] lArray = new long[2];
        String[] stringArray = new String[1];
        lArray[0] = bl ? 1L : 0L;
        lArray[1] = this.m_type == NAMING_TYPE_NAMEPAIR ? 1L : 0L;
        String string = this.nextNative(this.m_enum, lArray, stringArray);
        if (this.m_type == NAMING_TYPE_NAMEPAIR) {
            NameClassPair nameClassPair2;
            nameClassPair = nameClassPair2 = new NameClassPair(string, stringArray[0]);
        } else {
            Object object = null;
            if (this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE) {
                object = new XDBResource(this.m_env, string, (int)lArray[1]);
            } else if (lArray[0] == 1L) {
                object = new XDBDocument(null, lArray[1]);
                String[] stringArray2 = new String[1];
                stringArray[0] = XDBContext.getSchemaNameNative(((XDBDocument)object).toCState(), stringArray2);
                if (stringArray[0] != null) {
                    try {
                        XMLTypeBean xMLTypeBean = (XMLTypeBean)DbmsJava.classForNameAndSchema((String)stringArray[0], (String)stringArray2[0].toUpperCase()).newInstance();
                        xMLTypeBean.setOwner((XDBDocument)object);
                        xMLTypeBean.setKidNum(0L);
                        xMLTypeBean.setXobCstate(((XDBNode)((Object)((XDBDocument)object).getDocumentElement())).toCState());
                        object = xMLTypeBean;
                    }
                    catch (Exception exception) {}
                }
            } else {
                object = new XDBContext(this.m_env, string, lArray[1]);
            }
            nameClassPair = new Binding(string, object);
        }
        return nameClassPair;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public native String nextNative(long var1, long[] var3, String[] var4);
}

