/*
 * Decompiled with CFR 0.152.
 */
package org.lunaspeed.lunar4s;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.lunaspeed.lunar4s.LunarDate;
import org.lunaspeed.lunar4s.LunarDateArgumentException;
import org.lunaspeed.lunar4s.LunarDateOutOfRangeException$;
import org.lunaspeed.lunar4s.MonthOutOfRangeException$;
import org.lunaspeed.lunar4s.YearOutOfRangeException$;
import org.lunaspeed.lunar4s.package$;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple6;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class LunarDate$
implements Serializable {
    public static final LunarDate$ MODULE$;

    static {
        new LunarDate$();
    }

    public Either<LunarDateArgumentException, LunarDate> toLunar(Date date) {
        return this.toLunar(new Timestamp(date.getTime()).toLocalDateTime());
    }

    public Either<LunarDateArgumentException, LunarDate> toLunar(LocalDate date) {
        return this.toLunar(date.atStartOfDay());
    }

    public Either<LunarDateArgumentException, LunarDate> toLunar(LocalDateTime date) {
        Left left;
        int year = date.getYear();
        if (year < package$.MODULE$.BASE_YEAR() || year > 2099) {
            left = scala.package$.MODULE$.Left().apply((Object)YearOutOfRangeException$.MODULE$);
        } else {
            int tempLeapMonth;
            int lunarYear = this.calculateLunarYear(date);
            int lunarMonth = 0;
            int lunarDate = 0;
            boolean isLeap = false;
            int dateDiff = this.daysYearToDate(date);
            int lMonth = tempLeapMonth = this.leapMonth(year);
            int newYearDif = this.chineseNewYearOffset(year);
            if (dateDiff < newYearDif) {
                lMonth = tempLeapMonth = this.leapMonth(year - 1);
                dateDiff = newYearDif - dateDiff;
                lunarMonth = 12;
                boolean bl = true;
                while (bl) {
                    int lunarMonthDays;
                    if (lMonth == lunarMonth) {
                        int leapMonthDays = this.daysOfLeapMonth(year);
                        if (dateDiff > leapMonthDays) {
                            dateDiff -= leapMonthDays;
                        } else {
                            isLeap = true;
                        }
                    }
                    if (dateDiff > (lunarMonthDays = this.daysInMonth(lunarYear, lunarMonth, false))) {
                        dateDiff -= lunarMonthDays;
                        isLeap = false;
                        --lunarMonth;
                        continue;
                    }
                    bl = false;
                }
                if (dateDiff == 0) {
                    lunarDate = 1;
                    ++lunarMonth;
                } else {
                    lunarDate = this.daysInMonth(lunarYear, lunarMonth, isLeap) - dateDiff + 1;
                }
            } else {
                dateDiff -= this.chineseNewYearOffset(year);
                lunarMonth = 1;
                boolean cont = true;
                while (cont) {
                    int lunarMonthDays = this.daysInMonth(lunarYear, lunarMonth, false);
                    if (dateDiff >= lunarMonthDays) {
                        dateDiff -= lunarMonthDays;
                        if (lMonth == lunarMonth) {
                            int leapMonthDays = this.daysOfLeapMonth(year);
                            if (dateDiff >= leapMonthDays) {
                                dateDiff -= leapMonthDays;
                                ++lunarMonth;
                                continue;
                            }
                            isLeap = true;
                            cont = false;
                            continue;
                        }
                        ++lunarMonth;
                        continue;
                    }
                    cont = false;
                }
                lunarDate = dateDiff + 1;
            }
            left = scala.package$.MODULE$.Right().apply((Object)new LunarDate(lunarYear, lunarMonth, lunarDate, date.getHour(), (int)Math.ceil((double)date.getHour() / 2.0), isLeap));
        }
        return left;
    }

    public Either<LunarDateArgumentException, LocalDate> fromLunar(int lunarYear, int lunarMonth, int lunarDate, boolean isLeap) {
        Either<LunarDateArgumentException, LocalDateTime> either;
        block4: {
            Right right;
            block3: {
                block2: {
                    either = this.fromLunar(lunarYear, lunarMonth, lunarDate, isLeap, 0);
                    if (!(either instanceof Right)) break block2;
                    Right right2 = (Right)either;
                    LocalDateTime d = (LocalDateTime)right2.b();
                    right = scala.package$.MODULE$.Right().apply((Object)d.toLocalDate());
                    break block3;
                }
                if (!(either instanceof Left)) break block4;
                Left left = (Left)either;
                LunarDateArgumentException e = (LunarDateArgumentException)left.a();
                right = scala.package$.MODULE$.Left().apply((Object)e);
            }
            return right;
        }
        throw new MatchError(either);
    }

    public Either<LunarDateArgumentException, LocalDateTime> fromLunar(int lunarYear, int lunarMonth, int lunarDate, boolean isLeap, int hour) {
        Left left;
        if (lunarYear < package$.MODULE$.BASE_YEAR() || lunarYear > 2099) {
            left = scala.package$.MODULE$.Left().apply((Object)YearOutOfRangeException$.MODULE$);
        } else if (lunarMonth < 1 || lunarMonth > 12) {
            left = scala.package$.MODULE$.Left().apply((Object)MonthOutOfRangeException$.MODULE$);
        } else if (lunarDate < 1 || lunarDate > 30) {
            left = scala.package$.MODULE$.Left().apply((Object)LunarDateOutOfRangeException$.MODULE$);
        } else if (this.leapMonth(lunarYear) == 0 && isLeap) {
            left = scala.package$.MODULE$.Left().apply((Object)new LunarDateArgumentException("no leap month in specified year but isLeap is true"));
        } else {
            int diy;
            int year = 0;
            int month = 1;
            int date = 0;
            int lytd = this.daysLunarYearToDate(lunarYear, lunarMonth, lunarDate, isLeap);
            int dateDiff = lytd - 1 + this.chineseNewYearOffset(lunarYear);
            if (dateDiff >= (diy = this.daysInYear(lunarYear))) {
                dateDiff -= diy;
                year = lunarYear + 1;
            } else {
                year = lunarYear;
            }
            while (dateDiff >= this.daysInMonth(year, month)) {
                dateDiff -= this.daysInMonth(year, month);
                ++month;
            }
            date = dateDiff + 1;
            left = scala.package$.MODULE$.Right().apply((Object)LocalDateTime.of(year, month, date, hour, 0));
        }
        return left;
    }

    public int fromLunar$default$5() {
        return 0;
    }

    private int calculateLunarYear(LocalDateTime date) {
        int newYearDif;
        int year = date.getYear();
        int dateDiff = this.daysYearToDate(date);
        return dateDiff < (newYearDif = this.chineseNewYearOffset(year)) ? year - 1 : year;
    }

    private boolean isLeap(int year) {
        return LocalDate.now().withYear(year).isLeapYear();
    }

    public int org$lunaspeed$lunar4s$LunarDate$$yearStemIndex(int year) {
        return (6 + (year - 1900)) % 10;
    }

    public int org$lunaspeed$lunar4s$LunarDate$$yearBranchIndex(int year) {
        return (year - 1900) % 12;
    }

    private int daysInYear(int year) {
        return this.isLeap(year) ? 366 : 365;
    }

    private int daysYearToDate(LocalDateTime dt) {
        return dt.getDayOfYear() - 1;
    }

    private int daysLunarYearToDate(int lunarYear, int lunarMonth, int lunarDate, boolean isLeap) {
        int lMonth = this.leapMonth(lunarYear);
        int total = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), isLeap ? lunarMonth + 1 : lunarMonth).foldLeft((Object)BoxesRunTime.boxToInteger((int)lunarDate), (Function2)new Serializable(lunarYear, lMonth){
            public static final long serialVersionUID = 0L;
            private final int lunarYear$1;
            private final int lMonth$1;

            public final int apply(int s, int m) {
                return this.apply$mcIII$sp(s, m);
            }

            public int apply$mcIII$sp(int s, int m) {
                int offset = this.lMonth$1 != 0 && m > this.lMonth$1 ? 1 : 0;
                return s + LunarDate$.MODULE$.org$lunaspeed$lunar4s$LunarDate$$daysInLunarMonth(this.lunarYear$1, m - 1 + offset);
            }
            {
                this.lunarYear$1 = lunarYear$1;
                this.lMonth$1 = lMonth$1;
            }
        }));
        int n = lMonth;
        switch (n) {
            default: 
        }
        return n != 0 && lunarMonth > n ? total + this.daysOfLeapMonth(lunarYear) : (n == 0 && isLeap ? 0 : total);
    }

    private int leapMonth(int year) {
        return BoxesRunTime.unboxToInt((Object)package$.MODULE$.LUNAR_CONSTANTS().apply(year - package$.MODULE$.BASE_YEAR())) >> 20;
    }

    private int daysOfLeapMonth(int year) {
        return this.org$lunaspeed$lunar4s$LunarDate$$daysInLunarMonth(year, this.leapMonth(year));
    }

    private boolean isBigMonth(int year, int monthIndex) {
        return (BoxesRunTime.unboxToInt((Object)package$.MODULE$.LUNAR_CONSTANTS().apply(year - package$.MODULE$.BASE_YEAR())) & 524288 >> monthIndex) != 0;
    }

    public int org$lunaspeed$lunar4s$LunarDate$$daysInLunarMonth(int year, int monthIndex) {
        return this.isBigMonth(year, monthIndex) ? 30 : 29;
    }

    private int daysInMonth(int year, int month) {
        return month % 2 == (month < 8 ? 1 : 0) ? 31 : (month == 2 ? (this.isLeap(year) ? 29 : 28) : 30);
    }

    private int chineseNewYearOffset(int year) {
        int lc = BoxesRunTime.unboxToInt((Object)package$.MODULE$.LUNAR_CONSTANTS().apply(year - package$.MODULE$.BASE_YEAR()));
        int date = lc % 32;
        int month = (lc >> 5) % 4;
        return (month > 1 ? date + 31 : date) - 1;
    }

    private int daysInMonth(int year, int month, boolean isLeap) {
        int n;
        int m = month;
        int lMonth = this.leapMonth(year);
        if (isLeap) {
            n = m != lMonth ? 0 : this.org$lunaspeed$lunar4s$LunarDate$$daysInLunarMonth(year, lMonth);
        } else {
            if (lMonth > 0 && m > lMonth) {
                ++m;
            }
            n = this.org$lunaspeed$lunar4s$LunarDate$$daysInLunarMonth(year, m - 1);
        }
        return n;
    }

    public LunarDate.LocalDateTimeConvert LocalDateTimeConvert(LocalDateTime date) {
        return new LunarDate.LocalDateTimeConvert(date);
    }

    public LunarDate.LocalDateConvert LocalDateConvert(LocalDate date) {
        return new LunarDate.LocalDateConvert(date);
    }

    public LunarDate.UtilDateConvert UtilDateConvert(Date date) {
        return new LunarDate.UtilDateConvert(date);
    }

    public LunarDate apply(int year, int month, int date, int hour, int lunarHour, boolean isLeap) {
        return new LunarDate(year, month, date, hour, lunarHour, isLeap);
    }

    public Option<Tuple6<Object, Object, Object, Object, Object, Object>> unapply(LunarDate x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)x$0.year()), (Object)BoxesRunTime.boxToInteger((int)x$0.month()), (Object)BoxesRunTime.boxToInteger((int)x$0.date()), (Object)BoxesRunTime.boxToInteger((int)x$0.hour()), (Object)BoxesRunTime.boxToInteger((int)x$0.lunarHour()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isLeap())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LunarDate$() {
        MODULE$ = this;
    }
}

