/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.io.IOException;
import lux.Evaluator;
import lux.functions.SearchBase;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public class FieldTerms
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "field-terms");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING};
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public boolean trustResultType() {
        return true;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ATOMIC_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new FieldTermsCall();
    }

    class TermsIterator
    implements SequenceIterator<AtomicValue> {
        private TermsEnum terms;
        private final Evaluator eval;
        private Term term;
        private int pos;
        private String current;

        TermsIterator(Evaluator eval, Term term) throws IOException {
            this.term = term;
            this.eval = eval;
            this.pos = -1;
            this.createTermsEnum(term);
        }

        private void createTermsEnum(Term t) throws IOException {
            Terms fieldTerms;
            String fieldName = t.field();
            Fields fields = MultiFields.getFields((IndexReader)this.eval.getSearcher().getIndexReader());
            if (fields != null && (fieldTerms = fields.terms(fieldName)) != null) {
                this.terms = fieldTerms.iterator(null);
                if (t != null && this.terms.seekCeil(new BytesRef(t.text().getBytes("utf-8"))) != TermsEnum.SeekStatus.END) {
                    this.current = this.terms.term().utf8ToString();
                }
            }
        }

        public AtomicValue next() throws XPathException {
            try {
                if (this.current == null) {
                    return null;
                }
                String value = this.current;
                BytesRef bytesRef = this.terms.next();
                if (bytesRef == null) {
                    this.pos = -1;
                    this.current = null;
                } else {
                    ++this.pos;
                    this.current = bytesRef.utf8ToString();
                }
                return new StringValue((CharSequence)value);
            }
            catch (IOException e) {
                throw new XPathException((Throwable)e);
            }
        }

        public AtomicValue current() {
            return new StringValue((CharSequence)this.current.toString());
        }

        public int position() {
            return this.pos;
        }

        public void close() {
        }

        public SequenceIterator<AtomicValue> getAnother() throws XPathException {
            try {
                return new TermsIterator(this.eval, this.term);
            }
            catch (IOException e) {
                throw new XPathException((Throwable)e);
            }
        }

        public int getProperties() {
            return 0;
        }
    }

    class FieldTermsCall
    extends ExtensionFunctionCall {
        FieldTermsCall() {
        }

        public SequenceIterator<? extends Item> call(SequenceIterator<? extends Item>[] arguments, XPathContext context) throws XPathException {
            String fieldName = null;
            String start = "";
            if (arguments.length > 0) {
                Item arg0 = arguments[0].next();
                if (arg0 != null) {
                    fieldName = arg0.getStringValue();
                }
                if (arguments.length > 1) {
                    Item arg1 = arguments[1].next();
                    start = arg1 == null ? "" : arg1.getStringValue();
                }
            }
            Evaluator eval = SearchBase.getEvaluator(context);
            try {
                if (fieldName == null && (fieldName = eval.getCompiler().getIndexConfiguration().getDefaultFieldName()) == null) {
                    return Value.asIterator((ValueRepresentation)EmptySequence.getInstance());
                }
                return new TermsIterator(eval, new Term(fieldName, start));
            }
            catch (IOException e) {
                throw new XPathException("failed getting terms from field " + fieldName, (Throwable)e);
            }
        }
    }
}

