/*
 * Decompiled with CFR 0.152.
 */
package lux.query;

import java.util.ArrayList;
import lux.index.IndexConfiguration;
import lux.query.BooleanPQuery;
import lux.query.ParseableQuery;
import lux.query.SpanBooleanPQuery;
import lux.query.SpanMatchAll;
import lux.query.SpanTermPQuery;
import lux.query.TermPQuery;
import lux.query.parser.LuxQueryParser;
import lux.xml.QName;
import lux.xpath.AbstractExpression;
import lux.xpath.LiteralExpression;
import lux.xpath.Sequence;
import lux.xquery.AttributeConstructor;
import lux.xquery.ElementConstructor;

public class SpanNearPQuery
extends ParseableQuery {
    private static final LiteralExpression SLOP_ATT_NAME = new LiteralExpression("slop");
    private static final QName SPAN_NEAR_QNAME = new QName("SpanNear");
    private static final AttributeConstructor IN_ORDER_ATT = new AttributeConstructor(new LiteralExpression("inOrder"), new LiteralExpression("true"));
    private ParseableQuery[] clauses;
    private int slop;
    private boolean inOrder;

    public SpanNearPQuery(int slop, boolean inOrder, ParseableQuery ... clauses) {
        this.clauses = slop == 0 && inOrder ? this.mergeSubClauses(clauses) : clauses;
        this.slop = slop;
        this.inOrder = inOrder;
    }

    private ParseableQuery[] mergeSubClauses(ParseableQuery[] nested) {
        ArrayList<ParseableQuery> subclauses = new ArrayList<ParseableQuery>();
        for (ParseableQuery clause : nested) {
            if (clause instanceof SpanNearPQuery) {
                SpanNearPQuery subquery = (SpanNearPQuery)clause;
                if (subquery.slop == 0 && subquery.inOrder) {
                    for (ParseableQuery subclause : subquery.clauses) {
                        subclauses.add(subclause);
                    }
                    continue;
                }
            }
            subclauses.add(clause);
        }
        return subclauses.toArray(new ParseableQuery[0]);
    }

    @Override
    public ElementConstructor toXmlNode(String field, IndexConfiguration config) {
        if (config.isOption(2048)) {
            String qs = this.toPathOccurrenceQueryString(field, config, false);
            AttributeConstructor fieldAtt = new AttributeConstructor(TermPQuery.FIELD_ATTR_NAME, new LiteralExpression("lux_path"));
            return new ElementConstructor(SpanTermPQuery.REGEXP_TERM_QNAME, new LiteralExpression(qs), fieldAtt);
        }
        AttributeConstructor inOrderAtt = null;
        if (this.inOrder) {
            inOrderAtt = IN_ORDER_ATT;
        }
        AttributeConstructor slopAtt = new AttributeConstructor(SLOP_ATT_NAME, new LiteralExpression(this.slop));
        if (this.clauses.length == 1) {
            return new ElementConstructor(SPAN_NEAR_QNAME, this.clauses[0].toXmlNode(field, config), inOrderAtt, slopAtt);
        }
        AbstractExpression[] clauseExprs = new AbstractExpression[this.clauses.length];
        int i = 0;
        for (ParseableQuery q : this.clauses) {
            clauseExprs[i++] = q.toXmlNode(field, config);
        }
        return new ElementConstructor(SPAN_NEAR_QNAME, new Sequence(clauseExprs), inOrderAtt, slopAtt);
    }

    @Override
    public String toQueryString(String field, IndexConfiguration config) {
        StringBuilder buf = new StringBuilder();
        if (config.isOption(2048)) {
            buf.append(field).append(":/").append(this.toPathOccurrenceQueryString(field, config, true)).append('/');
        }
        String markerName = this.inOrder ? "lux_within:" : "lux_near:";
        buf.append("(+").append(markerName).append(this.slop);
        for (ParseableQuery clause : this.clauses) {
            buf.append(' ').append(clause.toQueryString(field, config));
        }
        buf.append(')');
        return buf.toString();
    }

    private String toPathOccurrenceQueryString(String field, IndexConfiguration config, boolean escape) {
        StringBuilder buf = new StringBuilder();
        if (this.clauses.length > 0) {
            buf.append(this.toPathOccurrenceQueryString(this.clauses[this.clauses.length - 1], field, config));
            for (int i = this.clauses.length - 2; i >= 0; --i) {
                ParseableQuery clause = this.clauses[i];
                if (clause instanceof SpanMatchAll) {
                    if (this.slop <= 0) continue;
                    buf.append(escape ? "(\\/.*)?" : "(/.*)?");
                    continue;
                }
                if (this.slop > 0) {
                    buf.append(escape ? "\\/.*" : "/.*");
                } else {
                    buf.append(escape ? "\\/" : "/");
                }
                buf.append(this.toPathOccurrenceQueryString(clause, field, config));
            }
            if (this.clauses[0] instanceof SpanTermPQuery) {
                buf.append(escape ? "(\\/.*)?" : "(/.*)?");
            }
        }
        return buf.toString();
    }

    private String toPathOccurrenceQueryString(ParseableQuery q, String field, IndexConfiguration config) {
        if (q instanceof SpanTermPQuery) {
            return LuxQueryParser.escapeQParser(((SpanTermPQuery)q).getTerm().text());
        }
        if (q instanceof SpanNearPQuery) {
            return ((SpanNearPQuery)q).toPathOccurrenceQueryString(field, config, true);
        }
        if (q instanceof SpanBooleanPQuery) {
            StringBuilder buf = new StringBuilder();
            BooleanPQuery.Clause[] subClauses = ((SpanBooleanPQuery)q).getClauses();
            buf.append('(');
            buf.append(this.toPathOccurrenceQueryString(subClauses[0].getQuery(), field, config));
            for (int i = 1; i < subClauses.length; ++i) {
                buf.append('|');
                buf.append(this.toPathOccurrenceQueryString(subClauses[i].getQuery(), field, config));
            }
            buf.append(')');
            return buf.toString();
        }
        throw new IllegalStateException(q.getClass().getName());
    }

    @Override
    public boolean isSpan() {
        return true;
    }
}

