/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import lux.solr.XQueryComponent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.LoggerFactory;

public class AppServerComponent
extends XQueryComponent {
    private static final String RESOURCE_SCHEME = "resource:";
    private static final String CONTEXT_SCHEME = "context:";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (rb.getQueryString() == null) {
            this.queryPath = rb.req.getParams().get("lux.xquery");
            if (!StringUtils.isBlank((String)this.queryPath)) {
                String contextBase = params.get("lux.serverBaseUri");
                String baseUri = params.get("lux.baseUri") != null ? params.get("lux.baseUri") : (params.get("lux.serverBaseUri") != null ? contextBase : "");
                if (File.separatorChar == '\\') {
                    baseUri = baseUri.replace('\\', '/');
                }
                if (!baseUri.endsWith("/")) {
                    baseUri = baseUri + '/';
                }
                if (baseUri.startsWith("/") || File.separatorChar == '\\' && baseUri.matches("^[A-Za-z]:/.*$")) {
                    baseUri = "file://" + baseUri;
                }
                System.out.println("BASE URI = " + baseUri);
                String resourceBase = null;
                if (baseUri.startsWith(RESOURCE_SCHEME)) {
                    resourceBase = baseUri.substring(RESOURCE_SCHEME.length());
                } else if (baseUri.startsWith(CONTEXT_SCHEME)) {
                    baseUri = contextBase + baseUri.substring(CONTEXT_SCHEME.length());
                }
                String contents = null;
                if (resourceBase != null) {
                    InputStream in = AppServerComponent.class.getResourceAsStream(resourceBase + this.queryPath);
                    this.queryPath = baseUri + this.queryPath;
                    if (in == null) {
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, this.queryPath + " not found");
                    }
                    try {
                        contents = IOUtils.toString((InputStream)in);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(AppServerComponent.class).error("An error occurred while reading " + this.queryPath, (Throwable)e);
                    }
                    IOUtils.closeQuietly((InputStream)in);
                } else {
                    this.queryPath = baseUri + this.queryPath;
                    URL url = new URL(this.queryPath);
                    String scheme = url.getProtocol();
                    if (scheme.equals("lux")) {
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, this.queryPath + " not found (actually lux: scheme is not implemented)");
                    }
                    FileInputStream in = null;
                    try {
                        if (url.getProtocol().equals("file")) {
                            File f = new File(url.getPath());
                            if (!f.exists()) {
                                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, f + " not found");
                            }
                            if (f.isDirectory() || !f.canRead()) {
                                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "access to " + f + " denied by rule");
                            }
                            in = new FileInputStream(f);
                        } else {
                            LoggerFactory.getLogger(AppServerComponent.class).error("URL scheme not supported: " + url.getProtocol());
                        }
                        contents = IOUtils.toString(in);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(AppServerComponent.class).error("An error occurred while reading " + url, (Throwable)e);
                    }
                    if (in != null) {
                        IOUtils.closeQuietly(in);
                    }
                }
                rb.setQueryString(contents);
            }
        }
        super.prepare(rb);
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        this.evaluateQuery(rb, -1, -1);
    }
}

