/*
 * Decompiled with CFR 0.152.
 */
package lux.xml;

import java.util.Arrays;

public final class Offsets {
    private int iOffset;
    private int iDelta;
    private int[] textOffsets = new int[1024];
    private int[] deltaLocations;
    private short[] deltas = new short[1024];

    public Offsets() {
        this.deltaLocations = new int[1024];
        this.reset();
    }

    public void reset() {
        this.iDelta = 0;
        this.iOffset = 0;
    }

    public void addDelta(int deltaLocation, short delta) {
        if (this.iDelta >= this.deltas.length) {
            this.deltas = Arrays.copyOf(this.deltas, this.deltas.length + 1024);
            this.deltaLocations = Arrays.copyOf(this.deltaLocations, this.deltaLocations.length + 1024);
        }
        this.deltaLocations[this.iDelta] = deltaLocation;
        this.deltas[this.iDelta++] = delta;
    }

    public void addOffset(int characterOffset) {
        if (this.iOffset >= this.textOffsets.length) {
            this.textOffsets = Arrays.copyOf(this.textOffsets, this.textOffsets.length + 1024);
        }
        this.textOffsets[this.iOffset++] = characterOffset;
    }

    public int getTextLocation(int i) {
        return this.textOffsets[i];
    }

    public int getDeltaLocation(int i) {
        return this.deltaLocations[i];
    }

    public int getDeltaCount() {
        return this.iDelta;
    }

    public int getDelta(int i) {
        return this.deltas[i];
    }
}

