/*
 * Decompiled with CFR 0.152.
 */
package lux.xml.tinybin;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import lux.exception.LuxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.tree.tiny.AppendableCharSequence;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.LargeStringBuffer;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;

public class TinyBinary {
    public static final byte CURRENT_FORMAT = 1;
    private static final int TIN0 = 1414090240;
    private final ByteBuffer byteBuffer;
    private final byte formatVersion;
    private int charBufferLength;
    private int commentBufferLength;
    private int nodeCount;
    private int attCount;
    private int nsCount;
    private int nameCount;
    private int nsNameCount;
    private int attValueCount;
    private LinkedHashMap<CharSequence, Integer> namespaces;
    private LinkedHashMap<CharSequence, Integer> names;
    private LinkedHashMap<CharSequence, Integer> attValues;
    private HashMap<Integer, Integer> nameCodeMap;
    private CharsetDecoder charsetDecoder;
    private CharsetEncoder charsetEncoder;
    private TinyDocumentImpl document;
    private static Field fsbUsed;

    private static final int TINY(byte version) {
        return 0x54494E00 | version;
    }

    public TinyBinary(byte[] buf) {
        this(buf, null);
    }

    public TinyBinary(byte[] buf, Charset charset) {
        this.byteBuffer = ByteBuffer.wrap(buf);
        int signature = this.byteBuffer.getInt();
        if ((signature & 0xFFFFFF00) != 1414090240) {
            throw new LuxException("bytes lack TINY signature");
        }
        byte v = (byte)(signature & 0xFF);
        byte by = this.formatVersion = v == 89 ? (byte)0 : v;
        if (this.formatVersion > 1) {
            throw new LuxException("Uknown tiny binary format version: " + this.formatVersion);
        }
        this.charBufferLength = this.byteBuffer.getInt();
        this.commentBufferLength = this.byteBuffer.getInt();
        this.nodeCount = this.byteBuffer.getInt();
        this.attCount = this.byteBuffer.getInt();
        this.nsCount = this.byteBuffer.getInt();
        this.nameCount = this.byteBuffer.getInt();
        this.nsNameCount = this.byteBuffer.getInt();
        this.attValueCount = this.byteBuffer.getInt();
        if (charset != null) {
            this.charsetDecoder = charset.newDecoder();
        }
    }

    public TinyDocumentImpl getTinyDocument(Configuration config) {
        if (this.document != null) {
            return this.document;
        }
        byte[] nodeKind = new byte[this.nodeCount];
        short[] depth = new short[this.nodeCount];
        int[] next = new int[this.nodeCount];
        int[] alpha = new int[this.nodeCount];
        int[] beta = new int[this.nodeCount];
        int[] nameCode = new int[this.nodeCount];
        int[] attParent = new int[this.attCount];
        int[] attNameCode = new int[this.attCount];
        int[] nsParent = new int[this.nsCount];
        int[] nsNameCode = new int[this.nsCount];
        int[] attValueIndex = new int[this.attCount];
        NamespaceBinding[] binding = new NamespaceBinding[this.nsCount];
        Object charBuffer = this.charBufferLength > 65000 ? new LargeStringBuffer() : new FastStringBuffer(this.charBufferLength);
        FastStringBuffer commentBuffer = null;
        if (this.commentBufferLength > 0) {
            commentBuffer = new FastStringBuffer(this.commentBufferLength);
        }
        this.byteBuffer.get(nodeKind);
        ByteArrayDataInput in = new ByteArrayDataInput(this.byteBuffer.array(), this.byteBuffer.arrayOffset() + this.byteBuffer.position(), this.byteBuffer.remaining());
        this.readVInts(in, next, this.nodeCount);
        this.readAlpha(in, alpha, nodeKind, this.nodeCount);
        this.readBeta(in, beta, nodeKind, this.nodeCount);
        this.readMappedNameCodes(in, nameCode, this.nodeCount);
        this.readDeltas(in, attParent, this.attCount);
        this.readMappedNameCodes(in, attNameCode, this.attCount);
        this.readDeltas(in, nsParent, this.nsCount);
        this.readMappedNameCodes(in, nsNameCode, this.nsCount);
        this.readVInts(in, attValueIndex, this.attCount);
        this.readShortDeltas(in, depth, this.nodeCount);
        this.byteBuffer.position(in.getPosition() - this.byteBuffer.arrayOffset());
        this.readChars((AppendableCharSequence)charBuffer, this.charBufferLength);
        if (this.commentBufferLength > 0) {
            this.readChars((AppendableCharSequence)commentBuffer, this.commentBufferLength);
        }
        String[] nameTable = this.readStrings(this.nameCount, this.charsetDecoder);
        String[] nsTable = this.readStrings(this.nsNameCount, this.charsetDecoder);
        CharSequence[] attValueDict = this.readCharSequences(this.attValueCount, this.charsetDecoder);
        CharSequence[] attValue = new CharSequence[this.attCount];
        for (int i = 0; i < this.attCount; ++i) {
            int idx = attValueIndex[i];
            attValue[i] = idx == 0 ? "" : attValueDict[idx - 1];
        }
        NamePool namePool = config.getNamePool();
        this.allocateNames(nameCode, nameTable, nsTable, namePool);
        this.allocateNames(attNameCode, nameTable, nsTable, namePool);
        for (int i = 0; i < this.nsCount; ++i) {
            int nsCode = nsNameCode[i];
            int prefixCode = (nsCode >> 16 & 0xFFFF) - 1;
            String prefix = prefixCode < 0 ? "" : nsTable[prefixCode];
            int uriCode = (nsCode & 0xFFFF) - 1;
            binding[i] = new NamespaceBinding(prefix, nsTable[uriCode]);
        }
        this.resetByteBuffer();
        TinyTree tree = new TinyTree(config);
        try {
            Field documentList = TinyTree.class.getDeclaredField("documentList");
            documentList.setAccessible(true);
            ArrayList tinyDocuments = (ArrayList)documentList.get(tree);
            tinyDocuments.add(new TinyDocumentImpl(tree));
            this.setFieldValue(tree, "numberOfNodes", this.nodeCount);
            this.setFieldValue(tree, "nodeKind", nodeKind);
            this.setFieldValue(tree, "depth", depth);
            this.setFieldValue(tree, "next", next);
            this.setFieldValue(tree, "alpha", alpha);
            this.setFieldValue(tree, "beta", beta);
            this.setFieldValue(tree, "nameCode", nameCode);
            this.setFieldValue(tree, "numberOfAttributes", this.attCount);
            this.setFieldValue(tree, "attParent", attParent);
            this.setFieldValue(tree, "attCode", attNameCode);
            this.setFieldValue(tree, "attValue", attValue);
            this.setFieldValue(tree, "numberOfNamespaces", this.nsCount);
            this.setFieldValue(tree, "namespaceParent", nsParent);
            this.setFieldValue(tree, "namespaceBinding", binding);
            this.setFieldValue(tree, "charBuffer", charBuffer);
            this.setFieldValue(tree, "commentBuffer", commentBuffer);
            this.setFieldValue(tree, "documentNumber", config.getDocumentNumberAllocator().allocateDocumentNumber());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.document = (TinyDocumentImpl)tree.getNode(0);
        return this.document;
    }

    private void setFieldValue(TinyTree tree, String fieldName, Object fieldValue) throws NoSuchFieldException, IllegalAccessException {
        Field f = TinyTree.class.getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(tree, fieldValue);
    }

    private void readChars(AppendableCharSequence charBuffer, int len) {
        if (this.charsetDecoder == null) {
            CharBuffer chars = this.byteBuffer.asCharBuffer();
            chars.limit(len);
            if (charBuffer instanceof LargeStringBuffer) {
                charBuffer.append((CharSequence)chars.toString());
            } else {
                charBuffer.append((CharSequence)chars);
            }
            this.byteBuffer.position(this.byteBuffer.position() + len * 2);
        } else if (charBuffer instanceof FastStringBuffer) {
            FastStringBuffer buffer = (FastStringBuffer)charBuffer;
            CharBuffer chars = CharBuffer.wrap(buffer.getCharArray(), 0, len);
            CoderResult result = this.charsetDecoder.decode(this.byteBuffer, chars, false);
            if (result.isError() || result.isUnderflow()) {
                throw new LuxException("character mapping error: " + result.toString());
            }
            this.setStringBufferUsed(buffer, len);
        } else {
            CharBuffer chars = CharBuffer.wrap(new char[len]);
            this.charsetDecoder.decode(this.byteBuffer, chars, false);
            charBuffer.append((CharSequence)new CharSlice(chars.array()));
        }
    }

    private void allocateNames(int[] nameCode, String[] nameArr, String[] nsArr, NamePool namePool) {
        for (int i = 0; i < nameCode.length; ++i) {
            int poolCode;
            int code = nameCode[i];
            if (code < 0) continue;
            int localNameCode = (code & 0xFFFF) - 1;
            String localName = localNameCode < 0 ? "" : nameArr[localNameCode];
            int prefixCode = (code >> 24 & 0xFF) - 1;
            String prefix = prefixCode < 0 ? "" : nsArr[prefixCode];
            int uriCode = (code >> 16 & 0xFF) - 1;
            String uri = uriCode < 0 ? "" : nsArr[uriCode];
            nameCode[i] = poolCode = namePool.allocate(prefix, uri, localName);
        }
    }

    private CharSequence[] readCharSequences(int count, CharsetDecoder decoder) {
        CharSequence[] csqs = new CharSequence[count];
        for (int i = 0; i < count; ++i) {
            CharBuffer chars;
            short len = this.byteBuffer.getShort();
            if (decoder == null) {
                chars = this.byteBuffer.asCharBuffer();
                chars.limit(len);
                this.byteBuffer.position(this.byteBuffer.position() + len * 2);
            } else {
                chars = CharBuffer.wrap(new char[len]);
                decoder.decode(this.byteBuffer, chars, false);
                chars.position(0);
            }
            csqs[i] = chars;
        }
        return csqs;
    }

    private String[] readStrings(int count, CharsetDecoder decoder) {
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            CharBuffer chars;
            short len = this.byteBuffer.getShort();
            if (decoder == null) {
                chars = this.byteBuffer.asCharBuffer();
                chars.limit(len);
                this.byteBuffer.position(this.byteBuffer.position() + len * 2);
                strings[i] = chars.toString();
                continue;
            }
            chars = CharBuffer.wrap(new char[len]);
            decoder.decode(this.byteBuffer, chars, false);
            strings[i] = new String(chars.array(), 0, chars.position());
        }
        return strings;
    }

    public TinyBinary(TinyTree tree) {
        this(tree, null);
    }

    public TinyBinary(TinyTree tree, Charset charset) {
        this(tree, charset, 1);
    }

    public TinyBinary(TinyTree tree, Charset charset, byte formatVersion) {
        this.names = new LinkedHashMap();
        this.namespaces = new LinkedHashMap();
        this.attValues = new LinkedHashMap();
        this.nameCodeMap = new HashMap();
        if (charset != null) {
            this.charsetEncoder = charset.newEncoder();
        }
        this.formatVersion = formatVersion;
        int totalSize = this.calculateTotalSize(tree);
        this.byteBuffer = ByteBuffer.allocate(totalSize);
        this.byteBuffer.putInt(TinyBinary.TINY(formatVersion));
        this.byteBuffer.putInt(tree.getCharacterBuffer().length());
        if (tree.getCommentBuffer() == null) {
            this.byteBuffer.putInt(0);
        } else {
            this.byteBuffer.putInt(tree.getCommentBuffer().length());
        }
        this.byteBuffer.putInt(this.nodeCount);
        this.byteBuffer.putInt(this.attCount);
        this.byteBuffer.putInt(this.nsCount);
        this.byteBuffer.putInt(this.names.size());
        this.byteBuffer.putInt(this.namespaces.size());
        this.byteBuffer.putInt(this.attValues.size());
        this.byteBuffer.put(tree.nodeKind, 0, this.nodeCount);
        ByteArrayDataOutput out = new ByteArrayDataOutput(this.byteBuffer.array(), this.byteBuffer.arrayOffset() + this.byteBuffer.position(), this.byteBuffer.remaining());
        this.writeVInts(out, tree.getNextPointerArray(), this.nodeCount);
        this.writeAlpha(out, tree.getAlphaArray(), tree.nodeKind, this.nodeCount);
        this.writeBeta(out, tree.getBetaArray(), tree.nodeKind, this.nodeCount);
        this.writeMappedNameCodes(out, tree.getNameCodeArray(), this.nodeCount);
        this.writeDeltas(out, tree.getAttributeParentArray(), this.attCount);
        this.writeMappedNameCodes(out, tree.getAttributeNameCodeArray(), this.attCount);
        this.writeDeltas(out, tree.getNamespaceParentArray(), this.nsCount);
        NamespaceBinding[] bindings = tree.getNamespaceCodeArray();
        try {
            int i;
            for (i = 0; i < this.nsCount; ++i) {
                NamespaceBinding binding = bindings[i];
                int a = binding.getPrefix().length() == 0 ? 0 : this.namespaces.get(binding.getPrefix());
                int b = this.namespaces.get(binding.getURI());
                out.writeVInt(a << 16 | b);
            }
            for (i = 0; i < this.attCount; ++i) {
                Integer index = this.attValues.get(tree.getAttributeValueArray()[i]);
                out.writeVInt(index == null ? 0 : index);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.writeShortDeltas(out, tree.getNodeDepthArray(), this.nodeCount);
        this.byteBuffer.position(out.getPosition() - this.byteBuffer.arrayOffset());
        this.putCharacterBuffer((CharSequence)tree.getCharacterBuffer(), this.charsetEncoder);
        if (tree.getCommentBuffer() != null) {
            this.putCharacterBuffer(tree.getCommentBuffer(), this.charsetEncoder);
        }
        this.writeStrings(this.names, this.charsetEncoder);
        this.writeStrings(this.namespaces, this.charsetEncoder);
        this.writeStrings(this.attValues, this.charsetEncoder);
        this.resetByteBuffer();
    }

    private void resetByteBuffer() {
        this.byteBuffer.limit(this.byteBuffer.position());
        this.byteBuffer.position(0);
    }

    private void writeAlpha(ByteArrayDataOutput out, int[] alpha, byte[] nodeKind, int count) {
        int textOffset = 0;
        int commentOffset = 0;
        int attrIndex = -1;
        try {
            block9: for (int i = 0; i < count; ++i) {
                int k;
                switch (nodeKind[i]) {
                    case 3: {
                        k = alpha[i] - textOffset;
                        textOffset = alpha[i];
                        break;
                    }
                    case 1: {
                        if (alpha[i] < 0) {
                            k = 0;
                            break;
                        }
                        k = alpha[i] - attrIndex;
                        attrIndex = alpha[i];
                        break;
                    }
                    case 7: 
                    case 8: {
                        k = alpha[i] - commentOffset;
                        commentOffset = alpha[i];
                        break;
                    }
                    case 4: {
                        out.writeInt(alpha[i]);
                        continue block9;
                    }
                    case 9: 
                    case 11: 
                    case 12: {
                        k = alpha[i];
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unexpected node kind: " + nodeKind[i]);
                    }
                }
                out.writeVInt(k);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void readAlpha(ByteArrayDataInput in, int[] alpha, byte[] nodeKind, int count) {
        int textOffset = 0;
        int commentOffset = 0;
        int attrIndex = -1;
        block7: for (int i = 0; i < count; ++i) {
            switch (nodeKind[i]) {
                case 3: {
                    int k = in.readVInt();
                    alpha[i] = textOffset += k;
                    continue block7;
                }
                case 1: {
                    int k = in.readVInt();
                    if (k == 0) {
                        alpha[i] = -1;
                        continue block7;
                    }
                    alpha[i] = attrIndex += k;
                    continue block7;
                }
                case 7: 
                case 8: {
                    int k = in.readVInt();
                    alpha[i] = commentOffset += k;
                    continue block7;
                }
                case 4: {
                    alpha[i] = in.readInt();
                    continue block7;
                }
                case 9: 
                case 11: 
                case 12: {
                    alpha[i] = in.readVInt();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("unexpected node kind: " + nodeKind[i]);
                }
            }
        }
    }

    private void writeBeta(ByteArrayDataOutput out, int[] beta, byte[] nodeKind, int count) {
        int nsIndex = -1;
        try {
            block6: for (int i = 0; i < count; ++i) {
                switch (nodeKind[i]) {
                    case 1: {
                        int k;
                        if (beta[i] < 0) {
                            k = 0;
                        } else {
                            k = beta[i] - nsIndex;
                            nsIndex = beta[i];
                        }
                        out.writeVInt(k);
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: {
                        out.writeVInt(beta[i]);
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("unexpected node kind: " + nodeKind[i]);
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void readBeta(ByteArrayDataInput in, int[] beta, byte[] nodeKind, int count) {
        int attrIndex = -1;
        block4: for (int i = 0; i < count; ++i) {
            switch (nodeKind[i]) {
                case 1: {
                    beta[i] = attrIndex += in.readVInt();
                    continue block4;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    beta[i] = in.readVInt();
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("unexpected node kind: " + nodeKind[i]);
                }
            }
        }
    }

    private void readVInts(ByteArrayDataInput in, int[] ints, int count) {
        for (int i = 0; i < count; ++i) {
            ints[i] = in.readVInt();
        }
    }

    private void readDeltas(ByteArrayDataInput in, int[] ints, int count) {
        int k = 0;
        if (this.formatVersion < 1) {
            for (int i = 0; i < count; ++i) {
                ints[i] = k += in.readByte();
            }
        } else {
            for (int i = 0; i < count; ++i) {
                ints[i] = k += in.readVInt();
            }
        }
    }

    private void readShortDeltas(ByteArrayDataInput in, short[] shorts, int count) {
        short k = 0;
        if (this.formatVersion < 1) {
            for (int i = 0; i < count; ++i) {
                shorts[i] = k = (short)(k + in.readByte());
            }
        } else {
            for (int i = 0; i < count; ++i) {
                shorts[i] = k = (short)(k + in.readVInt());
            }
        }
    }

    private void writeVInts(ByteArrayDataOutput out, int[] ints, int count) {
        try {
            for (int i = 0; i < count; ++i) {
                out.writeVInt(ints[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void writeDeltas(ByteArrayDataOutput out, int[] ints, int count) {
        int k = 0;
        try {
            if (this.formatVersion < 1) {
                for (int i = 0; i < count; ++i) {
                    k = ints[i] - k;
                    out.writeByte((byte)(k & 0xFF));
                    k = ints[i];
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    k = ints[i] - k;
                    out.writeVInt(k);
                    k = ints[i];
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void writeShortDeltas(ByteArrayDataOutput out, short[] shorts, int count) {
        int k = 0;
        try {
            if (this.formatVersion < 1) {
                for (int i = 0; i < count; ++i) {
                    k = shorts[i] - k;
                    out.writeByte((byte)(k & 0xFF));
                    k = shorts[i];
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    k = shorts[i] - k;
                    out.writeVInt(k);
                    k = shorts[i];
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void putCharacterBuffer(CharSequence characterBuffer, CharsetEncoder encoder) {
        if (encoder == null) {
            CharBuffer chars = this.byteBuffer.asCharBuffer();
            chars.put(characterBuffer.toString());
            this.byteBuffer.position(this.byteBuffer.position() + chars.position() * 2);
        } else if (characterBuffer instanceof FastStringBuffer) {
            CharBuffer chars = CharBuffer.wrap(((FastStringBuffer)characterBuffer).getCharArray(), 0, characterBuffer.length());
            encoder.encode(chars, this.byteBuffer, false);
        } else {
            CharBuffer chars = CharBuffer.wrap(characterBuffer, 0, characterBuffer.length());
            encoder.encode(chars, this.byteBuffer, false);
        }
    }

    private void writeMappedNameCodes(ByteArrayDataOutput out, int[] nameCodes, int count) {
        try {
            for (int i = 0; i < count; ++i) {
                int nameCode = nameCodes[i];
                if (nameCode >= 0) {
                    out.writeVInt(this.nameCodeMap.get(nameCode).intValue());
                    continue;
                }
                out.writeVInt(0);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void readMappedNameCodes(ByteArrayDataInput in, int[] nameCodes, int count) {
        for (int i = 0; i < count; ++i) {
            int nameCode = in.readVInt();
            nameCodes[i] = nameCode > 0 ? nameCode : -1;
        }
    }

    private void writeStrings(LinkedHashMap<CharSequence, Integer> map, CharsetEncoder encoder) {
        CharBuffer chars = this.byteBuffer.asCharBuffer();
        for (CharSequence name : map.keySet()) {
            int len = name.length();
            this.byteBuffer.putShort((short)len);
            if (encoder == null) {
                chars.position(chars.position() + 1);
                chars.put(name.toString());
                this.byteBuffer.position(this.byteBuffer.position() + len * 2);
                continue;
            }
            chars = CharBuffer.wrap(name);
            encoder.encode(chars, this.byteBuffer, false);
        }
    }

    private int calculateTotalSize(TinyTree tree) {
        this.nodeCount = tree.getNumberOfNodes();
        this.attCount = tree.getNumberOfAttributes();
        this.nsCount = tree.getNumberOfNamespaces();
        this.getStrings(tree);
        int stringLen = 12;
        for (CharSequence s : this.names.keySet()) {
            stringLen += s.length() * 2;
            stringLen += 2;
        }
        for (CharSequence s : this.namespaces.keySet()) {
            stringLen += s.length() * 2;
            stringLen += 2;
        }
        for (CharSequence s : this.attValues.keySet()) {
            stringLen += s.length() * 2;
            stringLen += 2;
        }
        return 36 + this.nodeCount * 19 + this.attCount * 8 + this.nsCount * 8 + tree.getCharacterBuffer().length() * 2 + (tree.getCommentBuffer() == null ? 0 : tree.getCommentBuffer().length() * 2) + stringLen;
    }

    private void getStrings(TinyTree tree) {
        NamePool namePool = tree.getNamePool();
        for (int i = 0; i < this.nodeCount; ++i) {
            int nameCode = tree.getNameCode(i);
            this.internNameCodeStrings(nameCode, namePool);
        }
        int[] attNameCode = tree.getAttributeNameCodeArray();
        for (int i = 0; i < this.attCount; ++i) {
            int nameCode = attNameCode[i];
            this.internNameCodeStrings(nameCode, namePool);
        }
        NamespaceBinding[] bindings = tree.getNamespaceCodeArray();
        for (int i = 0; i < this.nsCount; ++i) {
            this.internString(this.namespaces, bindings[i].getPrefix());
            this.internString(this.namespaces, bindings[i].getURI());
        }
        CharSequence[] attValueArray = tree.getAttributeValueArray();
        for (int i = 0; i < this.attCount; ++i) {
            this.internString(this.attValues, attValueArray[i]);
        }
    }

    private void internNameCodeStrings(int nameCode, NamePool namePool) {
        if (nameCode >= 0 && !this.nameCodeMap.containsKey(nameCode)) {
            int a = this.internString(this.names, namePool.getLocalName(nameCode));
            int b = this.internString(this.namespaces, namePool.getPrefix(nameCode));
            int c = this.internString(this.namespaces, namePool.getURI(nameCode));
            this.nameCodeMap.put(nameCode, a | b << 24 | c << 16);
        }
    }

    private int internString(HashMap<CharSequence, Integer> symbolTable, CharSequence s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        Integer n = symbolTable.get(s);
        if (n == null) {
            n = symbolTable.size() + 1;
            symbolTable.put(s, n);
        }
        return n;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public byte[] getBytes() {
        return this.byteBuffer.array();
    }

    public int length() {
        return this.byteBuffer.limit();
    }

    private void setStringBufferUsed(FastStringBuffer buffer, int used) {
        if (fsbUsed == null) {
            try {
                fsbUsed = FastStringBuffer.class.getDeclaredField("used");
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            fsbUsed.setAccessible(true);
        }
        try {
            fsbUsed.set(buffer, used);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

