/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xpath.AbstractExpression;
import lux.xpath.Dot;
import lux.xpath.ExpressionVisitor;
import lux.xpath.NodeTest;

public class PathStep
extends AbstractExpression {
    public static final int MSELF = 1;
    public static final int MCHILD = 2;
    public static final int MPARENT = 4;
    public static final int MDESCENDANT = 8;
    public static final int MANCESTOR = 16;
    public static final int MPRECEDING = 32;
    public static final int MFOLLOWING = 64;
    public static final int MPRECEDING_SIB = 128;
    public static final int MFOLLOWING_SIB = 256;
    public static final int MATTRIBUTE = 512;
    private final Axis axis;
    private final NodeTest nodeTest;

    public PathStep(Axis axis, NodeTest nodeTest) {
        super(AbstractExpression.Type.PATH_STEP);
        this.axis = axis;
        this.nodeTest = nodeTest;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append((Object)this.axis).append("::");
        this.nodeTest.toString(buf);
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public int getPrecedence() {
        return 100;
    }

    @Override
    public boolean isDocumentOrdered() {
        return this.axis.isForward;
    }

    @Override
    public AbstractExpression getLastContextStep() {
        if (this.axis == Axis.Self && this.nodeTest.isWild()) {
            return Dot.getInstance();
        }
        return this;
    }

    @Override
    public boolean propEquals(AbstractExpression other) {
        return this.axis == ((PathStep)other).axis && this.nodeTest.equivalent(((PathStep)other).nodeTest);
    }

    @Override
    public boolean propGreaterEqual(AbstractExpression other) {
        PathStep otherStep = (PathStep)other;
        int oax = otherStep.axis.rangeMask;
        return (this.axis == otherStep.axis || (this.axis.rangeMask & oax) == oax) && this.nodeTest.propGreaterEqual(otherStep.nodeTest);
    }

    @Override
    public int equivHash() {
        return this.axis.ordinal() * this.nodeTest.equivHash();
    }

    @Override
    public boolean isRestrictive() {
        return true;
    }

    public static enum Axis {
        DescendantSelf("descendant-or-self", false, 11, new Axis[0]),
        Descendant("descendant", true, 10, DescendantSelf),
        AncestorSelf("ancestor-or-self", false, 21, new Axis[0]),
        Ancestor("ancestor", false, 20, AncestorSelf),
        Self("self", true, 1, AncestorSelf, DescendantSelf),
        Child("child", true, 2, Descendant),
        Parent("parent", false, 4, Ancestor),
        Preceding("preceding", false, 160, new Axis[0]),
        Following("following", true, 320, new Axis[0]),
        PrecedingSibling("preceding-sibling", false, 128, Preceding),
        FollowingSibling("following-sibling", true, 256, Following),
        Attribute("attribute", true, 512, new Axis[0]);

        public final String name;
        public final boolean isForward;
        public final int rangeMask;
        public Axis[] extensions;

        private Axis(String name, boolean forward, int rangeMask, Axis ... extensions) {
            this.name = name;
            this.isForward = forward;
            this.rangeMask = rangeMask;
            this.extensions = extensions;
        }

        public String toString() {
            return this.name;
        }

        public boolean isAxisMask(int mask) {
            return (this.rangeMask & mask) != 0;
        }
    }
}

