/*
 * Decompiled with CFR 0.152.
 */
package lux.compiler;

import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.BinaryOperation;
import lux.xpath.ExpressionVisitorBase;
import lux.xpath.FunCall;
import lux.xpath.NodeTest;
import lux.xpath.PathStep;
import lux.xpath.Root;
import lux.xpath.Sequence;

public class SlopCounter
extends ExpressionVisitorBase {
    private boolean done = false;
    private Integer slop = null;

    public void reset() {
        this.slop = null;
        this.done = false;
    }

    @Override
    public AbstractExpression visit(Root root) {
        this.foundNode();
        return root;
    }

    @Override
    public AbstractExpression visit(PathStep step) {
        NodeTest nodeTest = step.getNodeTest();
        switch (step.getAxis()) {
            case Child: {
                if (!nodeTest.getType().equals((Object)ValueType.NODE) && !nodeTest.getType().equals((Object)ValueType.ELEMENT)) break;
                this.foundNode();
                if (nodeTest.isWild()) {
                    this.slop = this.slop + 1;
                    break;
                }
                this.done = true;
                break;
            }
            case Self: {
                if (!nodeTest.getType().equals((Object)ValueType.NODE) && !nodeTest.getType().equals((Object)ValueType.ELEMENT)) break;
                this.foundNode();
                if (this.isReverse()) break;
                this.slop = this.slop - 1;
                break;
            }
            case Descendant: 
            case DescendantSelf: {
                if (this.isReverse()) {
                    if (this.slop == null && !nodeTest.isWild()) {
                        this.slop = 0;
                        this.done = true;
                        break;
                    }
                    this.slop = 98;
                    break;
                }
                this.slop = 98;
                break;
            }
            case Attribute: {
                if (nodeTest.getQName() == null) break;
                this.foundNode();
                break;
            }
            default: {
                this.done = true;
            }
        }
        return step;
    }

    private void foundNode() {
        if (this.slop == null) {
            this.slop = 0;
        }
    }

    @Override
    public AbstractExpression visit(FunCall f) {
        if (!f.getName().equals(FunCall.FN_EXISTS) && !f.getName().equals(FunCall.FN_DATA)) {
            this.slop = null;
        }
        this.done = true;
        return f;
    }

    @Override
    public AbstractExpression visit(Sequence seq) {
        this.computeMaxSubSlop(seq);
        this.done = true;
        return seq;
    }

    @Override
    public AbstractExpression visit(BinaryOperation exp) {
        this.computeMaxSubSlop(exp);
        this.done = true;
        return exp;
    }

    private void computeMaxSubSlop(AbstractExpression exp) {
        int maxSlop = -1;
        Integer origSlop = this.slop;
        for (AbstractExpression sub : exp.getSubs()) {
            sub.accept(this);
            if (this.slop == null) {
                return;
            }
            this.done = false;
            maxSlop = Math.max(maxSlop, this.slop);
            this.slop = origSlop;
        }
        if (maxSlop >= 0) {
            this.slop = maxSlop;
        }
    }

    public Integer getSlop() {
        return this.slop;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

