/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lux.index.FieldName;
import lux.index.MultiFieldAnalyzer;
import lux.index.analysis.DefaultAnalyzer;
import lux.index.field.AttributeQNameField;
import lux.index.field.AttributeTextField;
import lux.index.field.DocumentField;
import lux.index.field.ElementQNameField;
import lux.index.field.ElementTextField;
import lux.index.field.FieldDefinition;
import lux.index.field.PathField;
import lux.index.field.PathOccurrenceField;
import lux.index.field.PathValueField;
import lux.index.field.QNameValueField;
import lux.index.field.TinyBinaryField;
import lux.index.field.TinyBinarySolrField;
import lux.index.field.URIField;
import lux.index.field.XmlTextField;
import org.apache.lucene.util.Version;

public class IndexConfiguration {
    public static final Version LUCENE_VERSION = Version.LUCENE_42;
    public static final int BUILD_DOCUMENT = 1;
    public static final int SOLR = 2;
    public static final int NAMESPACE_AWARE = 4;
    public static final int STORE_DOCUMENT = 8;
    public static final int STORE_TINY_BINARY = 16;
    public static final int INDEX_QNAMES = 32;
    public static final int INDEX_PATHS = 64;
    public static final int INDEX_FULLTEXT = 128;
    public static final int INDEX_VALUES = 256;
    public static final int COMPUTE_OFFSETS = 512;
    public static final int STRIP_NAMESPACES = 1024;
    public static final int INDEX_EACH_PATH = 2048;
    public static final int INDEXES = 480;
    public static final int DEFAULT_OPTIONS = 236;
    public static final FieldDefinition URI = URIField.getInstance();
    private static final FieldDefinition XML_STORE = DocumentField.getInstance();
    private static final FieldDefinition TINY_BINARY_STORE = TinyBinaryField.getInstance();
    public static final FieldDefinition ELT_QNAME = ElementQNameField.getInstance();
    public static final FieldDefinition ATT_QNAME = AttributeQNameField.getInstance();
    public static final FieldDefinition PATH = PathField.getInstance();
    public static final FieldDefinition ELEMENT_TEXT = ElementTextField.getInstance();
    public static final FieldDefinition ATTRIBUTE_TEXT = AttributeTextField.getInstance();
    public static final FieldDefinition XML_TEXT = XmlTextField.getInstance();
    public static final FieldDefinition PATH_VALUE = PathValueField.getInstance();
    public static final FieldDefinition QNAME_VALUE = QNameValueField.getInstance();
    public static final IndexConfiguration DEFAULT = new IndexConfiguration();
    private long options;
    private final HashMap<String, FieldDefinition> fields;
    private final HashMap<FieldDefinition, String> fieldNames;
    private MultiFieldAnalyzer fieldAnalyzers;
    private final HashMap<String, String> namespaceMap = new HashMap();

    public MultiFieldAnalyzer getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    public static IndexConfiguration makeIndexConfiguration(long options) {
        long opt = options | 4L;
        if (opt == 236L) {
            return DEFAULT;
        }
        return new IndexConfiguration(opt);
    }

    protected IndexConfiguration(long options) {
        this.fields = new HashMap();
        this.fieldNames = new HashMap();
        this.fieldAnalyzers = new MultiFieldAnalyzer();
        this.fieldAnalyzers.put(null, new DefaultAnalyzer());
        this.addField(URI);
        this.options = options | 4L;
        this.init();
    }

    protected IndexConfiguration() {
        this(236L);
    }

    private void init() {
        if (this.isOption(32)) {
            this.addField(ELT_QNAME);
            this.addField(ATT_QNAME);
            if (this.isOption(256)) {
                this.addField(QNAME_VALUE);
            }
        }
        if (this.isOption(64)) {
            if (this.isOption(2048)) {
                this.addField(PathOccurrenceField.getInstance());
            } else {
                this.addField(PATH);
            }
            if (this.isOption(256)) {
                this.addField(PATH_VALUE);
            }
        }
        if (this.isOption(128)) {
            this.addField(XML_TEXT);
            this.addField(ELEMENT_TEXT);
            this.addField(ATTRIBUTE_TEXT);
        }
        if (this.isOption(8)) {
            if (this.isOption(16)) {
                if (this.isOption(2)) {
                    this.addField(TinyBinarySolrField.getInstance());
                } else {
                    this.addField(TINY_BINARY_STORE);
                }
            } else {
                this.addField(XML_STORE);
            }
        }
    }

    public void addField(FieldDefinition field) {
        FieldDefinition existing = this.fields.get(field.getDefaultName());
        if (existing != null) {
            if (existing != field) {
                throw new IllegalStateException("Duplicate field name: " + field);
            }
            return;
        }
        this.fields.put(field.getDefaultName(), field);
        this.fieldAnalyzers.put(this.getFieldName(field), field.getAnalyzer());
    }

    public String getFieldName(FieldName field) {
        return this.getFieldName(field.getField());
    }

    public String getFieldName(FieldDefinition field) {
        String alias = this.fieldNames.get(field);
        if (alias != null) {
            return alias;
        }
        return field.getDefaultName();
    }

    public void renameField(FieldDefinition field, String name) {
        if (!field.isRenameable()) {
            throw new IllegalArgumentException("Attempt to rename field " + field + " whose name is fixed");
        }
        String currentName = this.fieldNames.get(field);
        if (currentName == null) {
            currentName = field.getDefaultName();
        }
        if (currentName != null) {
            if (currentName.equals(name)) {
                return;
            }
            this.fields.remove(currentName);
        }
        this.fieldNames.put(field, name);
        this.fields.put(name, field);
    }

    public Collection<FieldDefinition> getFields() {
        return this.fields.values();
    }

    public FieldDefinition getField(FieldName fieldName) {
        return fieldName.getField();
    }

    public FieldDefinition getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public String getDefaultFieldName() {
        return this.getFieldName(XML_TEXT);
    }

    public boolean isOption(int option) {
        return (this.options & (long)option) != 0L;
    }

    public boolean isIndexingEnabled() {
        return (this.options & 0x1E0L) != 0L;
    }

    public Map<String, String> getNamespaceMap() {
        return Collections.unmodifiableMap(this.namespaceMap);
    }

    public void defineNamespaceMapping(String prefix, String namespaceURI) {
        this.namespaceMap.put(prefix, namespaceURI);
    }
}

