/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class LuxResponseWriter
implements QueryResponseWriter {
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        String xsl = request.getParams().get("lux.xml-xsl-stylesheet");
        List errors = response.getValues().getAll("xpath-error");
        String contentType = request.getParams().get("lux.contentType");
        if (!errors.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String e : errors) {
                buf.append(e).append("\n");
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, buf.toString());
        }
        if (response.getException() != null) {
            String error = (String)((NamedList)response.getValues().get("error")).get("msg");
            if (error == null) {
                error = response.getException().toString();
            }
            this.writeError(writer, error);
        } else {
            NamedList values = (NamedList)response.getValues().get("xpath-results");
            if (values != null) {
                boolean wrapResults;
                if (xsl != null) {
                    writer.write("<?xml-stylesheet type='text/xsl' href='" + xsl + "' ?>\n");
                }
                boolean bl = wrapResults = "text/xml".equals(contentType) && (values.size() == 0 || values.size() > 1 || !values.getName(0).equals("document") && !values.getName(0).equals("element"));
                if (wrapResults) {
                    writer.write("<results>");
                }
                for (int i = 0; i < values.size(); ++i) {
                    Object val = values.getVal(i);
                    writer.write(val.toString());
                }
                if (wrapResults) {
                    writer.write("</results>");
                }
            }
        }
    }

    private void writeError(Writer writer, String error) throws IOException {
        String encError = error.replace("&", "&amp;").replace("<", "&lt;");
        writer.write(String.format("<html><head><title>Error</title></head><body><h1>Error</h1><code>%s</code></body></html>", encError));
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        String contentTypeParam = request.getParams().get("lux.contentType");
        if (contentTypeParam != null) {
            return contentTypeParam;
        }
        return "text/html; charset=UTF-8";
    }

    public void init(NamedList args) {
    }
}

