/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import java.util.ArrayList;
import lux.SearchResultIterator;
import lux.compiler.XPathQuery;
import lux.index.IndexConfiguration;
import lux.query.BooleanPQuery;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.FunCall;
import lux.xpath.LiteralExpression;
import lux.xpath.Sequence;
import lux.xquery.AttributeConstructor;
import lux.xquery.ElementConstructor;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.SortField;

public class SearchCall
extends FunCall {
    private AbstractExpression queryArg;
    private XPathQuery query;
    private boolean fnCollection;
    private final boolean generated;

    public SearchCall(XPathQuery query, IndexConfiguration config) {
        this(query.getParseableQuery().toXmlNode(config.getDefaultFieldName(), config), query.getFacts(), query.getResultType(), query.getSortFields(), true);
    }

    public SearchCall(AbstractExpression abstractExpression) {
        this(abstractExpression, 6L, ValueType.VALUE, null, false);
    }

    private SearchCall(AbstractExpression queryArg, long facts, ValueType resultType, SortField[] sortFields, boolean isGenerated) {
        super(FunCall.LUX_SEARCH, resultType, new AbstractExpression[0]);
        this.queryArg = queryArg;
        this.fnCollection = false;
        this.query = XPathQuery.getQuery(null, facts, resultType, null, sortFields);
        this.generated = isGenerated;
        this.generateArguments();
    }

    public void combineQuery(XPathQuery additionalQuery, IndexConfiguration config) {
        ElementConstructor additional = additionalQuery.getParseableQuery().toXmlNode(config.getDefaultFieldName(), config);
        if (!additional.getName().getLocalPart().equals("MatchAllDocsQuery") && this.queryArg.getType() == AbstractExpression.Type.ELEMENT) {
            ElementConstructor addClause = new ElementConstructor(BooleanPQuery.CLAUSE_QNAME, additional, BooleanPQuery.MUST_OCCUR_ATT);
            ElementConstructor thisClause = new ElementConstructor(BooleanPQuery.CLAUSE_QNAME, this.queryArg, BooleanPQuery.MUST_OCCUR_ATT);
            ElementConstructor combined = new ElementConstructor(BooleanPQuery.BOOLEAN_QUERY_QNAME, new Sequence(thisClause, addClause), new AttributeConstructor[0]);
            this.queryArg = combined;
        }
        this.query = this.query.combineBooleanQueries(BooleanClause.Occur.MUST, additionalQuery, BooleanClause.Occur.MUST, this.query.getResultType(), config);
        this.generateArguments();
    }

    private void generateArguments() {
        ArrayList<AbstractExpression> args = new ArrayList<AbstractExpression>();
        args.add(this.queryArg);
        SortField[] sortFields = this.query.getSortFields();
        if (sortFields != null) {
            args.add(new LiteralExpression(this.createSortString(sortFields)));
        } else if (!this.generated) {
            args.add(new LiteralExpression("lux:score descending"));
        }
        this.subs = args.toArray(new AbstractExpression[args.size()]);
    }

    private String createSortString(SortField[] sort) {
        StringBuilder buf = new StringBuilder();
        if (sort != null) {
            for (SortField sortField : sort) {
                buf.append(sortField.getField());
                if (sortField.getReverse()) {
                    buf.append(" descending");
                }
                if (((Object)((Object)SearchResultIterator.MISSING_LAST)).equals(sortField.getComparatorSource())) {
                    buf.append(" empty greatest");
                }
                switch (sortField.getType()) {
                    case INT: {
                        buf.append(" int");
                        break;
                    }
                    case LONG: {
                        buf.append(" long");
                        break;
                    }
                }
                buf.append(",");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
        }
        return buf.toString();
    }

    public boolean isFnCollection() {
        return this.fnCollection;
    }

    public void setFnCollection(boolean isFnCollection) {
        this.fnCollection = isFnCollection;
    }

    @Override
    public SearchCall getRoot() {
        return this;
    }

    public XPathQuery getQuery() {
        return this.query;
    }
}

