/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import java.util.ArrayList;
import java.util.Collections;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xpath.LiteralExpression;
import lux.xquery.FLWORClause;
import lux.xquery.SortKey;

public class OrderByClause
extends FLWORClause {
    private final ArrayList<SortKey> sortKeys = new ArrayList();

    public OrderByClause(SortKey[] sortKeys) {
        Collections.addAll(this.sortKeys, sortKeys);
    }

    @Override
    public AbstractExpression getSequence() {
        return LiteralExpression.EMPTY;
    }

    @Override
    public void setSequence(AbstractExpression seq) {
    }

    public ArrayList<SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public void toString(StringBuilder buf) {
        if (this.sortKeys.isEmpty()) {
            return;
        }
        buf.append("order by ");
        this.sortKeys.get(0).toString(buf);
        for (int i = 1; i < this.sortKeys.size(); ++i) {
            buf.append(", ");
            this.sortKeys.get(i).toString(buf);
        }
    }

    @Override
    public OrderByClause accept(ExpressionVisitor visitor) {
        for (int i = 0; i < this.sortKeys.size(); ++i) {
            AbstractExpression key2;
            SortKey sk = this.sortKeys.get(i);
            AbstractExpression key = sk.getKey();
            if (key == (key2 = key.accept(visitor))) continue;
            this.sortKeys.set(i, new SortKey(key2, sk.getOrder(), sk.getCollation(), sk.isEmptyLeast()));
        }
        return visitor.visit(this);
    }
}

