/*
 * Decompiled with CFR 0.152.
 */
package lux;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import lux.CachingDocReader;
import lux.Compiler;
import lux.DirectDocWriter;
import lux.DocWriter;
import lux.QueryContext;
import lux.QueryStats;
import lux.TransformErrorListener;
import lux.XdmResultSet;
import lux.exception.LuxException;
import lux.exception.NotFoundException;
import lux.functions.Search;
import lux.index.FieldName;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import lux.query.parser.LuxQueryParser;
import lux.query.parser.XmlQueryParser;
import lux.search.DocIterator;
import lux.search.LuxSearcher;
import lux.xml.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.slf4j.LoggerFactory;

public class Evaluator {
    public static final String LUX_NAMESPACE = "http://luxdb.net";
    private final Compiler compiler;
    private final CachingDocReader docReader;
    private final DocWriter docWriter;
    private final DocumentBuilder builder;
    private final TransformErrorListener errorListener;
    private LuxSearcher searcher;
    private LuxQueryParser queryParser;
    private XmlQueryParser xmlQueryParser;
    private QueryStats queryStats;
    private URIResolver defaultURIResolver;

    public Evaluator(Compiler compiler, LuxSearcher searcher, DocWriter docWriter) {
        LoggerFactory.getLogger(this.getClass()).debug("new evaluator");
        this.compiler = compiler;
        this.searcher = searcher;
        Configuration config = compiler.getProcessor().getUnderlyingConfiguration();
        this.defaultURIResolver = config.getURIResolver();
        config.setURIResolver((URIResolver)new LuxURIResolver());
        config.setCollectionURIResolver((CollectionURIResolver)new LuxCollectionURIResolver());
        config.setOutputURIResolver((OutputURIResolver)new LuxOutputURIResolver());
        this.builder = compiler.getProcessor().newDocumentBuilder();
        this.docReader = searcher != null ? new CachingDocReader(this.builder, config, compiler.getIndexConfiguration()) : null;
        this.docWriter = docWriter;
        this.queryStats = new QueryStats();
        this.errorListener = new TransformErrorListener();
        this.errorListener.setUserData(this);
    }

    public static Evaluator createEvaluator(Directory dir) throws IOException {
        XmlIndexer indexer = new XmlIndexer();
        IndexWriter indexWriter = indexer.newIndexWriter(dir);
        DirectDocWriter writer = new DirectDocWriter(indexer, indexWriter);
        Compiler compiler = new Compiler(indexer.getConfiguration());
        LuxSearcher searcher = new LuxSearcher((IndexReader)DirectoryReader.open((IndexWriter)indexWriter, (boolean)true));
        Evaluator eval = new Evaluator(compiler, searcher, writer);
        return eval;
    }

    public Evaluator() {
        this(new Compiler(IndexConfiguration.DEFAULT), null, null);
    }

    public void close() {
        LoggerFactory.getLogger(this.getClass()).debug("close evaluator");
        Configuration config = this.compiler.getProcessor().getUnderlyingConfiguration();
        config.setURIResolver(this.defaultURIResolver);
        config.setCollectionURIResolver(null);
        try {
            this.searcher.close();
            this.docWriter.close();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("failed to close searcher", (Throwable)e);
            e.printStackTrace();
        }
    }

    public XdmResultSet evaluate(String query) {
        return this.evaluate(query, null);
    }

    public XdmResultSet evaluate(String query, QueryContext context) {
        this.errorListener.clear();
        XQueryExecutable compiledQuery = this.compiler.compile(query, this.errorListener, this.queryStats);
        return this.evaluate(compiledQuery, context);
    }

    public XdmResultSet evaluate(XQueryExecutable xquery) {
        return this.evaluate(xquery, null);
    }

    public XdmResultSet evaluate(XQueryExecutable xquery, QueryContext context) {
        return this.evaluate(xquery, context, this.errorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XdmResultSet evaluate(XQueryExecutable xquery, QueryContext context, TransformErrorListener listener) {
        if (context == null) {
            context = new QueryContext();
        }
        XQueryEvaluator xqueryEvaluator = this.prepareEvaluation(context, listener, xquery);
        try {
            XdmValue value = xqueryEvaluator.evaluate();
            XdmResultSet xdmResultSet = new XdmResultSet(value);
            return xdmResultSet;
        }
        catch (SaxonApiException e) {
            XdmResultSet xdmResultSet = new XdmResultSet(((TransformErrorListener)xqueryEvaluator.getErrorListener()).getErrors());
            return xdmResultSet;
        }
        finally {
            if (this.docReader != null) {
                this.docReader.clear();
            }
        }
    }

    public Iterator<XdmItem> iterator(XQueryExecutable xquery, QueryContext context) {
        return this.iterator(xquery, context, this.errorListener);
    }

    private Iterator<XdmItem> iterator(XQueryExecutable xquery, QueryContext context, TransformErrorListener listener) {
        if (context == null) {
            context = new QueryContext();
        }
        XQueryEvaluator xqueryEvaluator = this.prepareEvaluation(context, listener, xquery);
        try {
            return xqueryEvaluator.iterator();
        }
        catch (SaxonApiUncheckedException e) {
            return new XdmResultSet(((TransformErrorListener)xqueryEvaluator.getErrorListener()).getErrors()).iterator();
        }
    }

    private XQueryEvaluator prepareEvaluation(QueryContext context, TransformErrorListener listener, XQueryExecutable xquery) {
        listener.setUserData(this);
        XQueryEvaluator xqueryEvaluator = xquery.load();
        xqueryEvaluator.setErrorListener((ErrorListener)listener);
        if (context != null) {
            xqueryEvaluator.setContextItem((XdmItem)context.getContextItem());
            if (context.getVariableBindings() != null) {
                for (Map.Entry<QName, Object> binding : context.getVariableBindings().entrySet()) {
                    net.sf.saxon.s9api.QName saxonQName = new net.sf.saxon.s9api.QName((javax.xml.namespace.QName)binding.getKey());
                    xqueryEvaluator.setExternalVariable(saxonQName, (XdmValue)binding.getValue());
                }
            }
        }
        return xqueryEvaluator;
    }

    public XdmNode build(Reader xml, String uri) {
        StreamSource source = new StreamSource(xml);
        source.setSystemId(uri);
        try {
            return this.builder.build((Source)source);
        }
        catch (SaxonApiException e) {
            throw new LuxException(e);
        }
    }

    public void reopenSearcher() {
        LoggerFactory.getLogger(this.getClass()).debug("evaluator reopen searcher");
        try {
            LuxSearcher current = this.searcher;
            this.searcher = new LuxSearcher((IndexReader)DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)this.getSearcher().getIndexReader())));
            current.close();
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public CachingDocReader getDocReader() {
        return this.docReader;
    }

    public DocWriter getDocWriter() {
        return this.docWriter;
    }

    public LuxSearcher getSearcher() {
        return this.searcher;
    }

    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    public void setQueryStats(QueryStats queryStats) {
        this.queryStats = queryStats;
    }

    public LuxQueryParser getLuxQueryParser() {
        if (this.queryParser == null) {
            this.queryParser = LuxQueryParser.makeLuxQueryParser(this.compiler.getIndexConfiguration());
        }
        return this.queryParser;
    }

    public XmlQueryParser getXmlQueryParser() {
        if (this.xmlQueryParser == null) {
            IndexConfiguration config = this.compiler.getIndexConfiguration();
            FieldDefinition field = config.getField(FieldName.ELEMENT_TEXT);
            this.xmlQueryParser = new XmlQueryParser(config.getFieldName(field), field.getAnalyzer());
        }
        return this.xmlQueryParser;
    }

    public TransformErrorListener getErrorListener() {
        return this.errorListener;
    }

    class LuxOutputURIResolver
    implements OutputURIResolver {
        LuxOutputURIResolver() {
        }

        public Result resolve(String href, String base) throws TransformerException {
            try {
                XdmDestination dest = new XdmDestination();
                URI uri = new URI("lux:/").resolve(href);
                dest.setBaseURI(uri);
                Configuration config = Evaluator.this.getCompiler().getProcessor().getUnderlyingConfiguration();
                Receiver receiver = dest.getReceiver(config);
                receiver.setSystemId(href);
                XdmDestinationProxy xdmDestinationProxy = new XdmDestinationProxy(receiver, dest);
                xdmDestinationProxy.setSystemId(href);
                return xdmDestinationProxy;
            }
            catch (SaxonApiException e) {
                throw new TransformerException(e);
            }
            catch (URISyntaxException e) {
                throw new TransformerException(e);
            }
        }

        public void close(Result result) throws TransformerException {
            XdmDestinationProxy receiver = (XdmDestinationProxy)((Object)result);
            if (Evaluator.this.docWriter == null) {
                throw new TransformerException("Attempted to write document " + receiver.getSystemId() + " to a read-only Evaluator");
            }
            Evaluator.this.docWriter.write(receiver.dest.getXdmNode().getUnderlyingNode(), receiver.getSystemId());
        }

        class XdmDestinationProxy
        extends ProxyReceiver {
            private XdmDestination dest;

            public XdmDestinationProxy(Receiver nextReceiver, XdmDestination dest) {
                super(nextReceiver);
                this.dest = dest;
            }
        }
    }

    public class LuxCollectionURIResolver
    implements CollectionURIResolver {
        public SequenceIterator<?> resolve(String href, String base, XPathContext context) throws XPathException {
            if (StringUtils.isEmpty((String)href)) {
                return new Search().iterate((Query)new MatchAllDocsQuery(), Evaluator.this, null, 1);
            }
            if (href.startsWith("lux:")) {
                Query q;
                String query = href.substring(4);
                try {
                    q = Evaluator.this.getLuxQueryParser().parse(query);
                }
                catch (ParseException e) {
                    throw new XPathException("Failed to parse query: " + query, (Throwable)e);
                }
                LoggerFactory.getLogger(this.getClass()).debug("executing query: {}", (Object)q);
                return new Search().iterate(q, Evaluator.this, null, 1);
            }
            return Evaluator.this.compiler.getDefaultCollectionURIResolver().resolve(href, base, context);
        }
    }

    public class LuxURIResolver
    implements URIResolver {
        @Override
        public Source resolve(String href, String base) throws TransformerException {
            boolean isFile;
            String path = href;
            if (href.matches("^\\w+:.*$")) {
                isFile = href.startsWith("file:");
                if (isFile) {
                    path = href.substring(5);
                } else if (href.startsWith("lux:/")) {
                    path = href.substring(5);
                }
            } else {
                isFile = base != null ? base.startsWith("file:") : false;
            }
            if (isFile) {
                Source source = null;
                if (Evaluator.this.defaultURIResolver != null) {
                    source = Evaluator.this.defaultURIResolver.resolve(path, base);
                }
                if (source == null) {
                    source = Evaluator.this.getCompiler().getProcessor().getUnderlyingConfiguration().getSystemURIResolver().resolve(path, base);
                }
                return source;
            }
            if (Evaluator.this.searcher == null) {
                throw new IllegalStateException("Attempted search, but no searcher was provided");
            }
            path = path.replace('\\', '/');
            try {
                DocIterator disi = Evaluator.this.getSearcher().search((Query)new TermQuery(new Term(Evaluator.this.compiler.getUriFieldName(), path)));
                int docID = disi.nextDoc();
                if (docID == Integer.MAX_VALUE) {
                    throw new NotFoundException(href);
                }
                XdmNode doc = Evaluator.this.docReader.get(docID, disi.getCurrentReaderContext());
                return doc.asSource();
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
    }
}

