/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.util.ArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import lux.Evaluator;
import lux.functions.InterpreterCall;
import lux.functions.SearchBase;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class Eval
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "eval");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.ANY_SEQUENCE};
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ANY_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new EvalCall();
    }

    class EvalCall
    extends InterpreterCall {
        private XQueryEvaluator evaluator;

        EvalCall() {
        }

        public SequenceIterator<?> call(SequenceIterator<? extends Item>[] arguments, XPathContext context) throws XPathException {
            String query = arguments[0].next().getStringValue();
            Evaluator eval = SearchBase.getEvaluator(context);
            XQueryCompiler xqueryCompiler = eval.getCompiler().getXQueryCompiler();
            xqueryCompiler.setErrorListener((ErrorListener)eval.getErrorListener());
            try {
                XQueryExecutable xqueryExec = xqueryCompiler.compile(query);
                this.evaluator = xqueryExec.load();
                this.evaluator.setErrorListener((ErrorListener)eval.getErrorListener());
                if (arguments.length > 1) {
                    this.bindParameters(arguments[1]);
                }
                XdmValue result = this.evaluator.evaluate();
                ArrayList<TransformerException> runtimeErrors = eval.getErrorListener().getErrors();
                if (!runtimeErrors.isEmpty()) {
                    throw new XPathException(runtimeErrors.get(0).getMessage(), runtimeErrors.get(0).getLocator());
                }
                return Value.asIterator((ValueRepresentation)result.getUnderlyingValue());
            }
            catch (SaxonApiException e) {
                throw new XPathException((Throwable)e);
            }
        }

        @Override
        protected void setParameter(StructuredQName name, Item<?> value) {
            this.evaluator.getUnderlyingQueryContext().setParameterValue(name.getClarkName(), value);
        }
    }
}

