/*
 * Decompiled with CFR 0.152.
 */
package lux.functions;

import java.io.IOException;
import java.util.Collections;
import lux.Evaluator;
import lux.functions.SearchBase;
import lux.index.field.FieldDefinition;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.slf4j.LoggerFactory;

public class Key
extends ExtensionFunctionDefinition {
    public StructuredQName getFunctionQName() {
        return new StructuredQName("lux", "http://luxdb.net", "key");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_NODE};
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public boolean trustResultType() {
        return true;
    }

    public boolean dependsOnFocus() {
        return true;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.ATOMIC_SEQUENCE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new FieldValuesCall();
    }

    class FieldValuesCall
    extends ExtensionFunctionCall {
        FieldValuesCall() {
        }

        public SequenceIterator<? extends Item> call(SequenceIterator<? extends Item>[] arguments, XPathContext context) throws XPathException {
            Document doc;
            NodeInfo node;
            String fieldName = arguments[0].next().getStringValue();
            if (arguments.length == 1) {
                Item contextItem = context.getContextItem();
                if (!(contextItem instanceof NodeInfo)) {
                    throw new XPathException("Call to lux:key($field-name) depends on context, but there is no context defined");
                }
                node = (NodeInfo)contextItem;
            } else {
                node = (NodeInfo)arguments[1].next();
            }
            if (node == null) {
                return EmptySequence.asIterator((ValueRepresentation)EmptySequence.getInstance());
            }
            long docID = node.getDocumentNumber();
            Evaluator eval = SearchBase.getEvaluator(context);
            FieldDefinition field = eval.getCompiler().getIndexConfiguration().getField(fieldName);
            if (field == null) {
                LoggerFactory.getLogger(Key.class).warn("Attempt to retrieve values of non-existent field: {}", (Object)fieldName);
                return EmptySequence.asIterator((ValueRepresentation)EmptySequence.getInstance());
            }
            if (field.isStored() == Field.Store.NO) {
                LoggerFactory.getLogger(Key.class).warn("Attempt to retrieve values of non-stored field: {}", (Object)fieldName);
                return EmptySequence.asIterator((ValueRepresentation)EmptySequence.getInstance());
            }
            try {
                doc = eval.getSearcher().doc((int)docID, Collections.singleton(fieldName));
            }
            catch (IOException e) {
                throw new XPathException((Throwable)e);
            }
            if (field.getType() == FieldDefinition.Type.STRING) {
                String[] values = doc.getValues(fieldName);
                StringValue[] valueItems = new StringValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valueItems[i] = new StringValue((CharSequence)values[i]);
                }
                return new ArrayIterator((Item[])valueItems);
            }
            if (field.getType() == FieldDefinition.Type.INT || field.getType() == FieldDefinition.Type.LONG) {
                IndexableField[] fieldValues = doc.getFields(fieldName);
                Int64Value[] valueItems = new Int64Value[fieldValues.length];
                for (int i = 0; i < fieldValues.length; ++i) {
                    valueItems[i] = Int64Value.makeIntegerValue((long)fieldValues[i].numericValue().longValue());
                }
                return new ArrayIterator((Item[])valueItems);
            }
            return EmptySequence.asIterator((ValueRepresentation)EmptySequence.getInstance());
        }
    }
}

