/*
 * Decompiled with CFR 0.152.
 */
package lux.index;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import lux.index.MutableString;
import lux.xml.StAXHandler;
import org.apache.commons.lang.StringUtils;

public class XmlPathMapper
implements StAXHandler {
    protected MutableString currentPath = new MutableString(2048);
    private MutableString currentQName = new MutableString();
    private HashMap<CharSequence, Integer> eltQNameCounts = new HashMap();
    private HashMap<CharSequence, Integer> attQNameCounts = new HashMap();
    private HashMap<CharSequence, Integer> pathCounts = new HashMap();
    private HashMap<CharSequence, CharSequence> names = new HashMap();
    private boolean namespaceAware = true;

    public Map<CharSequence, Integer> getEltQNameCounts() {
        return this.eltQNameCounts;
    }

    public Map<CharSequence, Integer> getAttQNameCounts() {
        return this.attQNameCounts;
    }

    public Map<CharSequence, Integer> getPathCounts() {
        return this.pathCounts;
    }

    public int getEltQNameCount(String s) {
        Integer i = this.eltQNameCounts.get(new MutableString(s));
        if (i == null) {
            return 0;
        }
        return i;
    }

    public int getAttQNameCount(String s) {
        Integer i = this.attQNameCounts.get(new MutableString(s));
        if (i == null) {
            return 0;
        }
        return i;
    }

    public int getPathCount(String s) {
        Integer i = this.pathCounts.get(new MutableString(s));
        if (i == null) {
            return 0;
        }
        return i;
    }

    public CharSequence getCurrentQName() {
        return this.names.get(this.currentQName);
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    @Override
    public void handleEvent(XMLStreamReader reader, int eventType) {
        if (eventType == 1) {
            this.getEventQName(this.currentQName, reader);
            this.currentPath.append(' ');
            this.currentPath.append(this.currentQName);
            this.incrCount(this.eltQNameCounts, this.currentQName);
            this.incrCount(this.pathCounts, this.currentPath);
            int len = this.currentPath.length();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                this.getEventAttQName(this.currentQName, reader, i);
                this.incrCount(this.attQNameCounts, this.currentQName);
                this.currentPath.append(" @").append(this.currentQName);
                this.incrCount(this.pathCounts, this.currentPath);
                this.currentPath.setLength(len);
            }
        } else if (eventType == 2) {
            this.getEventQName(this.currentQName, reader);
            this.currentPath.setLength(this.currentPath.length() - this.currentQName.length() - 1);
        } else if (eventType == 7) {
            this.currentPath.append("{}");
        }
    }

    protected void getEventAttQName(MutableString buf, XMLStreamReader reader, int i) {
        this.encodeQName(buf, reader.getAttributeLocalName(i), reader.getAttributePrefix(i), reader.getAttributeNamespace(i));
    }

    private void getEventQName(MutableString buf, XMLStreamReader reader) {
        this.encodeQName(buf, reader.getLocalName(), reader.getPrefix(), reader.getNamespaceURI());
    }

    private void encodeQName(MutableString buf, String localName, String prefix, String namespace) {
        buf.setLength(0);
        if (this.namespaceAware) {
            buf.append(localName);
            if (!StringUtils.isEmpty((String)namespace)) {
                buf.append('{').append(namespace).append("}");
            }
        } else if (!prefix.isEmpty()) {
            buf.append(prefix).append(':').append(localName);
        } else {
            buf.append(localName);
        }
    }

    private void incrCount(HashMap<CharSequence, Integer> map, MutableString o) {
        if (map.containsKey(o)) {
            map.put(o, map.get(o) + 1);
        } else {
            MutableString copy = new MutableString(o);
            map.put(copy, 1);
            this.names.put(copy, copy);
        }
    }

    @Override
    public void reset() {
        this.eltQNameCounts.clear();
        this.attQNameCounts.clear();
        this.pathCounts.clear();
        this.names.clear();
        this.currentPath.setLength(0);
        this.currentQName.setLength(0);
    }
}

