/*
 * Decompiled with CFR 0.152.
 */
package lux.index.analysis;

import java.io.IOException;
import lux.index.attribute.QNameAttribute;
import lux.xml.QName;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.CharsRef;

public final class QNameTokenFilter
extends TokenFilter {
    private final QNameAttribute qnameAtt = (QNameAttribute)this.addAttribute(QNameAttribute.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private boolean namespaceAware;
    private CharsRef term = new CharsRef();

    protected QNameTokenFilter(TokenStream input) {
        super(input);
        this.setNamespaceAware(true);
    }

    public final void reset(TokenStream inputAgain) {
        assert (this.input.getAttribute(CharTermAttribute.class) == inputAgain.getAttribute(CharTermAttribute.class));
    }

    public boolean incrementToken() throws IOException {
        if (!this.qnameAtt.hasNext() || this.qnameAtt.onFirst()) {
            if (!this.input.incrementToken()) {
                return false;
            }
            this.term.copyChars(this.termAtt.buffer(), 0, this.termAtt.length());
        } else {
            this.posAtt.setPositionIncrement(0);
        }
        QName qname = this.qnameAtt.next();
        this.termAtt.setEmpty();
        if (this.namespaceAware) {
            this.termAtt.append(qname.getEncodedName());
        } else {
            if (qname.getPrefix().length() > 0) {
                this.termAtt.append(qname.getPrefix()).append(':');
            }
            this.termAtt.append(qname.getLocalPart());
        }
        this.termAtt.append(':');
        this.termAtt.append((CharSequence)this.term);
        return true;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }
}

