/*
 * Decompiled with CFR 0.152.
 */
package lux.search;

import java.io.IOException;
import java.util.List;
import lux.search.LuxSearcher;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class DocIterator
extends DocIdSetIterator {
    private final LuxSearcher luxSearcher;
    private final Weight weight;
    private final boolean ordered;
    private int nextReader;
    private int docID;
    private Scorer scorer;
    private List<AtomicReaderContext> leaves;
    private AtomicReaderContext leaf;

    DocIterator(LuxSearcher luxSearcher, Query query, boolean ordered) throws IOException {
        this.luxSearcher = luxSearcher;
        this.weight = this.luxSearcher.createNormalizedWeight(query);
        this.leaves = this.luxSearcher.getIndexReader().leaves();
        this.ordered = ordered;
        this.nextReader = 0;
        this.docID = -1;
        this.advanceScorer();
    }

    private void advanceScorer() throws IOException {
        while (this.nextReader < this.leaves.size()) {
            this.leaf = this.leaves.get(this.nextReader++);
            this.scorer = this.weight.scorer(this.leaf, this.ordered, false, this.leaf.reader().getLiveDocs());
            if (this.scorer == null) continue;
            return;
        }
        this.scorer = null;
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() throws IOException {
        while (this.scorer != null) {
            this.docID = this.scorer.nextDoc();
            if (this.docID != Integer.MAX_VALUE) {
                return this.docID;
            }
            this.advanceScorer();
        }
        return Integer.MAX_VALUE;
    }

    public int advance(int target) throws IOException {
        while (this.scorer != null) {
            this.docID = this.scorer.advance(target - this.leaf.docBase);
            if (this.docID != Integer.MAX_VALUE) {
                return this.docID + this.leaf.docBase;
            }
            this.advanceScorer();
        }
        return Integer.MAX_VALUE;
    }

    public AtomicReaderContext getCurrentReaderContext() {
        return this.leaf;
    }
}

