/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import org.apache.lucene.document.Document;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.update.AddUpdateCommand;

public class UpdateDocCommand
extends AddUpdateCommand {
    private Document doc;

    public UpdateDocCommand(SolrCore core, Document doc, String uri) {
        super(UpdateDocCommand.makeSolrRequest(core));
        this.doc = doc;
        this.setIndexedId(new BytesRef((CharSequence)uri));
    }

    public UpdateDocCommand(SolrQueryRequest req, SolrInputDocument sdoc, Document doc, String uri) {
        super(req);
        this.doc = doc;
        this.solrDoc = sdoc;
        this.setIndexedId(new BytesRef((CharSequence)uri));
    }

    public Document getLuceneDocument() {
        return this.doc;
    }

    private static SolrQueryRequest makeSolrRequest(SolrCore core) {
        ModifiableSolrParams params = new ModifiableSolrParams(){};
        return new SolrQueryRequestBase(core, (SolrParams)params){};
    }
}

