/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import lux.Compiler;
import lux.Evaluator;
import lux.QueryContext;
import lux.QueryStats;
import lux.TransformErrorListener;
import lux.exception.LuxException;
import lux.exception.ResourceExhaustedException;
import lux.search.LuxSearcher;
import lux.solr.SolrDocWriter;
import lux.solr.SolrIndexConfig;
import lux.xml.QName;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XQueryComponent
extends QueryComponent
implements SolrCoreAware {
    public static final String LUX_XQUERY = "lux.xquery";
    public static final String LUX_PATH_INFO = "lux.pathInfo";
    private static final QName LUX_HTTP = new QName("http://luxdb.net", "http");
    private static final int MAX_RESULT_SIZE = (int)(Runtime.getRuntime().maxMemory() / 32L);
    protected Set<String> fields = new HashSet<String>();
    protected SolrIndexConfig solrIndexConfig;
    protected String queryPath;
    private Serializer serializer;
    private Logger logger = LoggerFactory.getLogger(XQueryComponent.class);
    private int resultByteSize;
    public static final String XQUERY_COMPONENT_NAME = "xquery";

    public void inform(SolrCore core) {
        this.solrIndexConfig = SolrIndexConfig.registerIndexConfiguration(core);
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (rb.getQueryString() == null) {
            rb.setQueryString(params.get("q"));
        }
        String contentType = params.get("lux.contentType");
        this.serializer = this.solrIndexConfig.checkoutSerializer();
        if (contentType != null) {
            if (contentType.equals("text/html")) {
                this.serializer.setOutputProperty(Serializer.Property.METHOD, "html");
            } else if (contentType.equals("text/xml")) {
                this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            }
        } else {
            this.serializer.setOutputProperty(Serializer.Property.METHOD, this.getDefaultSerialization());
        }
        if (this.queryPath == null) {
            this.queryPath = rb.req.getParams().get(LUX_XQUERY);
        }
        this.resultByteSize = 0;
    }

    public String getDefaultSerialization() {
        return "xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (!params.getBool(XQUERY_COMPONENT_NAME, true)) {
            return;
        }
        int start = params.getInt("start", 1);
        int len = params.getInt("rows", -1);
        try {
            this.evaluateQuery(rb, start, len);
        }
        finally {
            this.solrIndexConfig.returnSerializer(this.serializer);
        }
    }

    protected void evaluateQuery(ResponseBuilder rb, int start, int len) {
        ArrayList<TransformerException> errors;
        XQueryExecutable expr;
        String query = rb.getQueryString();
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        if (StringUtils.isBlank((String)query)) {
            rsp.add("xpath-error", (Object)"query was blank");
            return;
        }
        SolrParams params = req.getParams();
        long timeAllowed = params.getInt("timeAllowed", -1);
        if (!params.getBool(XQUERY_COMPONENT_NAME, true)) {
            return;
        }
        SolrIndexSearcher.QueryResult result = new SolrIndexSearcher.QueryResult();
        SolrIndexSearcher searcher = rb.req.getSearcher();
        SolrDocWriter docWriter = new SolrDocWriter(this, rb.req.getCore());
        Compiler compiler = this.solrIndexConfig.getCompiler();
        Evaluator evaluator = new Evaluator(compiler, new LuxSearcher((IndexSearcher)searcher), docWriter);
        TransformErrorListener errorListener = evaluator.getErrorListener();
        try {
            URI baseURI = this.queryPath == null ? null : URI.create(this.queryPath);
            expr = compiler.compile(query, errorListener, baseURI, null);
        }
        catch (LuxException ex) {
            String err = this.formatError(query, errorListener);
            if (StringUtils.isEmpty((String)err)) {
                err = ex.getMessage();
            }
            rsp.add("xpath-error", (Object)err);
            return;
        }
        NamedList xpathResults = new NamedList();
        long tstart = System.currentTimeMillis();
        int count = 0;
        QueryContext context = null;
        String xqueryPath = rb.req.getParams().get(LUX_XQUERY);
        if (xqueryPath != null) {
            context = new QueryContext();
            context.bindVariable(LUX_HTTP, this.buildHttpParams(evaluator, rb.req.getParams(), rb.req.getContext(), xqueryPath));
        }
        Iterator<XdmItem> queryResults = evaluator.iterator(expr, context);
        String err = null;
        while (queryResults.hasNext()) {
            XdmItem xpathResult = queryResults.next();
            if (++count < start) continue;
            try {
                this.addResult((NamedList<Object>)xpathResults, xpathResult);
            }
            catch (SaxonApiException e) {
                err = e.getMessage();
                xpathResults = null;
                break;
            }
            catch (ResourceExhaustedException e) {
                err = e.getMessage();
                break;
            }
            catch (OutOfMemoryError e) {
                xpathResults = null;
                err = e.getMessage();
                break;
            }
            if ((len <= 0 || xpathResults.size() < len) && (timeAllowed <= 0L || System.currentTimeMillis() - tstart <= timeAllowed)) continue;
            break;
        }
        if (!(errors = evaluator.getErrorListener().getErrors()).isEmpty()) {
            err = this.formatError(query, errors, evaluator.getQueryStats());
            if (xpathResults.size() == 0) {
                xpathResults = null;
            }
        }
        if (err != null) {
            rsp.add("xpath-error", err);
        }
        rsp.add("xpath-results", (Object)xpathResults);
        result.setDocList((DocList)new DocSlice(0, 0, null, null, evaluator.getQueryStats().docCount, 0.0f));
        rb.setResult(result);
        rsp.add("response", (Object)rb.getResults().docList);
        if (xpathResults != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("retrieved: " + evaluator.getDocReader().getCacheMisses() + " docs, " + xpathResults.size() + " results, " + (System.currentTimeMillis() - tstart) + "ms");
            }
        } else {
            this.logger.warn("xquery evaluation error: " + evaluator.getDocReader().getCacheMisses() + " docs, " + "0 results, " + (System.currentTimeMillis() - tstart) + "ms");
        }
    }

    private String formatError(String query, TransformErrorListener errorListener) {
        ArrayList<TransformerException> errors = errorListener.getErrors();
        return this.formatError(query, errors, null);
    }

    private String formatError(String query, List<TransformerException> errors, QueryStats queryStats) {
        StringBuilder buf = new StringBuilder();
        if (queryStats != null && queryStats.optimizedQuery != null) {
            query = queryStats.optimizedQuery;
        }
        for (TransformerException te : errors) {
            String additionalLocationText;
            if (te instanceof XPathException && (additionalLocationText = ((XPathException)((Object)te)).getAdditionalLocationText()) != null) {
                buf.append(additionalLocationText);
            }
            buf.append(te.getMessageAndLocation());
            buf.append("\n");
            if (te.getLocator() != null) {
                int lineNumber = te.getLocator().getLineNumber();
                int column = te.getLocator().getColumnNumber();
                String[] lines = query.split("\r?\n");
                if (lineNumber <= lines.length && lineNumber > 0) {
                    String line = lines[lineNumber - 1];
                    buf.append(line, Math.min(Math.max(0, column - 100), line.length()), Math.min(line.length(), column + 100));
                }
            }
            this.logger.error("XQuery exception", (Throwable)te);
        }
        return buf.toString();
    }

    private XdmNode buildHttpParams(Evaluator evaluator, SolrParams params, Map<Object, Object> context, String path) {
        return evaluator.build(new StringReader(this.buildHttpInfo(params, context)), path);
    }

    protected void addResult(NamedList<Object> xpathResults, XdmItem item) throws SaxonApiException {
        if (item.isAtomicValue()) {
            XdmAtomicValue xdmValue = (XdmAtomicValue)item;
            AtomicValue value = (AtomicValue)xdmValue.getUnderlyingValue();
            TypeHierarchy typeHierarchy = this.solrIndexConfig.getCompiler().getProcessor().getUnderlyingConfiguration().getTypeHierarchy();
            try {
                Object javaValue;
                String typeName = value.getItemType(typeHierarchy).toString();
                if (value instanceof DecimalValue) {
                    javaValue = ((DecimalValue)value).getDoubleValue();
                    this.addResultBytes(8);
                } else if (value instanceof QNameValue) {
                    javaValue = ((QNameValue)value).getClarkName();
                    this.addResultBytes(((String)javaValue).length() * 2);
                } else if (value instanceof GDateValue) {
                    javaValue = value instanceof GMonthValue ? ((GMonthValue)value).getPrimitiveStringValue().toString() : (value instanceof GYearValue ? ((GYearValue)value).getPrimitiveStringValue().toString() : (value instanceof GDayValue ? ((GDayValue)value).getPrimitiveStringValue().toString() : (value instanceof GMonthDayValue ? ((GMonthDayValue)value).getPrimitiveStringValue().toString() : (value instanceof GYearMonthValue ? ((GYearMonthValue)value).getPrimitiveStringValue().toString() : Value.convertToJava((Item)value)))));
                    this.addResultBytes(javaValue.toString().length() * 2);
                } else {
                    javaValue = Value.convertToJava((Item)value);
                    this.addResultBytes(javaValue.toString().length() * 2);
                }
                xpathResults.add(typeName, javaValue);
            }
            catch (XPathException e) {
                xpathResults.add(value.getPrimitiveType().getDisplayName(), (Object)value.toString());
            }
        } else {
            XdmNode node = (XdmNode)item;
            XdmNodeKind nodeKind = node.getNodeKind();
            StringWriter buf = new StringWriter();
            this.serializer.setOutputWriter((Writer)buf);
            this.serializer.serializeNode(node);
            String xml = buf.toString();
            this.addResultBytes(xml.length() * 2);
            xpathResults.add(nodeKind.toString().toLowerCase(), (Object)xml);
        }
    }

    private void addResultBytes(int count) {
        if (this.resultByteSize + count > MAX_RESULT_SIZE) {
            throw new ResourceExhaustedException("Maximum result size exceeded, returned result has been truncated");
        }
        this.resultByteSize += count;
    }

    private String buildHttpInfo(SolrParams params, Map<Object, Object> context) {
        String webapp;
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("<http>", new Object[0]));
        buf.append("<params>");
        Iterator paramNames = params.getParameterNamesIterator();
        while (paramNames.hasNext()) {
            String[] values;
            String param = (String)paramNames.next();
            if (param.startsWith("lux.")) continue;
            buf.append(String.format("<param name=\"%s\">", param));
            for (String value : values = params.getParams(param)) {
                buf.append(String.format("<value>%s</value>", this.xmlEscape(value)));
            }
            buf.append("</param>");
        }
        buf.append("</params>");
        String pathInfo = params.get(LUX_PATH_INFO);
        if (pathInfo != null) {
            buf.append("<path-info>").append(this.xmlEscape(pathInfo)).append("</path-info>");
        }
        if ((webapp = (String)context.get("webapp")) == null) {
            webapp = "";
        }
        buf.append("<context-path>").append(webapp).append("</context-path>");
        buf.append("</http>");
        return buf.toString();
    }

    public SolrIndexConfig getSolrIndexConfig() {
        return this.solrIndexConfig;
    }

    private String xmlEscape(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;");
    }

    public String getDescription() {
        return "XQuery";
    }

    public String getSource() {
        return "http://github.com/msokolov/lux";
    }

    public String getVersion() {
        return "";
    }
}

